/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mockito.Mockito;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.processor.relational.RelationalNode;

public class FakeRelationalNode
extends RelationalNode {
    private List[] data;
    private TupleSource source;
    private int batchSize;
    private int currentRow;
    private boolean useBuffer;

    public FakeRelationalNode(int nodeID, List[] data) {
        super(nodeID);
        this.data = data;
        this.currentRow = 0;
    }

    public void reset() {
        super.reset();
        this.currentRow = 0;
    }

    public FakeRelationalNode(int nodeID, List[] data, int batchSize) {
        super(nodeID);
        this.data = data;
        this.currentRow = 0;
        this.batchSize = batchSize;
    }

    public FakeRelationalNode(int nodeID, TupleSource source, int batchSize) {
        super(nodeID);
        this.source = source;
        this.batchSize = batchSize;
    }

    public TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.data != null) {
            if (this.currentRow < this.data.length) {
                int endRow = Math.min(this.data.length, this.currentRow + this.getBatchSize());
                ArrayList<List> batchRows = new ArrayList<List>();
                for (int i = this.currentRow; i < endRow; ++i) {
                    batchRows.add(this.data[i]);
                }
                TupleBatch batch = new TupleBatch((long)(this.currentRow + 1), batchRows);
                this.currentRow += batch.getRowCount();
                if (this.currentRow >= this.data.length) {
                    batch.setTerminationFlag(true);
                }
                return batch;
            }
            TupleBatch batch = new TupleBatch((long)(this.currentRow + 1), Collections.EMPTY_LIST);
            batch.setTerminationFlag(true);
            return batch;
        }
        boolean last = false;
        ArrayList<List> rows = new ArrayList<List>(this.batchSize);
        for (int i = 0; i < this.batchSize; ++i) {
            List tuple = this.source.nextTuple();
            if (tuple == null) {
                last = true;
                break;
            }
            rows.add(tuple);
        }
        TupleBatch batch = new TupleBatch((long)(this.currentRow + 1), rows);
        if (last) {
            batch.setTerminationFlag(true);
        } else {
            this.currentRow += rows.size();
        }
        return batch;
    }

    public boolean hasBuffer() {
        return this.useBuffer;
    }

    protected TupleBuffer getBufferDirect(int maxRows) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        TupleBuffer tb = (TupleBuffer)Mockito.mock(TupleBuffer.class);
        Mockito.stub((Object)tb.getRowCount()).toReturn((Object)(maxRows != -1 ? Math.min(maxRows, this.data.length) : this.data.length));
        return tb;
    }

    protected int getBatchSize() {
        if (this.batchSize != 0) {
            return this.batchSize;
        }
        return super.getBatchSize();
    }

    public Object clone() {
        throw new UnsupportedOperationException();
    }

    public void setUseBuffer(boolean useBuffer) {
        this.useBuffer = useBuffer;
    }
}

