/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Properties;
import javax.crypto.KeyAgreement;
import javax.crypto.spec.DHParameterSpec;
import org.teiid.core.BundleUtil;
import org.teiid.core.CorePlugin;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.crypto.CryptoException;
import org.teiid.core.crypto.SymmetricCryptor;

public class DhKeyGenerator {
    private static String ALGORITHM = "DiffieHellman";
    private static String DIGEST = "SHA-256";
    private static DHParameterSpec DH_SPEC = DhKeyGenerator.loadKeySpecification("dh.properties");
    private static DHParameterSpec DH_SPEC_2048 = DhKeyGenerator.loadKeySpecification("dh-2048.properties");
    private PrivateKey privateKey;
    private PrivateKey privateKeyLarge;
    private int keySize = 128;

    private static DHParameterSpec loadKeySpecification(String propsFile) {
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = DhKeyGenerator.class.getResourceAsStream(propsFile);
            props.load(is);
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)CorePlugin.Event.TEIID10000, (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
        BigInteger p = new BigInteger(props.getProperty("p"));
        BigInteger g = new BigInteger(props.getProperty("g"));
        DHParameterSpec result = new DHParameterSpec(p, g, Integer.parseInt(props.getProperty("l")));
        return result;
    }

    public byte[] createPublicKey(boolean large) throws CryptoException {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(ALGORITHM);
            if (large) {
                keyGen.initialize(DH_SPEC_2048);
            } else {
                keyGen.initialize(DH_SPEC);
            }
            KeyPair keypair = keyGen.generateKeyPair();
            if (large) {
                this.privateKeyLarge = keypair.getPrivate();
            } else {
                this.privateKey = keypair.getPrivate();
            }
            PublicKey publicKey = keypair.getPublic();
            return publicKey.getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException((BundleUtil.Event)CorePlugin.Event.TEIID10001, (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CryptoException((BundleUtil.Event)CorePlugin.Event.TEIID10002, (Throwable)e);
        }
    }

    public SymmetricCryptor getSymmetricCryptor(byte[] peerPublicKeyBytes, boolean useSealedObject, ClassLoader classLoader, boolean large) throws CryptoException {
        PrivateKey privKey;
        PrivateKey privateKey = privKey = large ? this.privateKeyLarge : this.privateKey;
        if (privKey == null) {
            throw new IllegalStateException("KeyGenerator did not successfully generate public key");
        }
        try {
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(peerPublicKeyBytes);
            KeyFactory keyFact = KeyFactory.getInstance(ALGORITHM);
            PublicKey publicKey = keyFact.generatePublic(x509KeySpec);
            KeyAgreement ka = KeyAgreement.getInstance(ALGORITHM);
            ka.init(privKey);
            ka.doPhase(publicKey, true);
            byte[] secret = ka.generateSecret();
            if (secret.length < 128) {
                byte[] temp = new byte[128];
                System.arraycopy(secret, 0, temp, 128 - secret.length, secret.length);
                secret = temp;
            }
            MessageDigest sha = MessageDigest.getInstance(DIGEST);
            byte[] hash = sha.digest(secret);
            byte[] symKey = new byte[this.keySize / 8];
            System.arraycopy(hash, 0, symKey, 0, symKey.length);
            SymmetricCryptor sc = SymmetricCryptor.getSymmectricCryptor(symKey);
            sc.setUseSealedObject(useSealedObject);
            sc.setClassLoader(classLoader);
            return sc;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException((BundleUtil.Event)CorePlugin.Event.TEIID10003, (Throwable)e);
        }
        catch (InvalidKeySpecException e) {
            throw new CryptoException((BundleUtil.Event)CorePlugin.Event.TEIID10004, (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException((BundleUtil.Event)CorePlugin.Event.TEIID10005, (Throwable)e);
        }
    }

    public static void main(String[] args) throws Exception {
        AlgorithmParameterGenerator paramGen = AlgorithmParameterGenerator.getInstance(ALGORITHM);
        paramGen.init(2048);
        AlgorithmParameters params = paramGen.generateParameters();
        DHParameterSpec dhSpec = params.getParameterSpec(DHParameterSpec.class);
        System.out.println("l=" + dhSpec.getL());
        System.out.println("g=" + dhSpec.getG());
        System.out.println("p=" + dhSpec.getP());
    }
}

