/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialBlob;
import org.teiid.core.CorePlugin;
import org.teiid.core.types.BaseLob;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.LobSearchUtil;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.SqlUtil;

public class BlobImpl
extends BaseLob
implements Blob,
LobSearchUtil.StreamProvider {
    public BlobImpl() {
    }

    public BlobImpl(InputStreamFactory streamFactory) {
        super(streamFactory);
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos < 1L) {
            Object[] params = new Object[]{new Long(pos)};
            throw new SQLException(CorePlugin.Util.getString("MMClob_MMBlob.0", params));
        }
        if (length == 0 || pos > this.length()) {
            return new byte[0];
        }
        --pos;
        if (length < 0) {
            Object[] params = new Object[]{new Integer(length)};
            throw new SQLException(CorePlugin.Util.getString("MMClob_MMBlob.3", params));
        }
        if (pos + (long)length > this.length()) {
            length = (int)(this.length() - pos);
        }
        InputStream in = this.getBinaryStream();
        try {
            long skipped = 0L;
            while (pos > 0L) {
                skipped = in.skip(pos);
                pos -= skipped;
            }
            byte[] byArray = ObjectConverterUtil.convertToByteArray(in, length);
            return byArray;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    public long position(final Blob pattern, long start) throws SQLException {
        if (pattern == null) {
            return -1L;
        }
        return LobSearchUtil.position(new LobSearchUtil.StreamProvider(){

            @Override
            public InputStream getBinaryStream() throws SQLException {
                return pattern.getBinaryStream();
            }
        }, pattern.length(), this, this.length(), start, 1);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        if (pattern == null) {
            return -1L;
        }
        return this.position(new SerialBlob(pattern), start);
    }

    @Override
    public InputStream getBinaryStream(long arg0, long arg1) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }
}

