/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.StorageManager;
import org.teiid.common.buffer.impl.MemoryStorageManager;
import org.teiid.common.buffer.impl.SplittableStorageManager;
import org.teiid.common.buffer.impl.TestFileStorageManager;

public class TestSplittableStorageManager {
    @Test
    public void testCreatesSpillFiles() throws Exception {
        MemoryStorageManager msm = new MemoryStorageManager();
        SplittableStorageManager ssm = new SplittableStorageManager((StorageManager)msm);
        ssm.setMaxFileSizeDirect(2048L);
        String tsID = "0";
        FileStore store = ssm.createFileStore(tsID);
        TestFileStorageManager.writeBytes(store);
        Assert.assertEquals((long)1L, (long)msm.getCreated());
        TestFileStorageManager.writeBytes(store);
        Assert.assertEquals((long)2L, (long)msm.getCreated());
        store.setLength(10000L);
        Assert.assertEquals((long)5L, (long)msm.getCreated());
        store.setLength(100L);
        Assert.assertEquals((long)4L, (long)msm.getRemoved());
        store.remove();
        Assert.assertEquals((long)5L, (long)msm.getRemoved());
    }

    @Test
    public void testTruncate() throws Exception {
        MemoryStorageManager msm = new MemoryStorageManager();
        SplittableStorageManager ssm = new SplittableStorageManager((StorageManager)msm);
        ssm.setMaxFileSizeDirect(2048L);
        String tsID = "0";
        FileStore store = ssm.createFileStore(tsID);
        TestFileStorageManager.writeBytes(store);
        Assert.assertEquals((long)1L, (long)msm.getCreated());
        TestFileStorageManager.writeBytes(store);
        Assert.assertEquals((long)2L, (long)msm.getCreated());
        store.setLength(100L);
        Assert.assertEquals((long)1L, (long)msm.getRemoved());
    }
}

