/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.api.exception.query.InvalidFunctionException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.NullType;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.Base64;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.function.FunctionMethods;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.unittest.TimestampUtil;
import org.teiid.query.util.CommandContext;

public class TestFunctionLibrary {
    private static final Class<String> T_STRING = DataTypeManager.DefaultDataClasses.STRING;
    private static final Class<Integer> T_INTEGER = DataTypeManager.DefaultDataClasses.INTEGER;
    private static final Class<BigInteger> T_BIG_INTEGER = DataTypeManager.DefaultDataClasses.BIG_INTEGER;
    private static final Class<? extends BigDecimal> T_BIG_DECIMAL = DataTypeManager.DefaultDataClasses.BIG_DECIMAL;
    private static final Class<Long> T_LONG = DataTypeManager.DefaultDataClasses.LONG;
    private static final Class<Float> T_FLOAT = DataTypeManager.DefaultDataClasses.FLOAT;
    private static final Class<Double> T_DOUBLE = DataTypeManager.DefaultDataClasses.DOUBLE;
    private static final Class<NullType> T_NULL = DataTypeManager.DefaultDataClasses.NULL;
    private static final Class<Time> T_TIME = DataTypeManager.DefaultDataClasses.TIME;
    private static final Class<Date> T_DATE = DataTypeManager.DefaultDataClasses.DATE;
    private static final Class<Timestamp> T_TIMESTAMP = DataTypeManager.DefaultDataClasses.TIMESTAMP;
    private FunctionLibrary library = new FunctionLibrary(RealMetadataFactory.SFM.getSystemFunctions(), new FunctionTree[0]);
    private Locale locale;

    @Before
    public void setUp() {
        this.locale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("GMT-06:00"));
    }

    @After
    public void tearDown() {
        Locale.setDefault(this.locale);
        FunctionMethods.dayNames = null;
        FunctionMethods.monthNames = null;
        TimestampWithTimezone.resetCalendar(null);
    }

    private FunctionDescriptor helpCreateDescriptor(String name, Class<?>[] types) {
        final String fname = name;
        final Class[] ftypes = types;
        return new FunctionDescriptor(){

            public String getName() {
                return fname;
            }

            public FunctionMethod.PushDown getPushdown() {
                return FunctionMethod.PushDown.CAN_PUSHDOWN;
            }

            public Class<?>[] getTypes() {
                return ftypes;
            }

            public Class<?> getReturnType() {
                return null;
            }

            public String toString() {
                StringBuffer str = new StringBuffer(fname);
                str.append("(");
                for (int i = 0; i < ftypes.length; ++i) {
                    if (ftypes[i] != null) {
                        str.append(ftypes[i].getName());
                    } else {
                        str.append("null");
                    }
                    if (i >= ftypes.length - 1) continue;
                    str.append(", ");
                }
                return str.toString();
            }

            public boolean requiresContext() {
                return false;
            }

            public boolean isNullDependent() {
                return true;
            }
        };
    }

    private void helpFindFunction(String fname, Class<?>[] types, FunctionDescriptor expected) {
        FunctionDescriptor actual = this.library.findFunction(fname, (Class[])types);
        Assert.assertEquals((String)"Function names do not match: ", (Object)expected.getName().toLowerCase(), (Object)actual.getName().toLowerCase());
        Assert.assertEquals((String)"Arg lengths do not match: ", (long)expected.getTypes().length, (long)actual.getTypes().length);
    }

    private void helpFindFunctionFail(String fname, Class<?>[] types) {
        FunctionDescriptor actual = this.library.findFunction(fname, (Class[])types);
        Assert.assertNull((String)("Function was found but should not have been: " + actual), (Object)actual);
    }

    private void helpFindConversions(String fname, Class<?>[] types, FunctionDescriptor[] expected) {
        FunctionDescriptor[] actual;
        try {
            FunctionLibrary.ConversionResult result = this.library.determineNecessaryConversions(fname, null, new Expression[types.length], (Class[])types, false);
            actual = result.needsConverion ? this.library.getConverts(result.method, (Class[])types) : (result.method != null ? new FunctionDescriptor[types.length] : null);
        }
        catch (InvalidFunctionException e) {
            actual = null;
        }
        if (expected == null) {
            if (actual != null) {
                Assert.fail((String)("Expected to find no conversion for " + fname + Arrays.asList(types) + " but found: " + Arrays.asList(actual)));
            }
        } else if (actual == null) {
            Assert.fail((String)("Expected to find conversion for " + fname + Arrays.asList(types) + " but found none"));
        } else {
            for (int i = 0; i < expected.length; ++i) {
                if (expected[i] == null) {
                    if (actual[i] == null) continue;
                    Assert.fail((String)("Expected no conversion at index " + i + ", but found: " + actual[i]));
                    continue;
                }
                if (actual[i] == null) {
                    Assert.fail((String)("Expected conversion at index " + i + ", but found none."));
                    continue;
                }
                Assert.assertEquals((String)"Expected conversion function names do not match: ", (Object)expected[i].getName(), (Object)actual[i].getName());
                Assert.assertEquals((String)"Expected conversion arg lengths do not match: ", (long)expected[i].getTypes().length, (long)actual[i].getTypes().length);
            }
        }
    }

    private void helpFindForm(String fname, int numArgs) {
        Assert.assertTrue((boolean)this.library.hasFunctionMethod(fname, numArgs));
    }

    private void helpInvokeMethod(String fname, Object[] inputs, Object expectedOutput) {
        try {
            this.helpInvokeMethod(fname, null, inputs, null, expectedOutput);
        }
        catch (Exception err) {
            throw new RuntimeException(err);
        }
    }

    private void helpInvokeMethod(String fname, Class<?>[] types, Object[] inputs, CommandContext context, Object expectedOutput) throws FunctionExecutionException, BlockedException {
        Object actualOutput = this.helpInvokeMethod(fname, types, inputs, context);
        Assert.assertEquals((String)"Actual function output not equal to expected: ", (Object)expectedOutput, (Object)actualOutput);
    }

    private Object helpInvokeMethod(String fname, Class<?>[] types, Object[] inputs, CommandContext context) throws FunctionExecutionException, BlockedException {
        if (types == null) {
            types = new Class[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                types[i] = DataTypeManager.determineDataTypeClass((Object)inputs[i]);
            }
        }
        if (context == null) {
            context = new CommandContext();
        }
        Object actualOutput = null;
        FunctionDescriptor descriptor = this.library.findFunction(fname, (Class[])types);
        if (descriptor.requiresContext()) {
            Object[] in = new Object[inputs.length + 1];
            in[0] = context;
            for (int i = 0; i < inputs.length; ++i) {
                in[i + 1] = inputs[i];
            }
            actualOutput = descriptor.invokeFunction(in, null, null);
        } else {
            actualOutput = descriptor.invokeFunction(inputs, null, null);
        }
        return actualOutput;
    }

    private void helpInvokeMethodFail(String fname, Object[] inputs) {
        this.helpInvokeMethodFail(fname, null, inputs);
    }

    private void helpInvokeMethodFail(String fname, Class<?>[] types, Object[] inputs) {
        try {
            this.helpInvokeMethod(fname, types, inputs, null);
            Assert.fail((String)"expected exception");
        }
        catch (FunctionExecutionException err) {
        }
        catch (BlockedException e) {
            // empty catch block
        }
    }

    @Test
    public void testFindFunction1() {
        this.helpFindFunction("convert", new Class[]{T_INTEGER, T_STRING}, this.helpCreateDescriptor("convert", new Class[]{T_INTEGER, T_STRING}));
    }

    @Test
    public void testFindFunction2() {
        this.helpFindFunction("cast", new Class[]{T_INTEGER, T_STRING}, this.helpCreateDescriptor("cast", new Class[]{T_INTEGER, T_STRING}));
    }

    @Test
    public void testFindFunction3() {
        this.helpFindFunction("curdate", new Class[0], this.helpCreateDescriptor("curdate", new Class[0]));
    }

    @Test
    public void testFindFunction4() {
        this.helpFindFunctionFail("curdate", new Class[]{T_INTEGER});
    }

    @Test
    public void testFindFunction5() {
        this.helpFindFunction("+", new Class[]{T_INTEGER, T_INTEGER}, this.helpCreateDescriptor("+", new Class[]{T_INTEGER, T_INTEGER}));
    }

    @Test
    public void testFindFunction6() {
        this.helpFindFunctionFail("+", new Class[]{T_INTEGER, T_FLOAT});
    }

    @Test
    public void testFindFunction7() {
        this.helpFindFunctionFail("+", new Class[]{T_INTEGER, T_FLOAT, T_INTEGER});
    }

    @Test
    public void testFindFunction8() {
        this.helpFindFunctionFail("+", new Class[]{T_INTEGER});
    }

    @Test
    public void testFindFunction9() {
        this.helpFindFunctionFail("+", new Class[]{T_INTEGER, T_NULL});
    }

    @Test
    public void testFindFunction10() {
        this.helpFindFunction("substring", new Class[]{T_STRING, T_INTEGER, T_INTEGER}, this.helpCreateDescriptor("substring", new Class[]{T_STRING, T_INTEGER, T_INTEGER}));
    }

    @Test
    public void testFindFunction11() {
        this.helpFindFunction("substring", new Class[]{T_STRING, T_INTEGER}, this.helpCreateDescriptor("substring", new Class[]{T_STRING, T_INTEGER}));
    }

    @Test
    public void testFindFunction12() {
        this.helpFindFunction("context", new Class[]{T_STRING, T_INTEGER}, this.helpCreateDescriptor("context", new Class[]{T_STRING, T_INTEGER}));
    }

    @Test
    public void testFindFunction12a() {
        this.helpFindFunction("rowlimit", new Class[]{T_STRING}, this.helpCreateDescriptor("rowlimit", new Class[]{T_STRING}));
    }

    @Test
    public void testFindFunction12b() {
        this.helpFindFunction("rowlimitexception", new Class[]{T_STRING}, this.helpCreateDescriptor("rowlimitexception", new Class[]{T_STRING}));
    }

    @Test
    public void testFind0ArgConversion1() {
        this.helpFindConversions("curdate", new Class[0], new FunctionDescriptor[0]);
    }

    @Test
    public void testFind0ArgConversion2() {
        this.helpFindConversions("curdate", new Class[]{T_INTEGER}, null);
    }

    @Test
    public void testFind1ArgConversion1() {
        this.helpFindConversions("length", new Class[]{T_STRING}, new FunctionDescriptor[1]);
    }

    @Test
    public void testFind1ArgConversion2() {
        this.helpFindConversions("length", new Class[]{T_INTEGER}, new FunctionDescriptor[]{this.helpCreateDescriptor("convert", new Class[]{T_INTEGER, T_STRING})});
    }

    @Test
    public void testFind1ArgConversion3() {
        this.helpFindConversions("length", new Class[]{DataTypeManager.DefaultDataClasses.TIMESTAMP}, new FunctionDescriptor[]{this.helpCreateDescriptor("convert", new Class[]{DataTypeManager.DefaultDataClasses.TIMESTAMP, T_STRING})});
    }

    @Test
    public void testFind2ArgConversion1() {
        this.helpFindConversions("+", new Class[]{T_INTEGER, T_INTEGER}, new FunctionDescriptor[2]);
    }

    @Test
    public void testFind2ArgConversion2() {
        this.helpFindConversions("+", new Class[]{T_INTEGER, T_FLOAT}, new FunctionDescriptor[]{this.helpCreateDescriptor("convert", new Class[]{T_INTEGER, T_STRING}), this.helpCreateDescriptor("convert", new Class[]{T_FLOAT, T_STRING})});
    }

    @Test
    public void testFind2ArgConversion3() {
        this.helpFindConversions("+", new Class[]{T_FLOAT, T_INTEGER}, new FunctionDescriptor[]{this.helpCreateDescriptor("convert", new Class[]{T_FLOAT, T_STRING}), this.helpCreateDescriptor("convert", new Class[]{T_INTEGER, T_STRING})});
    }

    @Test
    public void testFind2ArgConversion4() {
        this.helpFindConversions("+", new Class[]{T_STRING, T_FLOAT}, null);
    }

    @Test
    public void testFind2ArgConversion5() {
        this.helpFindConversions("+", new Class[]{T_NULL, T_NULL}, new FunctionDescriptor[]{this.helpCreateDescriptor("convert", new Class[]{T_NULL, T_STRING}), this.helpCreateDescriptor("convert", new Class[]{T_NULL, T_STRING})});
    }

    @Test
    public void testFind2ArgConversion6() {
        this.helpFindConversions("+", new Class[]{T_NULL, T_INTEGER}, new FunctionDescriptor[]{this.helpCreateDescriptor("convert", new Class[]{T_NULL, T_STRING}), null});
    }

    @Test
    public void testFind2ArgConversion7() {
        this.helpFindConversions("+", new Class[]{T_INTEGER, T_NULL}, new FunctionDescriptor[]{null, this.helpCreateDescriptor("convert", new Class[]{T_NULL, T_STRING})});
    }

    @Test
    public void testFind3ArgConversion1() {
        this.helpFindConversions("substring", new Class[]{T_STRING, T_INTEGER, T_INTEGER}, new FunctionDescriptor[3]);
    }

    @Test
    public void testFind3ArgConversion2() {
        this.helpFindConversions("substring", new Class[]{T_INTEGER, T_INTEGER, T_INTEGER}, new FunctionDescriptor[]{this.helpCreateDescriptor("convert", new Class[]{T_INTEGER, T_STRING}), null, null});
    }

    @Test
    public void testFind3ArgConversion3() {
        this.helpFindConversions("substring", new Class[]{T_INTEGER, T_INTEGER, DataTypeManager.DefaultDataClasses.SHORT}, new FunctionDescriptor[]{this.helpCreateDescriptor("convert", new Class[]{T_INTEGER, T_STRING}), null, this.helpCreateDescriptor("convert", new Class[]{DataTypeManager.DefaultDataClasses.SHORT, T_STRING})});
    }

    @Test
    public void testFind3ArgConversion4() {
        this.helpFindConversions("substring", new Class[]{T_STRING, T_INTEGER, DataTypeManager.DefaultDataClasses.TIMESTAMP}, null);
    }

    @Test
    public void testFind3ArgConversion5() {
        this.helpFindConversions("substring", new Class[]{T_STRING, DataTypeManager.DefaultDataClasses.SHORT, DataTypeManager.DefaultDataClasses.SHORT}, new FunctionDescriptor[]{null, this.helpCreateDescriptor("convert", new Class[]{DataTypeManager.DefaultDataClasses.SHORT, T_STRING}), this.helpCreateDescriptor("convert", new Class[]{DataTypeManager.DefaultDataClasses.SHORT, T_STRING})});
    }

    @Test
    public void testFind3ArgConversion6() {
        this.helpFindConversions("substring", new Class[]{T_INTEGER, DataTypeManager.DefaultDataClasses.SHORT, DataTypeManager.DefaultDataClasses.SHORT}, new FunctionDescriptor[]{this.helpCreateDescriptor("convert", new Class[]{DataTypeManager.DefaultDataClasses.INTEGER, T_STRING}), this.helpCreateDescriptor("convert", new Class[]{DataTypeManager.DefaultDataClasses.SHORT, T_STRING}), this.helpCreateDescriptor("convert", new Class[]{DataTypeManager.DefaultDataClasses.SHORT, T_STRING})});
    }

    @Test
    public void testFind3ArgConversion7() {
        this.helpFindConversions("substring", new Class[]{T_NULL, T_INTEGER, T_INTEGER}, new FunctionDescriptor[]{this.helpCreateDescriptor("convert", new Class[]{T_NULL, T_STRING}), null, null});
    }

    @Test
    public void testFind3ArgConversion8() {
        this.helpFindConversions("substring", new Class[]{T_NULL, T_NULL, T_INTEGER}, new FunctionDescriptor[]{this.helpCreateDescriptor("convert", new Class[]{T_NULL, T_STRING}), this.helpCreateDescriptor("convert", new Class[]{T_NULL, T_STRING}), null});
    }

    @Test
    public void testFind3ArgConversion9() {
        this.helpFindConversions("substring", new Class[]{T_NULL, T_NULL, T_NULL}, new FunctionDescriptor[]{this.helpCreateDescriptor("convert", new Class[]{T_NULL, T_STRING}), this.helpCreateDescriptor("convert", new Class[]{T_NULL, T_STRING}), this.helpCreateDescriptor("convert", new Class[]{T_NULL, T_STRING})});
    }

    @Test
    public void testFindForm1() {
        this.helpFindForm("convert", 2);
    }

    @Test
    public void testFindForm2() {
        this.helpFindForm("locate", 2);
    }

    @Test
    public void testFindForm3() {
        this.helpFindForm("locate", 3);
    }

    @Test
    public void testFindForm4() {
        this.helpFindForm("substring", 2);
    }

    @Test
    public void testFindForm5() {
        this.helpFindForm("substring", 3);
    }

    @Test
    public void testFindForm6() {
        this.helpFindForm("now", 0);
    }

    @Test
    public void testInvokePlus1() {
        this.helpInvokeMethod("+", new Object[]{new Integer(3), new Integer(2)}, new Integer(5));
    }

    @Test
    public void testInvokePlus2() {
        this.helpInvokeMethod("+", new Object[]{new Long(3L), new Long(2L)}, new Long(5L));
    }

    @Test
    public void testInvokePlus3() {
        this.helpInvokeMethod("+", new Object[]{new Float(3.0f), new Float(2.0f)}, new Float(5.0f));
    }

    @Test
    public void testInvokePlus4() {
        this.helpInvokeMethod("+", new Object[]{new Double(3.0), new Double(2.0)}, new Double(5.0));
    }

    @Test
    public void testInvokePlus5() {
        this.helpInvokeMethod("+", new Object[]{new BigInteger("3"), new BigInteger("2")}, new BigInteger("5"));
    }

    @Test
    public void testInvokePlus6() {
        this.helpInvokeMethod("+", new Object[]{new BigDecimal("3"), new BigDecimal("2")}, new BigDecimal("5"));
    }

    @Test
    public void testInvokeMinus1() {
        this.helpInvokeMethod("-", new Object[]{new Integer(3), new Integer(2)}, new Integer(1));
    }

    @Test
    public void testInvokeMinus2() {
        this.helpInvokeMethod("-", new Object[]{new Long(3L), new Long(2L)}, new Long(1L));
    }

    @Test
    public void testInvokeMinus3() {
        this.helpInvokeMethod("-", new Object[]{new Float(3.0f), new Float(2.0f)}, new Float(1.0f));
    }

    @Test
    public void testInvokeMinus4() {
        this.helpInvokeMethod("-", new Object[]{new Double(3.0), new Double(2.0)}, new Double(1.0));
    }

    @Test
    public void testInvokeMinus5() {
        this.helpInvokeMethod("-", new Object[]{new BigInteger("3"), new BigInteger("2")}, new BigInteger("1"));
    }

    @Test
    public void testInvokeMinus6() {
        this.helpInvokeMethod("-", new Object[]{new BigDecimal("3"), new BigDecimal("2")}, new BigDecimal("1"));
    }

    @Test
    public void testInvokeMultiply1() {
        this.helpInvokeMethod("*", new Object[]{new Integer(3), new Integer(2)}, new Integer(6));
    }

    @Test
    public void testInvokeMultiply2() {
        this.helpInvokeMethod("*", new Object[]{new Long(3L), new Long(2L)}, new Long(6L));
    }

    @Test
    public void testInvokeMultiply3() {
        this.helpInvokeMethod("*", new Object[]{new Float(3.0f), new Float(2.0f)}, new Float(6.0f));
    }

    @Test
    public void testInvokeMultiply4() {
        this.helpInvokeMethod("*", new Object[]{new Double(3.0), new Double(2.0)}, new Double(6.0));
    }

    @Test
    public void testInvokeMultiply5() {
        this.helpInvokeMethod("*", new Object[]{new BigInteger("3"), new BigInteger("2")}, new BigInteger("6"));
    }

    @Test
    public void testInvokeMultiply6() {
        this.helpInvokeMethod("*", new Object[]{new BigDecimal("3"), new BigDecimal("2")}, new BigDecimal("6"));
    }

    @Test
    public void testInvokeDivide1() {
        this.helpInvokeMethod("/", new Object[]{new Integer(3), new Integer(2)}, new Integer(1));
    }

    @Test
    public void testInvokeDivide2() {
        this.helpInvokeMethod("/", new Object[]{new Long(3L), new Long(2L)}, new Long(1L));
    }

    @Test
    public void testInvokeDivide3() {
        this.helpInvokeMethod("/", new Object[]{new Float(3.0f), new Float(2.0f)}, new Float(1.5));
    }

    @Test
    public void testInvokeDivide4() {
        this.helpInvokeMethod("/", new Object[]{new Double(3.0), new Double(2.0)}, new Double(1.5));
    }

    @Test
    public void testInvokeDivide5() {
        this.helpInvokeMethod("/", new Object[]{new BigInteger("3"), new BigInteger("2")}, new BigInteger("1"));
    }

    @Test
    public void testInvokeDivide6() {
        this.helpInvokeMethod("/", new Object[]{new BigDecimal("3"), new BigDecimal("2")}, new BigDecimal("1.5"));
    }

    @Test
    public void testInvokeDivide7() throws Exception {
        this.helpInvokeMethodFail("/", new Object[]{new Float("3"), new Float("0")});
    }

    @Test
    public void testInvokeDivideMod() {
        this.helpInvokeMethod("mod", new Object[]{new BigDecimal("3.1"), new BigDecimal("2")}, new BigDecimal("1.1"));
    }

    @Test
    public void testInvokeAbs1() {
        this.helpInvokeMethod("abs", new Object[]{new Integer(-3)}, new Integer(3));
    }

    @Test
    public void testInvokeAbs2() {
        this.helpInvokeMethod("abs", new Object[]{new Long(-3L)}, new Long(3L));
    }

    @Test
    public void testInvokeAbs3() {
        this.helpInvokeMethod("abs", new Object[]{new Float(-3.0f)}, new Float(3.0f));
    }

    @Test
    public void testInvokeAbs4() {
        this.helpInvokeMethod("abs", new Object[]{new Double(-3.0)}, new Double(3.0));
    }

    @Test
    public void testInvokeAbs5() {
        this.helpInvokeMethod("abs", new Object[]{new BigInteger("-3")}, new BigInteger("3"));
    }

    @Test
    public void testInvokeAbs6() {
        this.helpInvokeMethod("abs", new Object[]{new BigDecimal("-3")}, new BigDecimal("3"));
    }

    @Test
    public void testInvokeAcos() {
        this.helpInvokeMethod("acos", new Object[]{new Double(0.05)}, new Double(1.5207754699891267));
    }

    @Test
    public void testInvokeAsin() {
        this.helpInvokeMethod("asin", new Object[]{new Double(0.05)}, new Double(0.050020856805770016));
    }

    @Test
    public void testInvokeAtan() {
        this.helpInvokeMethod("atan", new Object[]{new Double(0.05)}, new Double(0.049958395721942765));
    }

    @Test
    public void testInvokeAtan2() {
        this.helpInvokeMethod("atan2", new Object[]{new Double(0.05), new Double(0.07)}, new Double(0.6202494859828215));
    }

    @Test
    public void testInvokeAtanBigDecimal() {
        this.helpInvokeMethod("atan", new Object[]{new BigDecimal(0.05)}, new Double(0.049958395721942765));
    }

    @Test
    public void testInvokeAtan2BigDecimal() {
        this.helpInvokeMethod("atan2", new Object[]{new BigDecimal(0.05), new BigDecimal(0.07)}, new Double(0.6202494859828215));
    }

    @Test
    public void testInvokeCos() {
        this.helpInvokeMethod("cos", new Object[]{new Double(1.57)}, new Double(7.963267107332633E-4));
    }

    @Test
    public void testInvokeCot() {
        this.helpInvokeMethod("cot", new Object[]{new Double(1.57)}, new Double(7.963269632231926E-4));
    }

    @Test
    public void testInvokeDegrees() {
        this.helpInvokeMethod("degrees", new Object[]{new Double(1.57)}, new Double(89.95437383553926));
    }

    @Test
    public void testInvokePI() {
        this.helpInvokeMethod("pi", new Object[0], new Double(Math.PI));
    }

    @Test
    public void testInvokeRadians() {
        this.helpInvokeMethod("radians", new Object[]{new Double(89.95437383553926)}, new Double(1.57));
    }

    @Test
    public void testInvokeSin() {
        this.helpInvokeMethod("sin", new Object[]{new Double(1.57)}, new Double(0.9999996829318346));
    }

    @Test
    public void testInvokeTan() {
        this.helpInvokeMethod("tan", new Object[]{new Double(0.785)}, new Double(0.9992039901050427));
    }

    @Test
    public void testInvokeAscii() {
        this.helpInvokeMethod("ascii", new Object[]{" "}, new Integer(32));
    }

    @Test
    public void testInvokeChr() {
        this.helpInvokeMethod("chr", new Object[]{new Integer(32)}, new Character(' '));
    }

    @Test
    public void testInvokeNvl() {
        this.helpInvokeMethod("nvl", new Object[]{new Integer(5), new Integer(10)}, new Integer(5));
    }

    @Test
    public void testInvokeConcatOperator() {
        this.helpInvokeMethod("||", new Object[]{"a", "b"}, "ab");
    }

    @Test
    public void testInvokeInitcap() {
        this.helpInvokeMethod("initcap", new Object[]{"my test\ndata"}, "My Test\nData");
    }

    @Test
    public void testInvokeLpad1() {
        this.helpInvokeMethod("lpad", new Object[]{"x", new Integer(3)}, "  x");
    }

    @Test
    public void testInvokeLpad2() {
        this.helpInvokeMethod("lpad", new Object[]{"x", new Integer(3), "y"}, "yyx");
    }

    @Test
    public void testInvokeRpad1() {
        this.helpInvokeMethod("rpad", new Object[]{"x", new Integer(3)}, "x  ");
    }

    @Test
    public void testInvokeRpad2() {
        this.helpInvokeMethod("rpad", new Object[]{"x", new Integer(3), "y"}, "xyy");
    }

    @Test
    public void testInvokeTranslate() {
        this.helpInvokeMethod("translate", new Object[]{"ababcd", "ad", "da"}, "dbdbca");
    }

    @Test
    public void testFindFunction13() {
        this.helpFindFunction("formatTime", new Class[]{T_TIME, T_STRING}, this.helpCreateDescriptor("formatTime", new Class[]{T_TIME, T_STRING}));
    }

    @Test
    public void testFindFunction14() {
        this.helpFindFunction("formatDate", new Class[]{T_DATE, T_STRING}, this.helpCreateDescriptor("formatDate", new Class[]{T_DATE, T_STRING}));
    }

    @Test
    public void testFindFunction15() {
        this.helpFindFunction("formatTimestamp", new Class[]{T_TIMESTAMP, T_STRING}, this.helpCreateDescriptor("formatTimestamp", new Class[]{T_TIMESTAMP, T_STRING}));
    }

    @Test
    public void testFindFunction16() {
        this.helpFindFunction("parseTime", new Class[]{T_STRING, T_STRING}, this.helpCreateDescriptor("parseTime", new Class[]{T_STRING, T_STRING}));
    }

    @Test
    public void testFindFunction17() {
        this.helpFindFunction("parseDate", new Class[]{T_STRING, T_STRING}, this.helpCreateDescriptor("parseDate", new Class[]{T_STRING, T_STRING}));
    }

    @Test
    public void testFindFunction18() {
        this.helpFindFunction("parseTimestamp", new Class[]{T_STRING, T_STRING}, this.helpCreateDescriptor("parseTimestamp", new Class[]{T_STRING, T_STRING}));
    }

    @Test
    public void testFindFunction19() {
        this.helpFindFunction("env", new Class[]{T_STRING}, this.helpCreateDescriptor("env", new Class[]{T_STRING}));
    }

    @Test
    public void testInvokeFormatTimestamp1() {
        this.helpInvokeMethod("formatTimestamp", new Object[]{TimestampUtil.createTimestamp((int)103, (int)2, (int)5, (int)3, (int)4, (int)12, (int)255), new String("mm/dd/yy h:mm a")}, "04/05/03 3:04 AM");
    }

    @Test
    public void testInvokeFormatTimestamp2() {
        this.helpInvokeMethod("formatTimestamp", new Object[]{TimestampUtil.createTimestamp((int)103, (int)2, (int)5, (int)3, (int)4, (int)12, (int)255), new String("yyyy-mm-dd k:mm a z")}, "2003-04-05 3:04 AM GMT-06:00");
    }

    @Test
    public void testInvokeFormatTimestamp3() {
        this.helpInvokeMethod("formatTimestamp", new Object[]{TimestampUtil.createTimestamp((int)103, (int)2, (int)5, (int)3, (int)4, (int)12, (int)255), new String("yyyy-mm-dd hh:mm:ss.SSSS")}, "2003-04-05 03:04:12.0000");
    }

    @Test
    public void testInvokeFormatTimestampFail() throws Exception {
        this.helpInvokeMethodFail("formatTimestamp", new Object[]{TimestampUtil.createTimestamp((int)103, (int)2, (int)5, (int)3, (int)4, (int)12, (int)255), new String("mm/dd/nn h:mm a")});
    }

    @Test
    public void testInvokeParseTimestamp1() {
        this.helpInvokeMethod("parseTimestamp", new Object[]{new String("05 Mar 2003 03:12:23 CST"), new String("dd MMM yyyy HH:mm:ss z")}, TimestampUtil.createTimestamp((int)103, (int)2, (int)5, (int)3, (int)12, (int)23, (int)0));
    }

    @Test
    public void testInvokeParseTimestamp2() {
        this.helpInvokeMethod("parseTimestamp", new Object[]{new String("05 Mar 2003 03:12:23.333"), new String("dd MMM yyyy HH:mm:ss.SSS")}, TimestampUtil.createTimestamp((int)103, (int)2, (int)5, (int)3, (int)12, (int)23, (int)333000000));
    }

    @Test
    public void testFindFormatInteger() {
        this.helpFindFunction("formatInteger", new Class[]{T_INTEGER, T_STRING}, this.helpCreateDescriptor("formatInteger", new Class[]{T_INTEGER, T_STRING}));
    }

    @Test
    public void testFindFormatFloat() {
        this.helpFindFunction("formatFloat", new Class[]{T_FLOAT, T_STRING}, this.helpCreateDescriptor("formatFloat", new Class[]{T_FLOAT, T_STRING}));
    }

    @Test
    public void testFindFormatDouble() {
        this.helpFindFunction("formatDouble", new Class[]{T_DOUBLE, T_STRING}, this.helpCreateDescriptor("formatDouble", new Class[]{T_DOUBLE, T_STRING}));
    }

    @Test
    public void testFindFormatLong() {
        this.helpFindFunction("formatLong", new Class[]{T_LONG, T_STRING}, this.helpCreateDescriptor("formatLong", new Class[]{T_LONG, T_STRING}));
    }

    @Test
    public void testFindFormatBigInteger() {
        this.helpFindFunction("formatBigInteger", new Class[]{T_BIG_INTEGER, T_STRING}, this.helpCreateDescriptor("formatBigInteger", new Class[]{T_BIG_INTEGER, T_STRING}));
    }

    @Test
    public void testFindFormatBigDecimal() {
        this.helpFindFunction("formatBigDecimal", new Class[]{T_BIG_DECIMAL, T_STRING}, this.helpCreateDescriptor("formatBigDecimal", new Class[]{T_BIG_DECIMAL, T_STRING}));
    }

    @Test
    public void testFindParseInteger() {
        this.helpFindFunction("parseInteger", new Class[]{T_STRING, T_STRING}, this.helpCreateDescriptor("parseInteger", new Class[]{T_STRING, T_STRING}));
    }

    @Test
    public void testFindParseLong() {
        this.helpFindFunction("parseLong", new Class[]{T_STRING, T_STRING}, this.helpCreateDescriptor("parseLong", new Class[]{T_STRING, T_STRING}));
    }

    @Test
    public void testFindParseDouble() {
        this.helpFindFunction("parseDouble", new Class[]{T_STRING, T_STRING}, this.helpCreateDescriptor("parseDouble", new Class[]{T_STRING, T_STRING}));
    }

    @Test
    public void testFindParseFloat() {
        this.helpFindFunction("parseFloat", new Class[]{T_STRING, T_STRING}, this.helpCreateDescriptor("parseFloat", new Class[]{T_STRING, T_STRING}));
    }

    @Test
    public void testFindParseBigInteger() {
        this.helpFindFunction("parseBigInteger", new Class[]{T_STRING, T_STRING}, this.helpCreateDescriptor("parseBigInteger", new Class[]{T_STRING, T_STRING}));
    }

    @Test
    public void testFindParseBigDecimal() {
        this.helpFindFunction("parseBigDecimal", new Class[]{T_STRING, T_STRING}, this.helpCreateDescriptor("parseBigDecimal", new Class[]{T_STRING, T_STRING}));
    }

    @Test
    public void testInvokeParseInteger() {
        this.helpInvokeMethod("parseInteger", new Object[]{new String("-1234"), new String("######")}, new Integer(-1234));
    }

    @Test
    public void testInvokeParseLong() {
        this.helpInvokeMethod("parseLong", new Object[]{new String("123456"), new String("######.##")}, new Long(123456L));
    }

    @Test
    public void testInvokeParseDouble() {
        this.helpInvokeMethod("parseDouble", new Object[]{new String("123456.78"), new String("#####.#")}, new Double(123456.78));
    }

    @Test
    public void testInvokeParseFloat() {
        this.helpInvokeMethod("parseFloat", new Object[]{new String("1234.56"), new String("####.###")}, new Float(1234.56));
    }

    @Test
    public void testInvokeParseBigInteger() {
        this.helpInvokeMethod("parseBigInteger", new Object[]{new String("12345678"), new String("###,###")}, new BigInteger("12345678"));
    }

    @Test
    public void testInvokeParseBigDecimal() {
        this.helpInvokeMethod("parseBigDecimal", new Object[]{new String("1234.56"), new String("#####")}, new BigDecimal("1234.56"));
    }

    @Test
    public void testInvokeFormatInteger() {
        this.helpInvokeMethod("formatInteger", new Object[]{new Integer(-1234), new String("######")}, "-1234");
    }

    @Test
    public void testInvokeFormatLong() {
        this.helpInvokeMethod("formatLong", new Object[]{new Long(123456788L), new String("##,###,#")}, "1,2,3,4,5,6,7,8,8");
    }

    @Test
    public void testInvokeFormatDouble() {
        this.helpInvokeMethod("formatDouble", new Object[]{new Double(1234.67), new String("####.##")}, "1234.67");
    }

    @Test
    public void testInvokeFormatFloat() {
        this.helpInvokeMethod("formatFloat", new Object[]{new Float(1234.67), new String("###.###")}, "1234.67");
    }

    @Test
    public void testInvokeFormatBigInteger() {
        this.helpInvokeMethod("formatBigInteger", new Object[]{new BigInteger("45"), new String("###.###")}, "45");
    }

    @Test
    public void testInvokeFormatBigDecimal() {
        this.helpInvokeMethod("formatBigDecimal", new Object[]{new BigDecimal("1234.56"), new String("###.###")}, "1234.56");
    }

    @Test
    public void testInvokeQuarter1() {
        this.helpInvokeMethod("quarter", new Object[]{TimestampUtil.createDate((int)103, (int)4, (int)15)}, new Integer(2));
    }

    @Test
    public void testInvokeQuarter2() {
        this.helpInvokeMethod("quarter", new Object[]{TimestampUtil.createDate((int)103, (int)3, (int)31)}, new Integer(2));
    }

    @Test
    public void testInvokeQuarter3() {
        this.helpInvokeMethod("quarter", new Object[]{TimestampUtil.createDate((int)103, (int)0, (int)31)}, new Integer(1));
    }

    @Test
    public void testInvokeQuarter4() {
        this.helpInvokeMethod("quarter", new Object[]{TimestampUtil.createDate((int)103, (int)8, (int)30)}, new Integer(3));
    }

    @Test
    public void testInvokeQuarter5() {
        this.helpInvokeMethod("quarter", new Object[]{TimestampUtil.createDate((int)103, (int)11, (int)31)}, new Integer(4));
    }

    @Test
    public void testInvokeQuarter6() {
        this.helpInvokeMethod("quarter", new Object[]{TimestampUtil.createDate((int)103, (int)12, (int)45)}, new Integer(1));
    }

    @Test
    public void testInvokeIfNull() {
        this.helpInvokeMethod("ifnull", new Object[]{new Integer(5), new Integer(10)}, new Integer(5));
    }

    @Test
    public void testInvokeLower() {
        this.helpInvokeMethod("lower", new Object[]{new String("LOWER")}, new String("lower"));
    }

    @Test
    public void testInvokeUpper() {
        this.helpInvokeMethod("upper", new Object[]{new String("upper")}, new String("UPPER"));
    }

    @Test
    public void testInvokeRepeat() {
        this.helpInvokeMethod("repeat", new Object[]{new String("cat"), new Integer(3)}, new String("catcatcat"));
    }

    @Test
    public void testInvokeChar() {
        this.helpInvokeMethod("char", new Object[]{new Integer(32)}, new Character(' '));
    }

    @Test
    public void testInvokeInsert1() {
        this.helpInvokeMethod("insert", new Object[]{new String("Downtown"), new Integer(4), new Integer(2), new String("cat")}, new String("Dowcatown"));
    }

    @Test
    public void testInvokeInsert2() {
        this.helpInvokeMethod("insert", new Object[]{new String("Downtown"), new Integer(4), new Integer(2), new String("")}, new String("Dowown"));
    }

    @Test
    public void testInvokeInsert3() {
        this.helpInvokeMethod("insert", new Object[]{new String(""), new Integer(1), new Integer(0), new String("cat")}, new String("cat"));
    }

    @Test
    public void testInvokeInsert4() throws Exception {
        this.helpInvokeMethodFail("insert", new Object[]{new String(""), new Integer(2), new Integer(0), new String("cat")});
    }

    @Test
    public void testInvokeInsert5() throws Exception {
        this.helpInvokeMethodFail("insert", new Object[]{new String(""), new Integer(1), new Integer(1), new String("cat")});
    }

    @Test
    public void testInvokeInsert6() {
        this.helpInvokeMethod("insert", new Object[]{new String("Downtown"), new Integer(7), new Integer(5), new String("cat")}, new String("Downtocat"));
    }

    @Test
    public void testInvokeTimestampAddDate_ignore_case() {
        this.helpInvokeMethod("timestampAdd", new Object[]{"sql_TSI_day", new Integer(28), new Timestamp(TimestampUtil.createDate((int)103, (int)4, (int)15).getTime())}, new Timestamp(TimestampUtil.createDate((int)103, (int)5, (int)12).getTime()));
    }

    @Test
    public void testInvokeTimestampAddDate2() {
        this.helpInvokeMethod("timestampAdd", new Object[]{"SQL_TSI_MONTH", new Integer(18), new Timestamp(TimestampUtil.createDate((int)103, (int)4, (int)15).getTime())}, new Timestamp(TimestampUtil.createDate((int)104, (int)10, (int)15).getTime()));
    }

    @Test
    public void testInvokeTimestampAddDate2a() {
        this.helpInvokeMethod("timestampAdd", new Object[]{"SQL_TSI_MONTH", new Integer(-18), new Timestamp(TimestampUtil.createDate((int)103, (int)4, (int)15).getTime())}, new Timestamp(TimestampUtil.createDate((int)101, (int)10, (int)15).getTime()));
    }

    @Test
    public void testInvokeTimestampAddDate3() {
        this.helpInvokeMethod("timestampAdd", new Object[]{"SQL_TSI_WEEK", new Integer(-6), new Timestamp(TimestampUtil.createDate((int)103, (int)4, (int)15).getTime())}, new Timestamp(TimestampUtil.createDate((int)103, (int)3, (int)3).getTime()));
    }

    @Test
    public void testInvokeTimestampAddDate4() {
        this.helpInvokeMethod("timestampAdd", new Object[]{"SQL_TSI_QUARTER", new Integer(3), new Timestamp(TimestampUtil.createDate((int)103, (int)4, (int)15).getTime())}, new Timestamp(TimestampUtil.createDate((int)104, (int)1, (int)15).getTime()));
    }

    @Test
    public void testInvokeTimestampAddDate5() {
        this.helpInvokeMethod("timestampAdd", new Object[]{"SQL_TSI_YEAR", new Integer(-1), new Timestamp(TimestampUtil.createDate((int)103, (int)4, (int)15).getTime())}, new Timestamp(TimestampUtil.createDate((int)102, (int)4, (int)15).getTime()));
    }

    @Test
    public void testInvokeTimestampAddTime1() {
        this.helpInvokeMethod("timestampAdd", new Object[]{"SQL_TSI_MINUTE", new Integer(23), new Timestamp(TimestampUtil.createTime((int)3, (int)9, (int)12).getTime())}, new Timestamp(TimestampUtil.createTime((int)3, (int)32, (int)12).getTime()));
    }

    @Test
    public void testInvokeTimestampAddTime2() {
        this.helpInvokeMethod("timestampAdd", new Object[]{"SQL_TSI_HOUR", new Integer(21), new Timestamp(TimestampUtil.createTime((int)3, (int)9, (int)12).getTime())}, TimestampUtil.createTimestamp((int)70, (int)0, (int)2, (int)0, (int)9, (int)12, (int)0));
    }

    @Test
    public void testInvokeTimestampAddTime3() {
        this.helpInvokeMethod("timestampAdd", new Object[]{"SQL_TSI_HOUR", new Integer(2), new Timestamp(TimestampUtil.createTime((int)23, (int)12, (int)12).getTime())}, TimestampUtil.createTimestamp((int)70, (int)0, (int)2, (int)1, (int)12, (int)12, (int)0));
    }

    @Test
    public void testInvokeTimestampAddTime4() {
        this.helpInvokeMethod("timestampAdd", new Object[]{"SQL_TSI_SECOND", new Integer(49), new Timestamp(TimestampUtil.createTime((int)3, (int)9, (int)12).getTime())}, new Timestamp(TimestampUtil.createTime((int)3, (int)10, (int)1).getTime()));
    }

    @Test
    public void testInvokeTimestampAddTimestamp1() {
        this.helpInvokeMethod("timestampAdd", new Object[]{"SQL_TSI_SECOND", new Integer(23), TimestampUtil.createTimestamp((int)103, (int)4, (int)15, (int)3, (int)9, (int)12, (int)100)}, TimestampUtil.createTimestamp((int)103, (int)4, (int)15, (int)3, (int)9, (int)35, (int)100));
    }

    @Test
    public void testInvokeTimestampAddTimestamp2() {
        this.helpInvokeMethod("timestampAdd", new Object[]{"SQL_TSI_FRAC_SECOND", new Integer(1), TimestampUtil.createTimestamp((int)103, (int)4, (int)15, (int)3, (int)9, (int)12, (int)100)}, TimestampUtil.createTimestamp((int)103, (int)4, (int)15, (int)3, (int)9, (int)12, (int)101));
    }

    @Test
    public void testInvokeTimestampAddTimestamp3() {
        this.helpInvokeMethod("timestampAdd", new Object[]{"SQL_TSI_FRAC_SECOND", new Integer(2100000000), TimestampUtil.createTimestamp((int)103, (int)4, (int)15, (int)3, (int)9, (int)59, (int)1)}, TimestampUtil.createTimestamp((int)103, (int)4, (int)15, (int)3, (int)10, (int)1, (int)100000003));
    }

    @Test
    public void testInvokeTimestampDiffTime1() {
        this.helpInvokeMethod("timestampDiff", new Object[]{"SQL_TSI_HOUR", new Timestamp(TimestampUtil.createTime((int)3, (int)4, (int)45).getTime()), new Timestamp(TimestampUtil.createTime((int)5, (int)5, (int)36).getTime())}, new Long(2L));
    }

    @Test
    public void testInvokeTimestampDiffTime1_ignorecase() {
        this.helpInvokeMethod("timestampDiff", new Object[]{"SQL_tsi_HOUR", new Timestamp(TimestampUtil.createTime((int)3, (int)4, (int)45).getTime()), new Timestamp(TimestampUtil.createTime((int)5, (int)5, (int)36).getTime())}, new Long(2L));
    }

    @Test
    public void testInvokeTimestampDiffTimestamp1() {
        this.helpInvokeMethod("timestampDiff", new Object[]{"SQL_TSI_WEEK", TimestampUtil.createTimestamp((int)102, (int)5, (int)21, (int)3, (int)9, (int)35, (int)100), TimestampUtil.createTimestamp((int)103, (int)4, (int)2, (int)5, (int)19, (int)35, (int)500)}, new Long(45L));
    }

    @Test
    public void testInvokeTimestampDiffTimestamp2() {
        this.helpInvokeMethod("timestampDiff", new Object[]{"SQL_TSI_FRAC_SECOND", TimestampUtil.createTimestamp((int)102, (int)5, (int)21, (int)3, (int)9, (int)35, (int)1), TimestampUtil.createTimestamp((int)102, (int)5, (int)21, (int)3, (int)9, (int)35, (int)100000000)}, new Long(99999999L));
    }

    @Test
    public void testInvokeTimestampDiffTimestamp3() {
        this.helpInvokeMethod("timestampDiff", new Object[]{"SQL_TSI_FRAC_SECOND", TimestampUtil.createTimestamp((int)102, (int)5, (int)21, (int)3, (int)9, (int)35, (int)2), TimestampUtil.createTimestamp((int)102, (int)5, (int)22, (int)3, (int)9, (int)35, (int)1)}, new Long(86399999999999L));
    }

    @Test
    public void testInvokeTimestampCreate1() {
        this.helpInvokeMethod("timestampCreate", new Object[]{TimestampUtil.createDate((int)103, (int)4, (int)15), TimestampUtil.createTime((int)23, (int)59, (int)59)}, TimestampUtil.createTimestamp((int)103, (int)4, (int)15, (int)23, (int)59, (int)59, (int)0));
    }

    @Test
    public void testInvokeBitand() {
        this.helpInvokeMethod("bitand", new Object[]{new Integer(4095), new Integer(240)}, new Integer(240));
    }

    @Test
    public void testInvokeBitor() {
        this.helpInvokeMethod("bitor", new Object[]{new Integer(4095), new Integer(240)}, new Integer(4095));
    }

    @Test
    public void testInvokeBitxor() {
        this.helpInvokeMethod("bitxor", new Object[]{new Integer(4095), new Integer(240)}, new Integer(3855));
    }

    @Test
    public void testInvokeBitnot() {
        this.helpInvokeMethod("bitnot", new Object[]{new Integer(3855)}, new Integer(-3856));
    }

    @Test
    public void testInvokeRound1() {
        this.helpInvokeMethod("round", new Object[]{new Integer(123), new Integer(-1)}, new Integer(120));
    }

    @Test
    public void testInvokeRound2() {
        this.helpInvokeMethod("round", new Object[]{new Float(123.456), new Integer(2)}, new Float(123.46));
    }

    @Test
    public void testInvokeRound3() {
        this.helpInvokeMethod("round", new Object[]{new Double(123.456), new Integer(2)}, new Double(123.46));
    }

    @Test
    public void testInvokeRound4() {
        this.helpInvokeMethod("round", new Object[]{new BigDecimal("123.456"), new Integer(2)}, new BigDecimal("123.460"));
    }

    @Test
    public void testInvokeConvertTime() {
        this.helpInvokeMethod("convert", new Object[]{"05:00:00", "time"}, TimestampUtil.createTime((int)5, (int)0, (int)0));
    }

    @Test
    public void testInvokeXpath1() {
        this.helpInvokeMethod("xpathValue", new Object[]{"<?xml version=\"1.0\" encoding=\"utf-8\" ?><a><b><c>test</c></b></a>", "a/b/c"}, "test");
    }

    @Test
    public void testInvokeXpathWithNill() {
        this.helpInvokeMethod("xpathValue", new Object[]{"<?xml version=\"1.0\" encoding=\"utf-8\" ?><a xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><b xsi:nil=\"true\"/></a>", "//*[local-name()='b' and not(@*[local-name()='nil' and string()='true'])]"}, null);
    }

    @Test
    public void testInvokeXpathWithNill1() {
        this.helpInvokeMethod("xpathValue", new Object[]{"<?xml version=\"1.0\" encoding=\"utf-8\" ?><a><b>value</b></a>", "//*[local-name()='b' and not(@*[local-name()='nil' and string()='true'])]"}, "value");
    }

    @Test
    public void testInvokeModifyTimeZone() {
        Timestamp ts = Timestamp.valueOf("2004-10-03 23:59:59.123");
        Timestamp out = Timestamp.valueOf("2004-10-03 22:59:59.123");
        this.helpInvokeMethod("modifyTimeZone", new Object[]{ts, "America/Chicago", "America/New_York"}, out);
    }

    public void defer_testInvokeModifyTimeZoneFromLocal() {
        Timestamp ts = Timestamp.valueOf("2004-10-03 23:59:59.123");
        Timestamp out = Timestamp.valueOf("2004-10-03 21:59:59.123");
        this.helpInvokeMethod("modifyTimeZone", new Object[]{ts, "America/New_York"}, out);
    }

    @Test
    public void testInvokeRand() throws Exception {
        this.helpInvokeMethod("rand", new Object[]{new Integer(100)}, new Double(0.7220096548596434));
        Assert.assertNotNull((Object)this.helpInvokeMethod("rand", new Class[]{Integer.class}, new Object[]{null}, null));
    }

    @Test
    public void testInvokeUser() throws Exception {
        CommandContext c = new CommandContext();
        c.setUserName("foodude");
        this.helpInvokeMethod("user", new Class[0], new Object[0], c, "foodude");
    }

    @Test
    public void testInvokeEnv() throws Exception {
        this.helpInvokeMethod("env", new Class[]{String.class}, new Object[]{null}, null);
    }

    @Test
    public void testInvokeCommandPayload() throws Exception {
        CommandContext c = new CommandContext();
        c.setCommandPayload((Serializable)((Object)"payload_too heavy"));
        this.helpInvokeMethod("commandpayload", new Class[0], new Object[0], c, "payload_too heavy");
        this.helpInvokeMethod("commandpayload", new Class[]{String.class}, new Object[]{null}, c, null);
        Properties props = new Properties();
        props.setProperty("payload", "payload_too heavy");
        c.setCommandPayload((Serializable)props);
        this.helpInvokeMethod("commandpayload", new Class[]{String.class}, new Object[]{"payload"}, c, "payload_too heavy");
    }

    @Test
    public void testNullDependent() {
        FunctionDescriptor actual = this.library.findFunction("concat2", new Class[]{String.class, String.class});
        Assert.assertTrue((boolean)actual.isNullDependent());
        actual = this.library.findFunction("concat", new Class[]{String.class, String.class});
        Assert.assertFalse((boolean)actual.isNullDependent());
    }

    @Test
    public void testInvokeCeiling() {
        this.helpInvokeMethod("ceiling", new Object[]{new Double("3.14")}, new Double("4"));
    }

    @Test
    public void testInvokeFloor() {
        this.helpInvokeMethod("floor", new Object[]{new Double("3.14")}, new Double("3"));
    }

    @Test
    public void testInvokeExp() {
        this.helpInvokeMethod("exp", new Object[]{new Double("0")}, new Double("1"));
    }

    @Test
    public void testInvokeLog() {
        this.helpInvokeMethod("log", new Object[]{new Double("1")}, new Double("0"));
    }

    @Test
    public void testInvokeLog10() {
        this.helpInvokeMethod("log10", new Object[]{new Double("10")}, new Double("1"));
    }

    @Test
    public void testInvokeLog10Error() throws Exception {
        this.helpInvokeMethodFail("log10", new Object[]{new Double("0")});
    }

    @Test
    public void testInvokePower() {
        this.helpInvokeMethod("power", new Object[]{new Double("10"), new Double("2")}, new Double("100"));
    }

    @Test
    public void testInvokePower1() {
        this.helpInvokeMethod("power", new Object[]{new BigDecimal("10"), new Integer(2)}, new BigDecimal("100"));
    }

    @Test
    public void testInvokeSqrt() {
        this.helpInvokeMethod("sqrt", new Object[]{new Double("4")}, new Double("2"));
    }

    @Test
    public void testInvokeDayName() {
        String[] dayNames = FunctionMethods.getDayNames();
        for (int i = 0; i < dayNames.length; ++i) {
            Date time = TimestampUtil.createDate((int)100, (int)0, (int)(i + 2));
            this.helpInvokeMethod("dayName", new Object[]{time}, dayNames[i]);
        }
    }

    @Test
    public void testInvokeDayOfMonth() {
        Timestamp time = TimestampUtil.createTimestamp((int)100, (int)0, (int)1, (int)1, (int)2, (int)3, (int)4);
        this.helpInvokeMethod("dayOfMonth", new Object[]{time}, new Integer(1));
    }

    @Test
    public void testInvokeDayOfWeek() {
        Timestamp time = TimestampUtil.createTimestamp((int)100, (int)0, (int)1, (int)1, (int)2, (int)3, (int)4);
        this.helpInvokeMethod("dayOfWeek", new Object[]{time}, new Integer(7));
    }

    @Test
    public void testInvokeDayOfYear() {
        Timestamp time = TimestampUtil.createTimestamp((int)100, (int)0, (int)2, (int)1, (int)2, (int)3, (int)4);
        this.helpInvokeMethod("dayOfYear", new Object[]{time}, new Integer(2));
    }

    @Test
    public void testInvokeMonth() {
        Timestamp time = TimestampUtil.createTimestamp((int)100, (int)0, (int)1, (int)1, (int)2, (int)3, (int)4);
        this.helpInvokeMethod("month", new Object[]{time}, new Integer(1));
    }

    @Test
    public void testInvokeMonthName() {
        String[] monthNames = FunctionMethods.getMonthNames();
        for (int i = 0; i < monthNames.length; ++i) {
            Date time = TimestampUtil.createDate((int)100, (int)i, (int)1);
            this.helpInvokeMethod("monthName", new Object[]{time}, monthNames[i]);
        }
    }

    @Test
    public void testInvokeMinute() {
        Timestamp time = TimestampUtil.createTimestamp((int)100, (int)0, (int)1, (int)1, (int)2, (int)3, (int)4);
        this.helpInvokeMethod("minute", new Object[]{time}, new Integer(2));
    }

    @Test
    public void testInvokeSecond() {
        Timestamp time = TimestampUtil.createTimestamp((int)100, (int)0, (int)1, (int)1, (int)2, (int)3, (int)4);
        this.helpInvokeMethod("second", new Object[]{time}, new Integer(3));
    }

    @Test
    public void testInvokeWeek() {
        Timestamp time = TimestampUtil.createTimestamp((int)100, (int)0, (int)1, (int)1, (int)2, (int)3, (int)4);
        this.helpInvokeMethod("week", new Object[]{time}, 52);
    }

    @Test
    public void testInvokeYear() {
        Timestamp time = TimestampUtil.createTimestamp((int)100, (int)0, (int)1, (int)1, (int)2, (int)3, (int)4);
        this.helpInvokeMethod("year", new Object[]{time}, new Integer(2000));
    }

    @Test
    public void testInvokeCoalesce() {
        this.helpInvokeMethod("coalesce", new Object[]{0, 1, 2}, 0);
    }

    @Test
    public void testInvokeCoalesce1() {
        this.helpInvokeMethod("coalesce", new Object[]{null, null}, null);
    }

    @Test
    public void testInvokeNull() throws Exception {
        this.helpInvokeMethod("ltrim", new Class[]{DataTypeManager.DefaultDataClasses.STRING}, new Object[]{null}, null, null);
    }

    @Test
    public void testInvokeNull1() throws Exception {
        this.helpInvokeMethod("concat", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.STRING}, new Object[]{null, String.valueOf(1)}, null, null);
    }

    @Test
    public void testInvokeXslTransform() throws Exception {
        CommandContext c = new CommandContext();
        c.setBufferManager(BufferManagerFactory.getStandaloneBufferManager());
        ClobType result = (ClobType)this.helpInvokeMethod("xsltransform", new Class[]{DataTypeManager.DefaultDataClasses.XML, DataTypeManager.DefaultDataClasses.XML}, new Object[]{DataTypeManager.transformValue((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Catalog><Items><Item ItemID=\"001\"><Name>Lamp</Name><Quantity>5</Quantity></Item></Items></Catalog></Catalogs>", (Class)DataTypeManager.DefaultDataClasses.XML), DataTypeManager.transformValue((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"><xsl:template match=\"@*|node()\"><xsl:copy><xsl:apply-templates select=\"@*|node()\"/></xsl:copy></xsl:template><xsl:template match=\"Quantity\"/></xsl:stylesheet>", (Class)DataTypeManager.DefaultDataClasses.XML)}, c);
        String xml = ObjectConverterUtil.convertToString((Reader)result.getCharacterStream());
        Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Catalog><Items><Item ItemID=\"001\"><Name>Lamp</Name></Item></Items></Catalog></Catalogs>", (Object)xml);
    }

    @Test
    public void testInvokeXmlConcat() throws Exception {
        CommandContext c = new CommandContext();
        c.setBufferManager(BufferManagerFactory.getStandaloneBufferManager());
        XMLType result = (XMLType)this.helpInvokeMethod("xmlconcat", new Class[]{DataTypeManager.DefaultDataClasses.XML, DataTypeManager.DefaultDataClasses.XML}, new Object[]{DataTypeManager.transformValue((Object)"<bar/>", (Class)DataTypeManager.DefaultDataClasses.XML), DataTypeManager.transformValue((Object)"<Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Catalog><Items><Item ItemID=\"001\"><Name>Lamp</Name><Quantity>5</Quantity></Item></Items></Catalog></Catalogs>", (Class)DataTypeManager.DefaultDataClasses.XML)}, c);
        String xml = ObjectConverterUtil.convertToString((Reader)result.getCharacterStream());
        Assert.assertEquals((Object)"<bar/><Catalogs xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Catalog><Items><Item ItemID=\"001\"><Name>Lamp</Name><Quantity>5</Quantity></Item></Items></Catalog></Catalogs>", (Object)xml);
    }

    @Test
    public void testInvokeXmlComment() throws Exception {
        CommandContext c = new CommandContext();
        c.setBufferManager(BufferManagerFactory.getStandaloneBufferManager());
        XMLType result = (XMLType)this.helpInvokeMethod("xmlcomment", new Class[]{DataTypeManager.DefaultDataClasses.STRING}, new Object[]{"comment"}, c);
        String xml = ObjectConverterUtil.convertToString((Reader)result.getCharacterStream());
        Assert.assertEquals((Object)"<!--comment-->", (Object)xml);
    }

    @Test
    public void testToChars() throws Exception {
        Clob result = (Clob)this.helpInvokeMethod("to_chars", new Class[]{DataTypeManager.DefaultDataClasses.BLOB, DataTypeManager.DefaultDataClasses.STRING}, new Object[]{new BlobType((Blob)new SerialBlob("hello world".getBytes("ASCII"))), "ASCII"}, null);
        String string = result.getSubString(1L, (int)result.length());
        Assert.assertEquals((Object)"hello world", (Object)string);
    }

    @Test
    public void testToBytes() throws Exception {
        Blob result = (Blob)this.helpInvokeMethod("to_bytes", new Class[]{DataTypeManager.DefaultDataClasses.CLOB, DataTypeManager.DefaultDataClasses.STRING}, new Object[]{new ClobType((Clob)new SerialClob("hello world".toCharArray())), "UTF32"}, null);
        Assert.assertEquals((long)44L, (long)result.length());
    }

    @Test
    public void testToBytes1() throws Exception {
        this.helpInvokeMethodFail("to_bytes", new Object[]{new ClobType((Clob)new SerialClob("hello\uffffworld".toCharArray())), "ASCII", Boolean.FALSE});
    }

    @Test
    public void testToChars1() throws Exception {
        Clob result = (Clob)this.helpInvokeMethod("to_chars", new Class[]{DataTypeManager.DefaultDataClasses.BLOB, DataTypeManager.DefaultDataClasses.STRING}, new Object[]{new BlobType((Blob)new SerialBlob("hello world".getBytes("ASCII"))), "BASE64"}, null);
        String string = result.getSubString(1L, (int)result.length());
        Assert.assertEquals((Object)"hello world", (Object)new String(Base64.decode((CharSequence)string), "ASCII"));
    }

    @Test
    public void testToChars2() throws Exception {
        Clob result = (Clob)this.helpInvokeMethod("to_chars", new Class[]{DataTypeManager.DefaultDataClasses.BLOB, DataTypeManager.DefaultDataClasses.STRING}, new Object[]{new BlobType((Blob)new SerialBlob("hello world".getBytes("ASCII"))), "HEX"}, null);
        String string = result.getSubString(1L, (int)result.length());
        Assert.assertEquals((Object)"68656C6C6F20776F726C64", (Object)string);
    }

    @Test
    public void testToBytes2() throws Exception {
        Blob result = (Blob)this.helpInvokeMethod("to_bytes", new Class[]{DataTypeManager.DefaultDataClasses.CLOB, DataTypeManager.DefaultDataClasses.STRING}, new Object[]{new ClobType((Clob)new SerialClob("68656C6C6F20776F726C64".toCharArray())), "HEX"}, null);
        Assert.assertEquals((Object)"hello world", (Object)new String(ObjectConverterUtil.convertToCharArray((InputStream)result.getBinaryStream(), (int)-1, (String)"ASCII")));
    }

    @Test(expected=FunctionExecutionException.class)
    public void testToBytes3() throws Exception {
        this.helpInvokeMethod("to_bytes", new Class[]{DataTypeManager.DefaultDataClasses.CLOB, DataTypeManager.DefaultDataClasses.STRING}, new Object[]{new ClobType((Clob)new SerialClob("a".toCharArray())), "BASE64"}, null);
    }

    @Test
    public void testUnescape() throws Exception {
        Assert.assertEquals((Object)"\r\t", (Object)this.helpInvokeMethod("unescape", new Class[]{DataTypeManager.DefaultDataClasses.STRING}, new Object[]{"\r\\\t"}, null));
    }

    @Test
    public void testUuid() throws Exception {
        Assert.assertNotNull((Object)this.helpInvokeMethod("uuid", new Class[0], new Object[0], null));
    }

    @Test
    public void testArrayGet() throws Exception {
        Assert.assertEquals((Object)1, (Object)this.helpInvokeMethod("array_get", new Class[]{DataTypeManager.DefaultDataClasses.OBJECT, DataTypeManager.DefaultDataClasses.INTEGER}, new Object[]{new Object[]{1}, 1}, null));
    }

    @Test
    public void testTrim() throws Exception {
        this.helpInvokeMethod("trim", new Object[]{"leading", "x", "xaxx"}, "axx");
    }

    @Test
    public void testTrim1() throws Exception {
        this.helpInvokeMethod("trim", new Object[]{"both", " ", "   a   "}, "a");
    }

    @Test
    public void testTrim2() throws Exception {
        this.helpInvokeMethod("trim", new Object[]{"trailing", "x", "xaxx"}, "xa");
    }

    @Test
    public void testCastWithNonRuntimeTypes() throws Exception {
        this.helpInvokeMethod("cast", new Object[]{new java.util.Date(0L), "time"}, new Time(86400000L));
        this.helpInvokeMethod("cast", new Object[]{new byte[0], "blob"}, new BlobType((Blob)BlobType.createBlob((byte[])new byte[0])));
    }

    @Test
    public void testSessionVariables() throws Exception {
        CommandContext c = new CommandContext();
        c.setSession(new SessionMetadata());
        Object result = this.helpInvokeMethod("teiid_session_set", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.OBJECT}, new Object[]{"key", "value"}, c);
        Assert.assertNull((Object)result);
        result = this.helpInvokeMethod("teiid_session_get", new Class[]{DataTypeManager.DefaultDataClasses.STRING}, new Object[]{"key"}, c);
        Assert.assertEquals((Object)"value", (Object)result);
        result = this.helpInvokeMethod("teiid_session_set", new Class[]{DataTypeManager.DefaultDataClasses.STRING, DataTypeManager.DefaultDataClasses.OBJECT}, new Object[]{"key", "value1"}, c);
        Assert.assertEquals((Object)"value", (Object)result);
        result = this.helpInvokeMethod("teiid_session_get", new Class[]{DataTypeManager.DefaultDataClasses.STRING}, new Object[]{"key"}, c);
        Assert.assertEquals((Object)"value1", (Object)result);
    }

    @Test
    public void testTokenize() throws Exception {
        this.helpInvokeMethod("tokenize", new Object[]{"bxaxxc", Character.valueOf('x')}, new ArrayImpl(new Object[]{"b", "axc"}));
    }

    @Test
    public void testNodeId() throws Exception {
        System.setProperty("jboss.node.name", "x");
        this.helpInvokeMethod("node_id", new Object[0], "x");
    }

    @Test
    public void testGetBuiltin() throws Exception {
        Assert.assertEquals((long)17L, (long)RealMetadataFactory.SFM.getSystemFunctionLibrary().getBuiltInAggregateFunctions(false).size());
    }
}

