/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.xml;

import java.util.Collection;
import junit.framework.TestCase;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.query.optimizer.xml.ContextReplacerVisitor;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.symbol.GroupSymbol;

public class TestContextReplacerVisitor
extends TestCase {
    public TestContextReplacerVisitor(String name) {
        super(name);
    }

    public GroupSymbol exampleGroupSymbol(int number) {
        return new GroupSymbol("group." + number);
    }

    public void helpTestReplacer(String critString, String expectedCrit, int numContexts) throws QueryParserException {
        Criteria crit = QueryParser.getQueryParser().parseCriteria(critString);
        Collection contexts = ContextReplacerVisitor.replaceContextFunctions((LanguageObject)crit);
        TestContextReplacerVisitor.assertTrue((String)("Actual crit " + crit + " didn't meet expected crit " + expectedCrit), (boolean)expectedCrit.equalsIgnoreCase(crit.toString()));
        TestContextReplacerVisitor.assertTrue((String)("Should've gotten " + numContexts + " but got " + contexts.size()), (contexts.size() == numContexts ? 1 : 0) != 0);
    }

    public void testSimplePredicate() throws Exception {
        this.helpTestReplacer("context(a, x)='3'", "x = '3'", 1);
    }

    public void testSimplePredicate2() throws Exception {
        this.helpTestReplacer("Context(a, x)='3'", "x = '3'", 1);
    }

    public void testConjunct() throws Exception {
        this.helpTestReplacer("context(a, x)='3' OR context(b, y)='j'", "(x = '3') or (y = 'j')", 2);
    }
}

