/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.proc;

import junit.framework.TestCase;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.proc.CommandStatement;

public class TestCommandStatement
extends TestCase {
    public TestCommandStatement(String name) {
        super(name);
    }

    public static final CommandStatement sample1() {
        QueryParser parser = new QueryParser();
        try {
            Query query = (Query)parser.parseCommand("Select x from y");
            return new CommandStatement((Command)query);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final CommandStatement sample2() {
        QueryParser parser = new QueryParser();
        try {
            Update update = (Update)parser.parseCommand("UPDATE x SET x = 'y'");
            return new CommandStatement((Command)update);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void testSelfEquivalence() {
        CommandStatement s1 = TestCommandStatement.sample1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1);
    }

    public void testEquivalence() {
        CommandStatement s1 = TestCommandStatement.sample1();
        CommandStatement s1a = TestCommandStatement.sample1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1a);
    }

    public void testNonEquivalence() {
        CommandStatement s1 = TestCommandStatement.sample1();
        CommandStatement s2 = TestCommandStatement.sample2();
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s2);
    }
}

