/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.Xid;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.Request;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.RequestMetadata;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.TransactionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.WorkerPoolStatisticsMetadata;
import org.teiid.client.DQP;
import org.teiid.client.RequestMessage;
import org.teiid.client.ResultsMessage;
import org.teiid.client.lob.LobChunk;
import org.teiid.client.metadata.MetadataResult;
import org.teiid.client.plan.PlanNode;
import org.teiid.client.util.ResultsFuture;
import org.teiid.client.util.ResultsReceiver;
import org.teiid.client.xa.XATransactionException;
import org.teiid.client.xa.XidImpl;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.ApplicationInfo;
import org.teiid.core.util.ExecutorUtils;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.dqp.internal.process.AuthorizationValidator;
import org.teiid.dqp.internal.process.CachedResults;
import org.teiid.dqp.internal.process.ClientState;
import org.teiid.dqp.internal.process.DQPConfiguration;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.DataTierManagerImpl;
import org.teiid.dqp.internal.process.DataTierTupleSource;
import org.teiid.dqp.internal.process.FutureWork;
import org.teiid.dqp.internal.process.MetaDataProcessor;
import org.teiid.dqp.internal.process.PreparedPlan;
import org.teiid.dqp.internal.process.PreparedStatementRequest;
import org.teiid.dqp.internal.process.Request;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.internal.process.TeiidExecutor;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.RequestID;
import org.teiid.dqp.service.TransactionContext;
import org.teiid.dqp.service.TransactionService;
import org.teiid.events.EventDistributor;
import org.teiid.jdbc.EnhancedTimer;
import org.teiid.logging.CommandLogMessage;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.tempdata.GlobalTableStoreImpl;
import org.teiid.query.tempdata.TempTableDataManager;
import org.teiid.query.tempdata.TempTableStore;
import org.teiid.query.util.CommandContext;
import org.teiid.query.util.Options;

public class DQPCore
implements DQP {
    private TeiidExecutor processWorkerPool;
    private BufferManager bufferManager;
    private TempTableDataManager dataTierMgr;
    private SessionAwareCache<PreparedPlan> prepPlanCache;
    private SessionAwareCache<CachedResults> rsCache;
    private TransactionService transactionService;
    private EventDistributor eventDistributor;
    private DQPConfiguration config = new DQPConfiguration();
    private int chunkSize = 102400;
    private Map<RequestID, RequestWorkItem> requests = new ConcurrentHashMap<RequestID, RequestWorkItem>();
    private Map<String, ClientState> clientState = new ConcurrentHashMap<String, ClientState>();
    private int maxActivePlans = 20;
    private int currentlyActivePlans;
    private int userRequestSourceConcurrency;
    private LinkedList<RequestWorkItem> waitingPlans = new LinkedList();
    private int maxWaitingPlans = 0;
    private AuthorizationValidator authorizationValidator;
    private EnhancedTimer cancellationTimer;
    private Options options;
    private ExecutorService timeoutExecutor;

    public void stop() {
        this.processWorkerPool.shutdownNow();
        try {
            this.processWorkerPool.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.timeoutExecutor.shutdownNow();
        try {
            this.timeoutExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)"Stopping the DQP");
    }

    public List<RequestMetadata> getRequestsForSession(String sessionId) {
        ClientState state = this.getClientState(sessionId, false);
        if (state == null) {
            return Collections.emptyList();
        }
        return this.buildRequestInfos(state.getRequests(), -1L);
    }

    public ClientState getClientState(String key, boolean create) {
        if (key == null) {
            return null;
        }
        ClientState state = this.clientState.get(key);
        if (state == null && create) {
            state = new ClientState(new TempTableStore(key, TempTableStore.TransactionMode.ISOLATE_WRITES));
            this.clientState.put(key, state);
        }
        return state;
    }

    public List<RequestMetadata> getRequests() {
        return this.buildRequestInfos(this.requests.keySet(), -1L);
    }

    public List<RequestMetadata> getLongRunningRequests() {
        return this.buildRequestInfos(this.requests.keySet(), System.currentTimeMillis() - this.config.getQueryThresholdInMilli());
    }

    private List<RequestMetadata> buildRequestInfos(Collection<RequestID> ids, long longRunningQueryThreshold) {
        ArrayList<RequestMetadata> results = new ArrayList<RequestMetadata>();
        for (RequestID requestID : ids) {
            RequestWorkItem holder = this.requests.get(requestID);
            if (holder == null || holder.isCanceled() || longRunningQueryThreshold != -1L && holder.getProcessingTimestamp() >= longRunningQueryThreshold) continue;
            RequestMetadata req = new RequestMetadata();
            req.setExecutionId(holder.requestID.getExecutionID());
            req.setSessionId(holder.requestID.getConnectionID());
            req.setCommand(holder.requestMsg.getCommandString());
            req.setStartTime(holder.getProcessingTimestamp());
            req.setState(holder.isCanceled() ? Request.ProcessingState.CANCELED : (holder.isDoneProcessing() ? Request.ProcessingState.DONE : Request.ProcessingState.PROCESSING));
            switch (holder.getThreadState()) {
                case DONE: 
                case IDLE: {
                    req.setThreadState(Request.ThreadState.IDLE);
                    break;
                }
                default: {
                    if (holder.isProcessing()) {
                        req.setThreadState(Request.ThreadState.RUNNING);
                        break;
                    }
                    req.setThreadState(Request.ThreadState.QUEUED);
                }
            }
            if (holder.getTransactionContext() != null && holder.getTransactionContext().getTransactionType() != TransactionContext.Scope.NONE) {
                req.setTransactionId(holder.getTransactionContext().getTransactionId());
            }
            for (DataTierTupleSource conInfo : holder.getConnectorRequests()) {
                String connectorName = conInfo.getConnectorName();
                if (connectorName == null) continue;
                AtomicRequestMessage arm = conInfo.getAtomicRequestMessage();
                RequestMetadata info = new RequestMetadata();
                if (conInfo.isQueued()) {
                    info.setThreadState(Request.ThreadState.QUEUED);
                } else if (conInfo.isRunning()) {
                    info.setThreadState(Request.ThreadState.RUNNING);
                } else {
                    info.setThreadState(Request.ThreadState.IDLE);
                }
                info.setExecutionId(arm.getRequestID().getExecutionID());
                info.setSessionId(holder.requestID.getConnectionID());
                info.setCommand(arm.getCommand().toString());
                info.setStartTime(arm.getProcessingTimestamp());
                info.setSourceRequest(true);
                info.setNodeId(Integer.valueOf(arm.getAtomicRequestID().getNodeID()));
                info.setState(conInfo.isCanceled() ? Request.ProcessingState.CANCELED : (conInfo.isDone() ? Request.ProcessingState.DONE : Request.ProcessingState.PROCESSING));
                results.add(info);
            }
            results.add(req);
        }
        return results;
    }

    public ResultsFuture<ResultsMessage> executeRequest(long reqID, RequestMessage requestMsg) throws TeiidProcessingException {
        return this.executeRequest(reqID, requestMsg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultsFuture<ResultsMessage> executeRequest(long reqID, RequestMessage requestMsg, Long queryTimeout) throws TeiidProcessingException {
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        this.checkActive(workContext);
        RequestID requestID = workContext.getRequestID(reqID);
        requestMsg.setFetchSize(Math.min(requestMsg.getFetchSize(), this.config.getMaxRowsFetchSize()));
        Request request = null;
        request = requestMsg.isPreparedStatement() || requestMsg.isCallableStatement() || requestMsg.getRequestOptions().isContinuous() ? new PreparedStatementRequest(this.prepPlanCache) : new Request();
        ClientState state = this.getClientState(workContext.getSessionId(), true);
        if (state.session == null) {
            state.session = workContext.getSession();
        }
        request.initialize(requestMsg, this.bufferManager, this.dataTierMgr, this.transactionService, state.sessionTables, workContext, this.prepPlanCache);
        request.setOptions(this.options);
        request.setExecutor(this.processWorkerPool);
        request.setResultSetCacheEnabled(this.rsCache != null);
        request.setAuthorizationValidator(this.authorizationValidator);
        request.setPreParser(this.config.getPreParser());
        request.setUserRequestConcurrency(this.getUserRequestSourceConcurrency());
        ResultsFuture resultsFuture = new ResultsFuture();
        final RequestWorkItem workItem = new RequestWorkItem(this, requestMsg, request, (ResultsReceiver<ResultsMessage>)resultsFuture.getResultsReceiver(), requestID, workContext);
        this.logMMCommand(workItem, CommandLogMessage.Event.NEW, null, null);
        this.addRequest(requestID, workItem, state);
        long timeout = workContext.getVDB().getQueryTimeout();
        timeout = Math.min(timeout > 0L ? timeout : Long.MAX_VALUE, this.config.getQueryTimeout() > 0L ? this.config.getQueryTimeout() : Long.MAX_VALUE);
        if (queryTimeout != null && queryTimeout > 0L) {
            timeout = Math.min(timeout > 0L ? timeout : Long.MAX_VALUE, queryTimeout);
        }
        if (timeout < Long.MAX_VALUE) {
            final long finalTimeout = timeout;
            workItem.setCancelTask(this.cancellationTimer.add(new Runnable(){
                WeakReference<RequestWorkItem> workItemRef;
                {
                    this.workItemRef = new WeakReference<RequestWorkItem>(workItem);
                }

                @Override
                public void run() {
                    try {
                        RequestWorkItem wi = (RequestWorkItem)this.workItemRef.get();
                        if (wi != null) {
                            LogManager.logInfo((String)"org.teiid.PROCESSOR", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31096, new Object[]{wi.requestID, finalTimeout}));
                            wi.requestCancel();
                        }
                    }
                    catch (TeiidComponentException e) {
                        LogManager.logError((String)"org.teiid.PROCESSOR", (Throwable)e, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30018, new Object[0]));
                    }
                }
            }, timeout));
        }
        boolean runInThread = requestMsg.isSync();
        LinkedList<RequestWorkItem> linkedList = this.waitingPlans;
        synchronized (linkedList) {
            if (runInThread || this.currentlyActivePlans <= this.maxActivePlans) {
                this.startActivePlan(workItem, !runInThread);
            } else {
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
                    LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)workItem.requestID, (Object)"Queuing plan, since max plans has been reached.");
                }
                this.waitingPlans.add(workItem);
                this.maxWaitingPlans = Math.max(this.maxWaitingPlans, this.waitingPlans.size());
            }
        }
        if (runInThread) {
            workItem.useCallingThread = true;
            workItem.run();
        }
        return resultsFuture;
    }

    public ResultsFuture<ResultsMessage> processCursorRequest(long reqID, int batchFirst, int fetchSize) throws TeiidProcessingException {
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)"DQP process cursor request", (Object)batchFirst, (Object)fetchSize);
        }
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        ResultsFuture resultsFuture = new ResultsFuture();
        RequestWorkItem workItem = this.getRequestWorkItem(workContext.getRequestID(reqID));
        workItem.requestMore(batchFirst, batchFirst + Math.min(fetchSize, this.config.getMaxRowsFetchSize()) - 1, (ResultsReceiver<ResultsMessage>)resultsFuture.getResultsReceiver());
        return resultsFuture;
    }

    void addRequest(RequestID requestID, RequestWorkItem workItem, ClientState state) {
        this.requests.put(requestID, workItem);
        state.addRequest(requestID);
    }

    private void startActivePlan(RequestWorkItem workItem, boolean addToQueue) {
        boolean continuous = workItem.requestMsg.getRequestOptions().isContinuous();
        boolean bl = workItem.active = !continuous;
        if (addToQueue) {
            this.addWork(workItem);
        }
        if (!continuous) {
            ++this.currentlyActivePlans;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishProcessing(RequestWorkItem workItem) {
        LinkedList<RequestWorkItem> linkedList = this.waitingPlans;
        synchronized (linkedList) {
            if (!workItem.active) {
                return;
            }
            workItem.active = false;
            --this.currentlyActivePlans;
            if (!this.waitingPlans.isEmpty()) {
                RequestWorkItem work = this.waitingPlans.remove();
                this.startActivePlan(work, true);
            }
        }
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)workItem.requestID, (Object)"Finished Processing");
        }
    }

    public int getActivePlanCount() {
        return this.currentlyActivePlans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean blockOnOutputBuffer(RequestWorkItem item) {
        LinkedList<RequestWorkItem> linkedList = this.waitingPlans;
        synchronized (linkedList) {
            if (!this.waitingPlans.isEmpty()) {
                return false;
            }
            if (item.useCallingThread || item.getDqpWorkContext().getSession().isEmbedded()) {
                return false;
            }
        }
        return true;
    }

    public int getWaitingPlanCount() {
        return this.waitingPlans.size();
    }

    public int getMaxWaitingPlanWatermark() {
        return this.maxWaitingPlans;
    }

    void removeRequest(RequestWorkItem workItem) {
        this.finishProcessing(workItem);
        this.requests.remove(workItem.requestID);
        ClientState state = this.getClientState(workItem.getDqpWorkContext().getSessionId(), false);
        if (state != null) {
            state.removeRequest(workItem.requestID);
        }
    }

    void addWork(Runnable work) {
        this.processWorkerPool.execute(work);
    }

    Future<Void> scheduleWork(Runnable r, long delay) {
        return this.cancellationTimer.add(r, delay);
    }

    public ResultsFuture<?> closeLobChunkStream(int lobRequestId, long requestId, String streamId) throws TeiidProcessingException {
        DQPWorkContext workContext;
        RequestWorkItem workItem;
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)("Request to close the Lob stream with Stream id=" + streamId + " instance id=" + lobRequestId));
        }
        if ((workItem = this.safeGetWorkItem((workContext = DQPWorkContext.getWorkContext()).getRequestID(requestId))) != null) {
            workItem.removeLobStream(lobRequestId);
        }
        return ResultsFuture.NULL_FUTURE;
    }

    public ResultsFuture<LobChunk> requestNextLobChunk(int lobRequestId, long requestId, String streamId) throws TeiidProcessingException {
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)("Request for next Lob chunk with Stream id=" + streamId + " instance id=" + lobRequestId));
        }
        RequestWorkItem workItem = this.getRequestWorkItem(DQPWorkContext.getWorkContext().getRequestID(requestId));
        ResultsFuture resultsFuture = new ResultsFuture();
        workItem.processLobChunkRequest(streamId, lobRequestId, (ResultsReceiver<LobChunk>)resultsFuture.getResultsReceiver());
        return resultsFuture;
    }

    RequestWorkItem getRequestWorkItem(RequestID reqID) throws TeiidProcessingException {
        RequestWorkItem result = this.requests.get(reqID);
        if (result == null) {
            throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30495, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30495, new Object[]{reqID}));
        }
        return result;
    }

    RequestWorkItem safeGetWorkItem(Object processorID) {
        return this.requests.get(processorID);
    }

    public WorkerPoolStatisticsMetadata getWorkerPoolStatistics() {
        return this.processWorkerPool.getStats();
    }

    public void terminateSession(String sessionId) {
        ClientState state = this.clientState.remove(sessionId);
        if (state != null) {
            GlobalTableStoreImpl store;
            for (RequestID reqId : state.getRequests()) {
                try {
                    this.cancelRequest(reqId);
                }
                catch (TeiidComponentException err) {
                    LogManager.logWarning((String)"org.teiid.PROCESSOR", (Throwable)err, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30026, new Object[]{reqId}));
                }
            }
            SessionMetadata session = state.session;
            if (session != null && (store = CommandContext.removeSessionScopedStore(session)) != null) {
                try {
                    store.getTempTableStore().removeTempTables();
                }
                catch (TeiidComponentException e) {
                    LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)((Object)e), (Object)"Error removing session scoped temp tables");
                }
            }
        }
        try {
            this.transactionService.cancelTransactions(sessionId, false);
        }
        catch (XATransactionException err) {
            LogManager.logWarning((String)"org.teiid.PROCESSOR", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30005, new Object[]{sessionId}));
        }
    }

    public boolean cancelRequest(String sessionId, long executionId) throws TeiidComponentException {
        RequestID requestID = new RequestID(sessionId, executionId);
        return this.cancelRequest(requestID);
    }

    public PlanNode getPlan(String sessionId, long executionId) {
        RequestWorkItem workItem;
        RequestID requestID = new RequestID(sessionId, executionId);
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)("getPlan for requestID=" + requestID));
        }
        if ((workItem = this.safeGetWorkItem(requestID)) == null) {
            return null;
        }
        QueryProcessor qp = workItem.getProcessor();
        if (qp == null) {
            return null;
        }
        return qp.getProcessorPlan().getDescriptionProperties();
    }

    private boolean cancelRequest(RequestID requestID) throws TeiidComponentException {
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)("cancelQuery for requestID=" + requestID));
        }
        boolean markCancelled = false;
        RequestWorkItem workItem = this.safeGetWorkItem(requestID);
        if (workItem != null) {
            markCancelled = workItem.requestCancel();
        }
        if (markCancelled) {
            this.logMMCommand(workItem, CommandLogMessage.Event.CANCEL, null, null);
        } else {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)QueryPlugin.Util.getString("DQPCore.failed_to_cancel", new Object[]{requestID}));
        }
        return markCancelled;
    }

    public ResultsFuture<?> closeRequest(long requestId) throws TeiidProcessingException, TeiidComponentException {
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        this.closeRequest(workContext.getRequestID(requestId));
        return ResultsFuture.NULL_FUTURE;
    }

    void closeRequest(RequestID requestID) throws TeiidComponentException {
        RequestWorkItem workItem;
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)("closeQuery for requestID=" + requestID));
        }
        if ((workItem = this.safeGetWorkItem(requestID)) != null) {
            workItem.requestClose();
        } else {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object)(requestID + " close call ignored as the request has already been removed."));
        }
    }

    public Collection<TransactionMetadata> getTransactions() {
        return this.transactionService.getTransactions();
    }

    public void terminateTransaction(String xid) throws AdminException {
        this.transactionService.terminateTransaction(xid);
    }

    void logMMCommand(RequestWorkItem workItem, CommandLogMessage.Event status, Long rowCount, Long cpuTime) {
        if (status != CommandLogMessage.Event.PLAN && !LogManager.isMessageToBeRecorded((String)"org.teiid.COMMAND_LOG", (int)4) || status == CommandLogMessage.Event.PLAN && !LogManager.isMessageToBeRecorded((String)"org.teiid.COMMAND_LOG", (int)6)) {
            return;
        }
        RequestMessage msg = workItem.requestMsg;
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        RequestID rID = workItem.requestID;
        String txnID = null;
        TransactionContext tc = workItem.getTransactionContext();
        if (tc != null && tc.getTransactionType() != TransactionContext.Scope.NONE) {
            txnID = tc.getTransactionId();
        }
        String appName = workContext.getAppName();
        CommandLogMessage message = null;
        if (status == CommandLogMessage.Event.NEW) {
            message = new CommandLogMessage(System.currentTimeMillis(), rID.toString(), txnID, workContext.getSessionId(), appName, workContext.getUserName(), workContext.getVdbName(), workContext.getVdbVersion(), msg.getCommandString(), cpuTime);
        } else {
            QueryProcessor qp = workItem.getProcessor();
            PlanNode plan = null;
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.COMMAND_LOG", (int)6) && qp != null) {
                plan = qp.getProcessorPlan().getDescriptionProperties();
            }
            message = new CommandLogMessage(System.currentTimeMillis(), rID.toString(), txnID, workContext.getSessionId(), workContext.getUserName(), workContext.getVdbName(), workContext.getVdbVersion(), rowCount, status, plan);
        }
        LogManager.log((int)(status == CommandLogMessage.Event.PLAN ? 6 : 4), (String)"org.teiid.COMMAND_LOG", (Object)message);
    }

    public TempTableDataManager getDataTierManager() {
        return this.dataTierMgr;
    }

    public BufferManager getBufferManager() {
        return this.bufferManager;
    }

    public TransactionService getTransactionService() {
        return this.transactionService;
    }

    SessionAwareCache<CachedResults> getRsCache() {
        return this.rsCache;
    }

    int getProcessorTimeSlice() {
        return this.config.getTimeSliceInMilli();
    }

    int getChunkSize() {
        return this.chunkSize;
    }

    public void start(DQPConfiguration theConfig) {
        this.config = theConfig;
        this.authorizationValidator = this.config.getAuthorizationValidator();
        this.chunkSize = this.config.getLobChunkSizeInKB() * 1024;
        this.processWorkerPool = this.config.getTeiidExecutor();
        this.timeoutExecutor = ExecutorUtils.newFixedThreadPool((int)3, (String)"Server Side Timeout");
        this.cancellationTimer = new EnhancedTimer((Executor)this.timeoutExecutor, (Executor)this.timeoutExecutor);
        this.maxActivePlans = this.config.getMaxActivePlans();
        if (this.maxActivePlans > this.config.getMaxThreads()) {
            LogManager.logWarning((String)"org.teiid.PROCESSOR", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30006, new Object[]{this.maxActivePlans, this.config.getMaxThreads()}));
            this.maxActivePlans = this.config.getMaxThreads();
        }
        this.bufferManager.setMaxActivePlans(this.maxActivePlans);
        try {
            this.bufferManager.initialize();
        }
        catch (TeiidComponentException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30496, (Throwable)e);
        }
        this.userRequestSourceConcurrency = this.config.getUserRequestSourceConcurrency();
        if (this.userRequestSourceConcurrency < 1) {
            this.userRequestSourceConcurrency = Math.min(this.config.getMaxThreads(), 2 * this.config.getMaxThreads() / this.maxActivePlans);
        }
        DataTierManagerImpl processorDataManager = new DataTierManagerImpl(this, this.bufferManager, this.config.isDetectingChangeEvents());
        processorDataManager.setEventDistributor(this.eventDistributor);
        this.dataTierMgr = new TempTableDataManager(processorDataManager, this.bufferManager, this.rsCache);
        this.dataTierMgr.setExecutor(new TempTableDataManager.RequestExecutor(){

            @Override
            public void execute(String command, List<?> parameters) {
                ResultsFuture<ResultsMessage> result;
                final String sessionId = DQPWorkContext.getWorkContext().getSessionId();
                RequestMessage request = new RequestMessage(command);
                request.setParameterValues(parameters);
                request.setStatementType(RequestMessage.StatementType.PREPARED);
                try {
                    result = DQPCore.this.executeRequest(0L, request);
                }
                catch (TeiidProcessingException e) {
                    throw new TeiidRuntimeException((Throwable)e);
                }
                result.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<ResultsMessage>(){

                    public void onCompletion(ResultsFuture<ResultsMessage> future) {
                        DQPCore.this.terminateSession(sessionId);
                    }
                });
            }
        });
        this.dataTierMgr.setEventDistributor(this.eventDistributor);
        this.options = new Options();
        this.options.setAssumeMatchingCollation(false);
        this.options.setProperties(this.config.getProperties());
        PropertiesUtils.setBeanProperties((Object)this.options, (Properties)this.options.getProperties(), (String)"org.teiid", (boolean)true);
        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"DQPCore started maxThreads", this.config.getMaxThreads(), "maxActivePlans", this.maxActivePlans, "source concurrency", this.userRequestSourceConcurrency});
        this.bufferManager.setOptions(this.options);
    }

    public void setBufferManager(BufferManager mgr) {
        this.bufferManager = mgr;
    }

    public void setTransactionService(TransactionService service) {
        this.transactionService = service;
    }

    public void setEventDistributor(EventDistributor eventDistributor) {
        this.eventDistributor = eventDistributor;
    }

    public boolean cancelRequest(long requestID) throws TeiidProcessingException, TeiidComponentException {
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        return this.cancelRequest(workContext.getRequestID(requestID));
    }

    public ResultsFuture<?> begin() throws XATransactionException {
        String threadId = DQPWorkContext.getWorkContext().getSessionId();
        this.getTransactionService().begin(threadId);
        return ResultsFuture.NULL_FUTURE;
    }

    public ResultsFuture<?> commit() throws XATransactionException {
        final String threadId = DQPWorkContext.getWorkContext().getSessionId();
        Callable<Void> processor = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DQPCore.this.getTransactionService().commit(threadId);
                return null;
            }
        };
        return this.addWork(processor, 0);
    }

    public ResultsFuture<?> rollback() throws XATransactionException {
        final String threadId = DQPWorkContext.getWorkContext().getSessionId();
        Callable<Void> processor = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DQPCore.this.getTransactionService().rollback(threadId);
                return null;
            }
        };
        return this.addWork(processor, 0);
    }

    public ResultsFuture<?> commit(final XidImpl xid, final boolean onePhase) throws XATransactionException {
        Callable<Void> processor = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DQPWorkContext workContext = DQPWorkContext.getWorkContext();
                DQPCore.this.getTransactionService().commit(workContext.getSessionId(), xid, onePhase, workContext.getSession().isEmbedded());
                return null;
            }
        };
        return this.addWork(processor, 0);
    }

    public ResultsFuture<?> end(XidImpl xid, int flags) throws XATransactionException {
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        this.getTransactionService().end(workContext.getSessionId(), xid, flags, workContext.getSession().isEmbedded());
        return ResultsFuture.NULL_FUTURE;
    }

    public ResultsFuture<?> forget(XidImpl xid) throws XATransactionException {
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        this.getTransactionService().forget(workContext.getSessionId(), xid, workContext.getSession().isEmbedded());
        return ResultsFuture.NULL_FUTURE;
    }

    public ResultsFuture<Integer> prepare(final XidImpl xid) throws XATransactionException {
        Callable<Integer> processor = new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                DQPWorkContext workContext = DQPWorkContext.getWorkContext();
                return DQPCore.this.getTransactionService().prepare(workContext.getSessionId(), xid, workContext.getSession().isEmbedded());
            }
        };
        return this.addWork(processor, 10);
    }

    private <T> ResultsFuture<T> addWork(final Callable<T> processor, int priority) {
        ResultsFuture result = new ResultsFuture();
        final ResultsReceiver receiver = result.getResultsReceiver();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    receiver.receiveResults(processor.call());
                }
                catch (Throwable t) {
                    receiver.exceptionOccurred(t);
                }
            }
        };
        FutureWork<Object> work = new FutureWork<Object>(r, null, priority);
        if (DQPWorkContext.getWorkContext().useCallingThread()) {
            work.run();
        } else {
            this.addWork(work);
        }
        return result;
    }

    public ResultsFuture<Xid[]> recover(int flag) throws XATransactionException {
        ResultsFuture result = new ResultsFuture();
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        result.getResultsReceiver().receiveResults((Object)this.getTransactionService().recover(flag, workContext.getSession().isEmbedded()));
        return result;
    }

    public ResultsFuture<?> rollback(final XidImpl xid) throws XATransactionException {
        Callable<Void> processor = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DQPWorkContext workContext = DQPWorkContext.getWorkContext();
                DQPCore.this.getTransactionService().rollback(workContext.getSessionId(), xid, workContext.getSession().isEmbedded());
                return null;
            }
        };
        return this.addWork(processor, 0);
    }

    public ResultsFuture<?> start(final XidImpl xid, final int flags, final int timeout) throws XATransactionException {
        final DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        if (workContext.getSession().isEmbedded()) {
            this.getTransactionService().start(workContext.getSessionId(), xid, flags, timeout, true);
            return ResultsFuture.NULL_FUTURE;
        }
        Callable<Void> processor = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DQPCore.this.getTransactionService().start(workContext.getSessionId(), xid, flags, timeout, false);
                return null;
            }
        };
        return this.addWork(processor, 100);
    }

    public MetadataResult getMetadata(long requestID) throws TeiidComponentException, TeiidProcessingException {
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        MetaDataProcessor processor = new MetaDataProcessor(this, this.prepPlanCache, workContext.getVdbName(), workContext.getVdbVersion());
        return processor.processMessage(workContext.getRequestID(requestID), workContext, null, true);
    }

    public MetadataResult getMetadata(long requestID, String preparedSql, boolean allowDoubleQuotedVariable) throws TeiidComponentException, TeiidProcessingException {
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        this.checkActive(workContext);
        MetaDataProcessor processor = new MetaDataProcessor(this, this.prepPlanCache, workContext.getVdbName(), workContext.getVdbVersion());
        return processor.processMessage(workContext.getRequestID(requestID), workContext, preparedSql, allowDoubleQuotedVariable);
    }

    private void checkActive(DQPWorkContext workContext) throws TeiidProcessingException {
        if (workContext.getVDB().getStatus() != VDB.Status.ACTIVE) {
            throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID31099, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31099, new Object[]{workContext.getVDB(), workContext.getVDB().getStatus()}));
        }
    }

    public boolean isExceptionOnMaxSourceRows() {
        return this.config.isExceptionOnMaxSourceRows();
    }

    public int getMaxSourceRows() {
        return this.config.getMaxSourceRows();
    }

    public int getMaxRowsFetchSize() {
        return this.config.getMaxRowsFetchSize();
    }

    public void setResultsetCache(SessionAwareCache<CachedResults> cache) {
        this.rsCache = cache;
    }

    public void setPreparedPlanCache(SessionAwareCache<PreparedPlan> cache) {
        this.prepPlanCache = cache;
    }

    public int getUserRequestSourceConcurrency() {
        return this.userRequestSourceConcurrency;
    }

    void setUserRequestSourceConcurrency(int userRequestSourceConcurrency) {
        this.userRequestSourceConcurrency = userRequestSourceConcurrency;
    }

    public int getMaxActivePlans() {
        return this.maxActivePlans;
    }

    SessionAwareCache<PreparedPlan> getPrepPlanCache() {
        return this.prepPlanCache;
    }

    public String getRuntimeVersion() {
        return ApplicationInfo.getInstance().getBuildNumber();
    }

    public static ResultsFuture<?> executeQuery(final String command, VDBMetaData vdb, String user, String app, final long timeoutInMilli, final DQPCore engine, final ResultsListener listener) throws Throwable {
        final SessionMetadata session = TempTableDataManager.createTemporarySession(user, app, vdb);
        long requestID = 0L;
        DQPWorkContext workContext = new DQPWorkContext();
        workContext.setUseCallingThread(true);
        workContext.setSession(session);
        workContext.setAdmin(true);
        final ResultsFuture resultFuture = new ResultsFuture();
        resultFuture.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Void>(){

            public void onCompletion(ResultsFuture<Void> future) {
                try {
                    ResultsFuture<?> response = engine.closeRequest(0L);
                    response.addCompletionListener(new ResultsFuture.CompletionListener(){

                        public void onCompletion(ResultsFuture future) {
                            engine.terminateSession(session.getSessionId());
                        }
                    });
                }
                catch (Exception e) {
                    engine.terminateSession(session.getSessionId());
                }
            }
        });
        workContext.runInContext(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                RequestMessage request = new RequestMessage(command);
                request.setExecutionId(0L);
                request.setRowLimit(engine.getMaxRowsFetchSize());
                ResultsFuture<ResultsMessage> message = engine.executeRequest(0L, request, timeoutInMilli);
                message.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<ResultsMessage>(){

                    public void onCompletion(ResultsFuture<ResultsMessage> future) {
                        try {
                            ResultsMessage rm = (ResultsMessage)future.get();
                            if (rm.getException() != null) {
                                throw rm.getException();
                            }
                            if (rm.isUpdateResult()) {
                                listener.onResults(Arrays.asList("update-count"), rm.getResultsList());
                                resultFuture.getResultsReceiver().receiveResults(null);
                            } else {
                                this.processResult(rm);
                            }
                        }
                        catch (Exception e) {
                            resultFuture.getResultsReceiver().exceptionOccurred((Throwable)e);
                        }
                    }

                    private void processResult(ResultsMessage rm) throws Exception {
                        if (rm.getException() != null) {
                            throw rm.getException();
                        }
                        listener.onResults(Arrays.asList(rm.getColumnNames()), rm.getResultsList());
                        if (rm.getFinalRow() == -1 || rm.getLastRow() < rm.getFinalRow()) {
                            ResultsFuture<ResultsMessage> next = engine.processCursorRequest(0L, rm.getLastRow() + 1, 1024);
                            next.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<ResultsMessage>(){

                                public void onCompletion(ResultsFuture<ResultsMessage> future) {
                                    try {
                                        this.processResult((ResultsMessage)future.get());
                                    }
                                    catch (Exception e) {
                                        resultFuture.getResultsReceiver().exceptionOccurred((Throwable)e);
                                    }
                                }
                            });
                        } else {
                            resultFuture.getResultsReceiver().receiveResults(null);
                        }
                    }
                });
                return null;
            }
        });
        return resultFuture;
    }

    public static interface ResultsListener {
        public void onResults(List<String> var1, List<? extends List<?>> var2) throws Exception;
    }

    public static interface CompletionListener<T> {
        public void onCompletion(FutureWork<T> var1);
    }
}

