/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.PropertiesUtils;

public class TimestampWithTimezone {
    public static final String ISO8601_WEEK_PROP = "org.teiid.iso8601Week";
    public static boolean ISO8601_WEEK = PropertiesUtils.getBooleanProperty(System.getProperties(), "org.teiid.iso8601Week", true);
    private static ThreadLocal<Calendar> CALENDAR = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            return TimestampWithTimezone.initialCalendar();
        }
    };

    public static Calendar getCalendar() {
        return CALENDAR.get();
    }

    public static void resetCalendar(TimeZone tz) {
        TimeZone.setDefault(tz);
        CALENDAR.set(TimestampWithTimezone.initialCalendar());
    }

    static Calendar initialCalendar() {
        Calendar result = Calendar.getInstance();
        if (ISO8601_WEEK) {
            result.setMinimalDaysInFirstWeek(4);
            result.setFirstDayOfWeek(2);
        }
        return result;
    }

    public static Object create(Date date, TimeZone initial, Calendar target, Class<?> type) {
        if (type.equals(DataTypeManager.DefaultDataClasses.TIME)) {
            return type.cast(TimestampWithTimezone.createTime(date, initial, target));
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.DATE)) {
            return type.cast(TimestampWithTimezone.createDate(date, initial, target));
        }
        return type.cast(TimestampWithTimezone.createTimestamp(date, initial, target));
    }

    public static Timestamp createTimestamp(Date date, TimeZone initial, Calendar target) {
        if (target == null) {
            target = TimestampWithTimezone.getCalendar();
        }
        long time = target.getTimeInMillis();
        TimestampWithTimezone.adjustCalendar(date, initial, target);
        target.set(14, 0);
        Timestamp tsInTz = new Timestamp(target.getTimeInMillis());
        if (date instanceof Timestamp) {
            tsInTz.setNanos(((Timestamp)date).getNanos());
        }
        target.setTimeInMillis(time);
        return tsInTz;
    }

    public static Time createTime(Date date, TimeZone initial, Calendar target) {
        if (target == null) {
            target = TimestampWithTimezone.getCalendar();
        }
        long time = target.getTimeInMillis();
        TimestampWithTimezone.adjustCalendar(date, initial, target);
        Time result = TimestampWithTimezone.normalizeTime(date, target);
        target.setTimeInMillis(time);
        return result;
    }

    public static java.sql.Date createDate(Date date, TimeZone initial, Calendar target) {
        if (target == null) {
            target = TimestampWithTimezone.getCalendar();
        }
        long time = target.getTimeInMillis();
        TimestampWithTimezone.adjustCalendar(date, initial, target);
        java.sql.Date result = TimestampWithTimezone.normalizeDate(date, target);
        target.setTimeInMillis(time);
        return result;
    }

    public static Time createTime(Date date) {
        if (date instanceof Time) {
            return (Time)date;
        }
        Calendar cal = TimestampWithTimezone.getCalendar();
        cal.setTime(date);
        return TimestampWithTimezone.normalizeTime(date, cal);
    }

    public static java.sql.Date createDate(Date date) {
        if (date instanceof java.sql.Date) {
            return (java.sql.Date)date;
        }
        Calendar cal = TimestampWithTimezone.getCalendar();
        cal.setTime(date);
        return TimestampWithTimezone.normalizeDate(date, cal);
    }

    public static Timestamp createTimestamp(Date date) {
        if (date instanceof Timestamp) {
            return (Timestamp)date;
        }
        return new Timestamp(date.getTime());
    }

    private static java.sql.Date normalizeDate(Date date, Calendar target) {
        if (!(date instanceof java.sql.Date)) {
            target.set(11, 0);
            target.set(12, 0);
            target.set(13, 0);
            target.set(14, 0);
        }
        java.sql.Date result = new java.sql.Date(target.getTimeInMillis());
        return result;
    }

    private static Time normalizeTime(Date date, Calendar target) {
        if (!(date instanceof Time)) {
            target.set(1, 1970);
            target.set(2, 0);
            target.set(5, 1);
            target.set(14, 0);
        }
        Time result = new Time(target.getTimeInMillis());
        return result;
    }

    private static void adjustCalendar(Date date, TimeZone initial, Calendar target) {
        assert (initial != null);
        if (initial.hasSameRules(target.getTimeZone())) {
            target.setTime(date);
            return;
        }
        long time = date.getTime();
        Calendar cal = Calendar.getInstance(initial);
        cal.setTimeInMillis(time);
        target.clear();
        for (int i = 0; i <= 14; ++i) {
            target.set(i, cal.get(i));
        }
    }
}

