/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver;

import java.sql.Clob;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.XMLType;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.XMLSerialize;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestFunctionResolving {
    @Test
    public void testResolveBadConvert() throws Exception {
        Function function = new Function("convert", new Expression[]{new Constant((Object)new Character('a')), new Constant((Object)"date")});
        try {
            ResolverVisitor.resolveLanguageObject((LanguageObject)function, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
            Assert.fail((String)"excpetion expected");
        }
        catch (QueryResolverException err) {
            Assert.assertEquals((Object)"TEIID30071 The conversion from char to date is not allowed.", (Object)err.getMessage());
        }
    }

    @Test
    public void testResolvesClosestType() throws Exception {
        ElementSymbol e1 = new ElementSymbol("pm1.g1.e1");
        e1.setType(DataTypeManager.DefaultDataClasses.BYTE);
        e1.setMetadataID(new Object());
        Function function = new Function("abs", new Expression[]{e1});
        ResolverVisitor.resolveLanguageObject((LanguageObject)function, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.INTEGER, (Object)function.getType());
    }

    @Test
    public void testResolveConvertReference() throws Exception {
        Function function = new Function("convert", new Expression[]{new Reference(0), new Constant((Object)"boolean")});
        ResolverVisitor.resolveLanguageObject((LanguageObject)function, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.BOOLEAN, (Object)function.getType());
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.BOOLEAN, (Object)function.getArgs()[0].getType());
    }

    @Test
    public void testResolveAmbiguousFunction() throws Exception {
        Function function = new Function("LCASE", new Expression[]{new Reference(0)});
        try {
            ResolverVisitor.resolveLanguageObject((LanguageObject)function, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
            Assert.fail((String)"excpetion expected");
        }
        catch (QueryResolverException err) {
            Assert.assertEquals((Object)"TEIID30069 The function 'LCASE(?)' has more than one possible signature.", (Object)err.getMessage());
        }
    }

    @Test
    public void testResolveCoalesce() throws Exception {
        String sql = "coalesce('', '')";
        this.helpResolveFunction(sql);
    }

    @Test
    public void testResolveCoalesce1() throws Exception {
        String sql = "coalesce('', '', '')";
        this.helpResolveFunction(sql);
    }

    @Test
    public void testResolveCoalesce1a() throws Exception {
        String sql = "coalesce('', '', '', '')";
        this.helpResolveFunction(sql);
    }

    @Test
    public void testResolveCoalesce2() throws Exception {
        String sql = "coalesce('', 1, '', '')";
        this.helpResolveFunction(sql);
    }

    @Test
    public void testResolveCoalesce3() throws Exception {
        String sql = "coalesce('', 1, null, '')";
        this.helpResolveFunction(sql);
    }

    @Test
    public void testResolveCoalesce4() throws Exception {
        String sql = "coalesce({d'2009-03-11'}, 1)";
        this.helpResolveFunction(sql);
    }

    private Function helpResolveFunction(String sql) throws QueryParserException, QueryResolverException, TeiidComponentException {
        Function func = (Function)TestFunctionResolving.getExpression(sql);
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.STRING, (Object)func.getType());
        return func;
    }

    public static Expression getExpression(String sql) throws QueryParserException, TeiidComponentException, QueryResolverException {
        Expression func = QueryParser.getQueryParser().parseExpression(sql);
        TransformationMetadata tm = RealMetadataFactory.example1Cached();
        ResolverVisitor.resolveLanguageObject((LanguageObject)func, (QueryMetadataInterface)tm);
        return func;
    }

    public static void assertEval(String expr, String result) throws Exception {
        Expression ex = TestFunctionResolving.getExpression(expr);
        Object val = Evaluator.evaluate((Expression)ex);
        String valStr = val instanceof Clob ? ClobType.getString((Clob)((Clob)val)) : (val instanceof XMLType ? ((XMLType)val).getString() : val.toString());
        Assert.assertEquals((Object)result, (Object)valStr);
    }

    @Test
    public void testLookupTypeConversion() throws Exception {
        String sql = "lookup('pm1.g1', 'e2', 'e1', 1)";
        Function f = (Function)TestFunctionResolving.getExpression(sql);
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.STRING, (Object)f.getArg(3).getType());
    }

    @Test
    public void testXMLSerialize() throws Exception {
        String sql = "xmlserialize(DOCUMENT '<a/>' as clob)";
        XMLSerialize xs = (XMLSerialize)TestFunctionResolving.getExpression(sql);
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.CLOB, (Object)xs.getType());
    }

    @Test(expected=QueryResolverException.class)
    public void testXMLSerialize_1() throws Exception {
        String sql = "xmlserialize(DOCUMENT 1 as clob)";
        XMLSerialize xs = (XMLSerialize)TestFunctionResolving.getExpression(sql);
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.CLOB, (Object)xs.getType());
    }

    @Test(expected=QueryResolverException.class)
    public void testStringAggWrongTypes() throws Exception {
        String sql = "string_agg(pm1.g1.e1, pm1.g1.e2)";
        TestFunctionResolving.getExpression(sql);
    }

    @Test(expected=QueryResolverException.class)
    public void testStringAggWrongArgs() throws Exception {
        String sql = "string_agg(pm1.g1.e1)";
        TestFunctionResolving.getExpression(sql);
    }

    public static String vararg(Object ... vals) {
        return String.valueOf(vals.length);
    }

    @Test
    public void testVarArgsFunction() throws Exception {
        String ddl = "create foreign function func (VARIADIC z object) returns string options (JAVA_CLASS '" + this.getClass().getName() + "', JAVA_METHOD 'vararg');\n";
        TransformationMetadata tm = RealMetadataFactory.fromDDL(ddl, "x", "y");
        String sql = "func(('a', 'b'))";
        Function func = (Function)QueryParser.getQueryParser().parseExpression(sql);
        ResolverVisitor.resolveLanguageObject((LanguageObject)func, (QueryMetadataInterface)tm);
        Assert.assertEquals((long)1L, (long)func.getArgs().length);
        Assert.assertEquals((Object)"2", (Object)Evaluator.evaluate((Expression)func));
    }

    @Test
    public void testAmbiguousUDF() throws Exception {
        TransformationMetadata tm = RealMetadataFactory.fromDDL("x", new RealMetadataFactory.DDLHolder("y", "create foreign function f () returns string"), new RealMetadataFactory.DDLHolder("z", "create foreign function f () returns string"));
        String sql = "f()";
        Function func = (Function)QueryParser.getQueryParser().parseExpression(sql);
        try {
            ResolverVisitor.resolveLanguageObject((LanguageObject)func, (QueryMetadataInterface)tm);
            Assert.fail();
        }
        catch (QueryResolverException queryResolverException) {
            // empty catch block
        }
        sql = "z.f()";
        func = (Function)QueryParser.getQueryParser().parseExpression(sql);
        ResolverVisitor.resolveLanguageObject((LanguageObject)func, (QueryMetadataInterface)tm);
    }

    @Test
    public void testUDFResolveOrder() throws Exception {
        TransformationMetadata tm = RealMetadataFactory.fromDDL("create foreign function func(x object) returns object;  create foreign function func(x string) returns string; create foreign function func1(x object) returns double; create foreign function func1(x string[]) returns bigdecimal;", "x", "y");
        String sql = "func('a')";
        Function func = (Function)QueryParser.getQueryParser().parseExpression(sql);
        ResolverVisitor.resolveLanguageObject((LanguageObject)func, (QueryMetadataInterface)tm);
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.STRING, (Object)func.getArgs()[0].getType());
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.STRING, (Object)func.getType());
        sql = "func1(('1',))";
        func = (Function)QueryParser.getQueryParser().parseExpression(sql);
        ResolverVisitor.resolveLanguageObject((LanguageObject)func, (QueryMetadataInterface)tm);
    }

    @Test
    public void testImportedPushdown() throws Exception {
        RealMetadataFactory.example1Cached();
        TransformationMetadata tm = RealMetadataFactory.fromDDL("x", new RealMetadataFactory.DDLHolder("y", "create foreign function func(x object) returns object;"), new RealMetadataFactory.DDLHolder("z", "create foreign function func(x object) returns object;"));
        String sql = "func('a')";
        Function func = (Function)QueryParser.getQueryParser().parseExpression(sql);
        try {
            ResolverVisitor.resolveLanguageObject((LanguageObject)func, (QueryMetadataInterface)tm);
            Assert.fail((String)"should be ambiguous");
        }
        catch (QueryResolverException queryResolverException) {
            // empty catch block
        }
        tm = RealMetadataFactory.fromDDL("x", new RealMetadataFactory.DDLHolder("y", "create foreign function func(x object) returns object options (\"teiid_rel:system-name\" 'f');"), new RealMetadataFactory.DDLHolder("z", "create foreign function func(x object) returns object options (\"teiid_rel:system-name\" 'f');"));
        func = (Function)QueryParser.getQueryParser().parseExpression(sql);
        ResolverVisitor.resolveLanguageObject((LanguageObject)func, (QueryMetadataInterface)tm);
        tm = RealMetadataFactory.fromDDL("x", new RealMetadataFactory.DDLHolder("y", "create foreign function func() returns object options (\"teiid_rel:system-name\" 'f');"), new RealMetadataFactory.DDLHolder("z", "create foreign function func() returns object options (\"teiid_rel:system-name\" 'f');"));
        func = (Function)QueryParser.getQueryParser().parseExpression("func()");
        ResolverVisitor.resolveLanguageObject((LanguageObject)func, (QueryMetadataInterface)tm);
    }

    @Test
    public void testNumericConversion() throws Exception {
        String sql = "1.0/2";
        Function f = (Function)TestFunctionResolving.getExpression(sql);
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.BIG_DECIMAL, (Object)f.getType());
    }
}

