/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.DependencyInfo;
import net.sf.antcontrib.cpptasks.TargetInfo;
import net.sf.antcontrib.cpptasks.compiler.CompilerConfiguration;
import org.apache.tools.ant.BuildException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class DependencyTable {
    private File baseDir;
    private String baseDirPath;
    private final Hashtable dependencies = new Hashtable();
    private File dependenciesFile;
    private boolean dirty;

    public DependencyTable(File baseDir) {
        if (baseDir == null) {
            throw new NullPointerException("baseDir");
        }
        this.baseDir = baseDir;
        try {
            this.baseDirPath = baseDir.getCanonicalPath();
        }
        catch (IOException ex) {
            this.baseDirPath = baseDir.toString();
        }
        this.dirty = false;
        this.dependenciesFile = new File(baseDir, "dependencies.xml");
    }

    public void commit(CCTask task) {
        if (this.dirty) {
            Vector includePaths = this.getIncludePaths();
            try {
                OutputStreamWriter streamWriter;
                FileOutputStream outStream = new FileOutputStream(this.dependenciesFile);
                String encodingName = "UTF-8";
                try {
                    streamWriter = new OutputStreamWriter((OutputStream)outStream, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    streamWriter = new OutputStreamWriter(outStream);
                    encodingName = streamWriter.getEncoding();
                }
                BufferedWriter writer = new BufferedWriter(streamWriter);
                writer.write("<?xml version='1.0' encoding='");
                writer.write(encodingName);
                writer.write("'?>\n");
                writer.write("<dependencies>\n");
                StringBuffer buf = new StringBuffer();
                Enumeration includePathEnum = includePaths.elements();
                while (includePathEnum.hasMoreElements()) {
                    this.writeIncludePathDependencies((String)includePathEnum.nextElement(), writer, buf);
                }
                writer.write("</dependencies>\n");
                writer.close();
                this.dirty = false;
            }
            catch (IOException ex) {
                task.log("Error writing " + this.dependenciesFile.toString() + ":" + ex.toString());
            }
        }
    }

    public Enumeration elements() {
        return this.dependencies.elements();
    }

    public DependencyInfo getDependencyInfo(String sourceRelativeName, String includePathIdentifier) {
        DependencyInfo dependInfo = null;
        DependencyInfo[] dependInfos = (DependencyInfo[])this.dependencies.get(sourceRelativeName);
        if (dependInfos != null) {
            for (int i = 0; i < dependInfos.length; ++i) {
                dependInfo = dependInfos[i];
                if (!dependInfo.getIncludePathIdentifier().equals(includePathIdentifier)) continue;
                return dependInfo;
            }
        }
        return null;
    }

    private Vector getIncludePaths() {
        Vector<String> includePaths = new Vector<String>();
        Enumeration dependenciesEnum = this.dependencies.elements();
        while (dependenciesEnum.hasMoreElements()) {
            DependencyInfo[] dependInfos = (DependencyInfo[])dependenciesEnum.nextElement();
            for (int i = 0; i < dependInfos.length; ++i) {
                DependencyInfo dependInfo = dependInfos[i];
                boolean matchesExisting = false;
                String dependIncludePath = dependInfo.getIncludePathIdentifier();
                Enumeration includePathEnum = includePaths.elements();
                while (includePathEnum.hasMoreElements()) {
                    if (!dependIncludePath.equals(includePathEnum.nextElement())) continue;
                    matchesExisting = true;
                    break;
                }
                if (matchesExisting) continue;
                includePaths.addElement(dependIncludePath);
            }
        }
        return includePaths;
    }

    public void load() throws IOException, ParserConfigurationException, SAXException {
        this.dependencies.clear();
        if (this.dependenciesFile.exists()) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            SAXParser parser = factory.newSAXParser();
            parser.parse(this.dependenciesFile, (DefaultHandler)new DependencyTableHandler(this, this.baseDir));
            this.dirty = false;
        }
    }

    public boolean needsRebuild(CCTask task, TargetInfo target, int dependencyDepth) {
        boolean mustRebuild = false;
        CompilerConfiguration compiler = (CompilerConfiguration)target.getConfiguration();
        String includePathIdentifier = compiler.getIncludePathIdentifier();
        File[] sources = target.getSources();
        DependencyInfo[] dependInfos = new DependencyInfo[sources.length];
        long outputLastModified = target.getOutput().lastModified();
        DependencyInfo[] stack = new DependencyInfo[50];
        boolean rebuildOnStackExhaustion = true;
        if (dependencyDepth >= 0) {
            if (dependencyDepth < 50) {
                stack = new DependencyInfo[dependencyDepth];
            }
            rebuildOnStackExhaustion = false;
        }
        TimestampChecker checker = new TimestampChecker(outputLastModified, rebuildOnStackExhaustion);
        for (int i = 0; i < sources.length && !mustRebuild; ++i) {
            File source = sources[i];
            String relative = CUtil.getRelativePath(this.baseDirPath, source);
            DependencyInfo dependInfo = this.getDependencyInfo(relative, includePathIdentifier);
            if (dependInfo == null) {
                task.log("Parsing " + relative, 3);
                dependInfo = this.parseIncludes(task, compiler, source);
            }
            this.walkDependencies(task, dependInfo, compiler, stack, checker);
            mustRebuild = checker.getMustRebuild();
        }
        return mustRebuild;
    }

    public DependencyInfo parseIncludes(CCTask task, CompilerConfiguration compiler, File source) {
        DependencyInfo dependInfo = compiler.parseIncludes(task, this.baseDir, source);
        String relativeSource = CUtil.getRelativePath(this.baseDirPath, source);
        this.putDependencyInfo(relativeSource, dependInfo);
        return dependInfo;
    }

    private void putDependencyInfo(String key, DependencyInfo dependInfo) {
        DependencyInfo[] old = this.dependencies.put(key, new DependencyInfo[]{dependInfo});
        this.dirty = true;
        if (old != null) {
            String includePathIdentifier = dependInfo.getIncludePathIdentifier();
            for (int i = 0; i < old.length; ++i) {
                DependencyInfo oldDepend = old[i];
                if (!oldDepend.getIncludePathIdentifier().equals(includePathIdentifier)) continue;
                old[i] = dependInfo;
                this.dependencies.put(key, old);
                return;
            }
            DependencyInfo[] combined = new DependencyInfo[old.length + 1];
            combined[0] = dependInfo;
            for (int i = 0; i < old.length; ++i) {
                combined[i + 1] = old[i];
            }
            this.dependencies.put(key, combined);
        }
    }

    public void walkDependencies(CCTask task, DependencyInfo dependInfo, CompilerConfiguration compiler, DependencyInfo[] stack, DependencyVisitor visitor) throws BuildException {
        if (visitor.visit(dependInfo)) {
            int stackPosition = -1;
            for (int i = 0; i < stack.length; ++i) {
                if (stack[i] == null) {
                    stackPosition = i;
                    stack[i] = dependInfo;
                    break;
                }
                if (stack[i] != dependInfo) continue;
                return;
            }
            if (stackPosition == -1) {
                visitor.stackExhausted();
                return;
            }
            String[] includes = dependInfo.getIncludes();
            String includePathIdentifier = compiler.getIncludePathIdentifier();
            DependencyInfo[] includeInfos = new DependencyInfo[includes.length];
            for (int i = 0; i < includes.length; ++i) {
                DependencyInfo includeInfo;
                includeInfos[i] = includeInfo = this.getDependencyInfo(includes[i], includePathIdentifier);
            }
            if (visitor.preview(dependInfo, includeInfos)) {
                int i;
                int missingCount = 0;
                for (i = 0; i < includes.length; ++i) {
                    DependencyInfo includeInfo;
                    if (includeInfos[i] != null) continue;
                    ++missingCount;
                    task.log("Parsing " + includes[i], 3);
                    File src = includes[i].startsWith("\\\\") ? new File(includes[i]) : new File(this.baseDir, includes[i]);
                    includeInfos[i] = includeInfo = this.parseIncludes(task, compiler, src);
                }
                if (missingCount == 0 || visitor.preview(dependInfo, includeInfos)) {
                    for (i = 0; i < includeInfos.length; ++i) {
                        DependencyInfo includeInfo = includeInfos[i];
                        this.walkDependencies(task, includeInfo, compiler, stack, visitor);
                    }
                }
            }
            stack[stackPosition] = null;
        }
    }

    private void writeDependencyInfo(BufferedWriter writer, StringBuffer buf, DependencyInfo dependInfo) throws IOException {
        int i;
        String[] includes = dependInfo.getIncludes();
        String[] sysIncludes = dependInfo.getSysIncludes();
        buf.setLength(0);
        buf.append("      <source file=\"");
        buf.append(CUtil.xmlAttribEncode(dependInfo.getSource()));
        buf.append("\" lastModified=\"");
        buf.append(Long.toHexString(dependInfo.getSourceLastModified()));
        buf.append("\">\n");
        writer.write(buf.toString());
        for (i = 0; i < includes.length; ++i) {
            buf.setLength(0);
            buf.append("         <include file=\"");
            buf.append(CUtil.xmlAttribEncode(includes[i]));
            buf.append("\"/>\n");
            writer.write(buf.toString());
        }
        for (i = 0; i < sysIncludes.length; ++i) {
            buf.setLength(0);
            buf.append("         <sysinclude file=\"");
            buf.append(CUtil.xmlAttribEncode(sysIncludes[i]));
            buf.append("\"/>\n");
            writer.write(buf.toString());
        }
        writer.write("      </source>\n");
    }

    private void writeIncludePathDependencies(String includePathIdentifier, BufferedWriter writer, StringBuffer buf) throws IOException {
        buf.setLength(0);
        buf.append("   <includePath signature=\"");
        buf.append(CUtil.xmlAttribEncode(includePathIdentifier));
        buf.append("\">\n");
        writer.write(buf.toString());
        Enumeration dependenciesEnum = this.dependencies.elements();
        while (dependenciesEnum.hasMoreElements()) {
            DependencyInfo[] dependInfos = (DependencyInfo[])dependenciesEnum.nextElement();
            for (int i = 0; i < dependInfos.length; ++i) {
                DependencyInfo dependInfo = dependInfos[i];
                if (!dependInfo.getIncludePathIdentifier().equals(includePathIdentifier)) continue;
                this.writeDependencyInfo(writer, buf, dependInfo);
            }
        }
        writer.write("   </includePath>\n");
    }

    public class TimestampChecker
    extends DependencyVisitor {
        private boolean noNeedToRebuild;
        private long outputLastModified;
        private boolean rebuildOnStackExhaustion;

        public TimestampChecker(long outputLastModified, boolean rebuildOnStackExhaustion) {
            this.outputLastModified = outputLastModified;
            this.noNeedToRebuild = true;
            this.rebuildOnStackExhaustion = rebuildOnStackExhaustion;
        }

        public boolean getMustRebuild() {
            return !this.noNeedToRebuild;
        }

        public boolean preview(DependencyInfo parent, DependencyInfo[] children) {
            int withCompositeTimes = 0;
            long parentCompositeLastModified = parent.getSourceLastModified();
            for (int i = 0; i < children.length; ++i) {
                if (children[i] == null) continue;
                this.visit(children[i]);
                long childCompositeLastModified = children[i].getCompositeLastModified();
                if (childCompositeLastModified == Long.MIN_VALUE) continue;
                ++withCompositeTimes;
                if (childCompositeLastModified <= parentCompositeLastModified) continue;
                parentCompositeLastModified = childCompositeLastModified;
            }
            if (withCompositeTimes == children.length) {
                parent.setCompositeLastModified(parentCompositeLastModified);
            }
            return this.noNeedToRebuild;
        }

        public void stackExhausted() {
            if (this.rebuildOnStackExhaustion) {
                this.noNeedToRebuild = false;
            }
        }

        public boolean visit(DependencyInfo dependInfo) {
            if (this.noNeedToRebuild && (CUtil.isSignificantlyAfter(dependInfo.getSourceLastModified(), this.outputLastModified) || CUtil.isSignificantlyAfter(dependInfo.getCompositeLastModified(), this.outputLastModified))) {
                this.noNeedToRebuild = false;
            }
            return this.noNeedToRebuild && dependInfo.getCompositeLastModified() == Long.MIN_VALUE;
        }
    }

    public abstract class DependencyVisitor {
        public abstract boolean preview(DependencyInfo var1, DependencyInfo[] var2);

        public abstract void stackExhausted();

        public abstract boolean visit(DependencyInfo var1);
    }

    private class DependencyTableHandler
    extends DefaultHandler {
        private File baseDir;
        private final DependencyTable dependencyTable;
        private String includePath;
        private Vector includes;
        private String source;
        private long sourceLastModified;
        private Vector sysIncludes;

        private DependencyTableHandler(DependencyTable dependencyTable, File baseDir) {
            this.dependencyTable = dependencyTable;
            this.baseDir = baseDir;
            this.includes = new Vector();
            this.sysIncludes = new Vector();
            this.source = null;
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (qName.equals("source")) {
                if (this.source != null && this.includePath != null) {
                    long existingLastModified;
                    File existingFile = new File(this.baseDir, this.source);
                    if (existingFile.exists() && !CUtil.isSignificantlyAfter(existingLastModified = existingFile.lastModified(), this.sourceLastModified) && !CUtil.isSignificantlyBefore(existingLastModified, this.sourceLastModified)) {
                        DependencyInfo dependInfo = new DependencyInfo(this.includePath, this.source, this.sourceLastModified, this.includes, this.sysIncludes);
                        this.dependencyTable.putDependencyInfo(this.source, dependInfo);
                    }
                    this.source = null;
                    this.includes.setSize(0);
                }
            } else if (qName.equals("includePath")) {
                this.includePath = null;
            }
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (qName.equals("include")) {
                this.includes.addElement(atts.getValue("file"));
            } else if (qName.equals("sysinclude")) {
                this.sysIncludes.addElement(atts.getValue("file"));
            } else if (qName.equals("source")) {
                this.source = atts.getValue("file");
                this.sourceLastModified = Long.parseLong(atts.getValue("lastModified"), 16);
                this.includes.setSize(0);
                this.sysIncludes.setSize(0);
            } else if (qName.equals("includePath")) {
                this.includePath = atts.getValue("signature");
            }
        }
    }
}

