/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.metadata.Column;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.relational.RelationalPlanner;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.NewCalculateCostUtil;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.TestVirtualDepJoin;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestCalculateCostUtil {
    private static Criteria helpGetCriteria(String critString, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException, TeiidProcessingException {
        Criteria result = QueryParser.getQueryParser().parseCriteria(critString);
        QueryResolver.resolveCriteria((Criteria)result, (QueryMetadataInterface)metadata);
        result = QueryRewriter.rewriteCriteria((Criteria)result, (CommandContext)new CommandContext(), (QueryMetadataInterface)metadata);
        return result;
    }

    private static PlanNode helpGetJoinNode(float childCost1, float childCost2, JoinType joinType) {
        PlanNode joinNode = NodeFactory.getNewNode((int)4);
        PlanNode child1 = NodeFactory.getNewNode((int)1);
        PlanNode child2 = NodeFactory.getNewNode((int)1);
        joinNode.addLastChild(child1);
        joinNode.addLastChild(child2);
        child1.setProperty(NodeConstants.Info.EST_CARDINALITY, (Object)new Float(childCost1));
        child2.setProperty(NodeConstants.Info.EST_CARDINALITY, (Object)new Float(childCost2));
        joinNode.setProperty(NodeConstants.Info.JOIN_TYPE, (Object)joinType);
        return joinNode;
    }

    void helpTestEstimateCost(String critString, float childCost, float expectedResult, QueryMetadataInterface metadata) throws Exception {
        Criteria crit = TestCalculateCostUtil.helpGetCriteria(critString, metadata);
        PlanNode select = RelationalPlanner.createSelectNode((Criteria)crit, (boolean)false);
        float resultCost = NewCalculateCostUtil.recursiveEstimateCostOfCriteria((float)childCost, (PlanNode)select, (Criteria)crit, (QueryMetadataInterface)metadata);
        Assert.assertEquals((long)((int)expectedResult), (long)((int)resultCost));
    }

    @Test
    public void testEstimateCostOfCriteria() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm2.g3.e1 = '3' or pm2.g3.e2 = 2";
        this.helpTestEstimateCost(critString, -1.0f, -1.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfCompareCriteria() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm1.g1.e1 = '3'";
        this.helpTestEstimateCost(critString, -1.0f, 1.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfCompareCriteria1() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm1.g1.e1 < '3'";
        this.helpTestEstimateCost(critString, -1.0f, -1.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfMatchCriteria1() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm2.g3.e1 LIKE '#%'";
        this.helpTestEstimateCost(critString, 300.0f, 100.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfMatchCriteria2() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm2.g3.e1 NOT LIKE '#_'";
        this.helpTestEstimateCost(critString, 300.0f, 241.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfMatchCriteria3() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm1.g1.e1 LIKE '#_'";
        this.helpTestEstimateCost(critString, 300.0f, 50.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfMatchCriteria4() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm1.g1.e1 NOT LIKE '#_'";
        this.helpTestEstimateCost(critString, 300.0f, 249.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfIsNullCriteria1() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm2.g3.e1 IS NULL";
        this.helpTestEstimateCost(critString, 300.0f, 35.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfIsNullCriteria2() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm2.g3.e1 IS NOT NULL";
        this.helpTestEstimateCost(critString, 300.0f, 264.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfIsNullCriteria3() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm1.g1.e1 IS NULL";
        this.helpTestEstimateCost(critString, 300.0f, 1.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfIsNullCriteria4() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm1.g1.e1 IS NOT NULL";
        this.helpTestEstimateCost(critString, 300.0f, 300.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfSetCriteria1() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm2.g3.e1 IN ('2', '3')";
        this.helpTestEstimateCost(critString, -1.0f, -1.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfSetCriteria2() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm2.g3.e1 NOT IN ('2', '3')";
        this.helpTestEstimateCost(critString, -1.0f, -1.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfSetCriteria3() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm2.g3.e1 IN ('2', '3')";
        this.helpTestEstimateCost(critString, 300.0f, 33.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfSetCriteria4() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm2.g3.e1 NOT IN ('2', '3')";
        this.helpTestEstimateCost(critString, 300.0f, 266.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfSetCriteria5() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm1.g1.e1 IN ('2', '3')";
        this.helpTestEstimateCost(critString, -1.0f, 2.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfSetCriteria6() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm1.g1.e1 NOT IN ('2', '3')";
        this.helpTestEstimateCost(critString, -1.0f, -1.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfSetCriteria7() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm1.g1.e1 IN ('2', '3')";
        this.helpTestEstimateCost(critString, 200.0f, 2.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfSetCriteria8() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm1.g1.e1 NOT IN ('2', '3')";
        this.helpTestEstimateCost(critString, 200.0f, 198.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateJoinNodeCost() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        PlanNode joinNode = TestCalculateCostUtil.helpGetJoinNode(-1.0f, -1.0f, JoinType.JOIN_CROSS);
        float cost = NewCalculateCostUtil.computeCostForTree((PlanNode)joinNode, (QueryMetadataInterface)metadata);
        Assert.assertTrue((cost == -1.0f ? 1 : 0) != 0);
    }

    @Ignore(value="this logic needs to be refined to work better")
    @Test
    public void testEstimateJoinNodeCostOneUnknown() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        PlanNode joinNode = TestCalculateCostUtil.helpGetJoinNode(-1.0f, 500.0f, JoinType.JOIN_INNER);
        joinNode.setProperty(NodeConstants.Info.JOIN_CRITERIA, Arrays.asList(TestCalculateCostUtil.helpGetCriteria("pm1.g1.e1 = pm1.g2.e1", (QueryMetadataInterface)metadata)));
        float cost = NewCalculateCostUtil.computeCostForTree((PlanNode)joinNode, (QueryMetadataInterface)metadata);
        Assert.assertEquals((float)10000.0f, (float)cost, (float)0.0f);
    }

    @Test
    public void testEstimateNdvPostJoin() throws Exception {
        String query = "SELECT account FROM US.Accounts, Europe.CustAccts, CustomerMaster.Customers where account + accid + CustomerMaster.Customers.id = 1000000";
        this.helpTestQuery(1.0f, query, new String[]{"SELECT g_0.accid FROM Europe.CustAccts AS g_0", "SELECT g_0.id FROM CustomerMaster.Customers AS g_0", "SELECT g_0.account FROM US.Accounts AS g_0"});
    }

    @Test
    public void testEstimateCostOfCriteriaCompoundKey() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm4.g1.e1 = '3' and pm4.g1.e2 = 2";
        this.helpTestEstimateCost(critString, -1.0f, 1.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfCriteriaCompoundKey2() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm4.g1.e1 = '3' or pm4.g1.e2 = 2";
        this.helpTestEstimateCost(critString, -1.0f, -1.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfCriteriaCompoundKey3() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm4.g1.e1 = '3' and not pm4.g1.e2 = 2";
        this.helpTestEstimateCost(critString, -1.0f, -1.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfCriteriaCompoundKey4() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "(pm4.g1.e1 = '3' or pm4.g1.e4 = 2.0) and not pm4.g1.e2 = 2";
        this.helpTestEstimateCost(critString, -1.0f, -1.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfCriteriaCompoundKey5() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "(pm4.g1.e1 = '3' or pm4.g1.e4 = 2.0) and pm4.g1.e2 = 2";
        this.helpTestEstimateCost(critString, -1.0f, -1.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfCriteriaCompoundKey6() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "(pm4.g1.e1 = '3' and pm4.g1.e2 = 2) or pm4.g1.e4 = 2.0";
        this.helpTestEstimateCost(critString, -1.0f, -1.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfCriteriaCompoundKey8() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm4.g1.e1 LIKE '3%' and pm4.g1.e2 = 2";
        this.helpTestEstimateCost(critString, -1.0f, 1.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfCriteriaCompoundKey9() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm4.g1.e1 NOT LIKE '3%' and pm4.g1.e2 = 2";
        this.helpTestEstimateCost(critString, -1.0f, -1.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfCriteriaCompoundKey10() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "'3' LIKE pm4.g1.e1 and pm4.g1.e2 = 2";
        this.helpTestEstimateCost(critString, -1.0f, 1.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfCriteriaCompoundKey11() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm4.g1.e1 IS NULL and pm4.g1.e2 = 2";
        this.helpTestEstimateCost(critString, -1.0f, 1.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfCriteriaCompoundKey12() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm4.g1.e1 IS NOT NULL and pm4.g1.e2 = 2";
        this.helpTestEstimateCost(critString, -1.0f, -1.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfCriteriaCompoundKey13() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm4.g1.e1 IN ('3', '4') and pm4.g1.e2 = 2";
        this.helpTestEstimateCost(critString, -1.0f, 1.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfCriteriaCompoundKey14() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm4.g1.e1 NOT IN ('3', '4') and pm4.g1.e2 = 2";
        this.helpTestEstimateCost(critString, -1.0f, -1.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfCriteriaCompoundKey15() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "(pm4.g1.e1 = '3' or pm4.g1.e1 = '2') and (pm4.g1.e2 = 2 or pm4.g1.e2 = 1)";
        this.helpTestEstimateCost(critString, -1.0f, 1.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfCriteriaMultiGroup() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm4.g1.e1 = pm1.g1.e1";
        this.helpTestEstimateCost(critString, -1.0f, -1.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfCriteriaMultiGroup1() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm2.g3.e1 = pm4.g1.e1";
        this.helpTestEstimateCost(critString, -1.0f, -1.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfCriteriaMultiGroup2() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm4.g1.e1 = pm1.g1.e1";
        this.helpTestEstimateCost(critString, 100.0f, 3.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfCriteriaMultiGroup3() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example4();
        String critString = "pm2.g3.e1 = pm4.g1.e1";
        this.helpTestEstimateCost(critString, 100.0f, 10.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfCriteriaDate1() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        Column e2 = metadata.getElementID("pm3.g1.e2");
        e2.setMinimumValue("2007-04-03 12:12:12.10");
        e2.setMaximumValue("2007-06-03 12:12:12.10");
        String critString = "pm3.g1.e2 <= {d'2008-04-03'}";
        this.helpTestEstimateCost(critString, 100.0f, 100.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfCriteriaDate2() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        Column e2 = metadata.getElementID("pm3.g1.e2");
        e2.setMinimumValue("2007-04-03");
        e2.setMaximumValue("2007-06-03");
        String critString = "pm3.g1.e2 <= {d'2008-04-03'}";
        this.helpTestEstimateCost(critString, 100.0f, 33.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfCriteriaTime1() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        Column e3 = metadata.getElementID("pm3.g1.e3");
        e3.setMinimumValue("12:12:12");
        e3.setMaximumValue("12:13:14");
        String critString = "pm3.g1.e3 <= {t'11:11:11'}";
        this.helpTestEstimateCost(critString, 100.0f, 1.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfCriteriaTime2() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        Column e3 = metadata.getElementID("pm3.g1.e3");
        e3.setMinimumValue("2007-04-03 12:12:12.10");
        e3.setMaximumValue("2007-06-03 12:12:12.10");
        String critString = "pm3.g1.e3 <= {t'11:11:11'}";
        this.helpTestEstimateCost(critString, 100.0f, 33.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfCriteriaTimestamp1() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        Column e4 = metadata.getElementID("pm3.g1.e4");
        e4.setMinimumValue("2007-04-03 12:12:12.10");
        e4.setMaximumValue("2007-04-03 12:12:12.10");
        String critString = "pm3.g1.e4 <= {ts'2007-04-03 12:12:12.10'}";
        this.helpTestEstimateCost(critString, 100.0f, 1.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testEstimateCostOfCriteriaTimestamp2() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1();
        Column e4 = metadata.getElementID("pm3.g1.e4");
        e4.setMinimumValue("2007-04-03");
        e4.setMaximumValue("2007-06-03");
        String critString = "pm3.g1.e4 <= {ts'2007-04-03 12:12:12.10'}";
        this.helpTestEstimateCost(critString, 100.0f, 33.0f, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testNDVEstimate() throws Exception {
        String crit = "US.accounts.account = 10";
        this.helpTestEstimateCost(crit, 1000.0f, 800.0f, (QueryMetadataInterface)TestVirtualDepJoin.exampleVirtualDepJoin());
    }

    @Test
    public void testNDVEstimate1() throws Exception {
        String crit = "US.accounts.account = US.accounts.customer";
        this.helpTestEstimateCost(crit, 1000.0f, 894.0f, (QueryMetadataInterface)TestVirtualDepJoin.exampleVirtualDepJoin());
    }

    @Test
    public void testCompoundCriteriaEstimate() throws Exception {
        String crit = "US.accounts.account = 10 and US.accounts.account = US.accounts.customer";
        this.helpTestEstimateCost(crit, 1000.0f, 757.0f, (QueryMetadataInterface)TestVirtualDepJoin.exampleVirtualDepJoin());
    }

    @Test
    public void testCompoundCriteriaEstimate1() throws Exception {
        String crit = "US.accounts.account = 10 or US.accounts.account = US.accounts.customer";
        this.helpTestEstimateCost(crit, 1000.0f, 1000.0f, (QueryMetadataInterface)TestVirtualDepJoin.exampleVirtualDepJoin());
    }

    @Test
    public void testNNVEstimate() throws Exception {
        String crit = "US.accounts.account is null";
        this.helpTestEstimateCost(crit, 1000.0f, 1.0f, (QueryMetadataInterface)TestVirtualDepJoin.exampleVirtualDepJoin());
    }

    @Test
    public void testNNVEstimate1() throws Exception {
        String crit = "US.accounts.account is null";
        this.helpTestEstimateCost(crit, -1.0f, 1.0f, (QueryMetadataInterface)TestVirtualDepJoin.exampleVirtualDepJoin());
    }

    @Test
    public void testCompoundCriteriaEstimate2() throws Exception {
        String crit = "US.accounts.account is null and US.accounts.account = US.accounts.customer";
        this.helpTestEstimateCost(crit, 1000.0f, 1.0f, (QueryMetadataInterface)TestVirtualDepJoin.exampleVirtualDepJoin());
    }

    @Test
    public void testCompoundCriteriaEstimate3() throws Exception {
        String crit = "US.accounts.account is null or US.accounts.account = US.accounts.customer";
        this.helpTestEstimateCost(crit, 1000.0f, 895.0f, (QueryMetadataInterface)TestVirtualDepJoin.exampleVirtualDepJoin());
    }

    @Test
    public void testCompoundCriteriaEstimate4() throws Exception {
        String crit = "US.accounts.account = 10 and US.accounts.account = US.accounts.customer and US.accounts.customer < 100";
        this.helpTestEstimateCost(crit, 1000.0f, 87.0f, (QueryMetadataInterface)TestVirtualDepJoin.exampleVirtualDepJoin());
        String crit1 = "US.accounts.account = US.accounts.customer and US.accounts.customer < 100 and US.accounts.account = 10";
        this.helpTestEstimateCost(crit1, 1000.0f, 85.0f, (QueryMetadataInterface)TestVirtualDepJoin.exampleVirtualDepJoin());
    }

    @Test
    public void testCompoundCriteriaEstimate5() throws Exception {
        String crit = "US.accounts.account is null and US.accounts.account = US.accounts.customer";
        this.helpTestEstimateCost(crit, -1.0f, 1.0f, (QueryMetadataInterface)TestVirtualDepJoin.exampleVirtualDepJoin());
    }

    @Test
    public void testCompoundCriteriaEstimate6() throws Exception {
        String crit = "US.accounts.account is null or US.accounts.account = US.accounts.customer";
        this.helpTestEstimateCost(crit, -1.0f, -1.0f, (QueryMetadataInterface)TestVirtualDepJoin.exampleVirtualDepJoin());
    }

    @Test
    public void testCompoundCriteriaEstimate7() throws Exception {
        String critString = "US.accounts.account = 10";
        this.helpTestEstimateCost(critString, 1000.0f, 800.0f, (QueryMetadataInterface)TestVirtualDepJoin.exampleVirtualDepJoin());
        critString = "US.accounts.customer < 100";
        this.helpTestEstimateCost(critString, 800.0f, 80.0f, (QueryMetadataInterface)TestVirtualDepJoin.exampleVirtualDepJoin());
        String crit = "US.accounts.account = 10 and US.accounts.customer < 100";
        this.helpTestEstimateCost(crit, 1000.0f, 90.0f, (QueryMetadataInterface)TestVirtualDepJoin.exampleVirtualDepJoin());
    }

    @Test
    public void testRangeEstimate() throws Exception {
        String crit = "US.accounts.account < 100";
        this.helpTestEstimateCost(crit, 1000.0f, 333.0f, (QueryMetadataInterface)TestVirtualDepJoin.exampleVirtualDepJoin());
    }

    @Test
    public void testRangeEstimate1() throws Exception {
        String crit = "US.accounts.customer < 100";
        this.helpTestEstimateCost(crit, 1000.0f, 100.0f, (QueryMetadataInterface)TestVirtualDepJoin.exampleVirtualDepJoin());
    }

    @Test
    public void testRangeEstimate2() throws Exception {
        String crit = "US.accounts.customer > 100";
        this.helpTestEstimateCost(crit, 1000.0f, 900.0f, (QueryMetadataInterface)TestVirtualDepJoin.exampleVirtualDepJoin());
    }

    @Test
    public void testRangeEstimate3() throws Exception {
        String crit = "US.accounts.customer >= 1600";
        this.helpTestEstimateCost(crit, 1000.0f, 1.0f, (QueryMetadataInterface)TestVirtualDepJoin.exampleVirtualDepJoin());
    }

    @Test
    public void testRangeEstimate4() throws Exception {
        String crit = "US.accounts.customer < -1";
        this.helpTestEstimateCost(crit, 1000.0f, 1.0f, (QueryMetadataInterface)TestVirtualDepJoin.exampleVirtualDepJoin());
    }

    @Test
    public void testRangeEstimate5() throws Exception {
        String crit = "US.accounts.customer >= -1";
        this.helpTestEstimateCost(crit, 1000.0f, 1000.0f, (QueryMetadataInterface)TestVirtualDepJoin.exampleVirtualDepJoin());
    }

    @Test
    public void testRangeEstimate6() throws Exception {
        String crit = "US.accounts.pennies >= -2";
        this.helpTestEstimateCost(crit, 1000.0f, 1000.0f, (QueryMetadataInterface)TestVirtualDepJoin.exampleVirtualDepJoin());
    }

    @Test
    public void testRangeEstimate7() throws Exception {
        String crit = "US.accounts.pennies >= -6";
        this.helpTestEstimateCost(crit, 1000.0f, 800.0f, (QueryMetadataInterface)TestVirtualDepJoin.exampleVirtualDepJoin());
    }

    @Test
    public void testLimitWithUnknownChildCardinality() throws Exception {
        String query = "select e1 from pm1.g1 limit 2";
        RelationalPlan plan = (RelationalPlan)TestOptimizer.helpPlan(query, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new String[]{"SELECT e1 FROM pm1.g1"});
        Assert.assertEquals((Object)new Float(2.0f), (Object)plan.getRootNode().getEstimateNodeCardinality());
    }

    public void helpTestSetOp(String op, float cost) throws Exception {
        String query = "SELECT customer as customer_id, convert(account, long) as account_id, convert(txnid, long) as transaction_id, case txn when 'DEP' then 1 when 'TFR' then 2 when 'WD' then 3 else -1 end as txn_type, (pennies + convert('0.00', bigdecimal)) / 100 as amount, 'US' as source FROM US.Accounts where txn != 'X'" + op + "SELECT id, convert(accid / 10000, long), mod(accid, 10000), convert(type, integer), amount, 'EU' from Europe.CustAccts";
        String[] expected = new String[]{"SELECT g_0.customer, g_0.account, g_0.txnid, g_0.txn, g_0.pennies FROM US.Accounts AS g_0 WHERE g_0.txn <> 'X'", "SELECT g_0.id, g_0.accid, g_0.type, g_0.amount FROM Europe.CustAccts AS g_0"};
        this.helpTestQuery(cost, query, expected);
    }

    private void helpTestQuery(float cost, String query, String[] expected) throws TeiidComponentException, TeiidProcessingException {
        RelationalPlan plan = (RelationalPlan)TestOptimizer.helpPlan(query, (QueryMetadataInterface)TestVirtualDepJoin.exampleVirtualDepJoin(), expected, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
        Assert.assertEquals((Object)Float.valueOf(cost), (Object)plan.getRootNode().getEstimateNodeCardinality());
    }

    @Test
    public void testUnion() throws Exception {
        this.helpTestSetOp("UNION ", 1375000.0f);
    }

    @Test
    public void testUnionALL() throws Exception {
        this.helpTestSetOp("UNION ALL ", 1750000.0f);
    }

    @Test
    public void testExcept() throws Exception {
        this.helpTestSetOp("EXCEPT ", 250000.0f);
    }

    @Test
    public void testIntersect() throws Exception {
        this.helpTestSetOp("INTERSECT ", 375000.0f);
    }
}

