/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.FakeServer;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.security.Credentials;
import org.teiid.security.GSSResult;
import org.teiid.security.SecurityHelper;

public class TestPassthroughAuthentication {
    static FakeServer server = new FakeServer(false);
    static TestableSecurityHelper securityHelper = new TestableSecurityHelper();

    @AfterClass
    public static void oneTimeTearDown() {
        server.stop();
    }

    @BeforeClass
    public static void oneTimeSetup() throws Exception {
        server.setUseCallingThread(true);
        server.start(new EmbeddedConfiguration(){

            public SecurityHelper getSecurityHelper() {
                return securityHelper;
            }
        }, false);
    }

    @Test
    public void test() throws Exception {
        try {
            server.deployVDB("not_there", UnitTestUtil.getTestDataPath() + "/PartsSupplier.vdb");
            server.getSessionService().setTrustAllLocal(false);
            try {
                server.createConnection("jdbc:teiid:not_there.1;passthroughAuthentication=true");
                Assert.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
            server.getSessionService().setTrustAllLocal(true);
            server.createConnection("jdbc:teiid:not_there.1;passthroughAuthentication=true");
            securityHelper.associateSecurityContext("testSC");
            try {
                server.createConnection("jdbc:teiid:not_there.1;passthroughAuthentication=true");
            }
            catch (Exception e) {
                Assert.fail();
            }
        }
        finally {
            server.undeployVDB("not_there");
        }
    }

    private static class TestableSecurityHelper
    implements SecurityHelper {
        Object ctx;

        private TestableSecurityHelper() {
        }

        public Object associateSecurityContext(Object context) {
            this.ctx = context;
            return this.ctx;
        }

        public void clearSecurityContext() {
            this.ctx = null;
        }

        public Object getSecurityContext() {
            return this.ctx;
        }

        public Subject getSubjectInContext(String securityDomain) {
            if (securityDomain.equals("teiid-security") && this.getSecurityContext() != null && this.getSecurityContext().equals("testSC")) {
                Subject s = new Subject();
                return s;
            }
            return null;
        }

        public Subject getSubjectInContext(Object context) {
            if (context != null) {
                return new Subject();
            }
            return null;
        }

        public Object authenticate(String securityDomain, String baseUserName, Credentials credentials, String applicationName) throws LoginException {
            return this.ctx;
        }

        public GSSResult negotiateGssLogin(String securityDomain, byte[] serviceTicket) throws LoginException {
            return null;
        }
    }
}

