/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.DefaultCacheFactory;
import org.teiid.client.RequestMessage;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.datamgr.FakeTransactionService;
import org.teiid.dqp.internal.process.AuthorizationValidator;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.DefaultAuthorizationValidator;
import org.teiid.dqp.internal.process.PreparedPlan;
import org.teiid.dqp.internal.process.PreparedStatementRequest;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.service.AutoGenDataService;
import org.teiid.dqp.service.TransactionService;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestPreparedStatement {
    private static final int SESSION_ID = 6;

    static void helpTestProcessing(String preparedSql, List<?> values, List<?>[] expected, ProcessorDataManager dataManager, QueryMetadataInterface metadata, boolean callableStatement, VDBMetaData vdb) throws Exception {
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, metadata, callableStatement, false, vdb);
    }

    static void helpTestProcessing(String preparedSql, List<?> values, List<?>[] expected, ProcessorDataManager dataManager, QueryMetadataInterface metadata, boolean callableStatement, boolean isSessionSpecific, VDBMetaData vdb) throws Exception {
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, null, metadata, null, callableStatement, isSessionSpecific, false, vdb);
    }

    public static void helpTestProcessing(String preparedSql, List<?> values, List<?>[] expected, ProcessorDataManager dataManager, CapabilitiesFinder capFinder, QueryMetadataInterface metadata, SessionAwareCache<PreparedPlan> prepPlanCache, boolean callableStatement, boolean isSessionSpecific, boolean isAlreadyCached, VDBMetaData vdb) throws Exception {
        if (dataManager == null) {
            dataManager = new FakeDataManager();
            TestProcessor.sampleData1((FakeDataManager)dataManager);
        }
        if (capFinder == null) {
            capFinder = new DefaultCapabilitiesFinder();
        }
        if (prepPlanCache == null) {
            prepPlanCache = new SessionAwareCache("preparedplan", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.PREPAREDPLAN, 0);
        }
        int exHitCount = -1;
        exHitCount = isAlreadyCached ? prepPlanCache.getCacheHitCount() + 2 : prepPlanCache.getCacheHitCount() + 1;
        PreparedStatementRequest plan = TestPreparedStatement.helpGetProcessorPlan(preparedSql, values, capFinder, metadata, (SessionAwareCache<PreparedPlan>)prepPlanCache, 6, callableStatement, false, vdb);
        TestProcessor.doProcess(plan.processPlan, dataManager, expected, plan.context);
        plan = TestPreparedStatement.helpGetProcessorPlan(preparedSql, values, capFinder, metadata, (SessionAwareCache<PreparedPlan>)prepPlanCache, 6, callableStatement, false, vdb);
        Assert.assertEquals((String)"should reuse the plan", (long)exHitCount, (long)prepPlanCache.getCacheHitCount());
        boolean dmir = false;
        if (dataManager instanceof FakeDataManager && ((FakeDataManager)dataManager).isRecordingCommands()) {
            dmir = true;
            ((FakeDataManager)dataManager).setRecordingCommands(false);
        }
        TestProcessor.doProcess(plan.processPlan, dataManager, expected, plan.context);
        if (dmir) {
            ((FakeDataManager)dataManager).setRecordingCommands(true);
        }
        Assert.assertNotNull((Object)TestPreparedStatement.helpGetProcessorPlan(preparedSql, values, capFinder, metadata, (SessionAwareCache<PreparedPlan>)prepPlanCache, 7, callableStatement, false, vdb));
        if (!isSessionSpecific) {
            ++exHitCount;
        }
        Assert.assertEquals((long)exHitCount, (long)prepPlanCache.getCacheHitCount());
    }

    @Test
    public void testWhere() throws Exception {
        String preparedSql = "SELECT pm1.g1.e1, e2, pm1.g1.e3 as a, e4 as b FROM pm1.g1 WHERE e2=?";
        List[] expected = new List[]{Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList("a", new Integer(0), Boolean.FALSE, new Double(2.0))};
        List<Short> values = Arrays.asList((short)0);
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), false, RealMetadataFactory.example1VDB());
    }

    @Test
    public void testObjectCast() throws Exception {
        String preparedSql = "SELECT array_length(cast(? as object))";
        List[] expected = new List[]{Arrays.asList(1)};
        List<Object> values = Arrays.asList(new double[][]{{1.0}});
        FakeDataManager dataManager = new FakeDataManager();
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), false, RealMetadataFactory.example1VDB());
        values = Arrays.asList(new Object[]{new Double[]{1.0}});
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), false, RealMetadataFactory.example1VDB());
    }

    @Test
    public void testSessionSpecificFunction() throws Exception {
        String preparedSql = "SELECT session_id(), e2, pm1.g1.e3 as a, e4 as b FROM pm1.g1 WHERE e2=?";
        List[] expected = new List[]{Arrays.asList("6", new Integer(0), Boolean.FALSE, new Double(2.0)), Arrays.asList("6", new Integer(0), Boolean.FALSE, new Double(2.0))};
        List<Short> values = Arrays.asList((short)0);
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), false, true, RealMetadataFactory.example1VDB());
    }

    @Test
    public void testFunctionWithReferencePushDown() throws Exception {
        String preparedSql = "SELECT pm1.g1.e1 FROM pm1.g1, pm1.g2 WHERE pm1.g1.e1 = pm1.g2.e1 and pm1.g1.e2+2=?";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_EQ, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_COMPARE_ORDERED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_NOT, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER_FULL, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_ORDERBY, true);
        caps.setFunctionSupport("+", false);
        caps.setFunctionSupport("convert", true);
        capFinder.addCapabilities("pm1", (SourceCapabilities)caps);
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        List<Integer> values = Arrays.asList(0);
        PreparedStatementRequest plan = TestPreparedStatement.helpGetProcessorPlan(preparedSql, values, capFinder, (QueryMetadataInterface)metadata, (SessionAwareCache<PreparedPlan>)new SessionAwareCache("preparedplan", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.PREPAREDPLAN, 0), 6, false, false, RealMetadataFactory.example1VDB());
        TestOptimizer.checkNodeTypes(plan.processPlan, TestOptimizer.FULL_PUSHDOWN);
    }

    public static PreparedStatementRequest helpGetProcessorPlan(String preparedSql, List<?> values, SessionAwareCache<PreparedPlan> prepPlanCache) throws TeiidComponentException, TeiidProcessingException {
        return TestPreparedStatement.helpGetProcessorPlan(preparedSql, values, new DefaultCapabilitiesFinder(), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), prepPlanCache, 6, false, false, RealMetadataFactory.example1VDB());
    }

    public static PreparedStatementRequest helpGetProcessorPlan(String preparedSql, List<?> values, SessionAwareCache<PreparedPlan> prepPlanCache, int conn) throws TeiidComponentException, TeiidProcessingException {
        return TestPreparedStatement.helpGetProcessorPlan(preparedSql, values, new DefaultCapabilitiesFinder(), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), prepPlanCache, conn, false, false, RealMetadataFactory.example1VDB());
    }

    static PreparedStatementRequest helpGetProcessorPlan(String preparedSql, List<?> values, CapabilitiesFinder capFinder, QueryMetadataInterface metadata, SessionAwareCache<PreparedPlan> prepPlanCache, int conn, boolean callableStatement, boolean limitResults, VDBMetaData vdb) throws TeiidComponentException, TeiidProcessingException {
        RequestMessage request = new RequestMessage(preparedSql);
        if (callableStatement) {
            request.setStatementType(RequestMessage.StatementType.CALLABLE);
        } else {
            request.setStatementType(RequestMessage.StatementType.PREPARED);
        }
        request.setParameterValues(values);
        if (values != null && values.size() > 0 && values.get(0) instanceof List) {
            request.setBatchedUpdate(true);
        }
        if (limitResults) {
            request.setRowLimit(1);
        }
        DQPWorkContext workContext = RealMetadataFactory.buildWorkContext(metadata, vdb);
        workContext.getSession().setSessionId(String.valueOf(conn));
        PreparedStatementRequest serverRequest = new PreparedStatementRequest(prepPlanCache);
        ConnectorManagerRepository repo = (ConnectorManagerRepository)Mockito.mock(ConnectorManagerRepository.class);
        Mockito.stub((Object)repo.getConnectorManager(Mockito.anyString())).toReturn((Object)new AutoGenDataService());
        serverRequest.initialize(request, BufferManagerFactory.getStandaloneBufferManager(), null, (TransactionService)new FakeTransactionService(), null, workContext, prepPlanCache);
        serverRequest.setMetadata(capFinder, metadata);
        DefaultAuthorizationValidator drav = new DefaultAuthorizationValidator();
        serverRequest.setAuthorizationValidator((AuthorizationValidator)drav);
        serverRequest.processRequest();
        Assert.assertNotNull((Object)serverRequest.processPlan);
        return serverRequest;
    }

    @Test
    public void testValidateCorrectValues() throws Exception {
        String preparedSql = "SELECT pm1.g1.e1, e2, pm1.g1.e3 as a, e4 as b FROM pm1.g1 WHERE pm1.g1.e1=?";
        List<String> values = Arrays.asList("a");
        TestPreparedStatement.helpGetProcessorPlan(preparedSql, values, (SessionAwareCache<PreparedPlan>)new SessionAwareCache("preparedplan", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.PREPAREDPLAN, 0));
    }

    @Test
    public void testWithSubquery() throws Exception {
        String preparedSql = "SELECT pm1.g1.e1 FROM pm1.g1 WHERE pm1.g1.e2 IN (SELECT pm1.g2.e2 FROM pm1.g2 WHERE pm1.g2.e1 = ?)";
        List<String> values = Arrays.asList("a");
        TestPreparedStatement.helpGetProcessorPlan(preparedSql, values, (SessionAwareCache<PreparedPlan>)new SessionAwareCache("preparedplan", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.PREPAREDPLAN, 0));
    }

    @Test
    public void testWithSubquery2() throws Exception {
        String preparedSql = "SELECT pm1.g1.e1 FROM pm1.g1 WHERE pm1.g1.e1 = ? AND pm1.g1.e2 IN (SELECT pm1.g2.e2 FROM pm1.g2 WHERE pm1.g2.e1 = ?)";
        List<String> values = Arrays.asList("d", "c");
        TestPreparedStatement.helpGetProcessorPlan(preparedSql, values, (SessionAwareCache<PreparedPlan>)new SessionAwareCache("preparedplan", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.PREPAREDPLAN, 0));
    }

    @Test
    public void testWithSubquery3() throws Exception {
        String preparedSql = "SELECT X.e1 FROM (SELECT pm1.g2.e1 FROM pm1.g2 WHERE pm1.g2.e1 = ?) as X";
        List<String> values = Arrays.asList("d");
        TestPreparedStatement.helpGetProcessorPlan(preparedSql, values, (SessionAwareCache<PreparedPlan>)new SessionAwareCache("preparedplan", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.PREPAREDPLAN, 0));
    }

    @Test
    public void testValidateWrongValues() throws Exception {
        List<String> values;
        String preparedSql = "SELECT pm1.g1.e1, e2, pm1.g1.e3 as a, e4 as b FROM pm1.g1 WHERE pm1.g1.e2=?";
        SessionAwareCache prepCache = new SessionAwareCache("preparedplan", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.PREPAREDPLAN, 0);
        try {
            values = Arrays.asList("x");
            TestPreparedStatement.helpGetProcessorPlan(preparedSql, values, (SessionAwareCache<PreparedPlan>)prepCache, 6);
            Assert.fail();
        }
        catch (QueryResolverException qe) {
            Assert.assertEquals((Object)"TEIID30558 Error converting parameter number 1 with value \"x\" of class java.lang.String to expected type integer.", (Object)qe.getMessage());
        }
        Assert.assertEquals((long)0L, (long)prepCache.getCacheHitCount());
        try {
            values = new ArrayList<String>();
            values.add("a");
            values.add("b");
            TestPreparedStatement.helpGetProcessorPlan(preparedSql, values, (SessionAwareCache<PreparedPlan>)prepCache, 6);
            Assert.fail();
        }
        catch (QueryResolverException qe) {
            Assert.assertEquals((Object)"TEIID30556 The number of bound values '2' does not match the number of parameters '1' in the prepared statement.", (Object)qe.getMessage());
        }
        Assert.assertEquals((long)1L, (long)prepCache.getCacheHitCount());
        try {
            values = new ArrayList<String>();
            values.add("a");
            values.add((String)((Object)new Integer(0)));
            TestPreparedStatement.helpGetProcessorPlan(preparedSql, values, (SessionAwareCache<PreparedPlan>)prepCache);
            Assert.fail();
        }
        catch (QueryResolverException qe) {
            Assert.assertEquals((Object)"TEIID30556 The number of bound values '2' does not match the number of parameters '1' in the prepared statement.", (Object)qe.getMessage());
        }
    }

    @Test
    public void testResolveParameterValues() throws Exception {
        String preparedSql = "SELECT pm1.g1.e1, e2, pm1.g1.e3 as a, e4 as b FROM pm1.g1 WHERE pm1.g1.e2=?";
        List<String> values = Arrays.asList("0");
        TestPreparedStatement.helpGetProcessorPlan(preparedSql, values, (SessionAwareCache<PreparedPlan>)new SessionAwareCache("preparedplan", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.PREPAREDPLAN, 0));
    }

    @Test
    public void testLimit() throws Exception {
        String preparedSql = "SELECT pm1.g1.e1, e2, pm1.g1.e3 as a, e4 as b FROM pm1.g1 WHERE pm1.g1.e2=?";
        List<String> values = Arrays.asList("0");
        SessionAwareCache planCache = new SessionAwareCache("preparedplan", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.PREPAREDPLAN, 0);
        TestPreparedStatement.helpGetProcessorPlan(preparedSql, values, new DefaultCapabilitiesFinder(), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (SessionAwareCache<PreparedPlan>)planCache, 6, false, true, RealMetadataFactory.example1VDB());
        TestPreparedStatement.helpGetProcessorPlan(preparedSql, values, new DefaultCapabilitiesFinder(), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (SessionAwareCache<PreparedPlan>)planCache, 6, false, true, RealMetadataFactory.example1VDB());
        Assert.assertEquals((long)1L, (long)planCache.getCacheHitCount());
    }

    @Test
    public void testUpdateProcedureCriteria() throws Exception {
        String preparedSql = "delete from vm1.g37 where e1=?";
        List[] expected = new List[]{Arrays.asList(1)};
        List<String> values = Arrays.asList("aa ");
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData2b(dataManager, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, TestOptimizer.getGenericFinder(), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null, false, false, false, RealMetadataFactory.example1VDB());
    }

    @Test(expected=QueryValidatorException.class)
    public void testLimitValidation() throws Exception {
        String preparedSql = "select pm1.g1.e1 from pm1.g1 limit ?";
        List<Integer> values = Arrays.asList(-1);
        FakeDataManager dataManager = new FakeDataManager();
        TestPreparedStatement.helpTestProcessing(preparedSql, values, null, dataManager, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), false, false, RealMetadataFactory.example1VDB());
    }

    @Test
    public void testExecParam() throws Exception {
        String preparedSql = "exec pm1.sq2(?)";
        List<String> values = Arrays.asList("c");
        List[] expected = new List[]{Arrays.asList("c", 1)};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), false, false, RealMetadataFactory.example1VDB());
    }

    @Test
    public void testLimitParam() throws Exception {
        String preparedSql = "select e1 from pm1.g1 order by e1 desc limit ?";
        List<Integer> values = Arrays.asList(1);
        List[] expected = new List[]{Arrays.asList("c")};
        FakeDataManager dataManager = new FakeDataManager();
        TestProcessor.sampleData1(dataManager);
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), false, false, RealMetadataFactory.example1VDB());
    }

    @Test
    public void testWithSubqueryPushdown() throws Exception {
        String preparedSql = "SELECT pm1.g1.e1 FROM pm1.g1 WHERE pm1.g1.e2 IN /*+ no_unnest */ (SELECT pm1.g2.e2 FROM pm1.g2 WHERE pm1.g2.e1 = ?)";
        List[] expected = new List[]{Arrays.asList("a")};
        List<String> values = Arrays.asList("a");
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        HardcodedDataManager dataManager = new HardcodedDataManager((QueryMetadataInterface)metadata);
        dataManager.addData("SELECT g_0.e1 FROM g1 AS g_0 WHERE g_0.e2 IN (SELECT g_1.e2 FROM g2 AS g_1 WHERE g_1.e1 = 'a')", Arrays.asList("a"));
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN_SUBQUERY, true);
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, new DefaultCapabilitiesFinder((SourceCapabilities)caps), (QueryMetadataInterface)metadata, null, false, false, false, RealMetadataFactory.example1VDB());
    }

    @Test
    public void testInherentlyUpdatableViewCompensation() throws Exception {
        String preparedSql = "SELECT pm1.g1.e1 FROM pm1.g1 WHERE pm1.g1.e2 IN /*+ no_unnest */ (SELECT pm1.g2.e2 FROM pm1.g2 WHERE pm1.g2.e1 = ?)";
        List[] expected = new List[]{Arrays.asList("a")};
        List<String> values = Arrays.asList("a");
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        HardcodedDataManager dataManager = new HardcodedDataManager((QueryMetadataInterface)metadata);
        dataManager.addData("SELECT g_0.e1 FROM g1 AS g_0 WHERE g_0.e2 IN (SELECT g_1.e2 FROM g2 AS g_1 WHERE g_1.e1 = 'a')", Arrays.asList("a"));
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_SUBQUERIES_CORRELATED, true);
        caps.setCapabilitySupport(SourceCapabilities.Capability.CRITERIA_IN_SUBQUERY, true);
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, new DefaultCapabilitiesFinder((SourceCapabilities)caps), (QueryMetadataInterface)metadata, null, false, false, false, RealMetadataFactory.example1VDB());
    }

    @Test
    public void testInsertWithSimpleSelect() throws Exception {
        String preparedSql = "insert into pm1.g1 (e1, e2) select ?, ?";
        List[] expected = new List[]{Arrays.asList(1)};
        List<String> values = Arrays.asList("a", "1");
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        HardcodedDataManager dataManager = new HardcodedDataManager((QueryMetadataInterface)metadata);
        dataManager.addData("INSERT INTO g1 (e1, e2) VALUES ('a', 1)", Arrays.asList(1));
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, new DefaultCapabilitiesFinder((SourceCapabilities)caps), (QueryMetadataInterface)metadata, null, false, false, false, RealMetadataFactory.example1VDB());
    }

    @Test
    public void testAnonBlockIn() throws Exception {
        String preparedSql = "begin insert into pm1.g1 (e1, e2) select ?, ?; select rowcount; end;";
        List[] expected = new List[]{Arrays.asList(1)};
        List<String> values = Arrays.asList("a", "1");
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        HardcodedDataManager dataManager = new HardcodedDataManager((QueryMetadataInterface)metadata);
        dataManager.addData("INSERT INTO g1 (e1, e2) VALUES ('a', 1)", Arrays.asList(1));
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        TestPreparedStatement.helpTestProcessing(preparedSql, values, expected, dataManager, new DefaultCapabilitiesFinder((SourceCapabilities)caps), (QueryMetadataInterface)metadata, null, false, false, false, RealMetadataFactory.example1VDB());
    }
}

