/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.io.Reader;
import java.util.Properties;
import junit.framework.TestCase;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.FileStore;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.query.processor.xml.AddNodeInstruction;
import org.teiid.query.processor.xml.DocumentInProgress;
import org.teiid.query.processor.xml.FakeXMLProcessorEnvironment;
import org.teiid.query.processor.xml.NodeDescriptor;
import org.teiid.query.processor.xml.ProcessorInstruction;
import org.teiid.query.processor.xml.Program;
import org.teiid.query.processor.xml.XMLContext;
import org.teiid.query.processor.xml.XMLProcessorEnvironment;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.util.VariableContext;

public class TestAddNodeInstruction
extends TestCase {
    private static final String RESULT_SET_NAME = "rsName".toUpperCase();
    private static final String STRING_COLUMN = ".stringValue";
    private static final String NULL_COLUMN = ".nullValue";

    public TestAddNodeInstruction(String name) {
        super(name);
    }

    public void testAddEmptyElement() throws Exception {
        String tag = "test";
        String namespacePrefix = null;
        boolean isElement = true;
        String fixedValue = null;
        Properties namespaceDeclarations = null;
        boolean isOptional = false;
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor((String)tag, namespacePrefix, (boolean)isElement, fixedValue, namespaceDeclarations, null, (boolean)isOptional, null, (String)"preserve");
        AddNodeInstruction addNodeInstruction = new AddNodeInstruction(descriptor);
        String actualDoc = this.helpGetDocument(addNodeInstruction);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><test/></root>";
        TestAddNodeInstruction.assertEquals((String)"XML doc mismatch: ", (String)expectedDoc, (String)actualDoc);
    }

    public void testDontAddEmptyElement() throws Exception {
        String tag = "test";
        String namespacePrefix = null;
        boolean isElement = true;
        String fixedValue = null;
        Properties namespaceDeclarations = null;
        boolean isOptional = true;
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor((String)tag, namespacePrefix, (boolean)isElement, fixedValue, namespaceDeclarations, null, (boolean)isOptional, null, (String)"preserve");
        AddNodeInstruction addNodeInstruction = new AddNodeInstruction(descriptor);
        String actualDoc = this.helpGetDocument(addNodeInstruction);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root/>";
        TestAddNodeInstruction.assertEquals((String)"XML doc mismatch: ", (String)expectedDoc, (String)actualDoc);
    }

    public void testAddElementWithContent() throws Exception {
        String tag = "test";
        String namespacePrefix = null;
        boolean isElement = true;
        String rsColumn = STRING_COLUMN;
        String defaultValue = null;
        Properties namespaceDeclarations = null;
        boolean isOptional = false;
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor((String)tag, namespacePrefix, (boolean)isElement, defaultValue, namespaceDeclarations, null, (boolean)isOptional, null, (String)"preserve");
        AddNodeInstruction addNodeInstruction = new AddNodeInstruction(descriptor, new ElementSymbol(RESULT_SET_NAME + rsColumn));
        String actualDoc = this.helpGetDocument(addNodeInstruction);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><test>Lamp</test></root>";
        TestAddNodeInstruction.assertEquals((String)"XML doc mismatch: ", (String)expectedDoc, (String)actualDoc);
    }

    public void testAddElementWithDefault() throws Exception {
        String tag = "test";
        String namespacePrefix = null;
        boolean isElement = true;
        String rsColumn = NULL_COLUMN;
        String defaultValue = "default";
        Properties namespaceDeclarations = null;
        boolean isOptional = false;
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor((String)tag, namespacePrefix, (boolean)isElement, (String)defaultValue, namespaceDeclarations, null, (boolean)isOptional, null, (String)"preserve");
        AddNodeInstruction addNodeInstruction = new AddNodeInstruction(descriptor, new ElementSymbol(RESULT_SET_NAME + rsColumn));
        String actualDoc = this.helpGetDocument(addNodeInstruction);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><test>default</test></root>";
        TestAddNodeInstruction.assertEquals((String)"XML doc mismatch: ", (String)expectedDoc, (String)actualDoc);
    }

    public void testAddElementWithFixed() throws Exception {
        String tag = "test";
        String namespacePrefix = null;
        boolean isElement = true;
        String fixedValue = "fixed";
        Properties namespaceDeclarations = null;
        boolean isOptional = false;
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor((String)tag, namespacePrefix, (boolean)isElement, (String)fixedValue, namespaceDeclarations, null, (boolean)isOptional, null, (String)"preserve");
        AddNodeInstruction addNodeInstruction = new AddNodeInstruction(descriptor);
        String actualDoc = this.helpGetDocument(addNodeInstruction);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><test>fixed</test></root>";
        TestAddNodeInstruction.assertEquals((String)"XML doc mismatch: ", (String)expectedDoc, (String)actualDoc);
    }

    public void testAddContentElementWithNamespacePrefix() throws Exception {
        String tag = "test";
        String namespacePrefix = "yyz";
        boolean isElement = true;
        String rsColumn = STRING_COLUMN;
        String defaultValue = null;
        boolean isOptional = false;
        Properties rootNamespaceDeclarations = new Properties();
        rootNamespaceDeclarations.setProperty("yyz", "http://my.namespace/");
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor((String)tag, (String)namespacePrefix, (boolean)isElement, defaultValue, (Properties)rootNamespaceDeclarations, null, (boolean)isOptional, null, (String)"preserve");
        AddNodeInstruction addNodeInstruction = new AddNodeInstruction(descriptor, new ElementSymbol(RESULT_SET_NAME + rsColumn));
        String actualDoc = this.helpGetDocument((ProcessorInstruction)addNodeInstruction, rootNamespaceDeclarations);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root xmlns:yyz=\"http://my.namespace/\"><yyz:test>Lamp</yyz:test></root>";
        TestAddNodeInstruction.assertEquals((String)"XML doc mismatch: ", (String)expectedDoc, (String)actualDoc);
    }

    public void testAddContentElementWithNamespaces() throws Exception {
        String tag = "test";
        String namespacePrefix = null;
        boolean isElement = true;
        String rsColumn = STRING_COLUMN;
        String defaultValue = null;
        Properties namespaceDeclarations = new Properties();
        namespaceDeclarations.setProperty("yyz", "http://my.namespace/");
        boolean isOptional = false;
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor((String)tag, namespacePrefix, (boolean)isElement, defaultValue, (Properties)namespaceDeclarations, null, (boolean)isOptional, null, (String)"preserve");
        AddNodeInstruction addNodeInstruction = new AddNodeInstruction(descriptor, new ElementSymbol(RESULT_SET_NAME + rsColumn));
        String actualDoc = this.helpGetDocument(addNodeInstruction);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><test xmlns:yyz=\"http://my.namespace/\">Lamp</test></root>";
        TestAddNodeInstruction.assertEquals((String)"XML doc mismatch: ", (String)expectedDoc, (String)actualDoc);
    }

    public void testAddContentElementWithNamespaces2() throws Exception {
        String tag = "test";
        String namespacePrefix = "yyz";
        boolean isElement = true;
        String rsColumn = STRING_COLUMN;
        String defaultValue = null;
        Properties namespaceDeclarations = new Properties();
        namespaceDeclarations.setProperty("yyz", "http://my.namespace/");
        boolean isOptional = false;
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor((String)tag, (String)namespacePrefix, (boolean)isElement, defaultValue, (Properties)namespaceDeclarations, null, (boolean)isOptional, null, (String)"preserve");
        AddNodeInstruction addNodeInstruction = new AddNodeInstruction(descriptor, new ElementSymbol(RESULT_SET_NAME + rsColumn));
        String actualDoc = this.helpGetDocument(addNodeInstruction);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root><yyz:test xmlns:yyz=\"http://my.namespace/\">Lamp</yyz:test></root>";
        TestAddNodeInstruction.assertEquals((String)"XML doc mismatch: ", (String)expectedDoc, (String)actualDoc);
    }

    public void testAddContentElementWithNamespaces3() throws Exception {
        String tag = "test";
        String namespacePrefix = "yyz";
        boolean isElement = true;
        String rsColumn = STRING_COLUMN;
        String defaultValue = "shouldn't see";
        Properties namespaceDeclarations = new Properties();
        namespaceDeclarations.setProperty("yyz", "http://my.namespace/");
        boolean isOptional = false;
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor((String)tag, (String)namespacePrefix, (boolean)isElement, (String)defaultValue, (Properties)namespaceDeclarations, null, (boolean)isOptional, null, (String)"preserve");
        AddNodeInstruction addNodeInstruction = new AddNodeInstruction(descriptor, new ElementSymbol(RESULT_SET_NAME + rsColumn));
        Properties rootNamespaceDeclarations = new Properties();
        rootNamespaceDeclarations.setProperty("yyz", "http://my.namespace/");
        String actualDoc = this.helpGetDocument((ProcessorInstruction)addNodeInstruction, rootNamespaceDeclarations);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root xmlns:yyz=\"http://my.namespace/\"><yyz:test>Lamp</yyz:test></root>";
        TestAddNodeInstruction.assertEquals((String)"XML doc mismatch: ", (String)expectedDoc, (String)actualDoc);
    }

    public void testAddContentElementWithConflictingNamespaces() throws Exception {
        String tag = "test";
        String namespacePrefix = "yyz";
        boolean isElement = true;
        String rsColumn = STRING_COLUMN;
        String defaultValue = "shouldn't see";
        Properties namespaceDeclarations = new Properties();
        namespaceDeclarations.setProperty("yyz", "http://myother.namespace/");
        boolean isOptional = false;
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor((String)tag, (String)namespacePrefix, (boolean)isElement, (String)defaultValue, (Properties)namespaceDeclarations, null, (boolean)isOptional, null, (String)"preserve");
        AddNodeInstruction addNodeInstruction = new AddNodeInstruction(descriptor, new ElementSymbol(RESULT_SET_NAME + rsColumn));
        Properties rootNamespaceDeclarations = new Properties();
        rootNamespaceDeclarations.setProperty("yyz", "http://my.namespace/");
        String actualDoc = this.helpGetDocument((ProcessorInstruction)addNodeInstruction, rootNamespaceDeclarations);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root xmlns:yyz=\"http://my.namespace/\"><yyz:test xmlns:yyz=\"http://myother.namespace/\">Lamp</yyz:test></root>";
        TestAddNodeInstruction.assertEquals((String)"XML doc mismatch: ", (String)expectedDoc, (String)actualDoc);
    }

    public void testAddAttributeWithContent() throws Exception {
        String tag = "test";
        String namespacePrefix = null;
        boolean isElement = false;
        String rsColumn = STRING_COLUMN;
        String defaultValue = null;
        Properties namespaceDeclarations = null;
        boolean isOptional = false;
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor((String)tag, namespacePrefix, (boolean)isElement, defaultValue, namespaceDeclarations, null, (boolean)isOptional, null, (String)"preserve");
        AddNodeInstruction addNodeInstruction = new AddNodeInstruction(descriptor, new ElementSymbol(RESULT_SET_NAME + rsColumn));
        String actualDoc = this.helpGetDocument(addNodeInstruction);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root test=\"Lamp\"/>";
        TestAddNodeInstruction.assertEquals((String)"XML doc mismatch: ", (String)expectedDoc, (String)actualDoc);
    }

    public void testDontAddEmptyAttribute() throws Exception {
        String tag = "test";
        String namespacePrefix = null;
        boolean isElement = false;
        String rsColumn = NULL_COLUMN;
        String defaultValue = null;
        Properties namespaceDeclarations = null;
        boolean isOptional = false;
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor((String)tag, namespacePrefix, (boolean)isElement, defaultValue, namespaceDeclarations, null, (boolean)isOptional, null, (String)"preserve");
        AddNodeInstruction addNodeInstruction = new AddNodeInstruction(descriptor, new ElementSymbol(RESULT_SET_NAME + rsColumn));
        String actualDoc = this.helpGetDocument(addNodeInstruction);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root/>";
        TestAddNodeInstruction.assertEquals((String)"XML doc mismatch: ", (String)expectedDoc, (String)actualDoc);
    }

    public void testAddAttributeWithDefaultValue() throws Exception {
        String tag = "test";
        String namespacePrefix = null;
        boolean isElement = false;
        String rsColumn = NULL_COLUMN;
        String defaultValue = "default";
        Properties namespaceDeclarations = null;
        boolean isOptional = false;
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor((String)tag, namespacePrefix, (boolean)isElement, (String)defaultValue, namespaceDeclarations, null, (boolean)isOptional, null, (String)"preserve");
        AddNodeInstruction addNodeInstruction = new AddNodeInstruction(descriptor, new ElementSymbol(RESULT_SET_NAME + rsColumn));
        String actualDoc = this.helpGetDocument(addNodeInstruction);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root test=\"default\"/>";
        TestAddNodeInstruction.assertEquals((String)"XML doc mismatch: ", (String)expectedDoc, (String)actualDoc);
    }

    public void testAddAttributeWithFixedValue() throws Exception {
        String tag = "test";
        String namespacePrefix = null;
        boolean isElement = false;
        String fixedValue = "fixed";
        Properties namespaceDeclarations = null;
        boolean isOptional = true;
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor((String)tag, namespacePrefix, (boolean)isElement, (String)fixedValue, namespaceDeclarations, null, (boolean)isOptional, null, (String)"preserve");
        AddNodeInstruction addNodeInstruction = new AddNodeInstruction(descriptor);
        String actualDoc = this.helpGetDocument(addNodeInstruction);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root test=\"fixed\"/>";
        TestAddNodeInstruction.assertEquals((String)"XML doc mismatch: ", (String)expectedDoc, (String)actualDoc);
    }

    public void testAddAttributeWithNamespacePrefix() throws Exception {
        String tag = "test";
        String namespacePrefix = "yyz";
        boolean isElement = false;
        String rsColumn = STRING_COLUMN;
        String defaultValue = "shouldn't see";
        boolean isOptional = false;
        Properties rootNamespaceDeclarations = new Properties();
        rootNamespaceDeclarations.setProperty("yyz", "http://my.namespace/");
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor((String)tag, (String)namespacePrefix, (boolean)isElement, (String)defaultValue, (Properties)rootNamespaceDeclarations, null, (boolean)isOptional, null, (String)"preserve");
        AddNodeInstruction addNodeInstruction = new AddNodeInstruction(descriptor, new ElementSymbol(RESULT_SET_NAME + rsColumn));
        String actualDoc = this.helpGetDocument((ProcessorInstruction)addNodeInstruction, rootNamespaceDeclarations);
        String expectedDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><root xmlns:yyz=\"http://my.namespace/\" yyz:test=\"Lamp\"/>";
        TestAddNodeInstruction.assertEquals((String)"XML doc mismatch: ", (String)expectedDoc, (String)actualDoc);
    }

    private String helpGetDocument(AddNodeInstruction addNodeInstruction) throws Exception {
        return this.helpGetDocument((ProcessorInstruction)addNodeInstruction, null);
    }

    private String helpGetDocument(ProcessorInstruction addNodeInstruction, Properties namespaceDeclarations) throws Exception {
        XMLContext context = new XMLContext();
        FakeXMLProcessorEnvironment env = new FakeXMLProcessorEnvironment();
        VariableContext varContext = context.getVariableContext();
        varContext.setValue((Object)new ElementSymbol(RESULT_SET_NAME + STRING_COLUMN), (Object)"Lamp");
        varContext.setValue((Object)new ElementSymbol(RESULT_SET_NAME + NULL_COLUMN), null);
        Program program = new Program();
        program.addInstruction(addNodeInstruction);
        env.pushProgram(program);
        FileStore fs = BufferManagerFactory.getStandaloneBufferManager().createFileStore("test");
        DocumentInProgress doc = new DocumentInProgress(fs, "UTF-8");
        env.setDocumentInProgress(doc);
        NodeDescriptor descriptor = NodeDescriptor.createNodeDescriptor((String)"root", null, (boolean)true, null, (Properties)namespaceDeclarations, null, (boolean)false, null, (String)"preserve");
        doc.addElement(descriptor, (NodeDescriptor)null);
        doc.moveToLastChild();
        addNodeInstruction.process((XMLProcessorEnvironment)env, context);
        doc.moveToParent();
        doc.markAsFinished();
        String actualDoc = ObjectConverterUtil.convertToString((Reader)doc.getSQLXML().getCharacterStream());
        return actualDoc;
    }
}

