/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;

public class TestSetCriteria {
    public static final SetCriteria sample1() {
        SetCriteria c1 = new SetCriteria();
        c1.setExpression((Expression)new ElementSymbol("e1"));
        ArrayList<Constant> vals = new ArrayList<Constant>();
        vals.add(new Constant((Object)"a"));
        vals.add(new Constant((Object)"b"));
        c1.setValues(vals);
        return c1;
    }

    public static final SetCriteria sample2() {
        SetCriteria c1 = new SetCriteria();
        c1.setExpression((Expression)new ElementSymbol("e2"));
        ArrayList<Constant> vals = new ArrayList<Constant>();
        vals.add(new Constant((Object)"c"));
        vals.add(new Constant((Object)"d"));
        c1.setValues(vals);
        return c1;
    }

    @Test
    public void testEquals1() {
        SetCriteria c1 = new SetCriteria();
        c1.setExpression((Expression)new ElementSymbol("e1"));
        ArrayList<Constant> vals = new ArrayList<Constant>();
        vals.add(new Constant((Object)"a"));
        vals.add(new Constant((Object)"b"));
        c1.setValues(vals);
        SetCriteria c2 = (SetCriteria)c1.clone();
        Assert.assertTrue((String)("Equivalent set criteria don't compare as equal: " + c1 + ", " + c2), (boolean)c1.equals((Object)c2));
    }

    @Test
    public void testEquals2() {
        SetCriteria c1 = new SetCriteria();
        c1.setNegated(true);
        c1.setExpression((Expression)new ElementSymbol("e1"));
        ArrayList<Constant> vals1 = new ArrayList<Constant>();
        vals1.add(new Constant((Object)"a"));
        vals1.add(new Constant((Object)"b"));
        c1.setValues(vals1);
        SetCriteria c2 = new SetCriteria();
        c2.setNegated(true);
        c2.setExpression((Expression)new ElementSymbol("e1"));
        ArrayList<Constant> vals2 = new ArrayList<Constant>();
        vals2.add(new Constant((Object)"b"));
        vals2.add(new Constant((Object)"a"));
        c2.setValues(vals2);
        Assert.assertTrue((String)("Equivalent set criteria don't compare as equal: " + c1 + ", " + c2), (boolean)c1.equals((Object)c2));
    }

    @Test
    public void testSelfEquivalence() {
        SetCriteria s1 = TestSetCriteria.sample1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1);
    }

    @Test
    public void testEquivalence() {
        SetCriteria s1 = TestSetCriteria.sample1();
        SetCriteria s1a = TestSetCriteria.sample1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1a);
    }

    @Test
    public void testNonEquivalence1() {
        SetCriteria s1 = TestSetCriteria.sample1();
        SetCriteria s2 = TestSetCriteria.sample2();
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s2);
    }

    @Test
    public void testNonEquivalence2() {
        SetCriteria c1 = new SetCriteria();
        c1.setExpression((Expression)new ElementSymbol("e1"));
        ArrayList<Constant> vals = new ArrayList<Constant>();
        vals.add(new Constant((Object)"a"));
        vals.add(new Constant((Object)"b"));
        c1.setValues(vals);
        SetCriteria c2 = (SetCriteria)c1.clone();
        Assert.assertNotSame(c1.getValues().iterator().next(), c2.getValues().iterator().next());
        c2.setNegated(true);
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)c1, (Object)c2);
    }

    @Test
    public void testNonHashableClone() {
        SetCriteria c1 = new SetCriteria();
        c1.setExpression((Expression)new ElementSymbol("e1"));
        TreeSet<Constant> vals = new TreeSet<Constant>();
        vals.add(new Constant((Object)BigDecimal.valueOf(1.1)));
        vals.add(new Constant((Object)BigDecimal.valueOf(1.2)));
        c1.setValues(vals);
        c1.setAllConstants(true);
        SetCriteria c2 = (SetCriteria)c1.clone();
        Assert.assertTrue((boolean)(c2.getValues() instanceof TreeSet));
    }
}

