/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.testcases;

import java.util.ArrayList;
import org.junit.Test;
import org.teiid.test.framework.TransactionContainer;
import org.teiid.test.framework.TransactionQueryTestCase;
import org.teiid.test.framework.query.AbstractQueryTransactionTest;
import org.teiid.test.framework.query.QueryExecution;
import org.teiid.test.framework.transaction.TxnAutoTransaction;
import org.teiid.test.testcases.BaseAbstractTransactionTestCase;

public class OffWrapTransactionTests
extends BaseAbstractTransactionTestCase {
    @Override
    protected TransactionContainer getTransactionContainter() {
        return new TxnAutoTransaction("OFF");
    }

    @Test
    public void testSingleSourceSelect() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testSingleSourceSelect"){

            public void testCase() throws Exception {
                this.execute("select * from pm1.g1 where pm1.g1.e1 < 100");
                this.assertRowCount(100);
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
    }

    @Test
    public void testSingleSourceUpdate() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testSingleSourceUpdate"){

            public void testCase() throws Exception {
                this.execute("insert into pm1.g1 (e1, e2) values(100, '100')");
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
        QueryExecution test = new QueryExecution(userTxn.getSource("pm1"));
        test.execute("select * from g1 where e1 = 100");
        test.assertRowCount(1);
    }

    @Test
    public void testSingleSourceMultipleCommands() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testSingleSourceMultipleCommands"){

            public void testCase() throws Exception {
                this.execute("delete from pm1.g1 where pm1.g1.e1 >= ?", new Object[]{new Integer(100)});
                this.execute("select * from pm1.g1");
                this.assertRowCount(100);
                for (int i = 100; i < 110; ++i) {
                    Integer val = new Integer(i);
                    this.execute("insert into pm1.g1 (e1, e2) values(?,?)", new Object[]{val, val.toString()});
                    this.execute("insert into pm1.g2 (e1, e2) values(?,?)", new Object[]{val, val.toString()});
                }
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
        QueryExecution test = new QueryExecution(userTxn.getSource("pm1"));
        test.execute("select * from g1 where e1 >= 100");
        test.assertRowCount(10);
        test.execute("select * from g2 where e1 >= 100");
        test.assertRowCount(10);
    }

    @Test
    public void testSingleSourceMultipleCommandsReferentialIntegrityRollback() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testSingleSourceMultipleCommandsReferentialIntegrityRollback"){

            public void testCase() throws Exception {
                for (int i = 200; i < 210; ++i) {
                    Integer val = new Integer(i);
                    this.execute("insert into pm1.g1 (e1, e2) values(?,?)", new Object[]{val, val.toString()});
                    this.execute("insert into pm1.g2 (e1, e2) values(?,?)", new Object[]{val, val.toString()});
                }
                this.execute("insert into pm1.g2 (e1, e2) values(?,?)", new Object[]{new Integer(9999), "9999"});
            }

            public boolean exceptionExpected() {
                return true;
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
        QueryExecution test = new QueryExecution(userTxn.getSource("pm1"));
        test.execute("select * from g1 where e1 >= 200");
        test.assertRowCount(10);
    }

    @Test
    public void testMultipleSourceSelect() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testMultipleSourceSelect"){

            public void testCase() throws Exception {
                this.execute("select * from pm1.g1 join pm2.g1 on pm1.g1.e1 = pm2.g1.e1 where pm1.g1.e1 < 100");
                this.assertRowCount(100);
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
    }

    @Test
    public void testMultipleSourceUpdate() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testMultipleSourceUpdate"){

            public void testCase() throws Exception {
                this.execute("insert into vm.g1 (pm1e1, pm1e2, pm2e1, pm2e2) values(500, '500', 500, '500')");
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
        QueryExecution test = new QueryExecution(userTxn.getSource("pm1"));
        test.execute("select * from g1 where e1 = 500");
        test.assertRowCount(1);
        test = new QueryExecution(userTxn.getSource("pm2"));
        test.execute("select * from g1 where e1 = 500");
        test.assertRowCount(1);
    }

    @Test
    public void testMultipleSourceMultipleCommandsReferentialIntegrityRollback() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testMultipleSourceMultipleCommandsReferentialIntegrityRollback"){

            public void testCase() throws Exception {
                for (int i = 700; i < 710; ++i) {
                    Integer val = new Integer(i);
                    this.execute("insert into pm1.g1 (e1, e2) values(?,?)", new Object[]{val, val.toString()});
                    this.execute("insert into pm1.g2 (e1, e2) values(?,?)", new Object[]{val, val.toString()});
                    this.execute("insert into pm2.g1 (e1, e2) values(?,?)", new Object[]{val, val.toString()});
                    this.execute("insert into pm2.g2 (e1, e2) values(?,?)", new Object[]{val, val.toString()});
                }
                this.execute("insert into pm1.g2 (e1, e2) values(?,?)", new Object[]{new Integer(9999), "9999"});
            }

            public boolean exceptionExpected() {
                return true;
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
        QueryExecution test = new QueryExecution(userTxn.getSource("pm1"));
        test.execute("select * from g1 where e1 >= 700 and e1 < 710");
        test.assertRowCount(10);
        test = new QueryExecution(userTxn.getSource("pm2"));
        test.execute("select * from g1 where e1 >= 700 and e1 < 710");
        test.assertRowCount(10);
    }

    @Test
    public void testMultipleSourceBulkRowInsert() throws Exception {
        AbstractQueryTransactionTest userTxn = new AbstractQueryTransactionTest("testMultipleSourceBulkRowInsert"){
            ArrayList list;
            {
                this.list = new ArrayList();
            }

            public void testCase() throws Exception {
                for (int i = 800; i < 807; ++i) {
                    this.list.add("insert into pm1.g1 (e1, e2) values(" + i + ",'" + i + "')");
                    this.list.add("insert into pm2.g1 (e1, e2) values(" + i + ",'" + i + "')");
                }
                this.list.add("select pm1.g1.e1, pm1.g1.e2 into pm2.g2 from pm1.g1 where pm1.g1.e1 >= 800");
                this.list.add("insert into pm1.g2 (e1, e2) values(9999,'9999')");
                this.executeBatch(this.list.toArray(new String[this.list.size()]), -1);
            }

            public boolean exceptionExpected() {
                return true;
            }
        };
        this.getTransactionContainter().runTransaction((TransactionQueryTestCase)userTxn);
        QueryExecution test = new QueryExecution(userTxn.getSource("pm1"));
        test.execute("select * from g1 where e1 >= 800 and e1 < 807");
        test.assertRowCount(7);
        test = new QueryExecution(userTxn.getSource("pm2"));
        test.execute("select * from g1 where e1 >= 800 and e1 < 807");
        test.assertRowCount(7);
        test.execute("select * from g2 where e1 >= 800 and e1 < 807");
        test.assertRowCount(7);
    }
}

