/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ByteOrderValues;
import com.vividsolutions.jts.io.InStream;
import com.vividsolutions.jts.io.InputStreamInStream;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.gml2.GMLHandler;
import com.vividsolutions.jts.io.gml2.GMLWriter;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.teiid.CommandContext;
import org.teiid.UserDefinedAggregate;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.GeometryType;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.GeometryTransformUtils;
import org.wololo.geojson.Geometry;
import org.wololo.jts2geojson.GeoJSONReader;
import org.wololo.jts2geojson.GeoJSONWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GeometryUtils {
    private static GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();
    private static final int SRID_4326 = 4326;

    public static ClobType geometryToClob(GeometryType geometry, boolean withSrid) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry jtsGeometry = GeometryUtils.getGeometry(geometry);
        int srid = jtsGeometry.getSRID();
        StringBuilder geomText = new StringBuilder();
        if (withSrid && srid != 0) {
            geomText.append("SRID=").append(jtsGeometry.getSRID()).append(";");
        }
        geomText.append(jtsGeometry.toText());
        return new ClobType((Clob)new ClobImpl(geomText.toString()));
    }

    public static GeometryType geometryFromClob(ClobType wkt) throws FunctionExecutionException {
        return GeometryUtils.geometryFromClob(wkt, 0, false);
    }

    public static GeometryType geometryFromClob(ClobType wkt, Integer srid, boolean allowEwkt) throws FunctionExecutionException {
        Reader r = null;
        try {
            com.vividsolutions.jts.geom.Geometry jtsGeometry;
            WKTReader reader = new WKTReader(GEOMETRY_FACTORY);
            r = wkt.getCharacterStream();
            if (allowEwkt) {
                int charRead;
                PushbackReader pbr = new PushbackReader(r, 1);
                r = pbr;
                char[] expected = new char[]{'s', 'r', 'i', 'd', '='};
                int expectedIndex = 0;
                StringBuilder sridBuffer = null;
                for (int i = 0; i < 100000 && (charRead = pbr.read()) != -1; ++i) {
                    if (expectedIndex == expected.length) {
                        if (sridBuffer == null) {
                            sridBuffer = new StringBuilder(4);
                        }
                        if (charRead == 59) {
                            if (sridBuffer.length() != 0) break;
                            pbr.unread(charRead);
                            break;
                        }
                        sridBuffer.append((char)charRead);
                        continue;
                    }
                    if (expectedIndex == 0 && Character.isWhitespace(charRead)) continue;
                    if (expected[expectedIndex] != Character.toLowerCase(charRead)) {
                        pbr.unread(charRead);
                        break;
                    }
                    ++expectedIndex;
                }
                if (sridBuffer != null) {
                    srid = Integer.parseInt(sridBuffer.toString());
                }
            }
            if ((jtsGeometry = reader.read(r)) == null) {
                throw new FunctionExecutionException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31203, new Object[0]));
            }
            if (!allowEwkt && (jtsGeometry.getSRID() != 0 || jtsGeometry.getCoordinate() != null && !Double.isNaN(jtsGeometry.getCoordinate().z))) {
                throw new FunctionExecutionException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31160, new Object[]{"EWKT"}));
            }
            if (srid == null) {
                srid = jtsGeometry.getSRID();
            }
            GeometryType geometryType = GeometryUtils.getGeometryType(jtsGeometry, srid);
            return geometryType;
        }
        catch (ParseException e) {
            throw new FunctionExecutionException(e);
        }
        catch (SQLException e) {
            throw new FunctionExecutionException(e);
        }
        catch (IOException e) {
            throw new FunctionExecutionException(e);
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static ClobType geometryToGeoJson(GeometryType geometry) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry jtsGeometry = GeometryUtils.getGeometry(geometry);
        GeoJSONWriter writer = new GeoJSONWriter();
        try {
            Geometry geoJson = writer.write(jtsGeometry);
            ClobType result = new ClobType((Clob)new ClobImpl(geoJson.toString()));
            result.setType(ClobType.Type.JSON);
            return result;
        }
        catch (Exception e) {
            throw new FunctionExecutionException(e);
        }
    }

    public static GeometryType geometryFromGeoJson(ClobType json) throws FunctionExecutionException {
        return GeometryUtils.geometryFromGeoJson(json, 0);
    }

    public static GeometryType geometryFromGeoJson(ClobType json, int srid) throws FunctionExecutionException {
        try {
            GeoJSONReader reader = new GeoJSONReader();
            String jsonText = ClobType.getString((Clob)json);
            com.vividsolutions.jts.geom.Geometry jtsGeometry = reader.read(jsonText);
            return GeometryUtils.getGeometryType(jtsGeometry, srid);
        }
        catch (SQLException e) {
            throw new FunctionExecutionException(e);
        }
        catch (IOException e) {
            throw new FunctionExecutionException(e);
        }
    }

    public static ClobType geometryToGml(CommandContext ctx, GeometryType geometry, boolean withGmlPrefix) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry jtsGeometry = GeometryUtils.getGeometry(geometry);
        GMLWriter writer = new GMLWriter();
        if (!withGmlPrefix) {
            if (geometry.getSrid() != 4326) {
                if (geometry.getSrid() == 0) {
                    throw new FunctionExecutionException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31161, new Object[0]));
                }
                jtsGeometry = GeometryTransformUtils.transform(ctx, jtsGeometry, 4326);
            }
            writer.setPrefix(null);
        } else if (geometry.getSrid() != 0) {
            // empty if block
        }
        String gmlText = writer.write(jtsGeometry);
        return new ClobType((Clob)new ClobImpl(gmlText));
    }

    public static GeometryType geometryFromGml(ClobType gml, Integer srid) throws FunctionExecutionException {
        try {
            return GeometryUtils.geometryFromGml(gml.getCharacterStream(), srid);
        }
        catch (SQLException e) {
            throw new FunctionExecutionException(e);
        }
    }

    public static GeometryType geometryFromGml(Reader reader, Integer srid) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry jtsGeometry = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            SAXParser parser = factory.newSAXParser();
            GmlSridHandler handler = new GmlSridHandler(GEOMETRY_FACTORY, null);
            parser.parse(new InputSource(reader), (DefaultHandler)((Object)handler));
            jtsGeometry = handler.getGeometry();
            if (srid == null) {
                srid = jtsGeometry.getSRID() == 0 ? Integer.valueOf(handler.getSrid()) : Integer.valueOf(jtsGeometry.getSRID());
            }
        }
        catch (IOException e) {
            throw new FunctionExecutionException(e);
        }
        catch (SAXException e) {
            throw new FunctionExecutionException(e);
        }
        catch (ParserConfigurationException e) {
            throw new FunctionExecutionException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return GeometryUtils.getGeometryType(jtsGeometry, srid);
    }

    public static GeometryType geometryFromBlob(BlobType wkb) throws FunctionExecutionException {
        return GeometryUtils.geometryFromBlob(wkb, 0);
    }

    public static GeometryType geometryFromBlob(BlobType wkb, int srid) throws FunctionExecutionException {
        GeometryType gt = new GeometryType((Blob)wkb.getReference(), srid);
        GeometryUtils.getGeometry(gt);
        return gt;
    }

    public static Boolean intersects(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g1 = GeometryUtils.getGeometry(geom1);
        com.vividsolutions.jts.geom.Geometry g2 = GeometryUtils.getGeometry(geom2);
        return g1.intersects(g2);
    }

    public static Boolean contains(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g1 = GeometryUtils.getGeometry(geom1);
        com.vividsolutions.jts.geom.Geometry g2 = GeometryUtils.getGeometry(geom2);
        return g1.contains(g2);
    }

    public static Boolean disjoint(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g1 = GeometryUtils.getGeometry(geom1);
        com.vividsolutions.jts.geom.Geometry g2 = GeometryUtils.getGeometry(geom2);
        return g1.disjoint(g2);
    }

    public static Boolean crosses(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g1 = GeometryUtils.getGeometry(geom1);
        com.vividsolutions.jts.geom.Geometry g2 = GeometryUtils.getGeometry(geom2);
        return g1.crosses(g2);
    }

    public static Double distance(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g1 = GeometryUtils.getGeometry(geom1);
        com.vividsolutions.jts.geom.Geometry g2 = GeometryUtils.getGeometry(geom2);
        return g1.distance(g2);
    }

    public static Boolean touches(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g1 = GeometryUtils.getGeometry(geom1);
        com.vividsolutions.jts.geom.Geometry g2 = GeometryUtils.getGeometry(geom2);
        return g1.touches(g2);
    }

    public static Boolean overlaps(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g1 = GeometryUtils.getGeometry(geom1);
        com.vividsolutions.jts.geom.Geometry g2 = GeometryUtils.getGeometry(geom2);
        return g1.overlaps(g2);
    }

    public static GeometryType getGeometryType(com.vividsolutions.jts.geom.Geometry jtsGeom) {
        return GeometryUtils.getGeometryType(jtsGeom, jtsGeom.getSRID());
    }

    public static GeometryType getGeometryType(com.vividsolutions.jts.geom.Geometry jtsGeom, int srid) {
        WKBWriter writer = new WKBWriter();
        byte[] bytes = writer.write(jtsGeom);
        return new GeometryType(bytes, srid);
    }

    public static com.vividsolutions.jts.geom.Geometry getGeometry(GeometryType geom) throws FunctionExecutionException {
        try {
            return GeometryUtils.getGeometry(geom.getBinaryStream(), geom.getSrid(), false);
        }
        catch (SQLException e) {
            throw new FunctionExecutionException(e);
        }
    }

    public static com.vividsolutions.jts.geom.Geometry getGeometry(InputStream is1, Integer srid, boolean allowEwkb) throws FunctionExecutionException {
        try {
            WKBReader reader = new WKBReader();
            com.vividsolutions.jts.geom.Geometry jtsGeom = reader.read((InStream)new InputStreamInStream(is1));
            if (!allowEwkb && (jtsGeom.getSRID() != 0 || jtsGeom.getCoordinate() != null && !Double.isNaN(jtsGeom.getCoordinate().z))) {
                throw new FunctionExecutionException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31160, new Object[]{"EWKB"}));
            }
            if (srid != null) {
                jtsGeom.setSRID(srid.intValue());
            }
            com.vividsolutions.jts.geom.Geometry geometry = jtsGeom;
            return geometry;
        }
        catch (ParseException e) {
            throw new FunctionExecutionException(e);
        }
        catch (IOException e) {
            throw new FunctionExecutionException(e);
        }
        finally {
            if (is1 != null) {
                try {
                    is1.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Boolean equals(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.getGeometry(geom1).equalsTopo(GeometryUtils.getGeometry(geom2));
    }

    public static GeometryType geometryFromEwkb(InputStream is, Integer srid) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry geom = GeometryUtils.getGeometry(is, srid, true);
        return GeometryUtils.getGeometryType(geom);
    }

    public static GeometryType simplify(GeometryType geom, double tolerance) throws FunctionExecutionException {
        return GeometryUtils.getGeometryType(DouglasPeuckerSimplifier.simplify((com.vividsolutions.jts.geom.Geometry)GeometryUtils.getGeometry(geom), (double)tolerance));
    }

    public static boolean boundingBoxIntersects(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g1 = GeometryUtils.getGeometry(geom1);
        com.vividsolutions.jts.geom.Geometry g2 = GeometryUtils.getGeometry(geom2);
        return g1.getEnvelope().intersects(g2.getEnvelope());
    }

    public static GeometryType envelope(GeometryType geom) throws FunctionExecutionException {
        return GeometryUtils.getGeometryType(GeometryUtils.getGeometry(geom).getEnvelope());
    }

    public static Boolean within(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g1 = GeometryUtils.getGeometry(geom1);
        com.vividsolutions.jts.geom.Geometry g2 = GeometryUtils.getGeometry(geom2);
        return g1.within(g2);
    }

    public static Boolean dwithin(GeometryType geom1, GeometryType geom2, double distance) throws FunctionExecutionException {
        return GeometryUtils.distance(geom1, geom2) < distance;
    }

    public static BlobType geometryToEwkb(final GeometryType geometry) {
        final Blob b = (Blob)geometry.getReference();
        BlobImpl blobImpl = new BlobImpl(new InputStreamFactory(){

            public InputStream getInputStream() throws IOException {
                PushbackInputStream pbis;
                try {
                    pbis = new PushbackInputStream(b.getBinaryStream(), 9);
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
                int byteOrder = pbis.read();
                if (byteOrder == -1) {
                    return pbis;
                }
                byte[] typeInt = new byte[4];
                int bytesRead = pbis.read(typeInt);
                if (bytesRead == 4) {
                    int srid = geometry.getSrid();
                    byte[] sridInt = new byte[4];
                    ByteOrderValues.putInt((int)srid, (byte[])sridInt, (int)(byteOrder == 0 ? 1 : 2));
                    pbis.unread(sridInt);
                    int n = byteOrder == 0 ? 0 : 3;
                    typeInt[n] = (byte)(typeInt[n] | 0x20);
                }
                pbis.unread(typeInt, 0, bytesRead);
                pbis.unread(byteOrder);
                return pbis;
            }
        });
        return new BlobType((Blob)blobImpl);
    }

    public static double area(GeometryType geom) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        return g.getArea();
    }

    public static GeometryType boundary(GeometryType geom) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        return GeometryUtils.getGeometryType(g.getBoundary());
    }

    public static GeometryType buffer(GeometryType geom, double distance) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        return GeometryUtils.getGeometryType(g.buffer(distance));
    }

    public static GeometryType buffer(GeometryType geom, double distance, int quadrantSegments) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        return GeometryUtils.getGeometryType(g.buffer(distance, quadrantSegments));
    }

    public static GeometryType centroid(GeometryType geom) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        return GeometryUtils.getGeometryType((com.vividsolutions.jts.geom.Geometry)g.getCentroid());
    }

    public static GeometryType convexHull(GeometryType geom) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        return GeometryUtils.getGeometryType(g.convexHull());
    }

    public static Integer coordDim(GeometryType geom) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        Coordinate c = g.getCoordinate();
        if (c != null && !Double.isNaN(c.z)) {
            return 3;
        }
        return 2;
    }

    public static GeometryType difference(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g1 = GeometryUtils.getGeometry(geom1);
        com.vividsolutions.jts.geom.Geometry g2 = GeometryUtils.getGeometry(geom2);
        return GeometryUtils.getGeometryType(g1.difference(g2));
    }

    public static GeometryType intersection(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g1 = GeometryUtils.getGeometry(geom1);
        com.vividsolutions.jts.geom.Geometry g2 = GeometryUtils.getGeometry(geom2);
        return GeometryUtils.getGeometryType(g1.intersection(g2));
    }

    public static int dimension(GeometryType geom) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        return g.getDimension();
    }

    public static GeometryType startEndPoint(GeometryType geom, boolean start) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        if (g instanceof LineString) {
            LineString lineString = (LineString)g;
            Point p = null;
            p = start ? lineString.getStartPoint() : lineString.getEndPoint();
            if (p == null) {
                return null;
            }
            return GeometryUtils.getGeometryType((com.vividsolutions.jts.geom.Geometry)p);
        }
        return null;
    }

    public static GeometryType exteriorRing(GeometryType geom) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        if (!(g instanceof Polygon)) {
            return null;
        }
        return GeometryUtils.getGeometryType((com.vividsolutions.jts.geom.Geometry)((Polygon)g).getExteriorRing());
    }

    public static GeometryType geometryN(GeometryType geom, int index) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        int num = g.getNumGeometries();
        if (index < 0 || index >= num) {
            return null;
        }
        com.vividsolutions.jts.geom.Geometry n = g.getGeometryN(index);
        return GeometryUtils.getGeometryType(n);
    }

    public static String geometryType(GeometryType geom) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        return "ST_" + g.getGeometryType();
    }

    public static Boolean isClosed(GeometryType geom) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        if (!(g instanceof LineString)) {
            return false;
        }
        LineString lineString = (LineString)g;
        return lineString.isClosed();
    }

    public static Boolean isEmpty(GeometryType geom) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        return g.isEmpty();
    }

    public static Boolean isRing(GeometryType geom) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        if (!(g instanceof LineString)) {
            return false;
        }
        LineString lineString = (LineString)g;
        return lineString.isClosed() && lineString.isSimple();
    }

    public static Boolean isSimple(GeometryType geom) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        return g.isSimple();
    }

    public static Boolean isValid(GeometryType geom) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        return g.isValid();
    }

    public static Double length(GeometryType geom) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        if (g instanceof LineString || g instanceof MultiLineString) {
            return g.getLength();
        }
        return 0.0;
    }

    public static Integer numInteriorRings(GeometryType geom) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        if (!(g instanceof Polygon)) {
            return null;
        }
        return ((Polygon)g).getNumInteriorRing();
    }

    public static int numGeometries(GeometryType geom) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        return g.getNumGeometries();
    }

    public static int numPoints(GeometryType geom) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        return g.getNumPoints();
    }

    public static GeometryType interiorRingN(GeometryType geom, int i) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        if (!(g instanceof Polygon)) {
            return null;
        }
        Polygon g2 = (Polygon)g;
        if (i < 0 || i >= g2.getNumInteriorRing()) {
            return null;
        }
        return GeometryUtils.getGeometryType((com.vividsolutions.jts.geom.Geometry)g2.getInteriorRingN(i));
    }

    public static Boolean orderingEquals(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        return GeometryUtils.getGeometry(geom1).equalsExact(GeometryUtils.getGeometry(geom2));
    }

    public static GeometryType point(double x, double y) {
        return GeometryUtils.getGeometryType((com.vividsolutions.jts.geom.Geometry)GEOMETRY_FACTORY.createPoint(new Coordinate(x, y)));
    }

    public static GeometryType pointN(GeometryType geom, int i) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        if (!(g instanceof LineString)) {
            return null;
        }
        LineString g2 = (LineString)g;
        if (i < 0 || i >= g2.getNumPoints()) {
            return null;
        }
        return GeometryUtils.getGeometryType((com.vividsolutions.jts.geom.Geometry)g2.getPointN(i));
    }

    public static Double perimeter(GeometryType geom) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        if (g instanceof Polygon || g instanceof MultiPolygon) {
            return g.getLength();
        }
        return 0.0;
    }

    public static GeometryType pointOnSurface(GeometryType geom) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        Coordinate c = g.getCoordinate();
        if (c == null) {
            return null;
        }
        Point point = GEOMETRY_FACTORY.createPoint(c);
        point.setSRID(geom.getSrid());
        return GeometryUtils.getGeometryType((com.vividsolutions.jts.geom.Geometry)point);
    }

    public static GeometryType polygon(GeometryType geom, int srid) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        if (!(g instanceof LineString)) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID31207, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31207, new Object[0]));
        }
        LineString ls = (LineString)g;
        Polygon result = GEOMETRY_FACTORY.createPolygon(ls.getCoordinateSequence());
        result.setSRID(srid);
        return GeometryUtils.getGeometryType((com.vividsolutions.jts.geom.Geometry)result);
    }

    public static Boolean relate(GeometryType geom1, GeometryType geom2, String intersectionPattern) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g1 = GeometryUtils.getGeometry(geom1);
        com.vividsolutions.jts.geom.Geometry g2 = GeometryUtils.getGeometry(geom2);
        return g1.relate(g2, intersectionPattern);
    }

    public static String relate(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g1 = GeometryUtils.getGeometry(geom1);
        com.vividsolutions.jts.geom.Geometry g2 = GeometryUtils.getGeometry(geom2);
        IntersectionMatrix im = g1.relate(g2);
        return im.toString();
    }

    public static GeometryType symDifference(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g1 = GeometryUtils.getGeometry(geom1);
        com.vividsolutions.jts.geom.Geometry g2 = GeometryUtils.getGeometry(geom2);
        return GeometryUtils.getGeometryType(g1.symDifference(g2));
    }

    public static GeometryType union(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g1 = GeometryUtils.getGeometry(geom1);
        com.vividsolutions.jts.geom.Geometry g2 = GeometryUtils.getGeometry(geom2);
        return GeometryUtils.getGeometryType(g1.union(g2));
    }

    public static Double ordinate(GeometryType geom, Ordinate ordinate) throws FunctionExecutionException {
        com.vividsolutions.jts.geom.Geometry g = GeometryUtils.getGeometry(geom);
        if (!(g instanceof Point)) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID31208, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31208, new Object[0]));
        }
        Point p = (Point)g;
        Coordinate c = p.getCoordinate();
        if (c == null) {
            return null;
        }
        double value = c.getOrdinate(ordinate.ordinal());
        if (Double.isNaN(value)) {
            return null;
        }
        return value;
    }

    public static class Extent
    implements UserDefinedAggregate<GeometryType> {
        private Envelope e;

        public void reset() {
            this.e = null;
        }

        public void addInput(GeometryType geom) throws FunctionExecutionException {
            com.vividsolutions.jts.geom.Geometry g1 = GeometryUtils.getGeometry(geom);
            if (this.e == null) {
                this.e = new Envelope();
            }
            this.e.expandToInclude(g1.getEnvelopeInternal());
        }

        public GeometryType getResult(CommandContext commandContext) {
            if (this.e == null) {
                return null;
            }
            return GeometryUtils.getGeometryType((com.vividsolutions.jts.geom.Geometry)GEOMETRY_FACTORY.createPolygon(new Coordinate[]{new Coordinate(this.e.getMinX(), this.e.getMinY()), new Coordinate(this.e.getMinX(), this.e.getMaxY()), new Coordinate(this.e.getMaxX(), this.e.getMaxY()), new Coordinate(this.e.getMaxX(), this.e.getMinY()), new Coordinate(this.e.getMinX(), this.e.getMinY())}));
        }
    }

    private static class GmlSridHandler
    extends GMLHandler {
        private int srid = 0;

        public GmlSridHandler(GeometryFactory gf, ErrorHandler delegate) {
            super(gf, delegate);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String srsName = attributes.getValue("srsName");
            if (srsName != null) {
                String[] srsParts = srsName.split(":");
                try {
                    if (srsParts.length == 2) {
                        this.srid = Integer.parseInt(srsParts[1]);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            super.startElement(uri, localName, qName, attributes);
        }

        public int getSrid() {
            return this.srid;
        }
    }

    public static enum Ordinate {
        X,
        Y,
        Z;

    }
}

