/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.List;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.function.aggregate.AggregateFunction;
import org.teiid.query.processor.relational.SortUtility;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.util.CommandContext;

public class SortingFilter
extends AggregateFunction {
    private AggregateFunction proxy;
    private BufferManager mgr;
    private String groupName;
    private boolean removeDuplicates;
    private List<ElementSymbol> elements;
    private List<OrderByItem> sortItems;
    private TupleBuffer collectionBuffer;
    private SortUtility sortUtility;

    public SortingFilter(AggregateFunction proxy, BufferManager mgr, String groupName, boolean removeDuplicates) {
        this.proxy = proxy;
        this.mgr = mgr;
        this.groupName = groupName;
        this.removeDuplicates = removeDuplicates;
    }

    public List<ElementSymbol> getElements() {
        return this.elements;
    }

    public void setElements(List<ElementSymbol> elements) {
        this.elements = elements;
    }

    public void setSortItems(List<OrderByItem> sortItems) {
        this.sortItems = sortItems;
    }

    @Override
    public void initialize(Class<?> dataType, Class<?>[] inputTypes) {
        this.proxy.initialize(dataType, inputTypes);
    }

    @Override
    public void reset() {
        this.proxy.reset();
        this.close();
    }

    private void close() {
        if (this.collectionBuffer != null) {
            this.collectionBuffer.remove();
            this.collectionBuffer = null;
        }
        if (this.sortUtility != null) {
            this.sortUtility.remove();
            this.sortUtility = null;
        }
    }

    @Override
    public void addInputDirect(List<?> tuple, CommandContext commandContext) throws TeiidComponentException, TeiidProcessingException {
        if (this.collectionBuffer == null) {
            this.collectionBuffer = this.mgr.createTupleBuffer(this.elements, this.groupName, BufferManager.TupleSourceType.PROCESSOR);
        }
        ArrayList row = new ArrayList(this.argIndexes.length);
        for (int i = 0; i < this.argIndexes.length; ++i) {
            row.add(tuple.get(this.argIndexes[i]));
        }
        if (!this.proxy.filter(row)) {
            this.collectionBuffer.addTuple(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getResult(CommandContext commandContext) throws TeiidComponentException, TeiidProcessingException {
        if (this.collectionBuffer != null) {
            this.collectionBuffer.close();
            if (this.sortUtility == null) {
                this.sortUtility = new SortUtility(null, this.sortItems, this.removeDuplicates ? SortUtility.Mode.DUP_REMOVE_SORT : SortUtility.Mode.SORT, this.mgr, this.groupName, this.collectionBuffer.getSchema());
                this.collectionBuffer.setForwardOnly(true);
                this.sortUtility.setWorkingBuffer(this.collectionBuffer);
            }
            TupleBuffer sorted = this.sortUtility.sort();
            sorted.setForwardOnly(true);
            try {
                List<?> tuple;
                TupleBuffer.TupleBufferTupleSource sortedSource = sorted.createIndexedTupleSource();
                while ((tuple = sortedSource.nextTuple()) != null) {
                    this.proxy.addInputDirect(tuple, commandContext);
                }
            }
            finally {
                sorted.remove();
            }
            this.close();
        }
        return this.proxy.getResult(commandContext);
    }

    @Override
    public boolean respectsNull() {
        return true;
    }
}

