/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.After;
import org.junit.Assert;
import org.teiid.jdbc.MetadataReader;
import org.teiid.jdbc.StringArrayReader;
import org.teiid.script.io.ResultSetReader;

public abstract class AbstractQueryTest {
    static boolean WRITE_ACTUAL = false;
    protected Connection internalConnection = null;
    protected ResultSet internalResultSet = null;
    protected Statement internalStatement = null;
    private SQLException internalException = null;
    protected int updateCount = -1;
    protected String DELIMITER = "    ";

    public AbstractQueryTest() {
    }

    public AbstractQueryTest(Connection conn) {
        this.internalConnection = conn;
    }

    @After
    public void tearDown() throws Exception {
        this.closeConnection();
    }

    public void setConnection(Connection c) {
        this.internalConnection = c;
    }

    public Connection getConnection() {
        return this.internalConnection;
    }

    public boolean execute(String sql) throws SQLException {
        return this.execute(sql, new Object[0]);
    }

    public boolean execute(String sql, Object ... params) throws SQLException {
        this.closeResultSet();
        this.closeStatement();
        this.updateCount = -1;
        try {
            Assert.assertNotNull((Object)this.internalConnection);
            Assert.assertTrue((!this.internalConnection.isClosed() ? 1 : 0) != 0);
            boolean result = false;
            if (params != null && params.length > 0) {
                if (sql.startsWith("exec ")) {
                    sql = sql.substring(5);
                    this.internalStatement = this.createPrepareCallStatement(sql);
                } else {
                    this.internalStatement = this.createPrepareStatement(sql);
                }
                this.setParameters((PreparedStatement)this.internalStatement, params);
                this.assignExecutionProperties(this.internalStatement);
                result = ((PreparedStatement)this.internalStatement).execute();
            } else {
                this.internalStatement = this.createStatement();
                this.assignExecutionProperties(this.internalStatement);
                result = this.internalStatement.execute(sql);
            }
            if (result) {
                this.internalResultSet = this.internalStatement.getResultSet();
            } else {
                this.updateCount = this.internalStatement.getUpdateCount();
            }
            return result;
        }
        catch (SQLException e) {
            this.internalException = e;
            if (!this.exceptionExpected()) {
                throw e;
            }
            return false;
        }
    }

    protected Statement createPrepareCallStatement(String sql) throws SQLException {
        return this.internalConnection.prepareCall("{?=call " + sql + "}");
    }

    protected Statement createPrepareStatement(String sql) throws SQLException {
        return this.internalConnection.prepareStatement(sql);
    }

    protected Statement createStatement() throws SQLException {
        return this.internalConnection.createStatement();
    }

    private void setParameters(PreparedStatement stmt, Object[] params) throws SQLException {
        for (int i = 0; i < params.length; ++i) {
            stmt.setObject(i + 1, params[i]);
        }
    }

    public int[] executeBatch(String[] sql) {
        return this.executeBatch(sql, -1);
    }

    public int[] executeBatch(String[] sql, int timeout) {
        this.closeResultSet();
        this.closeStatement();
        try {
            int i;
            Assert.assertNotNull((Object)this.internalConnection);
            Assert.assertTrue((!this.internalConnection.isClosed() ? 1 : 0) != 0);
            for (i = 0; i < sql.length; ++i) {
                if (sql[i].indexOf("?") == -1) continue;
                throw new RuntimeException("no prepared statements allowed in the batch command");
            }
            this.internalStatement = this.createStatement();
            this.assignExecutionProperties(this.internalStatement);
            if (timeout != -1) {
                this.internalStatement.setQueryTimeout(timeout);
            }
            for (i = 0; i < sql.length; ++i) {
                this.internalStatement.addBatch(sql[i]);
            }
            return this.internalStatement.executeBatch();
        }
        catch (SQLException e) {
            this.internalException = e;
            if (!this.exceptionExpected()) {
                throw new RuntimeException(e);
            }
            return null;
        }
    }

    protected void assignExecutionProperties(Statement stmt) {
    }

    public boolean exceptionOccurred() {
        return this.internalException != null;
    }

    public boolean exceptionExpected() {
        return false;
    }

    public SQLException getLastException() {
        return this.internalException;
    }

    public void assertResultsSetEquals(File expected) {
        this.assertResultsSetEquals(this.internalResultSet, expected);
    }

    public void assertResultsSetEquals(ResultSet resultSet, File expected) {
        Assert.assertNotNull((Object)resultSet);
        try {
            this.writeResultSet(expected, new BufferedReader((Reader)new ResultSetReader(resultSet, this.DELIMITER)));
            if (resultSet.getType() != 1003) {
                resultSet.beforeFirst();
            }
            this.assertReaderEquals((Reader)new ResultSetReader(resultSet, this.DELIMITER), new FileReader(expected));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeResultSet(File expected, BufferedReader resultReader) throws IOException {
        if (WRITE_ACTUAL) {
            BufferedWriter bw = new BufferedWriter(new FileWriter(expected));
            String s = null;
            while ((s = resultReader.readLine()) != null) {
                bw.write(s);
                bw.write("\n");
            }
            bw.close();
        }
    }

    public void assertResultsSetEquals(String expected) {
        this.assertResultsSetEquals(this.internalResultSet, expected);
    }

    public void assertResultsSetEquals(ResultSet resultSet, String expected) {
        Assert.assertNotNull((Object)resultSet);
        this.assertReaderEquals((Reader)new ResultSetReader(resultSet, this.DELIMITER), new StringReader(expected));
    }

    public void assertResults(String[] expected) {
        this.assertResultsSetEquals(expected);
    }

    public void assertResultsSetEquals(String[] expected) {
        this.assertResultsSetEquals(this.internalResultSet, expected);
    }

    public void assertResultsSetEquals(ResultSet resultSet, String[] expected) {
        Assert.assertNotNull((Object)resultSet);
        this.assertReaderEquals((Reader)new ResultSetReader(resultSet, this.DELIMITER), (Reader)((Object)new StringArrayReader(expected)));
    }

    public void assertReaderEquals(Reader expected, Reader reader) {
        BufferedReader resultReader = new BufferedReader(expected);
        BufferedReader expectedReader = new BufferedReader(reader);
        try {
            this.compareResults(resultReader, expectedReader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                resultReader.close();
                expectedReader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void assertResultsSetMetadataEquals(ResultSetMetaData metadata, File expected) {
        Assert.assertNotNull((Object)metadata);
        try {
            this.writeResultSet(expected, new BufferedReader((Reader)((Object)new MetadataReader(metadata, this.DELIMITER))));
            this.assertReaderEquals((Reader)((Object)new MetadataReader(metadata, this.DELIMITER)), new FileReader(expected));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void assertResultsSetMetadataEquals(ResultSetMetaData metadata, String[] expected) {
        Assert.assertNotNull((Object)metadata);
        this.assertReaderEquals((Reader)((Object)new MetadataReader(metadata, this.DELIMITER)), (Reader)((Object)new StringArrayReader(expected)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String read(BufferedReader r, boolean casesensitive) throws IOException {
        StringBuffer result = new StringBuffer();
        String s = null;
        try {
            while ((s = r.readLine()) != null) {
                result.append(casesensitive ? s.trim() : s.trim().toLowerCase());
                result.append("\n");
            }
        }
        finally {
            r.close();
        }
        return result.toString();
    }

    protected void compareResults(BufferedReader resultReader, BufferedReader expectedReader) throws IOException {
        Assert.assertEquals((Object)AbstractQueryTest.read(expectedReader, this.compareCaseSensitive()), (Object)AbstractQueryTest.read(resultReader, this.compareCaseSensitive()));
    }

    protected boolean compareCaseSensitive() {
        return true;
    }

    public void printResults() {
        this.printResults(this.internalResultSet);
    }

    public void printResults(ResultSet results) {
        this.printResults(results, false);
    }

    public void printResults(boolean comparePrint) {
        Assert.assertNotNull((Object)this.internalResultSet);
        this.printResults(this.internalResultSet, comparePrint);
    }

    public void walkResults() {
        Assert.assertNotNull((Object)this.internalResultSet);
        try {
            int columnCount = this.internalResultSet.getMetaData().getColumnCount();
            while (this.internalResultSet.next()) {
                for (int col = 1; col <= columnCount; ++col) {
                    this.internalResultSet.getObject(col);
                }
            }
            this.closeResultSet();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    void printResults(ResultSet results, boolean comparePrint) {
        if (results == null) {
            System.out.println("ResultSet is null");
            return;
        }
        try {
            int row = -1;
            BufferedReader in = new BufferedReader((Reader)new ResultSetReader(results, this.DELIMITER));
            String line = in.readLine();
            while (line != null) {
                ++row;
                if (comparePrint) {
                    line = line.replaceAll("\"", "\\\\\"");
                    System.out.println("\"" + line + "\",");
                } else {
                    System.out.println(line);
                }
                line = in.readLine();
            }
            System.out.println("Fetched " + row + " rows\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void assertUpdateCount(int expected) {
        Assert.assertEquals((long)expected, (long)this.updateCount);
    }

    public void assertRowCount(int expected) {
        int count = this.getRowCount();
        Assert.assertEquals((long)expected, (long)count);
    }

    public int getRowCount() {
        Assert.assertNotNull((Object)this.internalResultSet);
        try {
            int count = 0;
            while (this.internalResultSet.next()) {
                ++count;
            }
            return count;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void closeStatement() {
        this.closeResultSet();
        if (this.internalStatement != null) {
            try {
                this.internalStatement.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.internalStatement = null;
            }
        }
    }

    public void closeResultSet() {
        this.internalException = null;
        if (this.internalResultSet != null) {
            try {
                this.internalResultSet.close();
            }
            catch (SQLException sQLException) {
            }
            finally {
                this.internalResultSet = null;
            }
        }
    }

    public void closeConnection() {
        block5: {
            this.closeStatement();
            try {
                if (this.internalConnection == null) break block5;
                try {
                    this.internalConnection.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                this.internalConnection = null;
            }
        }
    }

    public void cancelQuery() throws SQLException {
        Assert.assertNotNull((Object)this.internalConnection);
        Assert.assertTrue((!this.internalConnection.isClosed() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)this.internalStatement);
        this.internalStatement.cancel();
    }

    public void print(String msg) {
        System.out.println(msg);
    }

    public void print(Throwable e) {
        e.printStackTrace();
    }

    protected void executeAndAssertResults(String query, String[] expected) throws SQLException {
        this.execute(query);
        if (expected != null) {
            this.assertResults(expected);
        } else {
            this.printResults(true);
        }
    }
}

