/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.DefaultCacheFactory;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.TupleBufferCache;
import org.teiid.core.TeiidProcessingException;
import org.teiid.dqp.internal.process.QueryProcessorFactoryImpl;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.tempdata.GlobalTableStore;
import org.teiid.query.tempdata.GlobalTableStoreImpl;
import org.teiid.query.tempdata.TempTableDataManager;
import org.teiid.query.tempdata.TempTableStore;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestMaterialization {
    private TempMetadataAdapter metadata;
    private TempTableDataManager dataManager;
    private TempTableStore tempStore;
    private GlobalTableStoreImpl globalStore;
    private ProcessorPlan previousPlan;
    private HardcodedDataManager hdm;

    @Before
    public void setUp() {
        this.tempStore = new TempTableStore("1", TempTableStore.TransactionMode.ISOLATE_WRITES);
        BufferManager bm = BufferManagerFactory.getStandaloneBufferManager();
        TransformationMetadata actualMetadata = RealMetadataFactory.exampleMaterializedView();
        this.globalStore = new GlobalTableStoreImpl(bm, actualMetadata.getVdbMetaData(), (QueryMetadataInterface)actualMetadata);
        this.metadata = new TempMetadataAdapter((QueryMetadataInterface)actualMetadata, this.tempStore.getMetadataStore());
        this.hdm = new HardcodedDataManager();
        this.hdm.addData("SELECT MatSrc.MatSrc.x FROM MatSrc.MatSrc", Arrays.asList(new String[]{null}), Arrays.asList("one"), Arrays.asList("two"), Arrays.asList("three"));
        this.hdm.addData("SELECT MatTable.info.e1, MatTable.info.e2 FROM MatTable.info", Arrays.asList("a", 1), Arrays.asList("a", 2));
        this.hdm.addData("SELECT MatTable.info.e2, MatTable.info.e1 FROM MatTable.info", Arrays.asList(1, "a"), Arrays.asList(2, "a"));
        SessionAwareCache cache = new SessionAwareCache("resultset", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.RESULTSET, 0);
        cache.setTupleBufferCache((TupleBufferCache)bm);
        this.dataManager = new TempTableDataManager((ProcessorDataManager)this.hdm, bm, cache);
    }

    private void execute(String sql, List<?> ... expectedResults) throws Exception {
        CommandContext cc = TestProcessor.createCommandContext();
        cc.setTempTableStore(this.tempStore);
        cc.setGlobalTableStore((GlobalTableStore)this.globalStore);
        cc.setMetadata((QueryMetadataInterface)this.metadata);
        DefaultCapabilitiesFinder finder = new DefaultCapabilitiesFinder();
        this.previousPlan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)this.metadata, finder, cc);
        cc.setQueryProcessorFactory((QueryProcessor.ProcessorFactory)new QueryProcessorFactoryImpl(BufferManagerFactory.getStandaloneBufferManager(), (ProcessorDataManager)this.dataManager, (CapabilitiesFinder)finder, null, (QueryMetadataInterface)this.metadata));
        TestProcessor.doProcess(this.previousPlan, (ProcessorDataManager)this.dataManager, expectedResults, cc);
    }

    @Test
    public void testPopulate() throws Exception {
        this.execute("SELECT * from vgroup3 where x = 'one'", Arrays.asList("one", "zne"));
        Assert.assertEquals((long)1L, (long)this.hdm.getCommandHistory().size());
        this.execute("SELECT * from vgroup3 where x is null", Arrays.asList(null, null));
        Assert.assertEquals((long)1L, (long)this.hdm.getCommandHistory().size());
    }

    @Test
    public void testReadWrite() throws Exception {
        this.execute("SELECT * from vgroup3 where x = 'one'", Arrays.asList("one", "zne"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String matTableName = "#MAT_MATVIEW.VGROUP3";
        this.globalStore.getState(matTableName, (OutputStream)baos);
        GlobalTableStoreImpl.MatTableInfo matTableInfo = this.globalStore.getMatTableInfo(matTableName);
        long time = matTableInfo.getUpdateTime();
        this.globalStore.failedLoad(matTableName);
        this.globalStore.setState(matTableName, (InputStream)new ByteArrayInputStream(baos.toByteArray()));
        Assert.assertEquals((long)time, (long)matTableInfo.getUpdateTime());
        this.execute("SELECT * from vgroup3 where x = 'one'", Arrays.asList("one", "zne"));
        this.execute("select lookup('mattable.info', 'e1', 'e2', 5)", Arrays.asList(new String[]{null}));
        baos = new ByteArrayOutputStream();
        String codeTableName = "#CODE_MATTABLE.INFO.E2.E1";
        this.globalStore.getState(codeTableName, (OutputStream)baos);
        this.globalStore.setState(codeTableName, (InputStream)new ByteArrayInputStream(baos.toByteArray()));
    }

    @Test(expected=TeiidProcessingException.class)
    public void testCodeTableResponseException() throws Exception {
        this.execute("select lookup('mattable.info', 'e2', 'e1', 'a')", new List[0]);
    }

    @Test
    public void testCodeTable() throws Exception {
        this.execute("select lookup('mattable.info', 'e1', 'e2', 5)", Arrays.asList(new String[]{null}));
        Assert.assertEquals((long)1L, (long)this.hdm.getCommandHistory().size());
        this.execute("select lookup('mattable.info', 'e1', 'e2', 1)", Arrays.asList("a"));
        Assert.assertEquals((long)1L, (long)this.hdm.getCommandHistory().size());
    }

    @Test
    public void testTtl() throws Exception {
        this.execute("SELECT * from vgroup4 where x = 'one'", Arrays.asList("one"));
        Assert.assertEquals((long)1L, (long)this.hdm.getCommandHistory().size());
        this.execute("SELECT * from vgroup4 where x is null", Arrays.asList(new String[]{null}));
        Assert.assertEquals((long)1L, (long)this.hdm.getCommandHistory().size());
        Thread.sleep(150L);
        this.execute("SELECT * from vgroup4 where x is null", Arrays.asList(new String[]{null}));
        Assert.assertEquals((long)2L, (long)this.hdm.getCommandHistory().size());
    }

    @Test
    public void testProcedureCache() throws Exception {
        this.execute("call sp1('one')", Arrays.asList("one"));
        Assert.assertEquals((long)1L, (long)this.hdm.getCommandHistory().size());
        this.execute("call sp1('one')", Arrays.asList("one"));
        Assert.assertEquals((long)1L, (long)this.hdm.getCommandHistory().size());
        this.execute("call sp1('one') option nocache sp.sp1", Arrays.asList("one"));
        Assert.assertEquals((long)2L, (long)this.hdm.getCommandHistory().size());
        this.execute("call sp1(null)", new List[0]);
        Assert.assertEquals((long)3L, (long)this.hdm.getCommandHistory().size());
        this.execute("call sp1(null)", new List[0]);
        Assert.assertEquals((long)3L, (long)this.hdm.getCommandHistory().size());
    }

    @Test
    public void testCoveringSecondaryIndex() throws Exception {
        this.execute("SELECT * from vgroup3 where y in ('zne', 'zwo') order by y desc", Arrays.asList("two", "zwo"), Arrays.asList("one", "zne"));
        this.execute("SELECT * from vgroup3 where y is null", Arrays.asList(null, null));
    }

    @Test
    public void testNonCoveringSecondaryIndex() throws Exception {
        this.execute("SELECT * from vgroup5 where y in ('zwo', 'zne') order by y desc", Arrays.asList("two", "zwo", 1), Arrays.asList("one", "zne", 1));
        this.execute("SELECT * from vgroup5 where y is null", Arrays.asList(null, null, 1), Arrays.asList(" b", null, 1), Arrays.asList(" c", null, 1), Arrays.asList(" d", null, 1));
        this.execute("SELECT * from vgroup5 where y is null and z = 2", new List[0]);
    }

    @Test
    public void testNonCoveringSecondaryIndexWithoutPrimaryKey() throws Exception {
        this.execute("SELECT * from vgroup6 where y in ('zne', 'zwo') order by y desc", Arrays.asList("two", "zwo"), Arrays.asList("one", "zne"));
        this.execute("SELECT * from vgroup6 where y is null", Arrays.asList(null, null));
    }

    @Test
    public void testPrimaryKeyOnOtherColumn() throws Exception {
        this.execute("SELECT * from vgroup7 where y is null", Arrays.asList("1", null, 1));
    }

    @Test
    public void testFunctionBasedIndexQuery() throws Exception {
        TempMetadataID id = this.globalStore.getGlobalTempTableMetadataId(this.metadata.getGroupID("MatView.vgroup2a"));
        Assert.assertEquals((Object)"SELECT MatView.VGroup2a.*, ucase(x) FROM MatView.VGroup2a option nocache MatView.VGroup2a", (Object)id.getQueryNode().getQuery());
    }
}

