/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.client.ctc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.XMLOutputter;
import org.junit.Assert;
import org.teiid.core.util.FileUtils;
import org.teiid.core.util.StringUtil;
import org.teiid.internal.core.xml.JdomHelper;
import org.teiid.test.client.ResultsGenerator;
import org.teiid.test.client.ctc.XMLQueryVisitationStrategy;
import org.teiid.test.framework.exception.QueryTestFailedException;
import org.teiid.test.util.TestResultSetUtil;

public class XMLGenerateResults
implements ResultsGenerator {
    private static final SimpleDateFormat FILE_NAME_DATE_FORMATER = new SimpleDateFormat("yyyyMMdd_HHmmss");
    private static final int MAX_COL_WIDTH = 65;
    private String outputDir = "";
    private String generateDir = "";

    public XMLGenerateResults(String testname, Properties props) {
        this.outputDir = props.getProperty("outputdir", ".");
        Assert.assertNotNull((String)"Property outputdir was not specified", (Object)this.outputDir);
        this.outputDir = this.outputDir + "/" + testname;
        File d = new File(this.outputDir);
        this.outputDir = d.getAbsolutePath();
        d = new File(this.outputDir);
        if (d.exists()) {
            FileUtils.removeDirectoryAndChildren((File)d);
        }
        if (!d.exists()) {
            d.mkdirs();
        }
        this.generateDir = props.getProperty("generatedir", ".");
        Assert.assertNotNull((String)"Property generatedir was not specified", (Object)this.generateDir);
        d = new File(this.generateDir, testname);
        this.generateDir = d.getAbsolutePath();
        d = new File(this.generateDir);
        if (d.exists()) {
            FileUtils.removeDirectoryAndChildren((File)d);
        }
        if (!d.exists()) {
            d.mkdirs();
        }
    }

    @Override
    public String getGenerateDir() {
        return this.generateDir;
    }

    @Override
    public String getOutputDir() {
        return this.outputDir;
    }

    @Override
    public void generateQueryResultFile(String querySetID, String queryID, String query, ResultSet result, Throwable ex, int testStatus) throws QueryTestFailedException {
        BufferedOutputStream outputStream;
        try {
            if (result != null) {
                result.isClosed();
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        File resultsFile = this.createNewResultsFile(queryID, querySetID, this.getGenerateDir());
        try {
            FileOutputStream fos = new FileOutputStream(resultsFile);
            outputStream = new BufferedOutputStream(fos);
        }
        catch (IOException e) {
            throw new QueryTestFailedException("Failed to open new results file: " + resultsFile.getPath() + ": " + e.getMessage());
        }
        try {
            XMLQueryVisitationStrategy jstrat = new XMLQueryVisitationStrategy();
            Element rootElement = new Element("root");
            Element queryElement = new Element("query");
            queryElement.addContent((Content)new CDATA(query));
            rootElement.addContent((Content)queryElement);
            Attribute resultsIDAttribute = new Attribute("name", queryID);
            if (result != null) {
                Element resultsElement = jstrat.produceResults(result);
                resultsElement.setAttribute(resultsIDAttribute);
                rootElement.addContent((Content)resultsElement);
            } else {
                Element exceptionElement = new Element("queryResults");
                if (ex != null) {
                    exceptionElement.addContent((Content)jstrat.produceMsg((Object)ex, null));
                }
                exceptionElement.setAttribute(resultsIDAttribute);
                rootElement.addContent((Content)exceptionElement);
            }
            XMLOutputter outputter = new XMLOutputter(JdomHelper.getFormat("  ", true));
            outputter.output(new Document(rootElement), (OutputStream)outputStream);
        }
        catch (SQLException e) {
            throw new QueryTestFailedException("Failed to convert results to JDOM: " + e.getMessage());
        }
        catch (JDOMException e) {
            throw new QueryTestFailedException("Failed to convert results to JDOM: " + e.getMessage());
        }
        catch (IOException e) {
            throw new QueryTestFailedException("Failed to output new results to " + resultsFile.getPath() + ": " + e.getMessage());
        }
        catch (Throwable e) {
            throw new QueryTestFailedException("Failed to convert results to JDOM: " + StringUtil.getStackTrace((Throwable)e));
        }
        finally {
            try {
                ((OutputStream)outputStream).close();
            }
            catch (IOException iOException) {}
        }
    }

    public String generateErrorFile_keep(String querySetID, String queryID, String sql, ResultSet resultSet, Throwable queryError, Object results) throws QueryTestFailedException {
        String errorFileName = null;
        try {
            errorFileName = this.generateErrorFileName(queryID, querySetID);
            File errorFile = new File(this.getOutputDir(), errorFileName);
            if (resultSet == null) {
                FileOutputStream actualOut = null;
                try {
                    actualOut = new FileOutputStream(errorFile);
                    PrintStream filePrintStream = new PrintStream(actualOut);
                    TestResultSetUtil.printThrowable(queryError, sql, filePrintStream);
                    filePrintStream.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new QueryTestFailedException(e);
                }
                finally {
                    if (actualOut != null) {
                        try {
                            actualOut.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                return errorFileName;
            }
            resultSet.beforeFirst();
            this.generateErrorResults(querySetID, queryID, sql, errorFile, resultSet, (File)results);
        }
        catch (Throwable e) {
            throw new QueryTestFailedException(e.getMessage());
        }
        return errorFileName;
    }

    private void generateErrorResults(String querySetID, String queryID, String sql, File resultsFile, ResultSet actualResult, File results) throws QueryTestFailedException {
        FileOutputStream actualOut = null;
        try {
            actualOut = new FileOutputStream(resultsFile);
            PrintStream filePrintStream = new PrintStream(actualOut);
            TestResultSetUtil.printResultSet(actualResult, sql, 65, true, filePrintStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new QueryTestFailedException(e);
        }
        finally {
            if (actualOut != null) {
                try {
                    actualOut.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public String generateErrorFile(String querySetID, String queryID, String sql, ResultSet resultSet, Throwable queryError, Object expectedResultsFile) throws QueryTestFailedException {
        String errorFileName = null;
        try {
            errorFileName = this.generateErrorFileName(queryID, querySetID);
            File errorFile = new File(this.getOutputDir(), errorFileName);
            if (resultSet != null) {
                resultSet.beforeFirst();
            }
            this.generateErrorResults(querySetID, queryID, sql, errorFile, resultSet, (File)expectedResultsFile, queryError);
        }
        catch (Throwable e) {
            throw new QueryTestFailedException(e.getMessage());
        }
        return errorFileName;
    }

    private File createNewResultsFile(String queryID, String querySetID, String genDir) {
        String resultFileName = queryID + ".xml";
        String targetDirname = genDir + File.separator + querySetID;
        File targetDir = new File(targetDirname);
        targetDir.mkdirs();
        return new File(targetDir, resultFileName);
    }

    private String generateErrorFileName(String queryID, String querySetID) {
        return queryID + ".err";
    }

    private void generateErrorResults(String querySetID, String queryID, String sql, File resultsFile, ResultSet actualResult, File expectedResultFile, Throwable ex) throws QueryTestFailedException {
        BufferedOutputStream outputStream;
        try {
            FileOutputStream fos = new FileOutputStream(resultsFile);
            outputStream = new BufferedOutputStream(fos);
        }
        catch (IOException e) {
            throw new QueryTestFailedException("Failed to open error results file: " + resultsFile.getPath() + ": " + e.getMessage());
        }
        try {
            XMLQueryVisitationStrategy jstrat = new XMLQueryVisitationStrategy();
            Element rootElement = new Element("root");
            Element resultElement = new Element("queryResults");
            resultElement.setAttribute(new Attribute("name", queryID));
            resultElement.setAttribute(new Attribute("value", sql));
            if (ex != null) {
                Element actualExceptionElement = new Element("actual_exception");
                actualExceptionElement = XMLQueryVisitationStrategy.jdomException(ex, actualExceptionElement);
                resultElement.addContent((Content)actualExceptionElement);
            }
            if (actualResult != null) {
                Element actualResultsElement = new Element("actual_queryResults");
                actualResultsElement = jstrat.produceMsg(actualResult, actualResultsElement);
                resultElement.addContent((Content)actualResultsElement);
                Element expectedResult = new Element("bogus");
                expectedResult = jstrat.parseXMLResultsFile(expectedResultFile, expectedResult);
                if (expectedResult.getChild("select") != null) {
                    expectedResult.setName("expected_queryResults");
                } else {
                    expectedResult.setName("expected_exception");
                }
                resultElement.addContent((Content)expectedResult);
            } else {
                Element expectedResult = new Element("bogus");
                if ((expectedResult = jstrat.parseXMLResultsFile(expectedResultFile, expectedResult)).getChild("select") != null) {
                    expectedResult.setName("expected_queryResults");
                } else {
                    expectedResult.setName("expected_exception");
                }
                resultElement.addContent((Content)expectedResult);
            }
            rootElement.addContent((Content)resultElement);
            XMLOutputter outputter = new XMLOutputter(JdomHelper.getFormat("  ", true));
            outputter.output(new Document(rootElement), (OutputStream)outputStream);
        }
        catch (SQLException e) {
            throw new QueryTestFailedException("Failed to convert error results to JDOM: " + e.getMessage());
        }
        catch (JDOMException e) {
            throw new QueryTestFailedException("Failed to convert error results to JDOM: " + e.getMessage());
        }
        catch (IOException e) {
            throw new QueryTestFailedException("Failed to output error results to " + resultsFile.getPath() + ": " + e.getMessage());
        }
        catch (Throwable e) {
            throw new QueryTestFailedException("Failed to convert error results to JDOM: " + StringUtil.getStackTrace((Throwable)e));
        }
        finally {
            try {
                ((OutputStream)outputStream).close();
            }
            catch (IOException iOException) {}
        }
    }
}

