/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.cache.CacheConfiguration;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.DefaultCacheFactory;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.PreparedPlan;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.relational.ProjectNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.util.CommandContext;

public class TestPreparedPlanCache {
    private static final String EXAMPLE_QUERY = "SELECT * FROM table";
    private static final DQPWorkContext token = new DQPWorkContext();
    private static final DQPWorkContext token2 = new DQPWorkContext();
    private static final ParseInfo pi = new ParseInfo();

    @BeforeClass
    public static void setUpOnce() {
        token.getSession().setVDBName("foo");
        token.getSession().setVDBVersion((Object)1);
        token2.getSession().setVDBName("foo");
        token2.getSession().setVDBVersion((Object)2);
    }

    @Test
    public void testPutPreparedPlan() {
        SessionAwareCache cache = new SessionAwareCache("preparedplan", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.PREPAREDPLAN, 0);
        SessionAwareCache.CacheID id = new SessionAwareCache.CacheID(token, pi, "SELECT * FROM table1");
        Assert.assertNull((Object)cache.get(id));
        cache.put(id, FunctionMethod.Determinism.SESSION_DETERMINISTIC, (Object)new PreparedPlan(), null);
        Assert.assertNotNull((String)"Unable to get prepared plan from cache", (Object)cache.get(id));
    }

    @Test
    public void testGet() {
        SessionAwareCache cache = new SessionAwareCache("preparedplan", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.PREPAREDPLAN, 0);
        this.helpPutPreparedPlans((SessionAwareCache<PreparedPlan>)cache, token, 0, 10);
        this.helpPutPreparedPlans((SessionAwareCache<PreparedPlan>)cache, token2, 0, 15);
        PreparedPlan pPlan = (PreparedPlan)cache.get(new SessionAwareCache.CacheID(token2, pi, "SELECT * FROM table12"));
        Assert.assertNotNull((String)"Unable to get prepared plan from cache", (Object)pPlan);
        Assert.assertEquals((String)"Error getting plan from cache", (Object)new RelationalPlan((RelationalNode)new ProjectNode(12)).toString(), (Object)pPlan.getPlan().toString());
        Assert.assertEquals((String)"Error getting command from cache", (Object)"SELECT * FROM table12", (Object)pPlan.getCommand().toString());
        Assert.assertNotNull((String)"Error getting plan description from cache", (Object)pPlan.getAnalysisRecord());
        Assert.assertEquals((String)"Error gettting reference from cache", (Object)new Reference(1), pPlan.getReferences().get(0));
    }

    @Test
    public void testClearAll() {
        SessionAwareCache cache = new SessionAwareCache("preparedplan", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.PREPAREDPLAN, 0);
        this.helpPutPreparedPlans((SessionAwareCache<PreparedPlan>)cache, token, 1, 1);
        this.helpPutPreparedPlans((SessionAwareCache<PreparedPlan>)cache, token2, 1, 1);
        Assert.assertNotNull((String)"Unable to get prepared plan from cache for token", (Object)cache.get(new SessionAwareCache.CacheID(token, pi, "SELECT * FROM table1")));
        cache.clearAll();
        Assert.assertNull((String)"Failed remove from cache", (Object)cache.get(new SessionAwareCache.CacheID(token, pi, "SELECT * FROM table1")));
        Assert.assertNull((String)"Unable to get prepared plan from cache for token2", (Object)cache.get(new SessionAwareCache.CacheID(token2, pi, "SELECT * FROM table1")));
    }

    @Test
    public void testNegativeSizeCacheUsesDefault() {
        CacheConfiguration config = new CacheConfiguration();
        config.setMaxEntries(-1);
        new SessionAwareCache("preparedplan", (CacheFactory)new DefaultCacheFactory(config), SessionAwareCache.Type.PREPAREDPLAN, 0);
    }

    private void helpPutPreparedPlans(SessionAwareCache<PreparedPlan> cache, DQPWorkContext session, int start, int count) {
        for (int i = 0; i < count; ++i) {
            Command dummy;
            try {
                dummy = QueryParser.getQueryParser().parseCommand(EXAMPLE_QUERY + (start + i));
            }
            catch (QueryParserException e) {
                throw new RuntimeException(e);
            }
            SessionAwareCache.CacheID id = new SessionAwareCache.CacheID(session, pi, dummy.toString());
            PreparedPlan pPlan = new PreparedPlan();
            cache.put(id, FunctionMethod.Determinism.SESSION_DETERMINISTIC, (Object)pPlan, null);
            pPlan.setCommand(dummy);
            pPlan.setPlan((ProcessorPlan)new RelationalPlan((RelationalNode)new ProjectNode(i)), new CommandContext());
            AnalysisRecord analysisRecord = new AnalysisRecord(true, false);
            pPlan.setAnalysisRecord(analysisRecord);
            ArrayList<Reference> refs = new ArrayList<Reference>();
            refs.add(new Reference(1));
            pPlan.setReferences(refs);
        }
    }
}

