/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.mapping.xml;

import junit.framework.TestCase;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingSourceNode;

public class TestMappingDocument
extends TestCase {
    public void testDoc1() {
        MappingDocument doc = new MappingDocument(true);
        TestMappingDocument.assertNull((Object)doc.getRootNode());
        TestMappingDocument.assertTrue((boolean)doc.isFormatted());
        TestMappingDocument.assertEquals((String)"UTF-8", (String)doc.getDocumentEncoding());
    }

    public void testDoc2() {
        MappingDocument doc = new MappingDocument("UTF-16", false);
        MappingElement root = new MappingElement("test");
        doc.addChildElement(root);
        TestMappingDocument.assertNotNull((Object)doc.getRootNode());
        TestMappingDocument.assertFalse((boolean)doc.isFormatted());
        TestMappingDocument.assertEquals((String)"UTF-16", (String)doc.getDocumentEncoding());
    }

    public void testDoc3() {
        MappingDocument doc = new MappingDocument("UTF-16", false);
        MappingElement root = new MappingElement("test");
        root.setMinOccurrs(2);
        root.setMaxOccurrs(-1);
        doc.addChildElement(root);
        TestMappingDocument.assertNotNull((Object)doc.getRootNode());
        TestMappingDocument.assertFalse((boolean)doc.isFormatted());
        TestMappingDocument.assertEquals((String)"UTF-16", (String)doc.getDocumentEncoding());
        root = (MappingElement)doc.getRootNode();
        TestMappingDocument.assertEquals((int)1, (int)root.getMinOccurence());
        TestMappingDocument.assertEquals((int)1, (int)root.getMaxOccurence());
    }

    public void testTagRoot() {
        MappingDocument doc = new MappingDocument("UTF-16", false);
        MappingSourceNode source = new MappingSourceNode("source");
        doc.addSourceNode(source);
        MappingElement tagroot = new MappingElement("test");
        source.addChildElement(tagroot);
        TestMappingDocument.assertTrue((doc.getRootNode() == source ? 1 : 0) != 0);
        TestMappingDocument.assertTrue((doc.getTagRootElement() == tagroot ? 1 : 0) != 0);
    }
}

