/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Properties;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.FakeServer;
import org.teiid.jdbc.TestMMDatabaseMetaData;

public class TestCase3473 {
    private DatabaseMetaData dbmd;
    private static FakeServer server;

    @BeforeClass
    public static void oneTimeSetup() throws Exception {
        server = new FakeServer(true);
        server.deployVDB("test", UnitTestUtil.getTestDataPath() + "/TestCase3473/test.vdb");
    }

    @AfterClass
    public static void oneTimeTeardown() throws Exception {
        server.stop();
    }

    @Before
    public void setUp() throws Exception {
        ConnectionImpl conn = server.createConnection("jdbc:teiid:test");
        this.dbmd = conn.getMetaData();
    }

    @Test
    public void testGetCrossReference() throws Exception {
        ResultSet rs = this.dbmd.getCrossReference(null, "test", "all_databases", null, "test", "all_models");
        ResultSet rs1 = this.dbmd.getCrossReference(null, "Foo%", "%", null, null, "%");
        ResultSet rs2 = this.dbmd.getCrossReference("foo", "Foo%", "%", null, null, "%");
        ResultSet rs3 = this.dbmd.getCrossReference(null, null, null, null, null, null);
        TestMMDatabaseMetaData.compareResultSet(rs, rs1, rs2, rs3);
    }

    @Test
    public void testGetImportedKeys() throws Exception {
        ResultSet rs = this.dbmd.getImportedKeys(null, "test", "all_models");
        ResultSet rs1 = this.dbmd.getImportedKeys(null, "Foo%", "%");
        ResultSet rs2 = this.dbmd.getImportedKeys("foo", "Foo%", "%");
        TestMMDatabaseMetaData.compareResultSet(rs, rs1, rs2);
    }

    @Test
    public void testGetExportedKeys() throws Exception {
        ResultSet rs = this.dbmd.getExportedKeys(null, "test", "all_models");
        ResultSet rs1 = this.dbmd.getExportedKeys(null, "Foo%", "%");
        ResultSet rs2 = this.dbmd.getExportedKeys("foo", "Foo%", "%");
        TestMMDatabaseMetaData.compareResultSet(rs, rs1, rs2);
    }

    @Test
    public void testGetPrimaryKeys() throws Exception {
        ResultSet rs = this.dbmd.getPrimaryKeys(null, "test", "all_models");
        ResultSet rs1 = this.dbmd.getPrimaryKeys(null, "Foo%", "test.all_models");
        ResultSet rs2 = this.dbmd.getPrimaryKeys("foo", "Foo%", "test.all_models");
        TestMMDatabaseMetaData.compareResultSet(rs, rs1, rs2);
    }

    @Test
    public void testGetTables() throws Exception {
        ResultSet rs = this.dbmd.getTables(null, null, null, null);
        ResultSet rs1 = this.dbmd.getTables(null, "%foo", null, null);
        ResultSet rs2 = this.dbmd.getTables("foo", "%foo", null, null);
        TestMMDatabaseMetaData.compareResultSet(rs, rs1, rs2);
        Assert.assertTrue((boolean)this.dbmd.getTables(null, null, null, new String[]{"VIEW"}).next());
        Properties p = new Properties();
        p.setProperty("reportAsViews", "true");
        ConnectionImpl c = server.getDriver().connect("jdbc:teiid:test", p);
        DatabaseMetaData dmd = c.getMetaData();
        Assert.assertTrue((boolean)dmd.getTables(null, null, null, new String[]{"VIEW"}).next());
    }
}

