/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.teiid.core.BundleUtil;
import org.teiid.core.CorePlugin;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;

public class StringToTimestampTransform
extends Transform {
    private static boolean validate = true;
    private static Pattern pattern = Pattern.compile("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}(\\.\\d{1,9})?");

    @Override
    public Object transformDirect(Object value) throws TransformationException {
        String val = ((String)value).trim();
        Timestamp result = null;
        try {
            result = Timestamp.valueOf(val);
        }
        catch (Exception e) {
            if (!validate && pattern.matcher(val).matches()) {
                throw new TransformationException((BundleUtil.Event)CorePlugin.Event.TEIID10060, CorePlugin.Util.gs(CorePlugin.Event.TEIID10060, value, this.getTargetType().getSimpleName()));
            }
            throw new TransformationException(CorePlugin.Event.TEIID10059, e, CorePlugin.Util.gs(CorePlugin.Event.TEIID10059, value));
        }
        String substring = result.toString().substring(0, 19);
        if (!val.startsWith(substring)) {
            TimeZone tz = TimeZone.getDefault();
            if (tz.useDaylightTime()) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                sdf.setLenient(false);
                sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                try {
                    sdf.parse(val.substring(0, 19));
                    return result;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            throw new TransformationException((BundleUtil.Event)CorePlugin.Event.TEIID10060, CorePlugin.Util.gs(CorePlugin.Event.TEIID10060, value, this.getTargetType().getSimpleName()));
        }
        return result;
    }

    @Override
    public Class<?> getSourceType() {
        return String.class;
    }

    @Override
    public Class<?> getTargetType() {
        return Timestamp.class;
    }

    @Override
    public boolean isExplicit() {
        return true;
    }

    static {
        try {
            Timestamp.valueOf("2000-14-01 00:00:00");
        }
        catch (Exception e) {
            validate = false;
        }
    }
}

