/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RelationalPlanner;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.RuleConstants;
import org.teiid.query.optimizer.relational.rules.RulePlanSorts;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.EvaluatableVisitor;
import org.teiid.query.util.CommandContext;

public class RulePushLimit
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        List<PlanNode> limitNodes = NodeEditor.findAllNodes(plan, 1024, 1);
        boolean pushRaiseNull = false;
        PlanNode[] rootHolder = new PlanNode[]{plan};
        while (!limitNodes.isEmpty()) {
            PlanNode childProject;
            PlanNode limitNode = limitNodes.get(0);
            Expression limit = (Expression)limitNode.getProperty(NodeConstants.Info.MAX_TUPLE_LIMIT);
            if (limit instanceof Constant && new Integer(0).equals(((Constant)limit).getValue()) && (childProject = NodeEditor.findNodePreOrder(limitNode, 8)) != null && childProject.getProperty(NodeConstants.Info.INTO_GROUP) == null) {
                limitNodes.removeAll(NodeEditor.findAllNodes(limitNode.getFirstChild(), 1024, 1));
                FrameUtil.replaceWithNullNode(limitNode.getFirstChild());
                PlanNode projectNode = NodeFactory.getNewNode(8);
                RelationalPlanner.createProjectNode((List)childProject.getProperty(NodeConstants.Info.PROJECT_COLS));
                limitNode.getFirstChild().addAsParent(projectNode);
                projectNode.setProperty(NodeConstants.Info.OUTPUT_COLS, projectNode.getProperty(NodeConstants.Info.PROJECT_COLS));
                pushRaiseNull = true;
                limitNodes.remove(limitNode);
                continue;
            }
            while (this.canPushLimit(rootHolder, limitNode, limitNodes, metadata, capabilitiesFinder, analysisRecord, context)) {
                rootHolder[0] = RuleRaiseAccess.performRaise(rootHolder[0], limitNode.getFirstChild(), limitNode);
                limitNode.setProperty(NodeConstants.Info.OUTPUT_COLS, limitNode.getFirstChild().getProperty(NodeConstants.Info.OUTPUT_COLS));
            }
            limitNodes.remove(limitNode);
            if (!limitNode.hasBooleanProperty(NodeConstants.Info.IS_COPIED)) continue;
            limitNode.getParent().replaceChild(limitNode, limitNode.getFirstChild());
        }
        if (pushRaiseNull) {
            rules.push(RuleConstants.RAISE_NULL);
        }
        return rootHolder[0];
    }

    private boolean canPushLimit(PlanNode[] rootNode, PlanNode limitNode, List<PlanNode> limitNodes, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord record, CommandContext context) throws QueryMetadataException, TeiidComponentException, QueryPlannerException {
        PlanNode child = limitNode.getFirstChild();
        if (child == null || child.getChildCount() == 0) {
            return false;
        }
        Expression parentLimit = (Expression)limitNode.getProperty(NodeConstants.Info.MAX_TUPLE_LIMIT);
        Expression parentOffset = (Expression)limitNode.getProperty(NodeConstants.Info.OFFSET_TUPLE_COUNT);
        switch (child.getType()) {
            case 1024: {
                Expression childLimit = (Expression)child.getProperty(NodeConstants.Info.MAX_TUPLE_LIMIT);
                Expression childOffset = (Expression)child.getProperty(NodeConstants.Info.OFFSET_TUPLE_COUNT);
                RulePushLimit.combineLimits(limitNode, metadata, parentLimit, parentOffset, childLimit, childOffset);
                if (child.hasBooleanProperty(NodeConstants.Info.IS_NON_STRICT)) {
                    limitNode.setProperty(NodeConstants.Info.IS_NON_STRICT, true);
                }
                NodeEditor.removeChildNode(limitNode, child);
                limitNodes.remove(child);
                return this.canPushLimit(rootNode, limitNode, limitNodes, metadata, capFinder, record, context);
            }
            case 256: {
                if (!this.canPushToBranches(limitNode, child)) {
                    return false;
                }
                LinkedList<PlanNode> grandChildren = new LinkedList<PlanNode>(child.getChildren());
                for (PlanNode grandChild : grandChildren) {
                    this.addBranchLimit(limitNode, limitNodes, metadata, parentLimit, parentOffset, grandChild);
                }
                return false;
            }
            case 4: {
                PlanNode newLimit;
                if (parentLimit == null) {
                    return false;
                }
                JoinType joinType = (JoinType)child.getProperty(NodeConstants.Info.JOIN_TYPE);
                boolean pushLeft = false;
                boolean pushRight = false;
                if (joinType == JoinType.JOIN_CROSS) {
                    pushLeft = true;
                    pushRight = true;
                } else if (joinType == JoinType.JOIN_LEFT_OUTER || joinType == JoinType.JOIN_FULL_OUTER) {
                    pushLeft = true;
                }
                if (pushLeft && !FrameUtil.findJoinSourceNode(child.getLastChild()).hasProperty(NodeConstants.Info.CORRELATED_REFERENCES)) {
                    newLimit = RulePushLimit.newLimit(limitNode);
                    newLimit.setProperty(NodeConstants.Info.MAX_TUPLE_LIMIT, RulePushLimit.op("+", parentLimit, parentOffset, metadata.getFunctionLibrary()));
                    child.getFirstChild().addAsParent(newLimit);
                    newLimit.setProperty(NodeConstants.Info.OUTPUT_COLS, newLimit.getFirstChild().getProperty(NodeConstants.Info.OUTPUT_COLS));
                    limitNodes.add(newLimit);
                }
                if (pushRight) {
                    newLimit = RulePushLimit.newLimit(limitNode);
                    newLimit.setProperty(NodeConstants.Info.MAX_TUPLE_LIMIT, RulePushLimit.op("+", parentLimit, parentOffset, metadata.getFunctionLibrary()));
                    child.getLastChild().addAsParent(newLimit);
                    newLimit.setProperty(NodeConstants.Info.OUTPUT_COLS, newLimit.getFirstChild().getProperty(NodeConstants.Info.OUTPUT_COLS));
                    limitNodes.add(newLimit);
                }
                return false;
            }
            case 1: {
                RulePushLimit.raiseAccessOverLimit(rootNode[0], child, metadata, capFinder, limitNode, record);
                return false;
            }
            case 8: {
                return child.getProperty(NodeConstants.Info.INTO_GROUP) == null && !child.hasProperty(NodeConstants.Info.HAS_WINDOW_FUNCTIONS);
            }
            case 64: {
                return this.canPushThroughView(child);
            }
            case 2: 
            case 16: {
                return limitNode.hasBooleanProperty(NodeConstants.Info.IS_NON_STRICT);
            }
            case 32: {
                switch (child.getFirstChild().getType()) {
                    case 64: {
                        if (this.canPushThroughView(child.getFirstChild())) {
                            PlanNode sourceNode = child.getFirstChild();
                            NodeEditor.removeChildNode(limitNode, child);
                            NodeEditor.removeChildNode(limitNode.getParent(), limitNode);
                            limitNode.setProperty(NodeConstants.Info.OUTPUT_COLS, sourceNode.getFirstChild().getProperty(NodeConstants.Info.OUTPUT_COLS));
                            child.setProperty(NodeConstants.Info.OUTPUT_COLS, sourceNode.getFirstChild().getProperty(NodeConstants.Info.OUTPUT_COLS));
                            HashMap symbolMap = new HashMap();
                            List<ElementSymbol> virtual = ((SymbolMap)sourceNode.getProperty(NodeConstants.Info.SYMBOL_MAP)).getKeys();
                            List projected = (List)NodeEditor.findNodePreOrder(sourceNode, 8).getProperty(NodeConstants.Info.PROJECT_COLS);
                            for (int i = 0; i < virtual.size(); ++i) {
                                symbolMap.put(virtual.get(i), projected.get(i));
                            }
                            OrderBy orderBy = (OrderBy)child.getProperty(NodeConstants.Info.SORT_ORDER);
                            for (OrderByItem item : orderBy.getOrderByItems()) {
                                Expression ex = (Expression)symbolMap.get(item.getSymbol());
                                if (ex == null) continue;
                                item.setSymbol(ex);
                                item.setExpressionPosition(projected.indexOf(ex));
                            }
                            FrameUtil.convertNode(child, sourceNode.getGroups().iterator().next(), null, symbolMap, metadata, false);
                            sourceNode.getFirstChild().addAsParent(child);
                            child.addAsParent(limitNode);
                            limitNodes.add(limitNode);
                            return false;
                        }
                    }
                    case 256: {
                        PlanNode setOp = child.getFirstChild();
                        if (!this.canPushToBranches(limitNode, setOp)) {
                            return false;
                        }
                        OrderBy parentOrderBy = (OrderBy)child.getProperty(NodeConstants.Info.SORT_ORDER);
                        this.distributeLimit(limitNode, setOp, parentOrderBy, metadata, limitNodes, parentLimit, parentOffset, capFinder, context);
                        break;
                    }
                    case 4: {
                        if (parentLimit == null) {
                            return false;
                        }
                        PlanNode join = child.getFirstChild();
                        JoinType jt = (JoinType)join.getProperty(NodeConstants.Info.JOIN_TYPE);
                        if (!jt.isOuter()) {
                            return false;
                        }
                        if ((jt == JoinType.JOIN_FULL_OUTER || jt == JoinType.JOIN_LEFT_OUTER) && join.getFirstChild().getGroups().containsAll(child.getGroups()) && !FrameUtil.findJoinSourceNode(join.getLastChild()).hasProperty(NodeConstants.Info.CORRELATED_REFERENCES)) {
                            this.pushOrderByAndLimit(limitNode, limitNodes, metadata, capFinder, context, child, parentLimit, parentOffset, join.getFirstChild());
                            break;
                        }
                        if (jt != JoinType.JOIN_FULL_OUTER || !join.getLastChild().getGroups().containsAll(child.getGroups())) break;
                        this.pushOrderByAndLimit(limitNode, limitNodes, metadata, capFinder, context, child, parentLimit, parentOffset, join.getLastChild());
                        break;
                    }
                    case 8: {
                        rootNode[0] = RulePlanSorts.checkForProjectOptimization(child, rootNode[0], metadata, capFinder, record, context);
                        if (child.getFirstChild().getType() == 8 || NodeEditor.findParent(child, 1) != null) break;
                        return this.canPushLimit(rootNode, limitNode, limitNodes, metadata, capFinder, record, context);
                    }
                    case 1: {
                        if (!RuleRaiseAccess.canRaiseOverSort(child.getFirstChild(), metadata, capFinder, child, null, false, context)) break;
                        NodeEditor.removeChildNode(limitNode, child);
                        limitNode.getFirstChild().getFirstChild().addAsParent(child);
                        limitNodes.add(limitNode);
                        return false;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private boolean canPushThroughView(PlanNode child) {
        if (child.getChildCount() == 0) {
            return false;
        }
        GroupSymbol virtualGroup = child.getGroups().iterator().next();
        if (virtualGroup.isProcedure()) {
            return false;
        }
        if (FrameUtil.isProcedure(child.getFirstChild())) {
            return false;
        }
        return !child.hasProperty(NodeConstants.Info.TABLE_FUNCTION);
    }

    private void pushOrderByAndLimit(PlanNode limitNode, List<PlanNode> limitNodes, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, CommandContext context, PlanNode child, Expression parentLimit, Expression parentOffset, PlanNode branch) throws QueryMetadataException, TeiidComponentException {
        OrderBy parentOrderBy = (OrderBy)child.getProperty(NodeConstants.Info.SORT_ORDER);
        PlanNode newSort = NodeFactory.getNewNode(32);
        OrderBy newOrderBy = parentOrderBy.clone();
        newSort.setProperty(NodeConstants.Info.SORT_ORDER, newOrderBy);
        newSort.addGroups(child.getGroups());
        newSort.setProperty(NodeConstants.Info.OUTPUT_COLS, branch.getProperty(NodeConstants.Info.OUTPUT_COLS));
        branch.addAsParent(newSort);
        this.addBranchLimit(limitNode, limitNodes, metadata, parentLimit, parentOffset, newSort);
        if (limitNode.hasBooleanProperty(NodeConstants.Info.IS_PUSHED)) {
            NodeEditor.removeChildNode(limitNode, limitNode.getFirstChild());
            NodeEditor.removeChildNode(limitNode.getParent(), limitNode);
        }
    }

    private void addBranchLimit(PlanNode limitNode, List<PlanNode> limitNodes, QueryMetadataInterface metadata, Expression parentLimit, Expression parentOffset, PlanNode grandChild) {
        PlanNode newLimit = RulePushLimit.newLimit(limitNode);
        newLimit.setProperty(NodeConstants.Info.MAX_TUPLE_LIMIT, RulePushLimit.op("+", parentLimit, parentOffset, metadata.getFunctionLibrary()));
        grandChild.addAsParent(newLimit);
        newLimit.setProperty(NodeConstants.Info.OUTPUT_COLS, newLimit.getFirstChild().getProperty(NodeConstants.Info.OUTPUT_COLS));
        if (NodeEditor.findParent(newLimit, 1) == null) {
            limitNodes.add(newLimit);
        }
        if (grandChild.getType() == 256) {
            newLimit.setProperty(NodeConstants.Info.IS_COPIED, true);
        }
        newLimit.setProperty(NodeConstants.Info.IS_PUSHED, true);
    }

    private void distributeLimit(PlanNode limitNode, PlanNode setOp, OrderBy parentOrderBy, QueryMetadataInterface metadata, List<PlanNode> limitNodes, Expression parentLimit, Expression parentOffset, CapabilitiesFinder capFinder, CommandContext context) throws QueryMetadataException, TeiidComponentException {
        block0: for (PlanNode branch : setOp.getChildren()) {
            List<OrderByItem> parentkeys;
            PlanNode branchSort = NodeEditor.findNodePreOrder(branch, 32, 320);
            if (branchSort != null) {
                OrderBy orderBy = (OrderBy)branchSort.getProperty(NodeConstants.Info.SORT_ORDER);
                if (parentOrderBy.getOrderByItems().size() > orderBy.getOrderByItems().size()) continue;
                parentkeys = parentOrderBy.getOrderByItems();
                List<OrderByItem> keys = orderBy.getOrderByItems();
                for (int i = 0; i < parentkeys.size(); ++i) {
                    int pos1 = parentkeys.get(i).getExpressionPosition();
                    int pos2 = keys.get(i).getExpressionPosition();
                    if (pos1 == -1 || pos2 == -1 || pos1 != pos2) continue block0;
                }
                this.addBranchLimit(limitNode, limitNodes, metadata, parentLimit, parentOffset, branch);
                continue;
            }
            if (branch.getType() == 256 && this.canPushToBranches(limitNode, branch)) {
                this.distributeLimit(limitNode, branch, parentOrderBy, metadata, limitNodes, parentLimit, parentOffset, capFinder, context);
                continue;
            }
            PlanNode newSort = NodeFactory.getNewNode(32);
            parentkeys = parentOrderBy.getOrderByItems();
            List cols = (List)NodeEditor.findNodePreOrder(branch, 8).getProperty(NodeConstants.Info.PROJECT_COLS);
            OrderBy newOrderBy = new OrderBy();
            for (int i = 0; i < parentkeys.size(); ++i) {
                OrderByItem item = parentkeys.get(i).clone();
                if (item.getExpressionPosition() == -1) continue block0;
                Expression ex = (Expression)cols.get(item.getExpressionPosition());
                item.setSymbol((Expression)ex.clone());
                newOrderBy.getOrderByItems().add(item);
            }
            newSort.setProperty(NodeConstants.Info.SORT_ORDER, newOrderBy);
            PlanNode childLimit = NodeEditor.findNodePreOrder(branch, 1024, 320);
            if (childLimit != null) {
                PlanNode parentAccess = NodeEditor.findParent(childLimit, 1, 256);
                if (parentAccess == null) continue;
                boolean removedLimit = false;
                if (parentAccess.getFirstChild() == childLimit) {
                    parentAccess.removeChild(childLimit);
                    parentAccess.addFirstChild(childLimit.getFirstChild());
                    removedLimit = true;
                }
                boolean canRaise = RuleRaiseAccess.canRaiseOverSort(parentAccess, metadata, capFinder, newSort, null, false, context);
                if (removedLimit) {
                    childLimit.addFirstChild(parentAccess.getFirstChild());
                    parentAccess.addFirstChild(childLimit);
                }
                if (!canRaise) continue;
                childLimit.getFirstChild().addAsParent(newSort);
            } else if (branch.getType() == 1 && RuleRaiseAccess.canRaiseOverSort(branch, metadata, capFinder, newSort, null, false, context)) {
                branch.getFirstChild().addAsParent(newSort);
            } else {
                branch.addAsParent(newSort);
                branch = newSort;
            }
            newSort.setProperty(NodeConstants.Info.OUTPUT_COLS, newSort.getFirstChild().getProperty(NodeConstants.Info.OUTPUT_COLS));
            this.addBranchLimit(limitNode, limitNodes, metadata, parentLimit, parentOffset, branch);
        }
    }

    private boolean canPushToBranches(PlanNode limitNode, PlanNode child) {
        if (!limitNode.hasProperty(NodeConstants.Info.MAX_TUPLE_LIMIT)) {
            return false;
        }
        if (!SetQuery.Operation.UNION.equals(child.getProperty(NodeConstants.Info.SET_OPERATION))) {
            return false;
        }
        return child.hasBooleanProperty(NodeConstants.Info.USE_ALL) || limitNode.hasBooleanProperty(NodeConstants.Info.IS_NON_STRICT);
    }

    private static PlanNode newLimit(PlanNode limitNode) {
        PlanNode newLimit = NodeFactory.getNewNode(1024);
        if (limitNode.hasBooleanProperty(NodeConstants.Info.IS_NON_STRICT)) {
            newLimit.setProperty(NodeConstants.Info.IS_NON_STRICT, Boolean.TRUE);
        }
        return newLimit;
    }

    static void combineLimits(PlanNode limitNode, QueryMetadataInterface metadata, Expression parentLimit, Expression parentOffset, Expression childLimit, Expression childOffset) {
        Expression minLimit = null;
        Expression offSet = null;
        if (childLimit == null) {
            minLimit = parentLimit;
            offSet = RulePushLimit.op("+", childOffset, parentOffset, metadata.getFunctionLibrary());
        } else {
            minLimit = RulePushLimit.getMinValue(parentLimit, RulePushLimit.op("-", childLimit, parentOffset, metadata.getFunctionLibrary()));
            offSet = childOffset;
            if (offSet == null) {
                offSet = parentOffset;
            }
        }
        limitNode.setProperty(NodeConstants.Info.MAX_TUPLE_LIMIT, minLimit);
        limitNode.setProperty(NodeConstants.Info.OFFSET_TUPLE_COUNT, offSet);
    }

    static PlanNode raiseAccessOverLimit(PlanNode rootNode, PlanNode accessNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, PlanNode parentNode, AnalysisRecord analysisRecord) throws QueryMetadataException, TeiidComponentException {
        Object modelID = RuleRaiseAccess.getModelIDFromAccess(accessNode, metadata);
        if (modelID == null) {
            return null;
        }
        Expression limit = (Expression)parentNode.getProperty(NodeConstants.Info.MAX_TUPLE_LIMIT);
        if (limit != null && !CapabilitiesUtil.supportsRowLimit(modelID, metadata, capFinder)) {
            parentNode.recordDebugAnnotation("limit not supported by source", modelID, "limit node not pushed", analysisRecord, metadata);
            return null;
        }
        boolean multiSource = accessNode.hasBooleanProperty(NodeConstants.Info.IS_MULTI_SOURCE);
        Expression offset = (Expression)parentNode.getProperty(NodeConstants.Info.OFFSET_TUPLE_COUNT);
        if (multiSource || offset != null && !CapabilitiesUtil.supportsRowOffset(modelID, metadata, capFinder)) {
            if (limit != null) {
                if (!multiSource) {
                    parentNode.setProperty(NodeConstants.Info.MAX_TUPLE_LIMIT, null);
                }
                PlanNode pushedLimit = RulePushLimit.newLimit(parentNode);
                pushedLimit.setProperty(NodeConstants.Info.MAX_TUPLE_LIMIT, RulePushLimit.op("+", limit, offset, metadata.getFunctionLibrary()));
                if (accessNode.getChildCount() == 0) {
                    accessNode.addFirstChild(pushedLimit);
                } else {
                    accessNode.getFirstChild().addAsParent(pushedLimit);
                }
                pushedLimit.setProperty(NodeConstants.Info.OUTPUT_COLS, pushedLimit.getFirstChild().getProperty(NodeConstants.Info.OUTPUT_COLS));
            }
            return null;
        }
        return RuleRaiseAccess.performRaise(rootNode, accessNode, parentNode);
    }

    static Expression op(String op, Expression expr1, Expression expr2, FunctionLibrary functionLibrary) {
        if (expr1 == null) {
            return expr2;
        }
        if (expr2 == null) {
            return expr1;
        }
        Function newExpr = new Function(op, new Expression[]{expr1, expr2});
        newExpr.setFunctionDescriptor(functionLibrary.findFunction(op, new Class[]{DataTypeManager.DefaultDataClasses.INTEGER, DataTypeManager.DefaultDataClasses.INTEGER}));
        newExpr.setType(newExpr.getFunctionDescriptor().getReturnType());
        return RulePushLimit.evaluateIfPossible(newExpr);
    }

    private static Expression evaluateIfPossible(Expression newExpr) {
        if (EvaluatableVisitor.isFullyEvaluatable(newExpr, true)) {
            try {
                return new Constant(Evaluator.evaluate(newExpr), newExpr.getType());
            }
            catch (TeiidException e) {
                throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30269, (Throwable)e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30269, new Object[0]));
            }
        }
        return newExpr;
    }

    static Expression getMinValue(Expression expr1, Expression expr2) {
        if (expr1 == null) {
            return expr2;
        }
        if (expr2 == null) {
            return expr1;
        }
        CompareCriteria crit = new CompareCriteria(expr1, 3, expr2);
        SearchedCaseExpression sce = new SearchedCaseExpression(Arrays.asList(crit), Arrays.asList(expr1));
        sce.setElseExpression(expr2);
        sce.setType(expr1.getType());
        return RulePushLimit.evaluateIfPossible(sce);
    }

    public String toString() {
        return "PushLimit";
    }
}

