/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.framework.connection;

import java.sql.Connection;
import java.util.Properties;
import javax.sql.XAConnection;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.test.framework.ConfigPropertyLoader;
import org.teiid.test.framework.connection.DataSourceConnection;
import org.teiid.test.framework.connection.DriverConnection;
import org.teiid.test.framework.datasource.DataSource;
import org.teiid.test.framework.datasource.DataSourceMgr;
import org.teiid.test.framework.exception.QueryTestFailedException;
import org.teiid.test.framework.exception.TransactionRuntimeException;

public abstract class ConnectionStrategy {
    private Properties env = null;
    private boolean useProxy = false;
    private boolean autoCommit;

    public ConnectionStrategy(Properties props) {
        this.env = PropertiesUtils.clone((Properties)props);
    }

    public abstract Connection getConnection() throws QueryTestFailedException;

    public boolean useProxy() {
        return this.useProxy;
    }

    void setUseProxy(boolean useproxy) {
        this.useProxy = useproxy;
    }

    public void shutdown() {
    }

    public Connection getAdminConnection() throws QueryTestFailedException {
        return null;
    }

    public boolean getAutocommit() {
        return this.autoCommit;
    }

    public XAConnection getXAConnection() throws QueryTestFailedException {
        return null;
    }

    public boolean isDataStoreDisabled() {
        return ConfigPropertyLoader.getInstance().isDataStoreDisabled();
    }

    public Properties getEnvironment() {
        return this.env;
    }

    public void setEnvironmentProperty(String key, String value) {
        this.env.setProperty(key, value);
    }

    void configure() throws QueryTestFailedException {
    }

    public synchronized Connection createDriverConnection(String identifier) throws QueryTestFailedException {
        DataSource ds = null;
        if (identifier != null) {
            ds = DataSourceMgr.getInstance().getDataSource(identifier);
        }
        if (ds == null) {
            throw new TransactionRuntimeException("Program Error: DataSource is not mapped to Identifier " + identifier);
        }
        Connection conn = ds.getConnection();
        if (conn != null) {
            return conn;
        }
        DriverConnection cs = null;
        cs = identifier == null ? new DriverConnection(ds.getProperties()) : new DriverConnection(ds.getProperties());
        ds.setConnection(((ConnectionStrategy)cs).getConnection());
        return ds.getConnection();
    }

    public synchronized XAConnection createDataSourceConnection(String identifier) throws QueryTestFailedException {
        DataSource ds = null;
        if (identifier != null) {
            ds = DataSourceMgr.getInstance().getDataSource(identifier);
        }
        if (ds == null) {
            throw new TransactionRuntimeException("Program Error: DataSource is not mapped to Identifier " + identifier);
        }
        XAConnection conn = ds.getXAConnection();
        if (conn != null) {
            return conn;
        }
        DataSourceConnection cs = null;
        cs = identifier == null ? new DataSourceConnection(ds.getProperties()) : new DataSourceConnection(ds.getProperties());
        ds.setXAConnection(((ConnectionStrategy)cs).getXAConnection());
        return ds.getXAConnection();
    }
}

