/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.JoinRegion;
import org.teiid.query.optimizer.relational.rules.RulePlanJoins;
import org.teiid.query.optimizer.relational.rules.TestFrameUtil;
import org.teiid.query.sql.lang.JoinType;

public class TestJoinRegion
extends TestCase {
    public void testFindJoinRegions() {
        ArrayList regions = new ArrayList();
        PlanNode joinRoot = TestFrameUtil.getExamplePlan();
        PlanNode joinRoot1 = TestFrameUtil.getExamplePlan();
        PlanNode outerJoin = NodeFactory.getNewNode((int)4);
        outerJoin.setProperty(NodeConstants.Info.JOIN_TYPE, (Object)JoinType.JOIN_LEFT_OUTER);
        outerJoin.addFirstChild(joinRoot);
        outerJoin.addFirstChild(joinRoot1);
        PlanNode source = NodeFactory.getNewNode((int)64);
        source.addFirstChild(outerJoin);
        RulePlanJoins.findJoinRegions((PlanNode)source, null, regions);
        TestJoinRegion.assertEquals((int)3, (int)regions.size());
        JoinRegion region = (JoinRegion)regions.get(0);
        TestJoinRegion.assertEquals((int)1, (int)region.getJoinSourceNodes().size());
    }

    public void testReconstruction() {
        ArrayList regions = new ArrayList();
        PlanNode joinRoot = TestFrameUtil.getExamplePlan();
        PlanNode source = NodeFactory.getNewNode((int)64);
        source.addFirstChild(joinRoot);
        RulePlanJoins.findJoinRegions((PlanNode)source, null, regions);
        TestJoinRegion.assertEquals((int)1, (int)regions.size());
        JoinRegion region = (JoinRegion)regions.get(0);
        TestJoinRegion.assertEquals((int)3, (int)region.getJoinSourceNodes().size());
        TestJoinRegion.assertEquals((Object)joinRoot, (Object)region.getJoinRoot());
        region.changeJoinOrder(new Object[]{new Integer(1), new Integer(0), new Integer(2)});
        region.reconstructJoinRegoin();
        PlanNode root = region.getJoinRoot();
        TestJoinRegion.assertEquals((int)4, (int)root.getFirstChild().getType());
        TestJoinRegion.assertEquals((int)64, (int)root.getFirstChild().getFirstChild().getFirstChild().getType());
    }

    public void testReconstructionOf1Source() {
        PlanNode source = NodeFactory.getNewNode((int)64);
        PlanNode accessNode = NodeFactory.getNewNode((int)1);
        source.addFirstChild(accessNode);
        JoinRegion region = new JoinRegion();
        region.addJoinSourceNode(accessNode);
        region.reconstructJoinRegoin();
        TestJoinRegion.assertEquals((int)1, (int)region.getJoinRoot().getType());
    }
}

