/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.client.ctc;

import java.sql.ResultSet;
import java.util.Properties;
import org.teiid.test.client.ExpectedResults;
import org.teiid.test.client.QueryScenario;
import org.teiid.test.client.TestResult;
import org.teiid.test.client.ctc.XMLExpectedResults;
import org.teiid.test.client.ctc.XMLGenerateResults;
import org.teiid.test.client.ctc.XMLQueryReader;
import org.teiid.test.framework.exception.QueryTestFailedException;
import org.teiid.test.framework.exception.TransactionRuntimeException;

public class CTCQueryScenario
extends QueryScenario {
    public CTCQueryScenario(String scenarioName, Properties querySetProperties) {
        super(scenarioName, querySetProperties);
    }

    @Override
    protected void setUp() {
        try {
            this.reader = new XMLQueryReader(this.getQueryScenarioIdentifier(), this.getProperties());
        }
        catch (QueryTestFailedException e1) {
            throw new TransactionRuntimeException(e1);
        }
        this.resultsGen = new XMLGenerateResults(this.getQueryScenarioIdentifier(), this.getProperties());
        if (this.reader.getQuerySetIDs() == null || this.reader.getQuerySetIDs().isEmpty()) {
            throw new TransactionRuntimeException("The queryreader did not return any queryset ID's to process");
        }
        this.validateResultsMode(this.getProperties());
    }

    @Override
    public ExpectedResults getExpectedResults(String querySetID) {
        return new XMLExpectedResults(querySetID, this.getProperties());
    }

    @Override
    public void handleTestResult(TestResult tr, ResultSet resultSet, int updatecnt, boolean resultFromQuery, String sql) {
        Throwable resultException = tr.getException();
        if (this.getResultsMode().equalsIgnoreCase("compare")) {
            if (tr.getStatus() != 1) {
                try {
                    this.getExpectedResults(tr.getQuerySetID()).compareResults(tr.getQueryID(), sql, resultSet, resultException, tr.getStatus(), this.isOrdered(sql), -1, resultFromQuery);
                }
                catch (QueryTestFailedException qtf) {
                    resultException = resultException != null ? resultException : qtf;
                    tr.setException(resultException);
                    tr.setStatus(1);
                }
            }
            if (tr.getStatus() == 1) {
                try {
                    this.getResultsGenerator().generateErrorFile(tr.getQuerySetID(), tr.getQueryID(), sql, resultSet, resultException, this.getExpectedResults(tr.getQuerySetID()).getResultsFile(tr.getQueryID()));
                }
                catch (QueryTestFailedException qtfe) {
                    throw new TransactionRuntimeException(qtfe.getMessage());
                }
            }
        } else {
            if (this.getResultsMode().equalsIgnoreCase("generate")) {
                try {
                    this.getResultsGenerator().generateQueryResultFile(tr.getQuerySetID(), tr.getQueryID(), sql, resultSet, resultException, tr.getStatus());
                }
                catch (QueryTestFailedException qtfe) {
                    throw new TransactionRuntimeException(qtfe.getMessage());
                }
            }
            if (tr.getStatus() == 1 && !this.getResultsMode().equalsIgnoreCase("none")) {
                try {
                    this.getResultsGenerator().generateErrorFile(tr.getQuerySetID(), tr.getQueryID(), sql, resultSet, resultException, this.getExpectedResults(tr.getQuerySetID()).getResultsFile(tr.getQueryID()));
                }
                catch (QueryTestFailedException qtfe) {
                    throw new TransactionRuntimeException(qtfe.getMessage());
                }
            }
        }
    }

    private boolean isOrdered(String sql) {
        return sql.toLowerCase().indexOf(" order by ") > 0;
    }
}

