/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.CollectionTupleSource;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.RegisterRequestParameter;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestSourceHints {
    @Test
    public void testUserQueryHint() {
        String sql = "SELECT /*+ sh:'foo' bar:'leading' */ e1 from pm1.g1 order by e1 limit 1";
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        List[] expected = new List[]{};
        TestProcessor.helpProcess(plan, this.manager("foo", "leading"), expected);
    }

    @Test
    public void testWithHint() {
        String sql = "WITH x as /*+ no_inline */ (SELECT /*+ sh:'x' */ e1 from pm1.g2) SELECT /*+ sh:'foo' bar:'leading' */ g1.e1 from pm1.g1, x where g1.e1 = x.e1 order by g1.e1 limit 1";
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        List[] expected = new List[]{};
        TestProcessor.helpProcess(plan, this.manager("foo x", "leading", "foo", "leading"), expected);
    }

    @Test
    public void testWithHintPushdown() throws TeiidException {
        String sql = "WITH x as /*+ no_inline */ (SELECT /*+ sh:'x' */ e1 from pm1.g2) SELECT /*+ sh:'foo' bar:'leading' */ g1.e1 from pm1.g1, x where g1.e1 = x.e1 order by g1.e1 limit 1";
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.COMMON_TABLE_EXPRESSIONS, true);
        CommandContext context = new CommandContext();
        context.setDQPWorkContext(new DQPWorkContext());
        context.getDQPWorkContext().getSession().setVdb(RealMetadataFactory.example1VDB());
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new DefaultCapabilitiesFinder((SourceCapabilities)caps), context);
        List[] expected = new List[]{};
        TestProcessor.helpProcess(plan, this.manager("foo x", "leading"), expected);
    }

    @Test
    public void testUnionHintPushdown() throws TeiidException {
        String sql = "SELECT /*+ sh:'foo' bar:'leading' */ g1.e1 from pm1.g1 UNION ALL SELECT * from (SELECT /*+ sh:'x' bar:'z' */ g1.e1 from pm1.g1) as x";
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        CommandContext context = new CommandContext();
        context.setDQPWorkContext(new DQPWorkContext());
        context.getDQPWorkContext().getSession().setVdb(RealMetadataFactory.example1VDB());
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new DefaultCapabilitiesFinder((SourceCapabilities)caps), context);
        List[] expected = new List[]{};
        TestProcessor.helpProcess(plan, this.manager("foo x", "leading z"), expected);
    }

    @Test
    public void testKeepAliases() throws Exception {
        String sql = "SELECT /*+ sh KEEP ALIASES bar:'leading(g)' */ e1 from pm1.g1 g order by e1 limit 1";
        CommandContext cc = TestProcessor.createCommandContext();
        cc.setDQPWorkContext(new DQPWorkContext());
        cc.getDQPWorkContext().getSession().setVdb(RealMetadataFactory.example1VDB());
        ProcessorPlan plan = TestOptimizer.getPlan(TestOptimizer.helpGetCommand(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), null), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), TestOptimizer.getGenericFinder(), null, true, cc);
        TestOptimizer.checkAtomicQueries(new String[]{"SELECT /*+sh KEEP ALIASES bar:'leading(g)' */ g.e1 AS c_0 FROM pm1.g1 AS g ORDER BY c_0"}, plan);
        List[] expected = new List[]{};
        TestProcessor.helpProcess(plan, this.manager(null, "leading(g)"), expected);
    }

    @Test
    public void testHintInView() {
        MetadataStore metadataStore = new MetadataStore();
        Schema p1 = RealMetadataFactory.createPhysicalModel("p1", metadataStore);
        Table t1 = RealMetadataFactory.createPhysicalGroup("t", p1);
        RealMetadataFactory.createElements(t1, new String[]{"a", "b"}, new String[]{"string", "string"});
        Schema v1 = RealMetadataFactory.createVirtualModel("v1", metadataStore);
        QueryNode n1 = new QueryNode("SELECT /*+ sh:'x' */ a as c, b FROM p1.t");
        Table vt1 = RealMetadataFactory.createVirtualGroup("t1", v1, n1);
        RealMetadataFactory.createElements(vt1, new String[]{"c", "b"}, new String[]{"string", "string"});
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata(metadataStore, "metadata", new FunctionTree[0]);
        HardcodedDataManager manager = this.manager("foo x", "leading");
        String sql = "SELECT /*+ sh:'foo' bar:'leading' */ c from t1 order by c limit 1";
        ProcessorPlan plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)metadata);
        List[] expected = new List[]{};
        TestProcessor.helpProcess(plan, manager, expected);
        manager = this.manager("x", null);
        sql = "SELECT c from t1 order by c limit 1";
        plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)metadata);
        TestProcessor.helpProcess(plan, manager, expected);
        sql = "SELECT c from t1 union all select c from t1";
        plan = TestProcessor.helpGetPlan(sql, (QueryMetadataInterface)metadata);
        TestProcessor.helpProcess(plan, manager, expected);
    }

    @Test
    public void testInsertWithQueryExpression() throws TeiidException {
        String sql = "INSERT /*+ sh:'append' */ into pm1.g1 (e1) select e1 from pm2.g1";
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        CommandContext context = new CommandContext();
        context.setDQPWorkContext(new DQPWorkContext());
        context.getDQPWorkContext().getSession().setVdb(RealMetadataFactory.example1VDB());
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new DefaultCapabilitiesFinder((SourceCapabilities)caps), context);
        HardcodedDataManager manager = this.manager("append", null);
        manager.addData("SELECT /*+sh:'append' */ g_0.e1 FROM pm2.g1 AS g_0", Arrays.asList("a"));
        manager.addData("INSERT /*+sh:'append' */ INTO pm1.g1 (e1) VALUES ('a')", Arrays.asList(1));
        TestProcessor.helpProcess(plan, manager, new List[]{Arrays.asList(1)});
    }

    private HardcodedDataManager manager(final String ... hints) {
        HardcodedDataManager manager = new HardcodedDataManager(){
            int i = 0;

            @Override
            public TupleSource registerRequest(CommandContext context, Command command, String modelName, RegisterRequestParameter parameterObject) throws TeiidComponentException {
                if (hints[this.i * 2] == null && hints[this.i * 2 + 1] == null) {
                    Assert.assertNull((Object)command.getSourceHint());
                } else {
                    Assert.assertEquals((Object)hints[this.i * 2], (Object)command.getSourceHint().getGeneralHint());
                    Assert.assertEquals((Object)hints[this.i * 2 + 1], (Object)command.getSourceHint().getSourceHint("bar"));
                }
                ++this.i;
                this.i %= hints.length / 2;
                if (this.getData(command.toString()) != null) {
                    return super.registerRequest(context, command, modelName, parameterObject);
                }
                return CollectionTupleSource.createNullTupleSource();
            }
        };
        return manager;
    }
}

