/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.crypto;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.crypto.CryptoException;
import org.teiid.core.crypto.DhKeyGenerator;
import org.teiid.core.crypto.SymmetricCryptor;

public class TestDhKeyGenerator {
    @Test
    public void testKeyGenerationDefault() throws CryptoException {
        DhKeyGenerator keyGenServer = new DhKeyGenerator();
        DhKeyGenerator keyGenClient = new DhKeyGenerator();
        byte[] serverKey = keyGenServer.createPublicKey(true);
        byte[] clientKey = keyGenClient.createPublicKey(true);
        SymmetricCryptor serverCryptor = keyGenServer.getSymmetricCryptor(clientKey, false, TestDhKeyGenerator.class.getClassLoader(), true);
        SymmetricCryptor clientCryptor = keyGenClient.getSymmetricCryptor(serverKey, false, TestDhKeyGenerator.class.getClassLoader(), true);
        String cleartext = "cleartext!";
        String ciphertext = serverCryptor.encrypt(cleartext);
        String cleartext2 = clientCryptor.decrypt(ciphertext);
        Assert.assertEquals((Object)cleartext, (Object)cleartext2);
        Assert.assertTrue((!ciphertext.equals(cleartext) ? 1 : 0) != 0);
        Object sealed = serverCryptor.sealObject((Object)cleartext);
        Object unsealed = clientCryptor.unsealObject(sealed);
        Assert.assertEquals((Object)cleartext, (Object)unsealed);
        Assert.assertTrue((!sealed.equals(unsealed) ? 1 : 0) != 0);
    }
}

