/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.impl.CacheStatisticsMetadata;
import org.teiid.cache.Cachable;
import org.teiid.cache.Cache;
import org.teiid.cache.CacheFactory;
import org.teiid.common.buffer.TupleBufferCache;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.dqp.internal.process.AccessInfo;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.logging.LogManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.parser.ParseInfo;
import org.teiid.vdb.runtime.VDBKey;

public class SessionAwareCache<T> {
    public static final String REPL = "-repl";
    public static final int DEFAULT_MAX_SIZE_TOTAL = 512;
    private Cache<CacheID, T> localCache;
    private Cache<CacheID, T> distributedCache;
    private long modTime;
    private Type type;
    private AtomicInteger cacheHit = new AtomicInteger();
    private AtomicInteger totalRequests = new AtomicInteger();
    private AtomicInteger cachePuts = new AtomicInteger();
    private TupleBufferCache bufferManager;

    public SessionAwareCache(String cacheName, CacheFactory cacheFactory, Type type, int maxStaleness) {
        assert (cacheFactory != null);
        this.localCache = cacheFactory.get(cacheName);
        if (type == Type.PREPAREDPLAN) {
            this.distributedCache = this.localCache;
        } else {
            this.distributedCache = cacheFactory.get(cacheName + REPL);
            if (this.distributedCache == null && this.localCache != null) {
                this.distributedCache = this.localCache;
            }
        }
        this.modTime = maxStaleness * 1000;
        this.type = type;
        assert (this.localCache != null);
        assert (this.distributedCache != null);
    }

    public T get(CacheID id) {
        Cachable c;
        this.totalRequests.getAndIncrement();
        id.setSessionId(id.originalSessionId);
        T result = this.localCache.get(id);
        if (result == null) {
            id.setSessionId(null);
            id.setUserName(id.originalUserName);
            result = this.distributedCache.get(id);
            if (result == null) {
                id.setUserName(null);
                result = this.distributedCache.get(id);
            }
            if (result instanceof Cachable && !(c = (Cachable)result).restore(this.bufferManager)) {
                result = null;
            }
        }
        if (result != null) {
            AccessInfo info;
            if (result instanceof Cachable && (info = (c = (Cachable)result).getAccessInfo()) != null && !info.validate(this.type == Type.RESULTSET, this.modTime)) {
                LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object)"Invalidating cache entry", (Object)id);
                if (id.getSessionId() == null) {
                    this.distributedCache.remove(id);
                } else {
                    this.localCache.remove(id);
                }
                return null;
            }
            LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object)"Cache hit for", (Object)id);
            this.cacheHit.getAndIncrement();
        } else {
            LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object)"Cache miss for", (Object)id);
        }
        return result;
    }

    public int getCacheHitCount() {
        return this.cacheHit.get();
    }

    public int getRequestCount() {
        return this.totalRequests.get();
    }

    public int getCachePutCount() {
        return this.cachePuts.get();
    }

    public int getTotalCacheEntries() {
        if (this.localCache == this.distributedCache) {
            return this.localCache.size();
        }
        return this.localCache.size() + this.distributedCache.size();
    }

    public T remove(CacheID id, FunctionMethod.Determinism determinismLevel) {
        if (determinismLevel.compareTo((Enum)FunctionMethod.Determinism.SESSION_DETERMINISTIC) <= 0) {
            id.setSessionId(id.originalSessionId);
            LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object)"Removing from session/local cache", (Object)id);
            return this.localCache.remove(id);
        }
        id.setSessionId(null);
        if (determinismLevel == FunctionMethod.Determinism.USER_DETERMINISTIC) {
            id.setUserName(id.originalUserName);
        } else {
            id.setUserName(null);
        }
        LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object)"Removing from global/distributed cache", (Object)id);
        return this.distributedCache.remove(id);
    }

    public void put(CacheID id, FunctionMethod.Determinism determinismLevel, T t, Long ttl) {
        this.cachePuts.incrementAndGet();
        if (determinismLevel.compareTo((Enum)FunctionMethod.Determinism.SESSION_DETERMINISTIC) <= 0) {
            id.setSessionId(id.originalSessionId);
            LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object)"Adding to session/local cache", (Object)id);
            ttl = this.computeTtl(id, t, ttl);
            if (ttl != null && ttl == 0L) {
                return;
            }
            this.localCache.put(id, t, ttl);
        } else {
            boolean insert = true;
            id.setSessionId(null);
            if (determinismLevel == FunctionMethod.Determinism.USER_DETERMINISTIC) {
                id.setUserName(id.originalUserName);
            } else {
                id.setUserName(null);
            }
            if (t instanceof Cachable) {
                Cachable c = (Cachable)t;
                if ((ttl = this.computeTtl(id, t, ttl)) != null && ttl == 0L) {
                    return;
                }
                insert = c.prepare(this.bufferManager);
            }
            if (insert) {
                LogManager.logTrace((String)"org.teiid.PROCESSOR", (Object)"Adding to global/distributed cache", (Object)id);
                this.distributedCache.put(id, t, ttl);
            }
        }
    }

    Long computeTtl(CacheID id, T t, Long ttl) {
        if (!(t instanceof Cachable) || this.type != Type.RESULTSET) {
            return ttl;
        }
        Cachable c = (Cachable)t;
        AccessInfo info = c.getAccessInfo();
        if (info == null) {
            return ttl;
        }
        Set<Object> objects = info.getObjectsAccessed();
        if (objects == null) {
            return ttl;
        }
        long computedTtl = Long.MAX_VALUE;
        for (Object o : objects) {
            AbstractMetadataRecord amr;
            Long l;
            if (!(o instanceof AbstractMetadataRecord) || (l = SessionAwareCache.getDataTtl(amr = (AbstractMetadataRecord)o)) == null || l < 0L) continue;
            if (l == 0L) {
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)5)) {
                    LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Not adding cache entry", id, "since", amr.getFullName(), "has caching disabled"});
                }
                return 0L;
            }
            computedTtl = Math.min(l, computedTtl);
        }
        if (ttl != null) {
            ttl = Math.min(ttl, computedTtl);
        } else if (computedTtl != Long.MAX_VALUE) {
            ttl = computedTtl;
        }
        return ttl;
    }

    static Long getDataTtl(AbstractMetadataRecord record) {
        block4: {
            String value = record.getProperty("{http://www.teiid.org/ext/relational/2012}data-ttl", false);
            if (value != null) {
                try {
                    return Long.valueOf(value);
                }
                catch (NumberFormatException e) {
                    if (!LogManager.isMessageToBeRecorded((String)"org.teiid.RUNTIME", (int)5)) break block4;
                    LogManager.logDetail((String)"org.teiid.RUNTIME", (Object)"Invalid data ttl specified for ", (Object)record.getFullName());
                }
            }
        }
        if (record.getParent() != null) {
            return SessionAwareCache.getDataTtl(record.getParent());
        }
        return null;
    }

    public void clearAll() {
        this.localCache.clear();
        this.distributedCache.clear();
        this.totalRequests.set(0);
        this.cacheHit.set(0);
        this.cachePuts.set(0);
    }

    public void clearForVDB(String vdbName, String version) {
        VDBKey vdbKey = new VDBKey(vdbName, version);
        this.clearForVDB(vdbKey);
    }

    public void clearForVDB(VDBKey vdbKey) {
        this.clearCache(this.localCache, vdbKey);
        this.clearCache(this.distributedCache, vdbKey);
    }

    private void clearCache(Cache<CacheID, T> cache, VDBKey vdbKey) {
        Set<CacheID> keys = cache.keySet();
        for (CacheID key : keys) {
            if (!key.vdbInfo.equals(vdbKey)) continue;
            cache.remove(key);
        }
    }

    public void setTupleBufferCache(TupleBufferCache bufferManager) {
        this.bufferManager = bufferManager;
    }

    public void setModTime(long modTime) {
        this.modTime = modTime;
    }

    public static Collection<String> getCacheTypes() {
        ArrayList<String> caches = new ArrayList<String>();
        caches.add(Admin.Cache.PREPARED_PLAN_CACHE.toString());
        caches.add(Admin.Cache.QUERY_SERVICE_RESULT_SET_CACHE.toString());
        return caches;
    }

    public boolean isTransactional() {
        return this.localCache.isTransactional() || this.distributedCache.isTransactional();
    }

    public CacheStatisticsMetadata buildCacheStats(String name) {
        CacheStatisticsMetadata stats = new CacheStatisticsMetadata();
        stats.setName(name);
        stats.setHitRatio(this.getRequestCount() == 0 ? 0.0 : (double)this.getCacheHitCount() / (double)this.getRequestCount() * 100.0);
        stats.setTotalEntries(this.getTotalCacheEntries());
        stats.setRequestCount(this.getRequestCount());
        return stats;
    }

    public static class CacheID
    implements Serializable {
        private static final long serialVersionUID = 8261905111156764744L;
        private String sql;
        private VDBKey vdbInfo;
        private boolean ansiIdentifiers;
        private String sessionId;
        private String originalSessionId;
        private List<Serializable> parameters;
        private String userName;
        private String originalUserName;

        public CacheID(DQPWorkContext context, ParseInfo pi, String sql) {
            this(pi, sql, context.getVdbName(), context.getVdbVersion(), context.getSessionId(), context.getUserName());
        }

        public CacheID(ParseInfo pi, String sql, String vdbName, String vdbVersion, String sessionId, String userName) {
            Assertion.isNotNull((Object)sql);
            this.sql = sql;
            this.vdbInfo = new VDBKey(vdbName, vdbVersion);
            this.ansiIdentifiers = pi.ansiQuotedIdentifiers;
            this.originalSessionId = sessionId;
            this.originalUserName = userName;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public String getUserName() {
            return this.userName;
        }

        private void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public boolean setParameters(List<?> parameters) {
            if (parameters != null && !parameters.isEmpty()) {
                this.parameters = new ArrayList<Serializable>(parameters.size());
                for (Object obj : parameters) {
                    if (obj == null) {
                        this.parameters.add(null);
                        continue;
                    }
                    if (!(obj instanceof Serializable)) {
                        return false;
                    }
                    this.parameters.add((Serializable)obj);
                }
            }
            return true;
        }

        void setUserName(String name) {
            this.userName = name;
        }

        public VDBKey getVDBKey() {
            return this.vdbInfo;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CacheID)) {
                return false;
            }
            CacheID that = (CacheID)obj;
            return this.ansiIdentifiers == that.ansiIdentifiers && this.vdbInfo.equals(that.vdbInfo) && this.sql.equals(that.sql) && EquivalenceUtil.areEqual((Object)this.userName, (Object)that.userName) && EquivalenceUtil.areEqual((Object)this.sessionId, (Object)that.sessionId) && EquivalenceUtil.areEqual(this.parameters, that.parameters);
        }

        public int hashCode() {
            return HashCodeUtil.hashCode((int)0, (Object[])new Object[]{this.vdbInfo, this.sql, this.userName, this.sessionId, this.parameters});
        }

        public String toString() {
            return "Cache Entry<" + this.originalSessionId + "=" + this.originalUserName + "> params:" + this.parameters + " sql:" + this.sql;
        }
    }

    public static enum Type {
        RESULTSET,
        PREPAREDPLAN;

    }
}

