/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.id.IDGenerator;
import org.teiid.core.types.DataTypeManager;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Column;
import org.teiid.metadata.Table;
import org.teiid.metadata.Trigger;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.CommandPlanner;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.CollectionTupleSource;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.proc.ForEachRowPlan;
import org.teiid.query.processor.proc.ProcedurePlan;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.proc.TriggerAction;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.util.CommandContext;

public final class SourceTriggerActionPlanner
implements CommandPlanner {
    @Override
    public ProcessorPlan optimize(Command command, IDGenerator idGenerator, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        SourceEventCommand sec = (SourceEventCommand)command;
        HashMap<Expression, Integer> lookup = new HashMap<Expression, Integer>();
        HashMap<ElementSymbol, Expression> params = new HashMap<ElementSymbol, Expression>();
        ArrayList<Constant> tuple = new ArrayList<Constant>();
        TreeMap<String, Integer> map = null;
        if (sec.getColumnNames() != null) {
            map = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
            for (String name : sec.getColumnNames()) {
                map.put(name, map.size());
            }
        }
        GroupSymbol changingGroup = new GroupSymbol("CHANGING");
        if (sec.newValues != null) {
            GroupSymbol newGroup = new GroupSymbol("NEW");
            newGroup.setMetadataID(sec.table);
            for (int i = 0; i < sec.getTable().getColumns().size(); ++i) {
                Column c = (Column)sec.getTable().getColumns().get(i);
                Integer index = null;
                index = map != null ? (Integer)map.get(c.getName()) : Integer.valueOf(i);
                ElementSymbol newElement = new ElementSymbol(c.getName(), newGroup);
                newElement.setMetadataID(c);
                ElementSymbol changingElement = new ElementSymbol(c.getName(), changingGroup);
                lookup.put(newElement, tuple.size());
                lookup.put(changingElement, tuple.size() + 1);
                params.put(newElement, newElement);
                params.put(changingElement, changingElement);
                if (index == null) {
                    tuple.add(new Constant(null));
                    tuple.add(new Constant(Boolean.FALSE));
                    continue;
                }
                tuple.add(new Constant(DataTypeManager.convertToRuntimeType((Object)sec.newValues[index], (boolean)true)));
                tuple.add(new Constant(Boolean.TRUE));
            }
        }
        ArrayList<ProcessorPlan> plans = new ArrayList<ProcessorPlan>();
        ArrayList<String> names = new ArrayList<String>();
        block9: for (Trigger tr : sec.getTable().getTriggers().values()) {
            TriggerAction parseProcedure;
            int updateType = 3;
            switch (tr.getEvent()) {
                case DELETE: {
                    updateType = 4;
                    if (sec.newValues == null) break;
                    continue block9;
                }
                case INSERT: {
                    updateType = 2;
                    if (sec.oldValues == null) break;
                    continue block9;
                }
            }
            ForEachRowPlan result = new ForEachRowPlan();
            result.setParams(params);
            GroupSymbol gs = new GroupSymbol(sec.table.getFullName());
            try {
                parseProcedure = (TriggerAction)QueryParser.getQueryParser().parseProcedure(tr.getPlan(), true);
                QueryResolver.resolveCommand(parseProcedure, gs, updateType, metadata.getDesignTimeMetadata(), false);
            }
            catch (QueryParserException e) {
                throw new TeiidComponentException((Throwable)((Object)e));
            }
            catch (QueryResolverException e) {
                throw new TeiidComponentException((Throwable)((Object)e));
            }
            CreateProcedureCommand cpc = new CreateProcedureCommand(parseProcedure.getBlock());
            gs.setMetadataID(sec.table);
            cpc.setVirtualGroup(gs);
            cpc.setUpdateType(updateType);
            ProcedurePlan rowProcedure = (ProcedurePlan)QueryOptimizer.optimizePlan(cpc, metadata, idGenerator, capFinder, analysisRecord, context);
            rowProcedure.setRunInContext(false);
            result.setRowProcedure(rowProcedure);
            result.setLookupMap(lookup);
            result.setTupleSource(new CollectionTupleSource(Arrays.asList(tuple).iterator()));
            plans.add(result);
            names.add(tr.getName());
        }
        return new CompositeProcessorPlan(plans, names, sec.table);
    }

    public static class SourceEventCommand
    extends Command {
        private Table table;
        private Object[] oldValues;
        private Object[] newValues;
        private String[] columnNames;

        public SourceEventCommand(Table t, Object[] old, Object[] newValues, String[] columnNames) {
            this.table = t;
            this.oldValues = old;
            this.newValues = newValues;
            this.columnNames = columnNames;
        }

        @Override
        public void acceptVisitor(LanguageVisitor visitor) {
        }

        @Override
        public int getType() {
            return -1;
        }

        @Override
        public Object clone() {
            return this;
        }

        @Override
        public List<Expression> getProjectedSymbols() {
            return null;
        }

        @Override
        public boolean areResultsCachable() {
            return false;
        }

        public Table getTable() {
            return this.table;
        }

        public Object[] getOldValues() {
            return this.oldValues;
        }

        public Object[] getNewValues() {
            return this.newValues;
        }

        public String[] getColumnNames() {
            return this.columnNames;
        }

        @Override
        public String toString() {
            return "AFTER EVENT ON " + this.table;
        }
    }

    public static class CompositeProcessorPlan
    extends ProcessorPlan {
        private List<ProcessorPlan> plans;
        private int planIndex;
        private boolean open;
        private List<String> names;
        private Table table;

        public CompositeProcessorPlan(List<ProcessorPlan> plans, List<String> names, Table t) {
            this.plans = plans;
            this.names = names;
            this.table = t;
        }

        @Override
        public List getOutputElements() {
            return Command.getUpdateCommandSymbol();
        }

        @Override
        public void open() throws TeiidComponentException, TeiidProcessingException {
        }

        @Override
        public void initialize(CommandContext context, ProcessorDataManager dataMgr, BufferManager bufferMgr) {
            super.initialize(context, dataMgr, bufferMgr);
            for (ProcessorPlan plan : this.plans) {
                plan.initialize(context, dataMgr, bufferMgr);
            }
        }

        @Override
        public TupleBatch nextBatch() throws BlockedException, TeiidComponentException, TeiidProcessingException {
            while (this.planIndex < this.plans.size()) {
                try {
                    if (!this.open) {
                        this.plans.get(this.planIndex).open();
                    }
                    this.plans.get(this.planIndex).nextBatch();
                    this.plans.get(this.planIndex).close();
                }
                catch (TeiidProcessingException e) {
                    LogManager.logWarning((String)"org.teiid.PROCESSOR", (Throwable)e, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31214, new Object[]{this.names.get(this.planIndex), this.table}));
                }
                catch (BlockedException e) {
                    throw e;
                }
                this.open = false;
                ++this.planIndex;
            }
            return new TupleBatch(1L, new List[0]);
        }

        @Override
        public void close() throws TeiidComponentException {
        }

        @Override
        public ProcessorPlan clone() {
            throw new UnsupportedOperationException();
        }
    }
}

