/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.framework;

import org.teiid.core.util.StringUtil;
import org.teiid.test.framework.TestLogger;
import org.teiid.test.framework.TransactionQueryTestCase;
import org.teiid.test.framework.exception.TransactionRuntimeException;

public abstract class TransactionContainer {
    private String testClassName = null;

    protected TransactionContainer() {
    }

    protected void before(TransactionQueryTestCase test) {
    }

    protected void after(TransactionQueryTestCase test) {
    }

    public void runTransaction(TransactionQueryTestCase test) {
        this.testClassName = StringUtil.getLastToken((String)test.getClass().getName(), (String)".");
        try {
            this.debug("Start transaction test: " + test.getTestName());
            try {
                test.setup();
            }
            catch (TransactionRuntimeException tre) {
                if (!test.exceptionExpected()) {
                    tre.printStackTrace();
                }
                throw tre;
            }
            catch (Throwable e) {
                if (!test.exceptionExpected()) {
                    e.printStackTrace();
                }
                throw new TransactionRuntimeException(e.getMessage());
            }
            this.runTest(test);
            this.debug("Completed transaction test: " + test.getTestName());
        }
        finally {
            this.debug("\ttest.cleanup");
            test.cleanup();
        }
    }

    protected void runTest(TransactionQueryTestCase test) {
        this.debug("Start runTest: " + test.getTestName());
        this.debug("\tbefore(test)");
        this.before(test);
        this.debug("\ttest.before");
        test.before();
        this.debug("\ttest.testcase");
        try {
            test.testCase();
        }
        catch (Throwable e) {
            test.setApplicationException(e);
        }
        this.debug("\ttest.after");
        test.after();
        this.debug("\tafter(test)");
        this.after(test);
        this.debug("End runTest: " + test.getTestName());
    }

    protected void debug(String message) {
        TestLogger.logDebug("[" + this.testClassName + "] " + message);
    }

    protected void detail(String message) {
        TestLogger.log("[" + this.testClassName + "] " + message);
    }

    protected boolean done() {
        return true;
    }
}

