/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import org.teiid.api.exception.query.QueryParserException;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataRepository;
import org.teiid.metadata.Table;
import org.teiid.query.parser.QueryParser;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;

public class MaterializationMetadataRepository
extends MetadataRepository {
    public static final String ALLOW_MATVIEW_MANAGEMENT = "{http://www.teiid.org/ext/relational/2012}ALLOW_MATVIEW_MANAGEMENT";
    public static final String ON_VDB_START_SCRIPT = "{http://www.teiid.org/ext/relational/2012}ON_VDB_START_SCRIPT";
    public static final String ON_VDB_DROP_SCRIPT = "{http://www.teiid.org/ext/relational/2012}ON_VDB_DROP_SCRIPT";
    public static final String MATVIEW_AFTER_LOAD_SCRIPT = "{http://www.teiid.org/ext/relational/2012}MATVIEW_AFTER_LOAD_SCRIPT";
    public static final String MATVIEW_BEFORE_LOAD_SCRIPT = "{http://www.teiid.org/ext/relational/2012}MATVIEW_BEFORE_LOAD_SCRIPT";
    public static final String MATVIEW_LOAD_SCRIPT = "{http://www.teiid.org/ext/relational/2012}MATVIEW_LOAD_SCRIPT";
    public static final String MATVIEW_STATUS_TABLE = "{http://www.teiid.org/ext/relational/2012}MATVIEW_STATUS_TABLE";
    public static final String MATVIEW_TTL = "{http://www.teiid.org/ext/relational/2012}MATVIEW_TTL";
    public static final String MATVIEW_STAGE_TABLE = "{http://www.teiid.org/ext/relational/2012}MATERIALIZED_STAGE_TABLE";
    public static final String MATVIEW_SHARE_SCOPE = "{http://www.teiid.org/ext/relational/2012}MATVIEW_SHARE_SCOPE";
    public static final String MATVIEW_ONERROR_ACTION = "{http://www.teiid.org/ext/relational/2012}MATVIEW_ONERROR_ACTION";
    public static final String MATVIEW_UPDATABLE = "{http://www.teiid.org/ext/relational/2012}MATVIEW_UPDATABLE";
    public static final String MATVIEW_PREFER_MEMORY = "{http://www.teiid.org/ext/relational/2012}MATVIEW_PREFER_MEMORY";
    public static final String MATVIEW_SCOPE = "{http://www.teiid.org/ext/relational/2012}MATVIEW_SCOPE";
    public static final String MATVIEW_LOADNUMBER_COLUMN = "{http://www.teiid.org/ext/relational/2012}MATVIEW_LOADNUMBER_COLUMN";
    public static final String MATVIEW_WRITE_THROUGH = "{http://www.teiid.org/ext/relational/2012}MATVIEW_WRITE_THROUGH";

    public void loadMetadata(MetadataFactory factory, ExecutionFactory executionFactory, Object connectionFactory) throws TranslatorException {
        for (Table table : factory.getSchema().getTables().values()) {
            String manage;
            if (!table.isMaterialized() || table.getMaterializedTable() == null || !Boolean.valueOf(manage = table.getProperty(ALLOW_MATVIEW_MANAGEMENT, false)).booleanValue()) continue;
            this.fixScript(ON_VDB_START_SCRIPT, table);
            this.fixScript(ON_VDB_DROP_SCRIPT, table);
            this.fixScript(MATVIEW_BEFORE_LOAD_SCRIPT, table);
            this.fixScript(MATVIEW_AFTER_LOAD_SCRIPT, table);
            this.fixScript(MATVIEW_LOAD_SCRIPT, table);
        }
    }

    private String fixScript(String property, Table table) {
        String script = table.getProperty(property, false);
        if (script == null) {
            return null;
        }
        if (!script.contains(";")) {
            return script;
        }
        QueryParser parser = QueryParser.getQueryParser();
        try {
            parser.parseCommand(script);
            return script;
        }
        catch (QueryParserException queryParserException) {
            String wrapped = "begin " + script + "; end";
            try {
                parser.parseCommand(wrapped);
                table.setProperty(property, wrapped);
                return wrapped;
            }
            catch (QueryParserException queryParserException2) {
                wrapped = "begin " + script + " end";
                try {
                    parser.parseCommand(wrapped);
                    table.setProperty(property, wrapped);
                    return wrapped;
                }
                catch (QueryParserException queryParserException3) {
                    return script;
                }
            }
        }
    }

    public static enum ErrorAction {
        THROW_EXCEPTION,
        IGNORE,
        WAIT;

    }

    public static enum Scope {
        NONE,
        VDB,
        SCHEMA;

    }

    public static enum LoadStates {
        NEEDS_LOADING,
        LOADING,
        LOADED,
        FAILED_LOAD;

    }
}

