/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.teiid.client.DQP;
import org.teiid.client.RequestMessage;
import org.teiid.client.ResultsMessage;
import org.teiid.client.util.ResultsFuture;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.StatementImpl;
import org.teiid.net.ServerConnection;

public class TestStatement {
    @Test
    public void testBatchExecution() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Mockito.stub((Object)conn.getConnectionProps()).toReturn((Object)new Properties());
        DQP dqp = (DQP)Mockito.mock(DQP.class);
        ResultsFuture results = new ResultsFuture();
        Mockito.stub((Object)dqp.executeRequest(Mockito.anyLong(), (RequestMessage)Mockito.anyObject())).toReturn((Object)results);
        ResultsMessage rm = new ResultsMessage();
        rm.setResults(new List[]{Arrays.asList(1), Arrays.asList(2)});
        rm.setUpdateResult(true);
        results.getResultsReceiver().receiveResults((Object)rm);
        Mockito.stub((Object)conn.getDQP()).toReturn((Object)dqp);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        statement.clearBatch();
        statement.addBatch("delete from table");
        statement.addBatch("delete from table1");
        Assert.assertTrue((boolean)Arrays.equals(new int[]{1, 2}, statement.executeBatch()));
    }

    @Test
    public void testWarnings() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Mockito.stub((Object)conn.getConnectionProps()).toReturn((Object)new Properties());
        DQP dqp = (DQP)Mockito.mock(DQP.class);
        ResultsFuture results = new ResultsFuture();
        Mockito.stub((Object)dqp.executeRequest(Mockito.anyLong(), (RequestMessage)Mockito.anyObject())).toReturn((Object)results);
        ResultsMessage rm = new ResultsMessage();
        rm.setResults(new List[]{Arrays.asList(1)});
        rm.setWarnings(Arrays.asList(new Throwable()));
        rm.setColumnNames(new String[]{"expr1"});
        rm.setDataTypes(new String[]{"string"});
        results.getResultsReceiver().receiveResults((Object)rm);
        Mockito.stub((Object)conn.getDQP()).toReturn((Object)dqp);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007){

            protected TimeZone getServerTimeZone() throws SQLException {
                return null;
            }
        };
        statement.execute("select 'a'");
        Assert.assertNotNull((Object)statement.getResultSet());
        SQLWarning warning = statement.getWarnings();
        Assert.assertNotNull((Object)warning);
        Assert.assertNull((Object)warning.getNextWarning());
    }

    @Test
    public void testGetMoreResults() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Mockito.stub((Object)conn.getConnectionProps()).toReturn((Object)new Properties());
        DQP dqp = (DQP)Mockito.mock(DQP.class);
        ResultsFuture results = new ResultsFuture();
        Mockito.stub((Object)dqp.executeRequest(Mockito.anyLong(), (RequestMessage)Mockito.anyObject())).toReturn((Object)results);
        ResultsMessage rm = new ResultsMessage();
        rm.setUpdateResult(true);
        rm.setColumnNames(new String[]{"expr1"});
        rm.setDataTypes(new String[]{"integer"});
        rm.setResults(new List[]{Arrays.asList(1)});
        results.getResultsReceiver().receiveResults((Object)rm);
        Mockito.stub((Object)conn.getDQP()).toReturn((Object)dqp);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007){

            protected TimeZone getServerTimeZone() throws SQLException {
                return null;
            }
        };
        statement.execute("update x set a = b");
        Assert.assertEquals((long)1L, (long)statement.getUpdateCount());
        statement.getMoreResults(3);
        Assert.assertEquals((long)-1L, (long)statement.getUpdateCount());
        statement = new StatementImpl(conn, 1003, 1007){

            protected TimeZone getServerTimeZone() throws SQLException {
                return null;
            }
        };
        statement.execute("update x set a = b");
        Assert.assertEquals((long)1L, (long)statement.getUpdateCount());
        statement.getMoreResults();
        Assert.assertEquals((long)-1L, (long)statement.getUpdateCount());
    }

    @Test
    public void testSetStatement() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        Assert.assertFalse((boolean)statement.execute("set foo bar"));
        ((ConnectionImpl)Mockito.verify((Object)conn)).setExecutionProperty("foo", "bar");
        Assert.assertFalse((boolean)statement.execute("set foo 'b''ar' ; "));
        ((ConnectionImpl)Mockito.verify((Object)conn)).setExecutionProperty("foo", "b'ar");
        Assert.assertFalse((boolean)statement.execute("set \"foo\" 'b''a1r' ; "));
        ((ConnectionImpl)Mockito.verify((Object)conn)).setExecutionProperty("foo", "b'a1r");
    }

    @Test
    public void testSetPayloadStatement() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Properties p = new Properties();
        Mockito.stub((Object)conn.getExecutionProperties()).toReturn((Object)p);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        Assert.assertFalse((boolean)statement.execute("set payload foo bar"));
    }

    @Test
    public void testSetAuthorizationStatement() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Properties p = new Properties();
        Mockito.stub((Object)conn.getExecutionProperties()).toReturn((Object)p);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        Assert.assertFalse((boolean)statement.execute("set session authorization bar"));
        ((ConnectionImpl)Mockito.verify((Object)conn)).changeUser("bar", null);
    }

    @Test
    public void testPropertiesOverride() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Properties p = new Properties();
        p.setProperty("ansiQuotedIdentifiers", Boolean.TRUE.toString());
        Mockito.stub((Object)conn.getExecutionProperties()).toReturn((Object)p);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        Assert.assertEquals((Object)Boolean.TRUE.toString(), (Object)statement.getExecutionProperty("ansiQuotedIdentifiers"));
        statement.setExecutionProperty("ansiQuotedIdentifiers", Boolean.FALSE.toString());
        Assert.assertEquals((Object)Boolean.FALSE.toString(), (Object)statement.getExecutionProperty("ansiQuotedIdentifiers"));
        Assert.assertEquals((Object)Boolean.TRUE.toString(), (Object)p.getProperty("ansiQuotedIdentifiers"));
    }

    @Test
    public void testTransactionStatements() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Properties p = new Properties();
        Mockito.stub((Object)conn.getExecutionProperties()).toReturn((Object)p);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        Assert.assertFalse((boolean)statement.execute("start transaction"));
        ((ConnectionImpl)Mockito.verify((Object)conn)).setAutoCommit(false);
        Assert.assertFalse((boolean)statement.execute("commit"));
        ((ConnectionImpl)Mockito.verify((Object)conn)).setAutoCommit(true);
        Assert.assertFalse((boolean)statement.execute("start transaction"));
        Assert.assertFalse((boolean)statement.execute("rollback"));
        ((ConnectionImpl)Mockito.verify((Object)conn)).rollback(false);
    }

    @Test
    public void testDisableLocalTransations() throws Exception {
        ServerConnection mock = (ServerConnection)Mockito.mock(ServerConnection.class);
        DQP dqp = (DQP)Mockito.mock(DQP.class);
        Mockito.stub((Object)mock.getService(DQP.class)).toReturn((Object)dqp);
        ConnectionImpl conn = new ConnectionImpl(mock, new Properties(), "x");
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        Assert.assertTrue((boolean)conn.getAutoCommit());
        statement.execute("set disablelocaltxn true");
        Assert.assertFalse((boolean)statement.execute("start transaction"));
        conn.beginLocalTxnIfNeeded();
        Assert.assertFalse((boolean)conn.isInLocalTxn());
        statement.execute("set disablelocaltxn false");
        Assert.assertFalse((boolean)statement.execute("start transaction"));
        conn.beginLocalTxnIfNeeded();
        Assert.assertTrue((boolean)conn.isInLocalTxn());
    }

    @Test
    public void testTransactionStatementsAsynch() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Mockito.stub((Object)conn.submitSetAutoCommitTrue(Mockito.anyBoolean())).toReturn((Object)ResultsFuture.NULL_FUTURE);
        Properties p = new Properties();
        Mockito.stub((Object)conn.getExecutionProperties()).toReturn((Object)p);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        statement.submitExecute("start transaction", null);
        ((ConnectionImpl)Mockito.verify((Object)conn)).setAutoCommit(false);
        statement.submitExecute("commit", null);
        ((ConnectionImpl)Mockito.verify((Object)conn)).submitSetAutoCommitTrue(true);
        statement.submitExecute("start transaction", null);
        statement.submitExecute("rollback", null);
        ((ConnectionImpl)Mockito.verify((Object)conn)).submitSetAutoCommitTrue(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsynchTimeout() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Mockito.stub((Object)conn.getConnectionProps()).toReturn((Object)new Properties());
        final StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        statement.setQueryTimeoutMS(1);
        DQP dqp = (DQP)Mockito.mock(DQP.class);
        Mockito.stub((Object)statement.getDQP()).toReturn((Object)dqp);
        final AtomicInteger counter = new AtomicInteger();
        Mockito.stub((Object)dqp.cancelRequest(0L)).toAnswer((Answer)new Answer<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                StatementImpl statementImpl = statement;
                synchronized (statementImpl) {
                    counter.incrementAndGet();
                    statement.notifyAll();
                }
                return true;
            }
        });
        ResultsFuture future = new ResultsFuture();
        Mockito.stub((Object)dqp.executeRequest(Mockito.anyLong(), (RequestMessage)Mockito.anyObject())).toReturn((Object)future);
        statement.submitExecute("select 'hello world'", null);
        StatementImpl statementImpl = statement;
        synchronized (statementImpl) {
            while (counter.get() != 1) {
                statement.wait();
            }
        }
        statement.setQueryTimeoutMS(1);
        statement.submitExecute("select 'hello world'", null);
        statementImpl = statement;
        synchronized (statementImpl) {
            while (counter.get() != 2) {
                statement.wait();
            }
        }
    }

    @Test
    public void testTimeoutProperty() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Properties p = new Properties();
        p.setProperty("QUERYTIMEOUT", "2");
        Mockito.stub((Object)conn.getExecutionProperties()).toReturn((Object)p);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        Assert.assertEquals((long)2L, (long)statement.getQueryTimeout());
    }

    @Test
    public void testUseJDBC4ColumnNameAndLabelSemantics() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Properties p = new Properties();
        p.setProperty("useJDBC4ColumnNameAndLabelSemantics", "false");
        Mockito.stub((Object)conn.getExecutionProperties()).toReturn((Object)p);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        Assert.assertEquals((Object)Boolean.FALSE.toString(), (Object)statement.getExecutionProperty("useJDBC4ColumnNameAndLabelSemantics"));
    }

    @Test
    public void testSet() {
        Matcher m = StatementImpl.SET_STATEMENT.matcher("set foo to 1");
        Assert.assertTrue((boolean)m.matches());
    }

    @Test
    public void testQuotedSet() {
        Matcher m = StatementImpl.SET_STATEMENT.matcher("set \"foo\"\"\" to 1");
        Assert.assertTrue((boolean)m.matches());
        Assert.assertEquals((Object)"\"foo\"\"\"", (Object)m.group(2));
        m = StatementImpl.SHOW_STATEMENT.matcher("show \"foo\"");
        Assert.assertTrue((boolean)m.matches());
    }

    @Test
    public void testSetTxnIsolationLevel() throws SQLException {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        StatementImpl statement = new StatementImpl(conn, 1003, 1007);
        Assert.assertFalse((boolean)statement.execute("set session characteristics as transaction isolation level read committed"));
        ((ConnectionImpl)Mockito.verify((Object)conn)).setTransactionIsolation(2);
        Assert.assertFalse((boolean)statement.execute("set session characteristics as transaction isolation level read uncommitted"));
        ((ConnectionImpl)Mockito.verify((Object)conn)).setTransactionIsolation(1);
        Assert.assertFalse((boolean)statement.execute("set session characteristics as transaction isolation level serializable"));
        ((ConnectionImpl)Mockito.verify((Object)conn)).setTransactionIsolation(8);
        Assert.assertFalse((boolean)statement.execute("set session characteristics as transaction isolation level repeatable read"));
        ((ConnectionImpl)Mockito.verify((Object)conn)).setTransactionIsolation(4);
    }
}

