/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.ExtensibleBufferedInputStream;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.StorageManager;
import org.teiid.common.buffer.impl.FileStorageManager;
import org.teiid.common.buffer.impl.SplittableStorageManager;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.util.UnitTestUtil;

public class TestFileStorageManager {
    static Random r = new Random();

    public static FileStorageManager getStorageManager(Integer openFiles, String dir) throws TeiidComponentException {
        FileStorageManager sm = new FileStorageManager();
        sm.setStorageDirectory(UnitTestUtil.getTestScratchPath() + (dir != null ? File.separator + dir : ""));
        if (openFiles != null) {
            sm.setMaxOpenFiles(openFiles.intValue());
        }
        sm.initialize();
        return sm;
    }

    @Test
    public void testInitialRead() throws Exception {
        FileStorageManager sm = TestFileStorageManager.getStorageManager(null, null);
        String tsID = "0";
        FileStore store = sm.createFileStore(tsID);
        Assert.assertEquals((long)-1L, (long)store.read(0L, new byte[1], 0, 1));
    }

    @Test
    public void testWrite() throws Exception {
        FileStorageManager sm = TestFileStorageManager.getStorageManager(null, null);
        String tsID = "0";
        FileStore store = sm.createFileStore(tsID);
        TestFileStorageManager.writeBytes(store);
        Assert.assertEquals((long)2048L, (long)sm.getUsedBufferSpace());
        store.remove();
        Assert.assertEquals((long)0L, (long)sm.getUsedBufferSpace());
    }

    @Test
    public void testPositionalWrite() throws Exception {
        FileStorageManager sm = TestFileStorageManager.getStorageManager(null, null);
        String tsID = "0";
        FileStore store = sm.createFileStore(tsID);
        byte[] expectedBytes = TestFileStorageManager.writeBytes(store, 2048L);
        Assert.assertEquals((long)4096L, (long)sm.getUsedBufferSpace());
        TestFileStorageManager.writeBytes(store, 4096L);
        Assert.assertEquals((long)6144L, (long)sm.getUsedBufferSpace());
        byte[] bytesRead = new byte[2048];
        store.readFully(2048L, bytesRead, 0, bytesRead.length);
        Assert.assertArrayEquals((byte[])expectedBytes, (byte[])bytesRead);
        store.remove();
        Assert.assertEquals((long)0L, (long)sm.getUsedBufferSpace());
    }

    @Test(expected=IOException.class)
    public void testMaxSpace() throws Exception {
        FileStorageManager sm = TestFileStorageManager.getStorageManager(null, null);
        sm.setMaxBufferSpace(1L);
        String tsID = "0";
        FileStore store = sm.createFileStore(tsID);
        TestFileStorageManager.writeBytes(store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IOException.class)
    public void testMaxSpaceSplit() throws Exception {
        FileStorageManager sm = TestFileStorageManager.getStorageManager(null, null);
        sm.setMaxBufferSpace(1L);
        String tsID = "0";
        SplittableStorageManager ssm = new SplittableStorageManager((StorageManager)sm);
        FileStore store = ssm.createFileStore(tsID);
        try {
            TestFileStorageManager.writeBytes(store);
        }
        finally {
            Assert.assertEquals((long)0L, (long)sm.getUsedBufferSpace());
        }
    }

    @Test
    public void testSetLength() throws Exception {
        FileStorageManager sm = TestFileStorageManager.getStorageManager(null, null);
        String tsID = "0";
        FileStore store = sm.createFileStore(tsID);
        store.setLength(1000L);
        Assert.assertEquals((long)1000L, (long)sm.getUsedBufferSpace());
        store.setLength(200L);
        Assert.assertEquals((long)200L, (long)sm.getUsedBufferSpace());
        store.setLength(1000L);
        Assert.assertEquals((long)1000L, (long)sm.getUsedBufferSpace());
    }

    @Test
    public void testFlush() throws Exception {
        FileStorageManager sm = TestFileStorageManager.getStorageManager(null, null);
        FileStore store = sm.createFileStore("0");
        FileStore.FileStoreOutputStream fsos = store.createOutputStream(2);
        fsos.write(new byte[3]);
        fsos.write(1);
        fsos.flush();
        Assert.assertEquals((long)0L, (long)fsos.getCount());
    }

    @Test
    public void testGrowth() throws Exception {
        FileStorageManager sm = TestFileStorageManager.getStorageManager(null, null);
        FileStore store = sm.createFileStore("0");
        FileStore.FileStoreOutputStream fsos = store.createOutputStream(32768);
        Assert.assertTrue((fsos.getBuffer().length < 32768 ? 1 : 0) != 0);
        fsos.write(1);
        fsos.write(new byte[16384]);
        fsos.flush();
        Assert.assertEquals((long)16385L, (long)fsos.getCount());
        Assert.assertEquals((long)32768L, (long)fsos.getBuffer().length);
    }

    @Test
    public void testClose() throws Exception {
        FileStorageManager sm = TestFileStorageManager.getStorageManager(null, null);
        FileStore store = sm.createFileStore("0");
        FileStore.FileStoreOutputStream fsos = store.createOutputStream(2);
        fsos.write(new byte[100000]);
        fsos.close();
        fsos.close();
    }

    static void writeBytes(FileStore store) throws IOException {
        TestFileStorageManager.writeBytes(store, store.getLength());
    }

    static byte[] writeBytes(FileStore store, long start) throws IOException {
        byte[] bytes = new byte[2048];
        r.nextBytes(bytes);
        store.write(start, bytes, 0, bytes.length);
        byte[] bytesRead = new byte[2048];
        store.readFully(start, bytesRead, 0, bytesRead.length);
        Assert.assertTrue((boolean)Arrays.equals(bytes, bytesRead));
        return bytes;
    }

    @Test
    public void testWritingMultipleFiles() throws Exception {
        FileStorageManager sm = TestFileStorageManager.getStorageManager(null, null);
        String tsID = "0";
        FileStore store = sm.createFileStore(tsID);
        String contentOrig = new String("some file content this will stored in same tmp file with another");
        OutputStream out = store.createOutputStream();
        out.write(contentOrig.getBytes(), 0, contentOrig.getBytes().length);
        out.close();
        out = store.createOutputStream();
        long start = store.getLength();
        byte[] bytesOrig = new byte[2048];
        r.nextBytes(bytesOrig);
        out.write(bytesOrig, 0, 2048);
        byte[] readContent = new byte[2048];
        ExtensibleBufferedInputStream in = store.createInputStream(0L, (long)contentOrig.getBytes().length);
        int c = in.read(readContent, 0, 3000);
        Assert.assertEquals((Object)contentOrig, (Object)new String(readContent, 0, c));
        c = in.read(readContent, 0, 3000);
        Assert.assertEquals((long)-1L, (long)c);
        in.close();
        in = store.createInputStream(start, 2048L);
        c = in.read(readContent, 0, 3000);
        Assert.assertTrue((boolean)Arrays.equals(bytesOrig, readContent));
        c = in.read(readContent, 0, 3000);
        Assert.assertEquals((long)-1L, (long)c);
        in.close();
    }
}

