/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.StringUtil;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.MetadataException;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Table;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.FunctionMethods;
import org.teiid.query.metadata.DatabaseStore;
import org.teiid.query.parser.ParseException;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.parser.SQLParser;
import org.teiid.query.parser.Token;
import org.teiid.query.sql.lang.AlterTrigger;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.SourceHint;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.WithQueryCommand;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.Statement;
import org.teiid.query.sql.proc.TriggerAction;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;

public class SQLParserUtil {
    static final Pattern hintPattern = Pattern.compile("\\s*(\\w+(?:\\(\\s*(max:\\d+)?\\s*((?:no)?\\s*join)\\s*\\))?)\\s*", 34);
    public static final boolean DECIMAL_AS_DOUBLE = PropertiesUtils.getBooleanProperty((Properties)System.getProperties(), (String)"org.teiid.decimalAsDouble", (boolean)false);
    private static Pattern SOURCE_HINT = Pattern.compile("\\s*sh(\\s+KEEP ALIASES)?\\s*(?::((?:'[^']*')+))?\\s*", 34);
    private static Pattern SOURCE_HINT_ARG = Pattern.compile("\\s*([^: ]+)(\\s+KEEP ALIASES)?\\s*:((?:'[^']*')+)", 34);
    private static Pattern HINT = Pattern.compile("\\s*/\\*([^/]*)\\*/", 34);
    private static Pattern CACHE_HINT = Pattern.compile("\\+?\\s*cache(\\(\\s*(pref_mem)?\\s*(ttl:\\d{1,19})?\\s*(updatable)?\\s*(scope:(session|vdb|user))?\\s*(min:\\d{1,19})?[^\\)]*\\))?[^\\*]*", 34);

    String prependSign(String sign, String literal) {
        if (sign != null && sign.charAt(0) == '-') {
            return sign + literal;
        }
        return literal;
    }

    void convertToParameters(List<Expression> values, StoredProcedure storedProcedure, int paramIndex) {
        for (Expression value : values) {
            SPParameter parameter = new SPParameter(paramIndex++, value);
            parameter.setParameterType(1);
            storedProcedure.setParameter(parameter);
        }
    }

    String matchesAny(String arg, String ... expected) {
        for (String string : expected) {
            if (!string.equalsIgnoreCase(arg)) continue;
            return arg;
        }
        return null;
    }

    String normalizeStringLiteral(String s) {
        int start = 1;
        boolean unescape = false;
        if (s.charAt(0) == 'N') {
            ++start;
        } else if (s.charAt(0) == 'E') {
            ++start;
            unescape = true;
        }
        char tickChar = s.charAt(start - 1);
        s = s.substring(start, s.length() - 1);
        String result = SQLParserUtil.removeEscapeChars(s, String.valueOf(tickChar));
        if (unescape) {
            result = FunctionMethods.unescape(result);
        }
        return result;
    }

    public static String normalizeId(String s) {
        if (s.indexOf(34) == -1) {
            return s;
        }
        LinkedList<String> nameParts = new LinkedList<String>();
        block0: while (s.length() > 0) {
            if (s.charAt(0) == '\"') {
                boolean escape = false;
                for (int i = 1; i < s.length(); ++i) {
                    boolean end;
                    if (s.charAt(i) != '\"') continue;
                    escape = !escape;
                    boolean bl = end = i == s.length() - 1;
                    if (!end && (!escape || s.charAt(i + 1) != '.')) continue;
                    String part = s.substring(1, i);
                    s = s.substring(i + (end ? 1 : 2));
                    nameParts.add(SQLParserUtil.removeEscapeChars(part, "\""));
                    continue block0;
                }
                continue;
            }
            int index = s.indexOf(46);
            if (index == -1) {
                nameParts.add(s);
                break;
            }
            nameParts.add(s.substring(0, index));
            s = s.substring(index + 1);
        }
        StringBuilder sb = new StringBuilder();
        Iterator i = nameParts.iterator();
        while (i.hasNext()) {
            sb.append((String)i.next());
            if (!i.hasNext()) continue;
            sb.append('.');
        }
        return sb.toString();
    }

    boolean isStringLiteral(String str, ParseInfo info) {
        if (info.useAnsiQuotedIdentifiers() || str.charAt(0) != '\"' || str.charAt(str.length() - 1) != '\"') {
            return false;
        }
        for (int index = 1; index < str.length() - 1; index += 2) {
            if ((index = str.indexOf(34, index)) == -1 || index + 1 == str.length()) {
                return true;
            }
            if (str.charAt(index + 1) == '\"') continue;
            return false;
        }
        return true;
    }

    String validateName(String id, boolean nonAlias) throws ParseException {
        if (id.indexOf(46) != -1) {
            String key = "SQLParser.Invalid_alias";
            if (nonAlias) {
                key = "SQLParser.Invalid_short_name";
            }
            throw new ParseException(QueryPlugin.Util.getString(key, new Object[]{id}));
        }
        return id;
    }

    static String removeEscapeChars(String str, String tickChar) {
        return StringUtil.replaceAll((String)str, (String)(tickChar + tickChar), (String)tickChar);
    }

    void setFromClauseOptions(Token groupID, FromClause fromClause) {
        String comment = this.getComment(groupID);
        if (comment == null || comment.isEmpty()) {
            return;
        }
        Matcher m = hintPattern.matcher(comment);
        int start = 0;
        while (m.find(start)) {
            String hint = m.group(1);
            start = m.end();
            if (StringUtil.startsWithIgnoreCase((String)hint, (String)"make")) {
                Option.MakeDep option;
                if (hint.equalsIgnoreCase("MAKENOTDEP")) {
                    fromClause.setMakeNotDep(true);
                    continue;
                }
                if (StringUtil.startsWithIgnoreCase((String)hint, (String)"MAKEDEP")) {
                    option = new Option.MakeDep();
                    fromClause.setMakeDep(option);
                    this.parseOptions(m, option);
                    continue;
                }
                if (!StringUtil.startsWithIgnoreCase((String)hint, (String)"MAKEIND")) continue;
                option = new Option.MakeDep();
                fromClause.setMakeInd(option);
                this.parseOptions(m, option);
                continue;
            }
            if (hint.equalsIgnoreCase(ExistsCriteria.SubqueryHint.NOUNNEST)) {
                fromClause.setNoUnnest(true);
                continue;
            }
            if (hint.equalsIgnoreCase("PRESERVE")) {
                fromClause.setPreserve(true);
                continue;
            }
            if (!hint.equalsIgnoreCase("optional")) continue;
            fromClause.setOptional(true);
        }
    }

    void parseWithHints(Token paren, WithQueryCommand with) {
        String[] parts;
        String comment = this.getComment(paren);
        if (comment == null || comment.isEmpty()) {
            return;
        }
        for (String part : parts = comment.split("\\s")) {
            if ("no_inline".equalsIgnoreCase(part)) {
                with.setNoInline(true);
                continue;
            }
            if (!"materialize".equalsIgnoreCase(part)) continue;
            with.setMaterialize(true);
        }
    }

    private void parseOptions(Matcher m, Option.MakeDep option) {
        if (m.group(3) != null) {
            if (StringUtil.startsWithIgnoreCase((String)m.group(3), (String)"no")) {
                option.setJoin(false);
            } else {
                option.setJoin(true);
            }
        }
        if (m.group(2) != null) {
            option.setMax(Integer.valueOf(m.group(2).trim().substring(4)));
        }
    }

    ExistsCriteria.SubqueryHint getSubqueryHint(Token t) {
        ExistsCriteria.SubqueryHint hint = new ExistsCriteria.SubqueryHint();
        String[] parts = this.getComment(t).split("\\s");
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].equalsIgnoreCase(ExistsCriteria.SubqueryHint.MJ)) {
                hint.setMergeJoin(true);
                continue;
            }
            if (parts[i].equalsIgnoreCase(ExistsCriteria.SubqueryHint.NOUNNEST)) {
                hint.setNoUnnest(true);
                continue;
            }
            if (!parts[i].equalsIgnoreCase(ExistsCriteria.SubqueryHint.DJ)) continue;
            hint.setDepJoin();
        }
        return hint;
    }

    String getComment(Token t) {
        Token optToken = t.specialToken;
        if (optToken == null) {
            return "";
        }
        String image = optToken.image;
        while (optToken.specialToken != null) {
            optToken = optToken.specialToken;
            image = optToken.image + image;
        }
        String hint = image.substring(2, image.length() - 2);
        if (hint.startsWith("+")) {
            hint = hint.substring(1);
        }
        return hint;
    }

    SourceHint getSourceHint(SQLParser parser) {
        String generalHint;
        int index = 1;
        Token t = null;
        while ((t = parser.getToken(index++)) != null && t.kind == 410) {
        }
        t = parser.getToken(index);
        if (t == null) {
            return null;
        }
        String comment = this.getComment(t);
        Matcher matcher = SOURCE_HINT.matcher(comment);
        if (!matcher.find()) {
            return null;
        }
        SourceHint sourceHint = new SourceHint();
        if (matcher.group(1) != null) {
            sourceHint.setUseAliases(true);
        }
        if ((generalHint = matcher.group(2)) != null) {
            sourceHint.setGeneralHint(this.normalizeStringLiteral(generalHint));
        }
        int end = matcher.end();
        matcher = SOURCE_HINT_ARG.matcher(comment);
        while (matcher.find(end)) {
            end = matcher.end();
            sourceHint.setSourceHint(matcher.group(1), this.normalizeStringLiteral(matcher.group(3)), matcher.group(2) != null);
        }
        return sourceHint;
    }

    void setSourceHint(SourceHint sourceHint, Command command) {
        if (sourceHint != null) {
            if (command instanceof SetQuery) {
                ((SetQuery)command).getProjectedQuery().setSourceHint(sourceHint);
            } else {
                command.setSourceHint(sourceHint);
            }
        }
    }

    boolean isNonStrictHint(Token t) {
        String[] parts = this.getComment(t).split("\\s");
        for (int i = 0; i < parts.length; ++i) {
            if (!parts[i].equalsIgnoreCase(Limit.NON_STRICT)) continue;
            return true;
        }
        return false;
    }

    static CacheHint getQueryCacheOption(String query) {
        Matcher hintMatch = HINT.matcher(query);
        int start = 0;
        while (hintMatch.find() && start == hintMatch.start()) {
            String min;
            String scope;
            String ttl;
            start = hintMatch.end();
            Matcher match = CACHE_HINT.matcher(hintMatch.group(1));
            if (!match.matches()) continue;
            CacheHint hint = new CacheHint();
            if (match.group(2) != null) {
                hint.setPrefersMemory(true);
            }
            if ((ttl = match.group(3)) != null) {
                hint.setTtl(Long.valueOf(ttl.substring(4)));
            }
            if (match.group(4) != null) {
                hint.setUpdatable(true);
            }
            if ((scope = match.group(5)) != null) {
                scope = scope.substring(6);
                hint.setScope(scope);
            }
            if ((min = match.group(7)) != null) {
                hint.setMinRows(Long.valueOf(min.substring(4)));
            }
            return hint;
        }
        return null;
    }

    int getOperator(String opString) {
        if (opString.equals("=")) {
            return 1;
        }
        if (opString.equals("<>") || opString.equals("!=")) {
            return 2;
        }
        if (opString.equals("<")) {
            return 3;
        }
        if (opString.equals(">")) {
            return 4;
        }
        if (opString.equals("<=")) {
            return 5;
        }
        if (opString.equals(">=")) {
            return 6;
        }
        Assertion.failed((String)"unknown operator");
        return 0;
    }

    SetQuery addQueryToSetOperation(QueryCommand query, QueryCommand rightQuery, SetQuery.Operation type, boolean all) {
        SetQuery setQuery = new SetQuery(type, all, query, rightQuery);
        return setQuery;
    }

    static Block asBlock(Statement stmt) {
        if (stmt == null) {
            return null;
        }
        if (stmt instanceof Block) {
            return (Block)stmt;
        }
        return new Block(stmt);
    }

    static FunctionMethod replaceProcedureWithFunction(MetadataFactory factory, Procedure proc) throws MetadataException {
        if (proc.isFunction() && proc.getQueryPlan() != null) {
            return null;
        }
        FunctionMethod method = SQLParserUtil.createFunctionMethod(proc);
        factory.getSchema().getResolvingOrder().remove(factory.getSchema().getResolvingOrder().size() - 1);
        factory.getSchema().getProcedures().remove(proc.getName());
        factory.getSchema().addFunction(method);
        return method;
    }

    public static FunctionMethod createFunctionMethod(Procedure proc) {
        FunctionMethod method = new FunctionMethod();
        method.setName(proc.getName());
        method.setPushdown(proc.isVirtual() ? FunctionMethod.PushDown.CAN_PUSHDOWN : FunctionMethod.PushDown.MUST_PUSHDOWN);
        ArrayList<FunctionParameter> ins = new ArrayList<FunctionParameter>();
        for (ProcedureParameter pp : proc.getParameters()) {
            if (pp.getType() == ProcedureParameter.Type.InOut || pp.getType() == ProcedureParameter.Type.Out) {
                throw new MetadataException(QueryPlugin.Util.getString("SQLParser.function_in", new Object[]{proc.getName()}));
            }
            FunctionParameter fp = new FunctionParameter(pp.getName(), pp.getRuntimeType(), pp.getAnnotation());
            fp.setDatatype(pp.getDatatype(), true, pp.getArrayDimensions());
            fp.setLength(pp.getLength());
            fp.setNameInSource(pp.getNameInSource());
            fp.setNativeType(pp.getNativeType());
            fp.setNullType(pp.getNullType());
            fp.setProperties(pp.getProperties());
            fp.setRadix(pp.getRadix());
            fp.setScale(pp.getScale());
            fp.setUUID(pp.getUUID());
            if (pp.getType() == ProcedureParameter.Type.In) {
                fp.setVarArg(pp.isVarArg());
                ins.add(fp);
                fp.setPosition(ins.size());
                continue;
            }
            method.setOutputParameter(fp);
            fp.setPosition(0);
        }
        method.setInputParameters(ins);
        if (proc.getResultSet() != null || method.getOutputParameter() == null) {
            throw new MetadataException(QueryPlugin.Util.getString("SQLParser.function_return", new Object[]{proc.getName()}));
        }
        method.setAnnotation(proc.getAnnotation());
        method.setNameInSource(proc.getNameInSource());
        method.setUUID(proc.getUUID());
        Map props = proc.getProperties();
        String value = (String)props.remove("CATEGORY");
        method.setCategory(value);
        value = (String)props.remove("DETERMINISM");
        if (value != null) {
            method.setDeterminism(FunctionMethod.Determinism.valueOf((String)value.toUpperCase()));
        }
        value = (String)props.remove("JAVA_CLASS");
        method.setInvocationClass(value);
        value = (String)props.remove("JAVA_METHOD");
        method.setInvocationMethod(value);
        for (String key : props.keySet()) {
            value = (String)props.get(key);
            method.setProperty(key, value);
        }
        FunctionMethod.convertExtensionMetadata((Procedure)proc, (FunctionMethod)method);
        if (method.getInvocationMethod() != null) {
            method.setPushdown(FunctionMethod.PushDown.CAN_PUSHDOWN);
        }
        return method;
    }

    public static boolean isTrue(String text) {
        return Boolean.valueOf(text);
    }

    AbstractMetadataRecord getChild(String name, AbstractMetadataRecord record, boolean parameter) {
        if (record instanceof Table) {
            if (parameter) {
                throw new MetadataException(QueryPlugin.Util.getString("SQLParser.alter_table_param", new Object[]{name, record.getName()}));
            }
            return this.getColumn(name, (Table)record);
        }
        return this.getColumn(name, (Procedure)record, parameter);
    }

    Column getColumn(String columnName, Table table) throws MetadataException {
        Column c = table.getColumnByName(columnName);
        if (c != null) {
            return c;
        }
        throw new MetadataException(QueryPlugin.Util.getString("SQLParser.no_column", new Object[]{columnName, table.getName()}));
    }

    AbstractMetadataRecord getColumn(String paramName, Procedure proc, boolean parameter) throws MetadataException {
        Column result;
        if (proc.getResultSet() != null && (result = proc.getResultSet().getColumnByName(paramName)) != null) {
            return result;
        }
        if (parameter) {
            List params = proc.getParameters();
            for (ProcedureParameter param : params) {
                if (!param.getName().equalsIgnoreCase(paramName)) continue;
                return param;
            }
        }
        throw new MetadataException(QueryPlugin.Util.getString("SQLParser.alter_procedure_param_doesnot_exist", new Object[]{paramName, proc.getName()}));
    }

    FunctionParameter getParameter(String paramName, FunctionMethod func) throws MetadataException {
        List params = func.getInputParameters();
        for (FunctionParameter param : params) {
            if (!param.getName().equalsIgnoreCase(paramName)) continue;
            return param;
        }
        throw new MetadataException(QueryPlugin.Util.getString("SQLParser.alter_function_param_doesnot_exist", new Object[]{paramName, func.getName()}));
    }

    void createDDLTrigger(DatabaseStore events, AlterTrigger trigger) {
        GroupSymbol group = trigger.getTarget();
        events.setTableTriggerPlan(trigger.getName(), group.getName(), trigger.getEvent(), ((TriggerAction)trigger.getDefinition()).toString(), trigger.isAfter());
    }

    BaseColumn addProcColumn(MetadataFactory factory, Procedure proc, String name, ParsedDataType type, boolean rs) throws MetadataException {
        Column column = null;
        if (rs) {
            column = factory.addProcedureResultSetColumn(name, type.type, proc);
        } else {
            boolean added = false;
            for (ProcedureParameter pp : proc.getParameters()) {
                if (pp.getType() != ProcedureParameter.Type.ReturnValue) continue;
                added = true;
                if (pp.getDatatype() == factory.getDataTypes().get(type.type)) continue;
                throw new MetadataException(QueryPlugin.Util.getString("SQLParser.proc_type_conflict", new Object[]{proc.getName(), pp.getDatatype(), type.type}));
            }
            if (!added) {
                column = factory.addProcedureParameter(name, type.type, ProcedureParameter.Type.ReturnValue, proc);
            }
        }
        SQLParserUtil.setTypeInfo(type, (BaseColumn)column);
        return column;
    }

    static void setTypeInfo(ParsedDataType type, BaseColumn column) {
        if (type.length != null) {
            column.setLength(type.length.intValue());
        }
        if (type.precision != null) {
            if (type.precision == 0) {
                throw new MetadataException(QueryPlugin.Util.getString("SQLParser.zero_precision"));
            }
            column.setPrecision(type.precision.intValue());
            if (type.scale != null) {
                if (Math.abs(type.scale) > type.precision) {
                    throw new MetadataException(QueryPlugin.Util.getString("SQLParser.invalid_scale", new Object[]{type.scale, type.precision}));
                }
                column.setScale(type.scale.intValue());
            } else {
                column.setScale(0);
            }
        }
    }

    KeyRecord addFBI(MetadataFactory factory, List<Expression> expressions, Table table, String name) throws MetadataException {
        ArrayList<String> columnNames = new ArrayList<String>(expressions.size());
        ArrayList<Boolean> nonColumnExpressions = new ArrayList<Boolean>(expressions.size());
        boolean fbi = false;
        for (int i = 0; i < expressions.size(); ++i) {
            Expression ex = expressions.get(i);
            if (ex instanceof ElementSymbol) {
                columnNames.add(((ElementSymbol)ex).getName());
                nonColumnExpressions.add(Boolean.FALSE);
                continue;
            }
            columnNames.add(ex.toString());
            nonColumnExpressions.add(Boolean.TRUE);
            fbi = true;
        }
        return factory.addFunctionBasedIndex(name != null ? name : "INDEX" + (fbi ? table.getFunctionBasedIndexes().size() : table.getIndexes().size()), columnNames, nonColumnExpressions, table);
    }

    MetadataFactory getTempMetadataFactory() {
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        return workContext.getTempMetadataFactory();
    }

    List<Expression> arrayExpressions(List<Expression> expressions, Expression expr) {
        if (expressions == null) {
            expressions = new ArrayList<Expression>();
        }
        if (expr != null) {
            expressions.add(expr);
        }
        return expressions;
    }

    public static void setDefault(BaseColumn column, Expression value) {
        if (value instanceof Constant && value.getType() == DataTypeManager.DefaultDataClasses.STRING) {
            column.setDefaultValue(((Constant)value).getValue().toString());
        } else {
            column.setProperty("{http://www.teiid.org/ext/relational/2012}default_handling", "expression");
            column.setDefaultValue(value.toString());
        }
    }

    static class ParsedDataType {
        String type;
        Integer length;
        Integer scale;
        Integer precision;

        public ParsedDataType(String type) {
            this.type = type;
        }

        public ParsedDataType(String type, int length, boolean precision) {
            this.type = type;
            if (precision) {
                this.precision = length;
            } else {
                this.length = length;
            }
        }

        public ParsedDataType(String type, int length, int scale, boolean precision) {
            this.type = type;
            this.scale = scale;
            if (precision) {
                this.precision = length;
            } else {
                this.length = length;
            }
        }
    }
}

