/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.nio.ByteBuffer;

public class BlockByteBuffer {
    private BlockByteBufferData data;
    private ByteBuffer[] buffers;

    public BlockByteBuffer(int segmentAddressBits, int blockCount, int blockAddressBits, boolean direct) {
        this.data = new BlockByteBufferData();
        this.data.segmentAddressBits = segmentAddressBits;
        this.data.blockAddressBits = blockAddressBits;
        this.data.blockSize = 1 << blockAddressBits;
        this.data.segmentSize = 1 << this.data.segmentAddressBits;
        this.data.blockCount = blockCount;
        long size = (long)blockCount << blockAddressBits;
        int fullSegments = (int)(size >> segmentAddressBits);
        int lastSegmentSize = (int)(size & (long)(this.data.segmentSize - 1));
        int segments = fullSegments;
        if (lastSegmentSize > 0) {
            ++segments;
        }
        this.data.origBuffers = new ByteBufferHolder[segments];
        this.data.direct = direct;
        this.buffers = new ByteBuffer[segments];
        for (int i = 0; i < fullSegments; ++i) {
            this.data.origBuffers[i] = new ByteBufferHolder(this.data.segmentSize);
        }
        if (lastSegmentSize > 0) {
            this.data.origBuffers[fullSegments] = new ByteBufferHolder(lastSegmentSize);
        }
    }

    public ByteBuffer[] getBuffers() {
        return this.buffers;
    }

    private BlockByteBuffer() {
    }

    public static ByteBuffer allocate(int size, boolean direct) {
        if (direct) {
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(size);
            int longsPerSegment = size >> 3;
            for (int j = 0; j < longsPerSegment; ++j) {
                newBuffer.putLong(0L);
            }
            return newBuffer;
        }
        return ByteBuffer.allocate(size);
    }

    public BlockByteBuffer duplicate() {
        BlockByteBuffer dup = new BlockByteBuffer();
        dup.data = this.data;
        dup.buffers = new ByteBuffer[this.buffers.length];
        return dup;
    }

    public ByteBuffer getByteBuffer(int block) {
        if (block < 0 || block >= this.data.blockCount) {
            throw new IndexOutOfBoundsException("Invalid block " + block);
        }
        int segment = block >> this.data.segmentAddressBits - this.data.blockAddressBits;
        ByteBuffer bb = this.buffers[segment];
        if (bb == null) {
            bb = this.buffers[segment] = this.data.origBuffers[segment].duplicate(this.data.direct);
        } else {
            bb.rewind();
        }
        int position = block << this.data.blockAddressBits & this.data.segmentSize - 1;
        bb.limit(position + this.data.blockSize);
        bb.position(position);
        return bb;
    }

    private static class BlockByteBufferData {
        int blockAddressBits;
        int segmentAddressBits;
        int segmentSize;
        int blockSize;
        int blockCount;
        boolean direct;
        ByteBufferHolder[] origBuffers;

        private BlockByteBufferData() {
        }
    }

    private static class ByteBufferHolder {
        int size;
        volatile ByteBuffer buffer;

        public ByteBufferHolder(int size) {
            this.size = size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ByteBuffer duplicate(boolean direct) {
            if (this.buffer == null) {
                ByteBufferHolder byteBufferHolder = this;
                synchronized (byteBufferHolder) {
                    if (this.buffer == null) {
                        this.buffer = BlockByteBuffer.allocate(this.size, direct);
                    }
                }
            }
            return this.buffer.duplicate();
        }
    }
}

