/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.io.OutStream;
import com.vividsolutions.jts.io.OutputStreamOutStream;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.io.WKTReader;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.client.util.ExceptionUtil;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.GeometryType;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.GeometryTransformUtils;
import org.teiid.query.function.GeometryUtils;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.resolver.TestFunctionResolving;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestGeometry {
    @Test
    public void testRoundTrip() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))')");
        GeometryType geom = (GeometryType)Evaluator.evaluate((Expression)ex);
        Assert.assertEquals((long)0L, (long)geom.getSrid());
        byte[] bytes = geom.getBytes(1L, (int)geom.length());
        Expression ex1 = TestFunctionResolving.getExpression("ST_GeomFromBinary(X'" + new BinaryType(bytes) + "', 8307)");
        GeometryType geom1 = (GeometryType)Evaluator.evaluate((Expression)ex1);
        Assert.assertEquals((long)8307L, (long)geom1.getSrid());
        Assert.assertEquals((Object)geom, (Object)geom1);
    }

    @Test
    public void testTextError() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_GeomFromText('''hello''')");
        try {
            Evaluator.evaluate((Expression)ex);
            Assert.fail();
        }
        catch (ExpressionEvaluationException e) {
            Assert.assertNull((Object)ExceptionUtil.getExceptionOfType((Throwable)e, NullPointerException.class));
        }
    }

    @Test
    public void testAsText() throws Exception {
        Expression ex2 = TestFunctionResolving.getExpression("st_astext(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'))");
        Clob val = (Clob)Evaluator.evaluate((Expression)ex2);
        Assert.assertEquals((Object)"POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))", (Object)ClobType.getString((Clob)val));
    }

    @Test
    public void testAsBinary() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("st_asbinary(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'))");
        Assert.assertTrue((boolean)(Evaluator.evaluate((Expression)ex) instanceof Blob));
    }

    @Test
    public void testContains() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("st_contains(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'), ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'))");
        Boolean b = (Boolean)Evaluator.evaluate((Expression)ex);
        Assert.assertTrue((boolean)b);
        ex = TestFunctionResolving.getExpression("st_contains(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'), ST_GeomFromText('POLYGON ((43 0, 50 50, 0 50, 0 0, 43 0))'))");
        b = (Boolean)Evaluator.evaluate((Expression)ex);
        Assert.assertFalse((boolean)b);
    }

    @Test
    public void testIntersects() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("st_intersects(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'), ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'))");
        Boolean b = (Boolean)Evaluator.evaluate((Expression)ex);
        Assert.assertTrue((boolean)b);
        ex = TestFunctionResolving.getExpression("st_intersects(ST_GeomFromText('POLYGON ((100 100, 200 200, 75 75, 100 100))'), ST_GeomFromText('POLYGON ((43 0, 50 50, 0 50, 0 0, 43 0))'))");
        b = (Boolean)Evaluator.evaluate((Expression)ex);
        Assert.assertFalse((boolean)b);
    }

    @Test
    public void testIntersection() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_AsText(st_intersection(ST_GeomFromText('POLYGON ((0 50, 50 50, 40 0, 0 0, 0 50))'), ST_GeomFromText('POLYGON ((0 50, 40 50, 40 0, 0 0, 0 50))')))");
        ClobType intersection = (ClobType)Evaluator.evaluate((Expression)ex);
        Assert.assertEquals((Object)"POLYGON ((0 50, 40 50, 40 0, 0 0, 0 50))", (Object)ClobType.getString((Clob)intersection));
        ex = TestFunctionResolving.getExpression("ST_AsText(st_intersection(ST_GeomFromText('POLYGON ((0 50, 50 50, 40 0, 0 0, 0 50))'), ST_GeomFromText('POLYGON ((150 50, 200 50, 190 0, 150 0, 150 50))')))");
        intersection = (ClobType)Evaluator.evaluate((Expression)ex);
        Assert.assertEquals((Object)"POLYGON EMPTY", (Object)ClobType.getString((Clob)intersection));
    }

    @Test
    public void testPointOnSurface() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_AsText(ST_PointOnSurface(ST_GeomFromText('POLYGON ((67 13, 67 18, 59 18, 59 13, 67 13))')));");
        ClobType pointOnSurface = (ClobType)Evaluator.evaluate((Expression)ex);
        Assert.assertEquals((Object)"POINT (63 15.5)", (Object)ClobType.getString((Clob)pointOnSurface));
        ex = TestFunctionResolving.getExpression("ST_AsText(ST_PointOnSurface(ST_GeomFromText('POLYGON ((50 0, 50 10, 10 10, 10 50, 50 50, 50 60, 0 60, 0 0, 50 0))')));");
        pointOnSurface = (ClobType)Evaluator.evaluate((Expression)ex);
        Assert.assertEquals((Object)"POINT (5 30)", (Object)ClobType.getString((Clob)pointOnSurface));
    }

    @Test
    public void testAsGeoJson() throws Exception {
        TestFunctionResolving.assertEval("ST_AsGeoJson(ST_GeomFromText('POINT (-48.23456 20.12345)'))", "{\"type\":\"Point\",\"coordinates\":[-48.23456,20.12345]}");
        TestFunctionResolving.assertEval("ST_AsGeoJson(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'))", "{\"type\":\"Polygon\",\"coordinates\":[[[40.0,0.0],[50.0,50.0],[0.0,50.0],[0.0,0.0],[40.0,0.0]]]}");
    }

    @Test
    public void testFromGeoJson() throws Exception {
        TestFunctionResolving.assertEval("ST_AsText(ST_GeomFromGeoJSON('{\"coordinates\":[-48.23456,20.12345],\"type\":\"Point\"}'))", "POINT (-48.23456 20.12345)");
        TestFunctionResolving.assertEval("ST_AsText(ST_GeomFromGeoJSON('{\"coordinates\":[[[40.0,0.0],[50.0,50.0],[0.0,50.0],[0.0,0.0],[40.0,0.0]]],\"type\":\"Polygon\"}'))", "POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))");
    }

    @Test
    public void testAsGml() throws Exception {
        TestFunctionResolving.assertEval("ST_AsGML(ST_GeomFromText('POINT (-48.23456 20.12345)'))", "<gml:Point>\n  <gml:coordinates>\n    -48.23456,20.12345 \n  </gml:coordinates>\n</gml:Point>\n");
        TestFunctionResolving.assertEval("ST_AsGML(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))', 4326))", "<gml:Polygon>\n  <gml:outerBoundaryIs>\n    <gml:LinearRing>\n      <gml:coordinates>\n        40.0,0.0 50.0,50.0 0.0,50.0 0.0,0.0 40.0,0.0 \n      </gml:coordinates>\n    </gml:LinearRing>\n  </gml:outerBoundaryIs>\n</gml:Polygon>\n");
    }

    @Test
    public void testFromGml() throws Exception {
        TestFunctionResolving.assertEval("ST_AsText(ST_GeomFromGML('<gml:Point>\n  <gml:coordinates>\n    -48.23456,20.12345 \n  </gml:coordinates>\n</gml:Point>'))", "POINT (-48.23456 20.12345)");
        TestFunctionResolving.assertEval("ST_AsText(ST_GeomFromGML('<gml:Polygon>\n  <gml:outerBoundaryIs>\n    <gml:LinearRing>\n      <gml:coordinates>\n        40.0,0.0 50.0,50.0 0.0,50.0 0.0,0.0 40.0,0.0 \n      </gml:coordinates>\n    </gml:LinearRing>\n  </gml:outerBoundaryIs>\n</gml:Polygon>'))", "POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))");
    }

    @Test
    public void testAsEwkt() throws Exception {
        TestFunctionResolving.assertEval("ST_AsEWKT(ST_GeomFromText('POLYGON((0 0,0 1,1 1,1 0,0 0))', 4326))", "SRID=4326;POLYGON ((0 0, 0 1, 1 1, 1 0, 0 0))");
        TestFunctionResolving.assertEval("ST_AsEWKT(ST_GeomFromText('POLYGON((0 0,0 1,1 1,1 0,0 0))'))", "POLYGON ((0 0, 0 1, 1 1, 1 0, 0 0))");
    }

    @Test
    public void testAsKml() throws Exception {
        TestFunctionResolving.assertEval("ST_AsKML(ST_GeomFromText('POLYGON((0 0,0 1,1 1,1 0,0 0))', 4326))", "<Polygon>\n  <outerBoundaryIs>\n    <LinearRing>\n      <coordinates>\n        0.0,0.0 0.0,1.0 1.0,1.0 1.0,0.0 0.0,0.0 \n      </coordinates>\n    </LinearRing>\n  </outerBoundaryIs>\n</Polygon>\n");
    }

    @Test(expected=ExpressionEvaluationException.class)
    public void testAsKmlException() throws Exception {
        TestFunctionResolving.assertEval("ST_AsKML(ST_GeomFromText('POLYGON((0 0,0 1,1 1,1 0,0 0))'))", null);
    }

    @Test
    public void testEquals() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_Equals (ST_GeomFromText('LINESTRING(-1 2, 0 3)'), ST_GeomFromText('LINESTRING(0 3, -1 2)'))");
        Boolean b = (Boolean)Evaluator.evaluate((Expression)ex);
        Assert.assertTrue((boolean)b);
        ex = TestFunctionResolving.getExpression("ST_Equals (ST_GeomFromText('LINESTRING(0 0, 0 1, 0 3)'), ST_GeomFromText('LINESTRING(0 3, 0 0)'))");
        b = (Boolean)Evaluator.evaluate((Expression)ex);
        Assert.assertTrue((boolean)b);
        ex = TestFunctionResolving.getExpression("ST_Equals (ST_GeomFromText('LINESTRING(0 1, 0 3)'), ST_GeomFromText('LINESTRING(0 3, 0 0)'))");
        b = (Boolean)Evaluator.evaluate((Expression)ex);
        Assert.assertFalse((boolean)b);
    }

    @Test(expected=ExpressionEvaluationException.class)
    public void testEwkb() throws Exception {
        WKBWriter writer = new WKBWriter(3, true);
        GeometryFactory gf = new GeometryFactory();
        Point point = gf.createPoint(new Coordinate(0.0, 0.0, 0.0));
        point.setSRID(100);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        writer.write((Geometry)point, (OutStream)new OutputStreamOutStream((OutputStream)baos));
        Expression ex1 = TestFunctionResolving.getExpression("ST_GeomFromBinary(X'" + new BinaryType(baos.toByteArray()) + "', 8307)");
        Evaluator.evaluate((Expression)ex1);
    }

    @Test(expected=ExpressionEvaluationException.class)
    public void testEwkbZCooridinate() throws Exception {
        WKBWriter writer = new WKBWriter(3, true);
        GeometryFactory gf = new GeometryFactory();
        Point point = gf.createPoint(new Coordinate(0.0, 0.0, 0.0));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        writer.write((Geometry)point, (OutStream)new OutputStreamOutStream((OutputStream)baos));
        Expression ex1 = TestFunctionResolving.getExpression("ST_GeomFromBinary(X'" + new BinaryType(baos.toByteArray()) + "', 8307)");
        Evaluator.evaluate((Expression)ex1);
    }

    @Test
    public void testGmlParseSrid() throws Exception {
        String gml = "<gml:Polygon srsName=\"SDO:8307\" xmlns:gml=\"http://www.opengis.net/gml\"><gml:outerBoundaryIs><gml:LinearRing><gml:coordinates decimal=\".\" cs=\",\" ts=\" \">5,1 8,1 8,6 5,7 5,1 </gml:coordinates></gml:LinearRing></gml:outerBoundaryIs></gml:Polygon>";
        GeometryType gt = GeometryUtils.geometryFromGml((ClobType)new ClobType(ClobImpl.createClob((char[])gml.toCharArray())), null);
        Assert.assertEquals((long)8307L, (long)gt.getSrid());
        gml = "<gml:Polygon srsName=\"SDO:\" xmlns:gml=\"http://www.opengis.net/gml\"><gml:outerBoundaryIs><gml:LinearRing><gml:coordinates decimal=\".\" cs=\",\" ts=\" \">5,1 8,1 8,6 5,7 5,1 </gml:coordinates></gml:LinearRing></gml:outerBoundaryIs></gml:Polygon>";
        gt = GeometryUtils.geometryFromGml((ClobType)new ClobType(ClobImpl.createClob((char[])gml.toCharArray())), null);
        Assert.assertEquals((long)0L, (long)gt.getSrid());
    }

    @Test
    public void testTransform() throws Exception {
        Geometry g0 = new WKTReader().read("POINT(426418.89 4957737.37)");
        Geometry g1 = GeometryTransformUtils.transform((Geometry)g0, (String)"+proj=utm +zone=32 +datum=WGS84 +units=m +no_defs", (String)"+proj=longlat +datum=WGS84 +no_defs");
        Assert.assertEquals((Object)"POINT (8.07013599546795 44.76924401481436)", (Object)g1.toText());
    }

    @Test
    public void testGeoJsonCollection() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_AsGeoJson(ST_GeomFromText('GEOMETRYCOLLECTION(POINT(4 6),LINESTRING(4 6,7 10))'))");
        ClobType c = (ClobType)Evaluator.evaluate((Expression)ex);
        Assert.assertEquals((Object)"{\"type\":\"GeometryCollection\",\"geometries\":[{\"type\":\"Point\",\"coordinates\":[4.0,6.0]},{\"type\":\"LineString\",\"coordinates\":[[4.0,6.0],[7.0,10.0]]}]}", (Object)ClobType.getString((Clob)c));
    }

    @Test(expected=ExpressionEvaluationException.class)
    public void testEwktNotExpected() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_GeomFromText('POINT(0 0 0)'))");
        Evaluator.evaluate((Expression)ex);
    }

    @Test
    public void testEnvelope() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_AsText(ST_Envelope(ST_GEOMFROMTEXT('LINESTRING(0 0, 1 3)')))");
        ClobType c = (ClobType)Evaluator.evaluate((Expression)ex);
        Assert.assertEquals((Object)"POLYGON ((0 0, 0 3, 1 3, 1 0, 0 0))", (Object)ClobType.getString((Clob)c));
    }

    @Test
    public void testEwkt() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("st_asewkt(ST_GeomFromEwkt('POINT(0 0 0)')))");
        Assert.assertEquals((Object)"POINT (0 0)", (Object)ClobType.getString((Clob)((ClobType)Evaluator.evaluate((Expression)ex))));
    }

    @Test
    public void testEwktWithSRID() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("st_asewkt(ST_GeomFromEwkt('SRID=4326;POINT(0 0)')))");
        Evaluator.evaluate((Expression)ex);
        ex = TestFunctionResolving.getExpression("st_asewkt(ST_GeomFromEwkt('   SRID=4326;POINT(0 0)')))");
        Evaluator.evaluate((Expression)ex);
        ex = TestFunctionResolving.getExpression("st_asewkt(ST_GeomFromEwkt('SrID=4326;POINT(0 0)')))");
        Assert.assertEquals((Object)"SRID=4326;POINT (0 0)", (Object)ClobType.getString((Clob)((ClobType)Evaluator.evaluate((Expression)ex))));
    }

    @Test
    public void testAsFromEwkb() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("st_asewkt(st_geomfromewkb(st_asewkb(ST_GeomFromEwkt('SrID=4326;POINT(0 0)'))))");
        Assert.assertEquals((Object)"SRID=4326;POINT (0 0)", (Object)ClobType.getString((Clob)((ClobType)Evaluator.evaluate((Expression)ex))));
    }

    @Test
    public void testSimplify() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_AsText(ST_SIMPLIFY(ST_GeomFromText('LINESTRING(1 1,2 2,2 3.5,1 3,1 2,2 1)'), 1))");
        Assert.assertEquals((Object)"LINESTRING (1 1, 2 3.5, 2 1)", (Object)ClobType.getString((Clob)((ClobType)Evaluator.evaluate((Expression)ex))));
        ex = TestFunctionResolving.getExpression("ST_ISEmpty(ST_Simplify(ST_GeomFromText('POLYGON((6 3,1 -2,-4 3,1 8,6 3))'),5))");
        Assert.assertTrue((boolean)((Boolean)Evaluator.evaluate((Expression)ex)));
    }

    @Test
    public void testSimplifyPreserveTopology() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_AsText(ST_SimplifyPreserveTopology(ST_GeomFromText('POLYGON((6 3,1 -2,-4 3,1 8,6 3))'),5))");
        Assert.assertEquals((Object)"POLYGON ((6 3, 1 -2, -4 3, 1 8, 6 3))", (Object)ClobType.getString((Clob)((ClobType)Evaluator.evaluate((Expression)ex))));
    }

    @Test
    public void testWithin() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_WITHIN(ST_GeomFromText('POINT(0 0)'), ST_GeomFromText('POINT(0 0)'))");
        Assert.assertTrue((boolean)((Boolean)Evaluator.evaluate((Expression)ex)));
        ex = TestFunctionResolving.getExpression("ST_WITHIN(ST_GeomFromText('POINT(0 1)'), ST_GeomFromText('POINT(0 0)'))");
        Assert.assertFalse((boolean)((Boolean)Evaluator.evaluate((Expression)ex)));
    }

    @Test
    public void testDWithin() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_DWITHIN(ST_GeomFromText('POINT(0 0)'), ST_GeomFromText('POINT(0 .5)'), 1)");
        Assert.assertTrue((boolean)((Boolean)Evaluator.evaluate((Expression)ex)));
        ex = TestFunctionResolving.getExpression("ST_DWITHIN(ST_GeomFromText('POINT(0 1)'), ST_GeomFromText('POINT(0 0)'), 1)");
        Assert.assertFalse((boolean)((Boolean)Evaluator.evaluate((Expression)ex)));
    }

    @Test
    public void testBoundingBoxIntesects() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_GEOMFROMTEXT('LINESTRING(0 0, 1 3)') && ST_GEOMFROMTEXT('POINT(0 1)')");
        Assert.assertTrue((boolean)((Boolean)Evaluator.evaluate((Expression)ex)));
    }

    @Test
    public void testExtent() throws Exception {
        String sql = "SELECT st_astext(st_extent(g)) from (select ST_GEOMFROMTEXT('LINESTRING(0 0, 1 3)') as g union all select ST_GEOMFROMTEXT('POINT(5 5)')) as x";
        List[] expected = new List[]{Arrays.asList("POLYGON ((0 0, 0 5, 5 5, 5 0, 0 0))")};
        ProcessorPlan plan = TestProcessor.helpGetPlan("SELECT st_astext(st_extent(g)) from (select ST_GEOMFROMTEXT('LINESTRING(0 0, 1 3)') as g union all select ST_GEOMFROMTEXT('POINT(5 5)')) as x", (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        TestProcessor.helpProcess(plan, new HardcodedDataManager(), expected);
    }

    @Test
    public void testForce2d() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("st_astext(st_force_2d(ST_GEOMFROMTEXT('LINESTRING(0 0, 1 3)')))");
        Assert.assertEquals((Object)"LINESTRING (0 0, 1 3)", (Object)ClobType.getString((Clob)((ClobType)Evaluator.evaluate((Expression)ex))));
    }

    @Test
    public void testHasArc() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("(st_hasarc(ST_GEOMFROMTEXT('LINESTRING(0 0, 1 3)')))");
        Assert.assertFalse((boolean)((Boolean)Evaluator.evaluate((Expression)ex)));
    }

    @Test
    public void testEndPoint() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_AsText(st_endpoint(ST_GEOMFROMTEXT('LINESTRING(0 0, 1 3)'))))");
        Assert.assertEquals((Object)"POINT (1 3)", (Object)ClobType.getString((Clob)((ClobType)Evaluator.evaluate((Expression)ex))));
    }

    @Test
    public void testStartPoint() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_AsText(st_startpoint(ST_GEOMFROMTEXT('LINESTRING(0 0, 1 3)'))))");
        Assert.assertEquals((Object)"POINT (0 0)", (Object)ClobType.getString((Clob)((ClobType)Evaluator.evaluate((Expression)ex))));
    }

    @Test
    public void testCoordDims() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_CoordDim(ST_GEOMFROMTEXT('LINESTRING EMPTY'))");
        Assert.assertEquals((Object)2, (Object)Evaluator.evaluate((Expression)ex));
    }

    @Test
    public void testOrderingEquals() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_OrderingEquals(ST_GeomFromText('LINESTRING(0 0, 10 10)'),ST_GeomFromText('LINESTRING(0 0, 0 0, 10 10)'))");
        Assert.assertFalse((boolean)((Boolean)Evaluator.evaluate((Expression)ex)));
    }

    @Test
    public void testPointN() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_AsText(ST_PointN(ST_GeomFromText('LINESTRING(1 2, 3 2, 1 2)'),4))");
        Assert.assertNull((Object)Evaluator.evaluate((Expression)ex));
    }

    @Test
    public void testPolygon() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_ASEWKT(ST_Polygon(ST_GeomFromText('LINESTRING(75.15 29.53,77 29,77.6 29.5, 75.15 29.53)'), 4326))");
        Assert.assertEquals((Object)"SRID=4326;POLYGON ((75.15 29.53, 77 29, 77.6 29.5, 75.15 29.53))", (Object)ClobType.getString((Clob)((ClobType)Evaluator.evaluate((Expression)ex))));
    }

    @Test
    public void testRelate() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_Relate(ST_GeomFromText('POINT(1 2)'), ST_Buffer(ST_GeomFromText('POINT(1 2)'),2))");
        Assert.assertEquals((Object)"0FFFFF212", (Object)Evaluator.evaluate((Expression)ex));
    }

    @Test
    public void testRelatePattern() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_Relate(ST_GeomFromText('POINT(1 2)'), ST_Buffer(ST_GeomFromText('POINT(1 2)'),2), '*FF*FF212')");
        Assert.assertEquals((Object)true, (Object)Evaluator.evaluate((Expression)ex));
    }

    @Test
    public void testX() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_X(ST_GeomFromText('POINT(1 2)'))");
        Assert.assertEquals((Object)1.0, (Object)Evaluator.evaluate((Expression)ex));
    }

    @Test
    public void testY() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_Y(ST_GeomFromText('POINT(1 2)'))");
        Assert.assertEquals((Object)2.0, (Object)Evaluator.evaluate((Expression)ex));
    }

    @Test
    public void testZ() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_Z(ST_GeomFromText('POINT(1 2)'))");
        Assert.assertNull((Object)Evaluator.evaluate((Expression)ex));
    }

    @Test
    public void testMakeEnvelope() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_ASEWKT(st_makeenvelope(-1.73431370972209553,-0.71846435100548445,1.31749469692502075,1.28153564899451555,2908))");
        Assert.assertEquals((Object)"SRID=2908;POLYGON ((-1.7343137097220955 -0.7184643510054844, -1.7343137097220955 1.2815356489945156, 1.3174946969250207 1.2815356489945156, 1.3174946969250207 -0.7184643510054844, -1.7343137097220955 -0.7184643510054844))", (Object)ClobType.getString((Clob)((ClobType)Evaluator.evaluate((Expression)ex))));
    }

    @Test
    public void testSnapToGrid() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_AsText(ST_SnapToGrid(ST_GeomFromText('LINESTRING(1.1115678 2.123, 4.111111 3.2374897, 4.11112 3.23748667)'),.001))");
        Assert.assertEquals((Object)"LINESTRING (1.112 2.123, 4.111 3.237)", (Object)ClobType.getString((Clob)((ClobType)Evaluator.evaluate((Expression)ex))));
    }
}

