/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;

public class NumberToLongTransform
extends Transform {
    private Class<?> sourceType;
    private boolean isNarrowing;
    private boolean isLossy;

    public NumberToLongTransform(Class<?> sourceType, boolean isNarrowing, boolean isLossy) {
        this.sourceType = sourceType;
        this.isNarrowing = isNarrowing;
        this.isLossy = isLossy;
    }

    @Override
    public Class<?> getSourceType() {
        return this.sourceType;
    }

    @Override
    public Object transformDirect(Object value) throws TransformationException {
        if (this.isNarrowing) {
            this.checkValueRange(value, Long.MIN_VALUE, Long.MAX_VALUE);
        }
        return ((Number)value).longValue();
    }

    @Override
    public Class<?> getTargetType() {
        return DataTypeManager.DefaultDataClasses.LONG;
    }

    @Override
    public boolean isExplicit() {
        return this.isNarrowing || this.isLossy;
    }
}

