/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.client;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.teiid.test.client.QueryScenario;
import org.teiid.test.client.TestClient;
import org.teiid.test.client.TestResult;
import org.teiid.test.framework.ConfigPropertyLoader;
import org.teiid.test.framework.TestLogger;
import org.teiid.test.util.StringUtil;

public class TestResultsSummary {
    private static final String OVERALL_SUMMARY_FILE = "Summary_totals.txt";
    private static final String OVERALL_SUMMARY_ERROR_FILE = "Summary_errors.txt";
    private static final String PROP_SUMMARY_PRT_DIR = "summarydir";
    private static final SimpleDateFormat FILE_NAME_DATE_FORMATER = new SimpleDateFormat("yyyyMMdd_HHmmss");
    private static final String NL = System.getProperty("line.separator");
    private String resultMode = "NotSet";
    private int total_queries = 0;
    private int total_pass = 0;
    private int total_fail = 0;
    private int total_querysets = 0;
    private long total_seconds = 0L;
    private List<String> failed_queries = new ArrayList<String>();
    private List<String> query_sets = new ArrayList<String>(10);
    private Map<String, Collection<TestResult>> testResults = Collections.synchronizedMap(new HashMap());

    public TestResultsSummary(String resultMode) {
        this.resultMode = resultMode;
    }

    public void cleanup() {
        this.failed_queries.clear();
        this.query_sets.clear();
        this.testResults.clear();
    }

    public synchronized void addTestResult(String querySetID, TestResult result) {
        if (result == null) {
            System.err.println("Error - trying to add a null result set for querysetID: " + querySetID);
            throw new RuntimeException("Error - trying to add a null result set for querysetID: " + querySetID);
        }
        Collection<Object> results = null;
        if (this.testResults.containsKey(querySetID)) {
            results = this.testResults.get(querySetID);
        } else {
            results = new ArrayList();
            this.testResults.put(querySetID, results);
        }
        results.add(result);
    }

    public Collection<TestResult> getTestResults(String querySetID) {
        return this.testResults.get(querySetID);
    }

    private static PrintStream getSummaryStream(String outputDir, String summaryName) throws IOException {
        File summaryFile = TestResultsSummary.createSummaryFile(outputDir, summaryName);
        OutputStream os = new FileOutputStream(summaryFile);
        os = new BufferedOutputStream(os);
        return new PrintStream(os);
    }

    private static PrintStream getSummaryStream(String outputDir, String summaryName, boolean overwrite) throws IOException {
        File summaryFile;
        if (summaryName.indexOf(".") == -1) {
            summaryName = summaryName + ".txt";
        }
        if ((summaryFile = new File(outputDir, summaryName)).exists() && !overwrite) {
            throw new IOException("Summary file already exists: " + summaryFile.getName());
        }
        try {
            summaryFile.createNewFile();
        }
        catch (IOException ioe) {
            TestLogger.log("Error creating new summary file: " + summaryFile.getAbsolutePath());
            throw ioe;
        }
        OutputStream os = new FileOutputStream(summaryFile);
        os = new BufferedOutputStream(os);
        return new PrintStream(os);
    }

    private static File createSummaryFile(String outputDir, String summaryName) throws IOException {
        File summaryFile = new File(outputDir, summaryName + ".txt");
        if (summaryFile.exists()) {
            System.err.println("Summary file already exists: " + summaryFile.getName());
            throw new IOException("Summary file already exists: " + summaryFile.getName());
        }
        try {
            summaryFile.createNewFile();
        }
        catch (IOException e) {
            System.err.println("Failed to create summary file at: " + summaryFile.getAbsolutePath());
            throw new IOException("Failed to create summary file at: " + summaryFile.getAbsolutePath() + ": " + e.getMessage());
        }
        return summaryFile;
    }

    private static Writer getOverallSummaryStream(String outputDir) throws IOException {
        boolean exists = false;
        File summaryFile = new File(outputDir, OVERALL_SUMMARY_FILE);
        exists = summaryFile.exists();
        FileWriter fstream = new FileWriter(summaryFile, true);
        BufferedWriter out = new BufferedWriter(fstream);
        if (!exists) {
            try {
                summaryFile.createNewFile();
            }
            catch (IOException e) {
                System.err.println("Failed to create overall summary file at: " + summaryFile.getAbsolutePath());
                throw new IOException("Failed to create overall summary file at: " + summaryFile.getAbsolutePath() + ": " + e.getMessage());
            }
            TestResultsSummary.printOverallSummaryHeadings(out);
        }
        return out;
    }

    private static void printOverallSummaryHeadings(Writer overallsummary) {
        try {
            overallsummary.write("================== \n");
            overallsummary.write("Test Summary \n");
            overallsummary.write("================== \n");
            overallsummary.write("Scenario \t\t\tPass\tFail\tTotal \n");
            overallsummary.flush();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static Writer getOverallSummaryErrorsStream(String outputDir) throws IOException {
        boolean exists = false;
        File summaryFile = new File(outputDir, OVERALL_SUMMARY_ERROR_FILE);
        exists = summaryFile.exists();
        FileWriter fstream = new FileWriter(summaryFile, true);
        BufferedWriter out = new BufferedWriter(fstream);
        if (!exists) {
            try {
                summaryFile.createNewFile();
            }
            catch (IOException e) {
                System.err.println("Failed to create overall summary error file at: " + summaryFile.getAbsolutePath());
                throw new IOException("Failed to create overall summary error file at: " + summaryFile.getAbsolutePath() + ": " + e.getMessage());
            }
            TestResultsSummary.printOverallSummaryErrorHeadings(out);
        }
        return out;
    }

    private static void printOverallSummaryErrorHeadings(Writer overallsummary) {
        try {
            overallsummary.write("================== \n");
            overallsummary.write("Test Summary Errors \n");
            overallsummary.write("================== \n");
            overallsummary.write("Scenario \tError \n");
            overallsummary.flush();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void printQueryTestResults(PrintStream outputStream, Date testStartTS, Date endTS, Date length, int numberOfClients, SimpleDateFormat formatter, Collection results) {
        outputStream.println("Query Test Results [" + this.resultMode + "]");
        outputStream.println("==================");
        outputStream.println("Start        Time: " + testStartTS);
        outputStream.println("End          Time: " + endTS);
        outputStream.println("Elapsed      Time: " + length.getTime() / 1000L + " seconds");
        outputStream.println("Number of Clients: " + numberOfClients);
        Map passFailGenMap = TestResultsSummary.getPassFailGen(results);
        outputStream.println("Number of Queries: " + passFailGenMap.get("queries"));
        outputStream.println("Number Passed    : " + passFailGenMap.get("pass"));
        outputStream.println("Number Failed    : " + passFailGenMap.get("fail"));
        ResponseTimes responseTimes = TestResultsSummary.calcQueryResponseTimes(results);
        outputStream.println("QPS              : " + responseTimes.qps);
        outputStream.println("Ave First Resp   : " + responseTimes.first);
        outputStream.println("Ave Full Resp    : " + responseTimes.full);
        for (TestResult stat : results) {
            TestResultsSummary.writeQueryResult(outputStream, formatter, stat);
        }
    }

    private static Map getPassFailGen(Collection results) {
        HashMap<String, String> passFailGenMap = new HashMap<String, String>();
        int queries = 0;
        int pass = 0;
        int fail = 0;
        boolean gen = false;
        for (TestResult stat : results) {
            ++queries;
            switch (stat.getStatus()) {
                case 1: {
                    ++fail;
                    break;
                }
                case 0: {
                    ++pass;
                    break;
                }
                case 4: {
                    ++pass;
                }
            }
        }
        passFailGenMap.put("queries", Integer.toString(queries));
        passFailGenMap.put("pass", Integer.toString(pass));
        passFailGenMap.put("fail", Integer.toString(fail));
        return passFailGenMap;
    }

    private void addTotalPassFailGen(String scenario_name, Collection results, Date testStartTS, Date endTS, Date lengthTime) {
        int queries = 0;
        int pass = 0;
        int fail = 0;
        String queryset = null;
        ++this.total_querysets;
        for (TestResult stat : results) {
            if (queryset == null) {
                queryset = stat.getQuerySetID();
            }
            ++queries;
            switch (stat.getStatus()) {
                case 1: {
                    ++fail;
                    String msg = StringUtil.removeChars(stat.getExceptionMsg(), new char[]{'\r', '\n'});
                    this.failed_queries.add(stat.getQueryID() + "~" + msg);
                    break;
                }
                case 0: {
                    ++pass;
                    break;
                }
                case 4: {
                    ++pass;
                }
            }
        }
        this.query_sets.add("\t" + queryset + "\t\t" + pass + "\t" + fail + "\t" + queries + "\t" + lengthTime.getTime() / 1000L);
        this.total_fail += fail;
        this.total_pass += pass;
        this.total_queries += queries;
    }

    public void printResults(QueryScenario scenario, String querySetID, long beginTS, long endTS) throws Exception {
        TestLogger.logDebug("Print results for Query Set [" + querySetID + "]");
        try {
            this.printResults(scenario, querySetID, beginTS, endTS, 1, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printResults(QueryScenario scenario, String querySetID, long testStartTS, long endTS, int numberOfClients, int runNumber) throws Exception {
        String testname = scenario.getQueryScenarioIdentifier();
        Collection<TestResult> testResults = this.getTestResults(querySetID);
        String outputDir = scenario.getResultsGenerator().getOutputDir();
        if (testResults != null && testResults.size() > 0) {
            String outputFileName = TestResultsSummary.generateFileName(querySetID, System.currentTimeMillis(), runNumber);
            PrintStream outputStream = null;
            PrintStream overwriteStream = null;
            outputStream = TestResultsSummary.getSummaryStream(outputDir, outputFileName);
            overwriteStream = TestResultsSummary.getSummaryStream(outputDir, querySetID, true);
            Date starttest = new Date(testStartTS);
            Date endtest = new Date(endTS);
            long diff = endtest.getTime() - starttest.getTime();
            this.total_seconds += diff;
            Date diffdate = new Date(diff);
            this.addTotalPassFailGen(testname, testResults, starttest, endtest, diffdate);
            this.printQueryTestResults(outputStream, starttest, endtest, diffdate, numberOfClients, TestClient.TSFORMAT, testResults);
            this.printQueryTestResults(overwriteStream, starttest, endtest, diffdate, numberOfClients, TestClient.TSFORMAT, testResults);
            PrintStream htmlStream = TestResultsSummary.getSummaryStream(outputDir, querySetID + ".html", true);
            TestResultsSummary.printHtmlQueryTestResults(htmlStream, testStartTS, endTS, numberOfClients, TestClient.TSFORMAT, testResults);
            htmlStream.close();
            outputStream.close();
            overwriteStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printTotals(QueryScenario scenario) throws Exception {
        String scenario_name = scenario.getQueryScenarioIdentifier();
        String querysetname = scenario.getQuerySetName();
        String summarydir = ConfigPropertyLoader.getInstance().getProperty(PROP_SUMMARY_PRT_DIR);
        PrintStream outputStream = null;
        Writer overallsummary = null;
        Writer overallsummaryerrors = null;
        try {
            outputStream = TestResultsSummary.getSummaryStream(summarydir, "Summary_" + querysetname + "_" + scenario_name, true);
            overallsummary = TestResultsSummary.getOverallSummaryStream(summarydir);
            overallsummaryerrors = TestResultsSummary.getOverallSummaryErrorsStream(summarydir);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        outputStream.println("Scenario " + scenario_name + " Summary [" + this.resultMode + "]");
        outputStream.println("Query Set Name " + querysetname);
        outputStream.println("==================");
        outputStream.println("Number of Test Query Sets: " + this.total_querysets);
        outputStream.println("==================");
        outputStream.println("Test Query Set");
        outputStream.println("\tName\t\t\t\tPass\tFail\tTotal\tTime(sec)");
        if (!this.query_sets.isEmpty()) {
            Collections.sort(this.query_sets);
            Iterator<String> it = this.query_sets.iterator();
            while (it.hasNext()) {
                outputStream.println(it.next());
            }
        }
        outputStream.println("==================");
        outputStream.println("\tTotals\t\t\t\t" + this.total_pass + "\t" + this.total_fail + "\t" + this.total_queries + "\t" + this.total_seconds / 1000L);
        try {
            overallsummary.write(TestResultsSummary.pad(scenario_name, 30, ' ') + " \t" + this.total_pass + "\t" + this.total_fail + "\t" + this.total_queries + "\n");
            overallsummary.flush();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                overallsummary.close();
            }
            catch (IOException ioe) {}
        }
        if (!this.failed_queries.isEmpty()) {
            Collections.sort(this.failed_queries);
            outputStream.println("\n\n==================");
            outputStream.println("Failed Queries");
            overallsummaryerrors.write("\n" + scenario_name + "\n");
            for (String error : this.failed_queries) {
                outputStream.println("\t - " + error);
                overallsummaryerrors.write("\t\t" + error + "\n");
            }
            try {
                overallsummaryerrors.flush();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                try {
                    overallsummaryerrors.close();
                }
                catch (IOException iOException) {}
            }
            outputStream.println("==================");
        }
        outputStream.close();
    }

    private static String pad(String src, int padTo, char padChar) {
        int numPad = padTo - src.length();
        if (numPad > 0) {
            StringBuffer sb = new StringBuffer();
            char[] pad = new char[numPad];
            Arrays.fill(pad, padChar);
            sb.append(src);
            sb.append(pad);
            return sb.toString();
        }
        return src;
    }

    private static String generateFileName(String configName, long timestamp, int runNumber) {
        return configName + "_" + FILE_NAME_DATE_FORMATER.format(new Date(timestamp)) + "_Run-" + runNumber;
    }

    private static void printHtmlQueryTestResults(PrintStream outputStream, long testStartTS, long endTS, int numberOfClients, SimpleDateFormat formatter, Collection results) {
        StringBuffer htmlCode = new StringBuffer("<html>").append(NL);
        htmlCode.append("<HEAD>").append(NL);
        htmlCode.append("<TITLE>Query Test Results</TITLE>").append(NL);
        htmlCode.append("<STYLE TYPE=\"text/css\">").append(NL);
        htmlCode.append("td { font-family: \"New Century Schoolbook\", Times, serif  }").append(NL);
        htmlCode.append("td { font-size: 8pt }").append(NL);
        htmlCode.append("</STYLE>").append(NL);
        htmlCode.append("<SCRIPT type=\"text/javascript\">").append(NL);
        htmlCode.append("var scriptWin = null;").append(NL);
        htmlCode.append("function show(msg){").append(NL);
        htmlCode.append("if (scriptWin == null || scriptWin.closed){").append(NL);
        htmlCode.append("scriptWin = window.open(\"\", \"script\", \"width=800,height=50,resizable\");").append(NL);
        htmlCode.append("scriptWin.document.open(\"text/plain\");").append(NL);
        htmlCode.append("}").append(NL);
        htmlCode.append("scriptWin.focus();").append(NL);
        htmlCode.append("msg = msg.replace(/#/g, '\"');").append(NL);
        htmlCode.append("scriptWin.document.writeln(msg);").append(NL);
        htmlCode.append("}").append(NL);
        htmlCode.append("</SCRIPT>").append(NL);
        htmlCode.append("</HEAD>").append(NL);
        htmlCode.append("<body>").append(NL);
        htmlCode.append("<h1>Query Test Results</h1>").append(NL);
        htmlCode.append("<table border=\"1\">").append(NL);
        TestResultsSummary.addTableRow(htmlCode, "StartTime", new Date(testStartTS).toString());
        TestResultsSummary.addTableRow(htmlCode, "EndTime", new Date(endTS).toString());
        TestResultsSummary.addTableRow(htmlCode, "Elapsed Time", (endTS - testStartTS) / 1000L + " seconds");
        TestResultsSummary.addTableRow(htmlCode, "Number Of Clients", String.valueOf(numberOfClients));
        Map passFailGenMap = TestResultsSummary.getPassFailGen(results);
        TestResultsSummary.addTableRow(htmlCode, "Number of Queries:", passFailGenMap.get("queries"));
        TestResultsSummary.addTableRow(htmlCode, "Number Passed    :", passFailGenMap.get("pass"));
        TestResultsSummary.addTableRow(htmlCode, "Number Failed    :", passFailGenMap.get("fail"));
        ResponseTimes responseTimes = TestResultsSummary.calcQueryResponseTimes(results);
        TestResultsSummary.addTableRow(htmlCode, "QPS :", Double.toString(responseTimes.qps));
        htmlCode.append("</table> <p>").append(NL);
        htmlCode.append("<table border=\"1\">").append(NL);
        htmlCode.append("<tr style=\"background: #C0C0C0 \">");
        TestResultsSummary.addTableData(htmlCode, "QueryId");
        TestResultsSummary.addTableData(htmlCode, "Result");
        TestResultsSummary.addTableData(htmlCode, "First Response");
        TestResultsSummary.addTableData(htmlCode, "Total Seconds");
        TestResultsSummary.addTableData(htmlCode, "Exception");
        TestResultsSummary.addTableData(htmlCode, "Error File (if any)");
        htmlCode.append("</tr>").append(NL);
        for (TestResult stat : results) {
            htmlCode.append("<tr>").append(NL);
            TestResultsSummary.addTableDataLink(htmlCode, stat.getQueryID(), "show('" + TestResultsSummary.scrub(stat.getQuery()) + "')");
            TestResultsSummary.addTableData(htmlCode, stat.getResultStatusString(), "fail".equalsIgnoreCase(stat.getResultStatusString()));
            TestResultsSummary.addTableData(htmlCode, new Date(stat.getBeginTS()).toString());
            TestResultsSummary.addTableData(htmlCode, Long.toString(stat.getEndTS() - stat.getBeginTS() / 1000L));
            if (stat.getStatus() == 1) {
                TestResultsSummary.addTableData(htmlCode, stat.getExceptionMsg());
                if (stat.getErrorfile() != null && !stat.getErrorfile().equals("null")) {
                    TestResultsSummary.addTableDataLink(htmlCode, stat.getErrorfile(), "");
                } else {
                    TestResultsSummary.addTableData(htmlCode, "");
                }
            } else {
                TestResultsSummary.addTableData(htmlCode, "");
                TestResultsSummary.addTableData(htmlCode, "");
            }
            htmlCode.append("</tr>").append(NL);
        }
        htmlCode.append("</table>").append(NL);
        outputStream.print(htmlCode.toString());
    }

    private static void addTableRow(StringBuffer table, String column, Object msg) {
        table.append("<tr>").append(NL);
        TestResultsSummary.addTableData(table, column);
        TestResultsSummary.addTableData(table, msg.toString());
        table.append("</tr>").append(NL);
    }

    private static void addTableData(StringBuffer table, String msg) {
        TestResultsSummary.addTableData(table, msg, false);
    }

    private static void addTableDataLink(StringBuffer table, String link, String jsEvent) {
        if (link.indexOf(".") == -1) {
            table.append("<td>").append("<a href=\"#" + link + "\" onclick=\"" + jsEvent + "\">" + link + "</a>").append("</td>").append(NL);
        } else {
            table.append("<td>").append("<a href=\"" + link + "\" onclick=\"" + jsEvent + "\">" + link + "</a>").append("</td>").append(NL);
        }
    }

    private static void addTableData(StringBuffer table, String msg, boolean error) {
        if (error) {
            table.append("<td style=\"background: #ffccff \">").append(msg).append("</td>").append(NL);
        } else {
            table.append("<td>").append(msg).append("</td>").append(NL);
        }
    }

    private static ResponseTimes calcQueryResponseTimes(Collection queryResults) {
        ResponseTimes responseTimes = new ResponseTimes();
        int nQueries = 0;
        double totalSecs = 0.0;
        double totalFullMilliSecs = 0.0;
        for (TestResult result : queryResults) {
            ++nQueries;
            double startTS = result.getBeginTS();
            double fullResponseTimeStamp = result.getEndTS();
            totalSecs += (fullResponseTimeStamp - startTS) / 1000.0;
            totalFullMilliSecs += fullResponseTimeStamp - startTS;
        }
        responseTimes.qps = totalSecs > 0.0 ? (double)nQueries / totalSecs : -1.0;
        responseTimes.full = nQueries > 0 ? totalFullMilliSecs / (double)nQueries : -1.0;
        return responseTimes;
    }

    private static String scrub(String str) {
        if (str != null) {
            str = str.replace('\"', '#');
            str = str.replace('\'', '#');
        }
        return str;
    }

    private static void writeQueryResult(PrintStream outputStream, SimpleDateFormat formatter, TestResult stat) {
        outputStream.print(stat.getQueryID());
        outputStream.print(",");
        outputStream.print(stat.getResultStatusString());
        outputStream.print(",");
        outputStream.print(stat.getBeginTS());
        outputStream.print(",");
        outputStream.print(stat.getEndTS());
        outputStream.print(",");
        outputStream.print(TestResultsSummary.getFormattedTimestamp(formatter, stat.getBeginTS()));
        outputStream.print(",");
        outputStream.print(TestResultsSummary.getFormattedTimestamp(formatter, stat.getEndTS()));
        outputStream.print(",");
        outputStream.println(stat.getStatus() != 0 ? stat.getExceptionMsg() : "");
    }

    private static String getFormattedTimestamp(SimpleDateFormat format, long millis) {
        return format.format(new Date(millis));
    }

    private static class ResponseTimes {
        double first;
        double full;
        double qps;

        private ResponseTimes() {
        }
    }
}

