/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.RuleChooseDependent;
import org.teiid.query.optimizer.relational.rules.RuleChooseJoinStrategy;
import org.teiid.query.optimizer.relational.rules.RulePlaceAccess;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestRuleChooseDependent {
    private static final int LEFT_SIDE = 1;
    private static final int RIGHT_SIDE = 2;
    private static final int NEITHER_SIDE = 3;
    private QueryMetadataInterface metadata = RealMetadataFactory.example1Cached();
    private static final boolean DEBUG = false;

    public PlanNode createAccessNode(Collection groupSymbols) throws Exception {
        PlanNode accessNode = NodeFactory.getNewNode((int)1);
        PlanNode joinNode = NodeFactory.getNewNode((int)4);
        PlanNode sourceNode = NodeFactory.getNewNode((int)64);
        joinNode.setProperty(NodeConstants.Info.JOIN_TYPE, (Object)JoinType.JOIN_INNER);
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(new CompareCriteria((Expression)this.getElementSymbol(1, 1), 1, (Expression)this.getElementSymbol(2, 1)));
        joinNode.setProperty(NodeConstants.Info.JOIN_CRITERIA, crits);
        joinNode.addFirstChild(accessNode);
        accessNode.addFirstChild(sourceNode);
        for (GroupSymbol gs : groupSymbols) {
            accessNode.addGroup(gs);
            sourceNode.addGroup(gs);
        }
        return accessNode;
    }

    public GroupSymbol getVirtualGroup() throws Exception {
        GroupSymbol gs = new GroupSymbol("vm1.g1");
        ResolverUtil.resolveGroup((GroupSymbol)gs, (QueryMetadataInterface)this.metadata);
        return gs;
    }

    public GroupSymbol getPhysicalGroup(int num) throws Exception {
        String id = "pm1.g" + num;
        GroupSymbol gs = new GroupSymbol(id);
        ResolverUtil.resolveGroup((GroupSymbol)gs, (QueryMetadataInterface)this.metadata);
        return gs;
    }

    public GroupSymbol getPhysicalGroup(int modelNum, int num) throws Exception {
        String id = "pm" + modelNum + ".g" + num;
        GroupSymbol gs = new GroupSymbol(id);
        ResolverUtil.resolveGroup((GroupSymbol)gs, (QueryMetadataInterface)this.metadata);
        return gs;
    }

    public GroupSymbol getPhysicalGroupWithAlias(int num, String alias) throws Exception {
        String id = "pm1.g" + num;
        GroupSymbol gs = new GroupSymbol(alias, id);
        ResolverUtil.resolveGroup((GroupSymbol)gs, (QueryMetadataInterface)this.metadata);
        return gs;
    }

    public ElementSymbol getElementSymbol(int groupNum, int elementNum) throws Exception {
        String id = "pm1.g" + groupNum + ".e" + elementNum;
        ElementSymbol es = new ElementSymbol(id);
        es.setMetadataID(this.metadata.getElementID(id));
        es.setGroupSymbol(this.getPhysicalGroup(groupNum));
        return es;
    }

    public ElementSymbol getElementSymbol(int modelNum, int groupNum, int elementNum) throws Exception {
        String id = "pm" + modelNum + ".g" + groupNum + ".e" + elementNum;
        ElementSymbol es = new ElementSymbol(id);
        es.setMetadataID(this.metadata.getElementID(id));
        es.setGroupSymbol(this.getPhysicalGroup(modelNum, groupNum));
        return es;
    }

    public ElementSymbol getElementSymbolWithGroupAlias(int groupNum, int elementNum, String alias) throws Exception {
        String id = "pm1.g" + groupNum + ".e" + elementNum;
        ElementSymbol es = new ElementSymbol(id);
        es.setMetadataID(this.metadata.getElementID(id));
        es.setGroupSymbol(this.getPhysicalGroupWithAlias(groupNum, alias));
        return es;
    }

    public Query createBaseQuery() throws Exception {
        Query query = new Query();
        Select select = new Select();
        select.addSymbol((Expression)this.getElementSymbol(1, 1));
        query.setSelect(select);
        From from = new From();
        from.addGroup(this.getPhysicalGroup(1));
        query.setFrom(from);
        return query;
    }

    public void helpTestValidJoin(PlanNode joinNode, PlanNode accessNode, boolean expectedValid) throws QueryMetadataException, TeiidComponentException {
        RuleChooseDependent rule = new RuleChooseDependent();
        RuleChooseJoinStrategy.chooseJoinStrategy((PlanNode)joinNode, (QueryMetadataInterface)this.metadata);
        boolean isValid = rule.isValidJoin(joinNode, accessNode, AnalysisRecord.createNonRecordingRecord());
        Assert.assertEquals((String)"Valid join check is wrong ", (Object)expectedValid, (Object)isValid);
    }

    private void helpTestChooseSiblingAndMarkDependent(GroupSymbol atomicRequestGroup1, Criteria atomicRequestCrit1, GroupSymbol atomicRequestGroup2, Criteria atomicRequestCrit2, Collection joinCriteria, int expectedMadeDependent) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        this.helpTestChooseSiblingAndMarkDependent(atomicRequestGroup1, atomicRequestCrit1, null, null, null, atomicRequestGroup2, atomicRequestCrit2, null, null, null, joinCriteria, expectedMadeDependent, null, null);
    }

    private void helpTestChooseSiblingAndMarkDependent(GroupSymbol atomicRequestGroup1, Criteria atomicRequestCrit1, GroupSymbol atomicRequestGroup1a, Criteria atomicRequestCrit1a, Collection atomicJoinCriteria1, GroupSymbol atomicRequestGroup2, Criteria atomicRequestCrit2, GroupSymbol atomicRequestGroup2a, Criteria atomicRequestCrit2a, Collection atomicJoinCriteria2, Collection joinCriteria, int expectedMadeDependent, Number expectedCost1, Number expectedCost2) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        PlanNode accessNode1 = NodeFactory.getNewNode((int)1);
        accessNode1.addGroup(atomicRequestGroup1);
        if (atomicRequestGroup1a != null) {
            accessNode1.addGroup(atomicRequestGroup1a);
        }
        PlanNode accessNode2 = NodeFactory.getNewNode((int)1);
        accessNode2.addGroup(atomicRequestGroup2);
        if (atomicRequestGroup2a != null) {
            accessNode2.addGroup(atomicRequestGroup2a);
        }
        PlanNode joinNode = NodeFactory.getNewNode((int)4);
        joinNode.setProperty(NodeConstants.Info.JOIN_TYPE, (Object)JoinType.JOIN_INNER);
        joinNode.setProperty(NodeConstants.Info.JOIN_CRITERIA, (Object)joinCriteria);
        joinNode.setProperty(NodeConstants.Info.JOIN_STRATEGY, (Object)JoinNode.JoinStrategyType.NESTED_LOOP);
        joinNode.addLastChild(accessNode1);
        joinNode.addLastChild(accessNode2);
        PlanNode bogusParentNode = NodeFactory.getNewNode((int)8);
        bogusParentNode.addLastChild(joinNode);
        PlanNode sourceNode1 = NodeFactory.getNewNode((int)64);
        sourceNode1.addGroup(atomicRequestGroup1);
        if (atomicRequestCrit1 != null) {
            PlanNode selectNode1 = NodeFactory.getNewNode((int)16);
            selectNode1.setProperty(NodeConstants.Info.SELECT_CRITERIA, (Object)atomicRequestCrit1);
            selectNode1.addGroup(atomicRequestGroup1);
            selectNode1.addFirstChild(sourceNode1);
            if (atomicRequestGroup1a != null) {
                PlanNode atomicJoinNode1 = NodeFactory.getNewNode((int)4);
                if (atomicJoinCriteria1.isEmpty()) {
                    atomicJoinNode1.setProperty(NodeConstants.Info.JOIN_TYPE, (Object)JoinType.JOIN_CROSS);
                } else {
                    atomicJoinNode1.setProperty(NodeConstants.Info.JOIN_TYPE, (Object)JoinType.JOIN_INNER);
                    atomicJoinNode1.setProperty(NodeConstants.Info.JOIN_CRITERIA, (Object)atomicJoinCriteria1);
                }
                atomicJoinNode1.addGroup(atomicRequestGroup1);
                atomicJoinNode1.addGroup(atomicRequestGroup1a);
                atomicJoinNode1.addLastChild(selectNode1);
                PlanNode sourceNode1a = NodeFactory.getNewNode((int)64);
                sourceNode1a.addGroup(atomicRequestGroup1a);
                if (atomicRequestCrit1a != null) {
                    PlanNode selectNode1a = NodeFactory.getNewNode((int)16);
                    selectNode1a.setProperty(NodeConstants.Info.SELECT_CRITERIA, (Object)atomicRequestCrit1a);
                    selectNode1a.addGroup(atomicRequestGroup1a);
                    selectNode1a.addFirstChild(sourceNode1a);
                    atomicJoinNode1.addLastChild(selectNode1a);
                } else {
                    atomicJoinNode1.addLastChild(sourceNode1a);
                }
                accessNode1.addLastChild(atomicJoinNode1);
            } else {
                accessNode1.addFirstChild(selectNode1);
            }
        } else {
            accessNode1.addFirstChild(sourceNode1);
        }
        PlanNode sourceNode2 = NodeFactory.getNewNode((int)64);
        sourceNode2.addGroup(atomicRequestGroup2);
        if (atomicRequestCrit2 != null) {
            PlanNode selectNode2 = NodeFactory.getNewNode((int)16);
            selectNode2.setProperty(NodeConstants.Info.SELECT_CRITERIA, (Object)atomicRequestCrit2);
            selectNode2.addGroup(atomicRequestGroup2);
            selectNode2.addFirstChild(sourceNode2);
            if (atomicRequestGroup2a != null) {
                PlanNode atomicJoinNode2 = NodeFactory.getNewNode((int)4);
                if (atomicJoinCriteria2.isEmpty()) {
                    atomicJoinNode2.setProperty(NodeConstants.Info.JOIN_TYPE, (Object)JoinType.JOIN_CROSS);
                } else {
                    atomicJoinNode2.setProperty(NodeConstants.Info.JOIN_TYPE, (Object)JoinType.JOIN_INNER);
                    atomicJoinNode2.setProperty(NodeConstants.Info.JOIN_CRITERIA, (Object)atomicJoinCriteria2);
                }
                atomicJoinNode2.addGroup(atomicRequestGroup2);
                atomicJoinNode2.addGroup(atomicRequestGroup2a);
                atomicJoinNode2.addLastChild(selectNode2);
                PlanNode sourceNode2a = NodeFactory.getNewNode((int)64);
                sourceNode2a.addGroup(atomicRequestGroup2a);
                if (atomicRequestCrit2a != null) {
                    PlanNode selectNode2a = NodeFactory.getNewNode((int)16);
                    selectNode2a.setProperty(NodeConstants.Info.SELECT_CRITERIA, (Object)atomicRequestCrit2a);
                    selectNode2a.addGroup(atomicRequestGroup2a);
                    selectNode2a.addFirstChild(sourceNode2a);
                    atomicJoinNode2.addLastChild(selectNode2a);
                } else {
                    atomicJoinNode2.addLastChild(sourceNode2a);
                }
                accessNode2.addLastChild(atomicJoinNode2);
            } else {
                accessNode2.addFirstChild(selectNode2);
            }
        } else {
            accessNode2.addFirstChild(sourceNode2);
        }
        RulePlaceAccess.addAccessPatternsProperty((PlanNode)accessNode1, (QueryMetadataInterface)this.metadata);
        RulePlaceAccess.addAccessPatternsProperty((PlanNode)accessNode2, (QueryMetadataInterface)this.metadata);
        RuleChooseDependent rule = new RuleChooseDependent();
        RuleChooseJoinStrategy.chooseJoinStrategy((PlanNode)joinNode, (QueryMetadataInterface)this.metadata);
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        capFinder.addCapabilities("pm1", (SourceCapabilities)TestOptimizer.getTypicalCapabilities());
        capFinder.addCapabilities("pm2", (SourceCapabilities)TestOptimizer.getTypicalCapabilities());
        capFinder.addCapabilities("pm3", (SourceCapabilities)TestOptimizer.getTypicalCapabilities());
        capFinder.addCapabilities("pm4", (SourceCapabilities)TestOptimizer.getTypicalCapabilities());
        rule.execute(bogusParentNode, this.metadata, (CapabilitiesFinder)capFinder, new RuleStack(), null, new CommandContext());
        Object prop1 = joinNode.getProperty(NodeConstants.Info.DEPENDENT_VALUE_SOURCE);
        if (expectedMadeDependent == 1) {
            Assert.assertNotNull((String)"Expected one side to be made dependent", (Object)prop1);
            Assert.assertEquals((Object)accessNode1, (Object)FrameUtil.findJoinSourceNode((PlanNode)joinNode.getLastChild()));
        } else if (expectedMadeDependent == 2) {
            Assert.assertNotNull((String)"Expected one side to be made dependent", (Object)prop1);
            Assert.assertEquals((Object)accessNode2, (Object)FrameUtil.findJoinSourceNode((PlanNode)joinNode.getLastChild()));
        } else if (expectedMadeDependent == 3) {
            Assert.assertNull((String)"Neither side should be dependent", (Object)prop1);
        } else {
            Assert.fail((String)("Invalid test constant " + expectedMadeDependent));
        }
        Float cost1 = (Float)accessNode1.getProperty(NodeConstants.Info.EST_CARDINALITY);
        Float cost2 = (Float)accessNode2.getProperty(NodeConstants.Info.EST_CARDINALITY);
        Assert.assertNotNull((Object)cost2);
        Assert.assertNotNull((Object)cost1);
        if (expectedCost1 != null) {
            Assert.assertEquals((long)expectedCost1.longValue(), (long)cost1.longValue());
            Assert.assertEquals((long)expectedCost2.longValue(), (long)cost2.longValue());
        }
    }

    @Test
    public void testValidJoin1() throws Exception {
        PlanNode accessNode = NodeFactory.getNewNode((int)1);
        accessNode.addGroup(this.getPhysicalGroup(1));
        PlanNode joinNode = NodeFactory.getNewNode((int)4);
        joinNode.setProperty(NodeConstants.Info.JOIN_TYPE, (Object)JoinType.JOIN_CROSS);
        joinNode.addFirstChild(accessNode);
        this.helpTestValidJoin(joinNode, accessNode, false);
    }

    @Test
    public void testValidJoin2() throws Exception {
        PlanNode accessNode = NodeFactory.getNewNode((int)1);
        accessNode.addGroup(this.getPhysicalGroup(1));
        PlanNode joinNode = NodeFactory.getNewNode((int)4);
        joinNode.setProperty(NodeConstants.Info.JOIN_TYPE, (Object)JoinType.JOIN_FULL_OUTER);
        joinNode.setProperty(NodeConstants.Info.JOIN_CRITERIA, Arrays.asList(QueryRewriter.FALSE_CRITERIA));
        joinNode.addFirstChild(accessNode);
        this.helpTestValidJoin(joinNode, accessNode, false);
    }

    @Test
    public void testValidJoin3() throws Exception {
        PlanNode accessNode1 = NodeFactory.getNewNode((int)1);
        PlanNode accessNode2 = NodeFactory.getNewNode((int)1);
        accessNode1.addGroup(this.getPhysicalGroup(1));
        accessNode2.addGroup(this.getPhysicalGroup(2));
        PlanNode joinNode = NodeFactory.getNewNode((int)4);
        joinNode.setProperty(NodeConstants.Info.JOIN_TYPE, (Object)JoinType.JOIN_RIGHT_OUTER);
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(new CompareCriteria((Expression)this.getElementSymbol(1, 1), 1, (Expression)this.getElementSymbol(2, 1)));
        joinNode.setProperty(NodeConstants.Info.JOIN_CRITERIA, crits);
        joinNode.addLastChild(accessNode1);
        joinNode.addLastChild(accessNode2);
        this.helpTestValidJoin(joinNode, accessNode1, true);
    }

    @Test
    public void testValidJoin4() throws Exception {
        PlanNode accessNode1 = NodeFactory.getNewNode((int)1);
        PlanNode accessNode2 = NodeFactory.getNewNode((int)1);
        PlanNode joinNode = NodeFactory.getNewNode((int)4);
        joinNode.setProperty(NodeConstants.Info.JOIN_TYPE, (Object)JoinType.JOIN_RIGHT_OUTER);
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(new CompareCriteria((Expression)this.getElementSymbol(1, 1), 1, (Expression)this.getElementSymbol(2, 1)));
        joinNode.setProperty(NodeConstants.Info.JOIN_CRITERIA, crits);
        joinNode.addLastChild(accessNode1);
        joinNode.addLastChild(accessNode2);
        this.helpTestValidJoin(joinNode, accessNode2, false);
    }

    @Test
    public void testValidJoin5() throws Exception {
        PlanNode accessNode1 = NodeFactory.getNewNode((int)1);
        PlanNode accessNode2 = NodeFactory.getNewNode((int)1);
        PlanNode joinNode = NodeFactory.getNewNode((int)4);
        joinNode.setProperty(NodeConstants.Info.JOIN_TYPE, (Object)JoinType.JOIN_LEFT_OUTER);
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(new CompareCriteria((Expression)this.getElementSymbol(1, 1), 1, (Expression)this.getElementSymbol(2, 1)));
        joinNode.setProperty(NodeConstants.Info.JOIN_CRITERIA, crits);
        joinNode.addLastChild(accessNode1);
        joinNode.addLastChild(accessNode2);
        this.helpTestValidJoin(joinNode, accessNode1, false);
    }

    @Test
    public void testValidJoin6() throws Exception {
        PlanNode accessNode1 = NodeFactory.getNewNode((int)1);
        PlanNode accessNode2 = NodeFactory.getNewNode((int)1);
        accessNode1.addGroup(this.getPhysicalGroup(1));
        accessNode2.addGroup(this.getPhysicalGroup(2));
        PlanNode joinNode = NodeFactory.getNewNode((int)4);
        joinNode.setProperty(NodeConstants.Info.JOIN_TYPE, (Object)JoinType.JOIN_LEFT_OUTER);
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>();
        crits.add(new CompareCriteria((Expression)this.getElementSymbol(1, 1), 1, (Expression)this.getElementSymbol(2, 1)));
        joinNode.setProperty(NodeConstants.Info.JOIN_CRITERIA, crits);
        joinNode.addLastChild(accessNode1);
        joinNode.addLastChild(accessNode2);
        this.helpTestValidJoin(joinNode, accessNode2, true);
    }

    @Test
    public void testChooseKey() throws Exception {
        this.metadata = RealMetadataFactory.example4();
        GroupSymbol group1 = this.getPhysicalGroup(2, 3);
        GroupSymbol group2 = this.getPhysicalGroup(3, 3);
        ElementSymbol group1e1 = this.getElementSymbol(2, 3, 1);
        ElementSymbol group2e1 = this.getElementSymbol(3, 3, 1);
        CompareCriteria crit = new CompareCriteria((Expression)group2e1, 1, (Expression)group1e1);
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>(1);
        crits.add(crit);
        Criteria atomicCrit1 = null;
        CompareCriteria atomicCrit2 = new CompareCriteria((Expression)group2e1, 1, (Expression)new Constant((Object)new Integer(5)));
        int expected = 1;
        this.helpTestChooseSiblingAndMarkDependent(group1, atomicCrit1, group2, (Criteria)atomicCrit2, crits, expected);
        expected = 2;
        this.helpTestChooseSiblingAndMarkDependent(group2, (Criteria)atomicCrit2, group1, atomicCrit1, crits, expected);
    }

    @Test
    public void testChooseKey2() throws Exception {
        this.metadata = RealMetadataFactory.example4();
        GroupSymbol group1 = this.getPhysicalGroup(2, 3);
        GroupSymbol group1a = null;
        GroupSymbol group2 = this.getPhysicalGroup(3, 3);
        GroupSymbol group2a = this.getPhysicalGroup(3, 2);
        ElementSymbol group1e1 = this.getElementSymbol(2, 3, 1);
        ElementSymbol group2e1 = this.getElementSymbol(3, 3, 1);
        ElementSymbol group2e2 = this.getElementSymbol(3, 3, 2);
        ElementSymbol group2ae1 = this.getElementSymbol(3, 2, 1);
        CompareCriteria crit = new CompareCriteria((Expression)group2e1, 1, (Expression)group1e1);
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>(1);
        crits.add(crit);
        Criteria atomicCrit1 = null;
        Criteria atomicCrit1a = null;
        CompareCriteria atomicCrit2 = new CompareCriteria((Expression)group2e2, 1, (Expression)new Constant((Object)new Integer(5)));
        Criteria atomicCrit2a = null;
        Collection atomicJoinCrits1 = null;
        CompareCriteria atomicJoinCrit2 = new CompareCriteria((Expression)group2ae1, 1, (Expression)group2e1);
        ArrayList<CompareCriteria> atomicJoinCrits2 = new ArrayList<CompareCriteria>(1);
        atomicJoinCrits2.add(atomicJoinCrit2);
        int expected = 3;
        this.helpTestChooseSiblingAndMarkDependent(group1, atomicCrit1, group1a, atomicCrit1a, atomicJoinCrits1, group2, (Criteria)atomicCrit2, group2a, atomicCrit2a, atomicJoinCrits2, crits, expected, -1, 99798);
    }

    @Test
    public void testCardinality() throws Exception {
        this.metadata = RealMetadataFactory.example4();
        GroupSymbol group1 = this.getPhysicalGroup(1, 2);
        GroupSymbol group2 = this.getPhysicalGroup(2, 2);
        ElementSymbol pm1g2e1 = this.getElementSymbol(1, 2, 1);
        ElementSymbol pm2g2e1 = this.getElementSymbol(2, 2, 1);
        CompareCriteria crit = new CompareCriteria((Expression)pm2g2e1, 1, (Expression)pm1g2e1);
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>(2);
        crits.add(crit);
        ElementSymbol pm1g2e2 = this.getElementSymbol(1, 2, 2);
        ElementSymbol pm2g2e2 = this.getElementSymbol(2, 2, 2);
        CompareCriteria crit2 = new CompareCriteria((Expression)pm1g2e2, 1, (Expression)pm2g2e2);
        crits.add(crit2);
        Criteria atomicCrit1 = null;
        Criteria atomicCrit2 = null;
        int expected = 2;
        this.helpTestChooseSiblingAndMarkDependent(group1, atomicCrit1, group2, atomicCrit2, crits, expected);
        expected = 1;
        this.helpTestChooseSiblingAndMarkDependent(group2, atomicCrit2, group1, atomicCrit1, crits, expected);
    }

    @Test
    public void testCardinalityAndKey() throws Exception {
        this.metadata = RealMetadataFactory.example4();
        GroupSymbol group1 = this.getPhysicalGroup(1, 2);
        GroupSymbol group2 = this.getPhysicalGroup(2, 2);
        ElementSymbol pm1g2e1 = this.getElementSymbol(1, 2, 1);
        ElementSymbol pm2g2e1 = this.getElementSymbol(2, 2, 1);
        CompareCriteria crit = new CompareCriteria((Expression)pm2g2e1, 1, (Expression)pm1g2e1);
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>(1);
        crits.add(crit);
        ElementSymbol pm1g2e2 = this.getElementSymbol(1, 2, 2);
        ElementSymbol pm2g2e2 = this.getElementSymbol(2, 2, 2);
        CompareCriteria crit2 = new CompareCriteria((Expression)pm1g2e2, 1, (Expression)pm2g2e2);
        crits.add(crit2);
        Criteria atomicCrit1 = null;
        Criteria atomicCrit2 = null;
        int expected = 2;
        this.helpTestChooseSiblingAndMarkDependent(group1, atomicCrit1, group2, atomicCrit2, crits, expected);
        expected = 1;
        this.helpTestChooseSiblingAndMarkDependent(group2, atomicCrit2, group1, atomicCrit1, crits, expected);
    }

    @Test
    public void testCardinalityAndKeyNestedLoop() throws Exception {
        this.metadata = RealMetadataFactory.example4();
        GroupSymbol group1 = this.getPhysicalGroup(1, 2);
        GroupSymbol group2 = this.getPhysicalGroup(2, 2);
        ElementSymbol pm1g2e1 = this.getElementSymbol(1, 2, 1);
        ElementSymbol pm2g2e1 = this.getElementSymbol(2, 2, 1);
        CompareCriteria crit = new CompareCriteria((Expression)pm2g2e1, 1, (Expression)pm1g2e1);
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>(1);
        crits.add(crit);
        ElementSymbol pm1g2e2 = this.getElementSymbol(1, 2, 2);
        ElementSymbol pm2g2e2 = this.getElementSymbol(2, 2, 2);
        CompareCriteria crit2 = new CompareCriteria((Expression)pm1g2e2, 3, (Expression)pm2g2e2);
        crits.add(crit2);
        Criteria atomicCrit1 = null;
        Criteria atomicCrit2 = null;
        int expected = 2;
        this.helpTestChooseSiblingAndMarkDependent(group1, atomicCrit1, group2, atomicCrit2, crits, expected);
        expected = 1;
        this.helpTestChooseSiblingAndMarkDependent(group2, atomicCrit2, group1, atomicCrit1, crits, expected);
    }

    @Test
    public void testRejectDependentJoin() throws Exception {
        this.metadata = RealMetadataFactory.example4();
        GroupSymbol group1 = this.getPhysicalGroup(3, 1);
        GroupSymbol group2 = this.getPhysicalGroup(3, 2);
        ElementSymbol pm3g1e2 = this.getElementSymbol(3, 1, 2);
        ElementSymbol pm3g2e2 = this.getElementSymbol(3, 2, 2);
        CompareCriteria crit = new CompareCriteria((Expression)pm3g1e2, 1, (Expression)pm3g2e2);
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>(1);
        crits.add(crit);
        Criteria atomicCrit1 = null;
        Criteria atomicCrit2 = null;
        int expected = 3;
        this.helpTestChooseSiblingAndMarkDependent(group1, atomicCrit1, group2, atomicCrit2, crits, expected);
        expected = 3;
        this.helpTestChooseSiblingAndMarkDependent(group2, atomicCrit2, group1, atomicCrit1, crits, expected);
    }

    @Test
    public void testCardinalityWithKeyCrit() throws Exception {
        this.metadata = RealMetadataFactory.example4();
        GroupSymbol group1 = this.getPhysicalGroup(1, 2);
        ElementSymbol g1e2 = this.getElementSymbol(1, 2, 2);
        GroupSymbol group2 = this.getPhysicalGroup(3, 3);
        ElementSymbol g2e1 = this.getElementSymbol(3, 3, 1);
        ElementSymbol g2e2 = this.getElementSymbol(3, 3, 2);
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>(1);
        CompareCriteria crit2 = new CompareCriteria((Expression)g1e2, 1, (Expression)g2e2);
        crits.add(crit2);
        Criteria atomicCrit1 = null;
        CompareCriteria atomicCrit2 = new CompareCriteria((Expression)g2e1, 1, (Expression)new Constant((Object)new Integer(5)));
        int expected = 1;
        this.helpTestChooseSiblingAndMarkDependent(group1, atomicCrit1, group2, (Criteria)atomicCrit2, crits, expected);
        expected = 2;
        this.helpTestChooseSiblingAndMarkDependent(group2, (Criteria)atomicCrit2, group1, atomicCrit1, crits, expected);
    }

    @Test
    public void testCardinalityWithKeyCompoundCritAND() throws Exception {
        this.metadata = RealMetadataFactory.example4();
        GroupSymbol group1 = this.getPhysicalGroup(1, 2);
        ElementSymbol g1e2 = this.getElementSymbol(1, 2, 2);
        GroupSymbol group2 = this.getPhysicalGroup(3, 3);
        ElementSymbol g2e1 = this.getElementSymbol(3, 3, 1);
        ElementSymbol g2e2 = this.getElementSymbol(3, 3, 2);
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>(1);
        crits.add(new CompareCriteria((Expression)g1e2, 1, (Expression)g2e2));
        Criteria atomicCrit1 = null;
        CompareCriteria crit1 = new CompareCriteria((Expression)g2e1, 1, (Expression)new Constant((Object)new Integer(5)));
        CompareCriteria crit2 = new CompareCriteria((Expression)g2e1, 1, (Expression)new Constant((Object)new Integer(7)));
        CompoundCriteria atomicCrit2 = new CompoundCriteria(0, (Criteria)crit1, (Criteria)crit2);
        int expected = 1;
        this.helpTestChooseSiblingAndMarkDependent(group1, atomicCrit1, group2, (Criteria)atomicCrit2, crits, expected);
        expected = 2;
        this.helpTestChooseSiblingAndMarkDependent(group2, (Criteria)atomicCrit2, group1, atomicCrit1, crits, expected);
    }

    @Test
    public void testCardinalityWithKeyCompoundCritOR() throws Exception {
        this.metadata = RealMetadataFactory.example4();
        GroupSymbol group1 = this.getPhysicalGroup(1, 2);
        ElementSymbol g1e2 = this.getElementSymbol(1, 2, 2);
        GroupSymbol group2 = this.getPhysicalGroup(3, 3);
        ElementSymbol g2e1 = this.getElementSymbol(3, 3, 1);
        ElementSymbol g2e2 = this.getElementSymbol(3, 3, 2);
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>(1);
        crits.add(new CompareCriteria((Expression)g1e2, 1, (Expression)g2e2));
        Criteria atomicCrit1 = null;
        CompareCriteria crit1 = new CompareCriteria((Expression)g2e1, 1, (Expression)new Constant((Object)new Integer(5)));
        CompareCriteria crit2 = new CompareCriteria((Expression)g2e1, 1, (Expression)new Constant((Object)new Integer(7)));
        CompoundCriteria atomicCrit2 = new CompoundCriteria(1, (Criteria)crit1, (Criteria)crit2);
        int expected = 1;
        this.helpTestChooseSiblingAndMarkDependent(group1, atomicCrit1, group2, (Criteria)atomicCrit2, crits, expected);
        expected = 2;
        this.helpTestChooseSiblingAndMarkDependent(group2, (Criteria)atomicCrit2, group1, atomicCrit1, crits, expected);
    }

    @Test
    public void testCardinalityWithKeySetCrit() throws Exception {
        this.metadata = RealMetadataFactory.example4();
        GroupSymbol group1 = this.getPhysicalGroup(1, 2);
        ElementSymbol g1e2 = this.getElementSymbol(1, 2, 2);
        GroupSymbol group2 = this.getPhysicalGroup(3, 3);
        ElementSymbol g2e1 = this.getElementSymbol(3, 3, 1);
        ElementSymbol g2e2 = this.getElementSymbol(3, 3, 2);
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>(1);
        CompareCriteria crit2 = new CompareCriteria((Expression)g1e2, 1, (Expression)g2e2);
        crits.add(crit2);
        Criteria atomicCrit1 = null;
        LinkedList<Constant> values = new LinkedList<Constant>();
        values.add(new Constant((Object)new Integer(3)));
        values.add(new Constant((Object)new Integer(4)));
        values.add(new Constant((Object)new Integer(5)));
        SetCriteria atomicCrit2 = new SetCriteria((Expression)g2e1, values);
        int expected = 1;
        this.helpTestChooseSiblingAndMarkDependent(group1, atomicCrit1, group2, (Criteria)atomicCrit2, crits, expected);
        expected = 2;
        this.helpTestChooseSiblingAndMarkDependent(group2, (Criteria)atomicCrit2, group1, atomicCrit1, crits, expected);
    }

    @Test
    public void testCardinalityWithKeyMatchCrit() throws Exception {
        this.metadata = RealMetadataFactory.example4();
        GroupSymbol group1 = this.getPhysicalGroup(1, 2);
        ElementSymbol g1e2 = this.getElementSymbol(1, 2, 2);
        GroupSymbol group2 = this.getPhysicalGroup(3, 3);
        ElementSymbol g2e1 = this.getElementSymbol(3, 3, 1);
        ElementSymbol g2e2 = this.getElementSymbol(3, 3, 2);
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>(1);
        CompareCriteria crit2 = new CompareCriteria((Expression)g1e2, 1, (Expression)g2e2);
        crits.add(crit2);
        Criteria atomicCrit1 = null;
        MatchCriteria atomicCrit2 = new MatchCriteria((Expression)g2e1, (Expression)new Constant((Object)new String("ab%")));
        int expected = 2;
        this.helpTestChooseSiblingAndMarkDependent(group1, atomicCrit1, group2, (Criteria)atomicCrit2, crits, expected);
        expected = 1;
        this.helpTestChooseSiblingAndMarkDependent(group2, (Criteria)atomicCrit2, group1, atomicCrit1, crits, expected);
    }

    @Test
    public void testCardinalityWithKeyIsNullCrit() throws Exception {
        this.metadata = RealMetadataFactory.example4();
        GroupSymbol group1 = this.getPhysicalGroup(1, 2);
        ElementSymbol g1e2 = this.getElementSymbol(1, 2, 2);
        GroupSymbol group2 = this.getPhysicalGroup(3, 3);
        ElementSymbol g2e1 = this.getElementSymbol(3, 3, 1);
        ElementSymbol g2e2 = this.getElementSymbol(3, 3, 2);
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>(1);
        CompareCriteria crit2 = new CompareCriteria((Expression)g1e2, 1, (Expression)g2e2);
        crits.add(crit2);
        Criteria atomicCrit1 = null;
        IsNullCriteria atomicCrit2 = new IsNullCriteria((Expression)g2e1);
        int expected = 1;
        this.helpTestChooseSiblingAndMarkDependent(group1, atomicCrit1, group2, (Criteria)atomicCrit2, crits, expected);
        expected = 2;
        this.helpTestChooseSiblingAndMarkDependent(group2, (Criteria)atomicCrit2, group1, atomicCrit1, crits, expected);
    }

    @Test
    public void testCardinalityWithKeyNotCrit() throws Exception {
        this.metadata = RealMetadataFactory.example4();
        GroupSymbol group1 = this.getPhysicalGroup(1, 2);
        ElementSymbol g1e2 = this.getElementSymbol(1, 2, 2);
        GroupSymbol group2 = this.getPhysicalGroup(3, 3);
        ElementSymbol g2e1 = this.getElementSymbol(3, 3, 1);
        ElementSymbol g2e2 = this.getElementSymbol(3, 3, 2);
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>(1);
        CompareCriteria crit2 = new CompareCriteria((Expression)g1e2, 1, (Expression)g2e2);
        crits.add(crit2);
        Criteria atomicCrit1 = null;
        CompareCriteria atomicCrit2 = new CompareCriteria((Expression)g2e1, 1, (Expression)new Constant((Object)new Integer(5)));
        atomicCrit2 = new NotCriteria((Criteria)atomicCrit2);
        int expected = 2;
        this.helpTestChooseSiblingAndMarkDependent(group1, atomicCrit1, group2, (Criteria)atomicCrit2, crits, expected);
        expected = 1;
        this.helpTestChooseSiblingAndMarkDependent(group2, (Criteria)atomicCrit2, group1, atomicCrit1, crits, expected);
    }

    @Test
    public void testCardinalityWithKeyComplexCrit() throws Exception {
        this.metadata = RealMetadataFactory.example4();
        GroupSymbol group1 = this.getPhysicalGroup(1, 2);
        ElementSymbol g1e2 = this.getElementSymbol(1, 2, 2);
        GroupSymbol group2 = this.getPhysicalGroup(3, 3);
        ElementSymbol g2e1 = this.getElementSymbol(3, 3, 1);
        ElementSymbol g2e2 = this.getElementSymbol(3, 3, 2);
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>(1);
        crits.add(new CompareCriteria((Expression)g1e2, 1, (Expression)g2e2));
        Criteria atomicCrit1 = null;
        CompareCriteria crit1 = new CompareCriteria((Expression)g2e1, 1, (Expression)new Constant((Object)new Integer(5)));
        CompareCriteria crit2 = new CompareCriteria((Expression)g2e1, 1, (Expression)new Constant((Object)new Integer(7)));
        CompoundCriteria atomicCrit2 = new CompoundCriteria(0, (Criteria)crit1, (Criteria)crit2);
        MatchCriteria crit3 = new MatchCriteria((Expression)g2e1, (Expression)new Constant((Object)new String("ab")));
        atomicCrit2 = new CompoundCriteria(1, (Criteria)atomicCrit2, (Criteria)crit3);
        int expected = 1;
        this.helpTestChooseSiblingAndMarkDependent(group1, atomicCrit1, group2, (Criteria)atomicCrit2, crits, expected);
        expected = 2;
        this.helpTestChooseSiblingAndMarkDependent(group2, (Criteria)atomicCrit2, group1, atomicCrit1, crits, expected);
    }

    @Test
    public void testCardinalityWithKeyComplexCrit2() throws Exception {
        this.metadata = RealMetadataFactory.example4();
        GroupSymbol group1 = this.getPhysicalGroup(1, 2);
        ElementSymbol g1e2 = this.getElementSymbol(1, 2, 2);
        GroupSymbol group2 = this.getPhysicalGroup(3, 3);
        ElementSymbol g2e1 = this.getElementSymbol(3, 3, 1);
        ElementSymbol g2e2 = this.getElementSymbol(3, 3, 2);
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>(1);
        crits.add(new CompareCriteria((Expression)g1e2, 1, (Expression)g2e2));
        Criteria atomicCrit1 = null;
        CompareCriteria crit1 = new CompareCriteria((Expression)g2e1, 4, (Expression)new Constant((Object)new Integer(5)));
        CompareCriteria crit2 = new CompareCriteria((Expression)g2e1, 3, (Expression)new Constant((Object)new Integer(7)));
        CompoundCriteria atomicCrit2 = new CompoundCriteria(0, (Criteria)crit1, (Criteria)crit2);
        MatchCriteria crit3 = new MatchCriteria((Expression)g2e1, (Expression)new Constant((Object)new String("cd%")));
        atomicCrit2 = new CompoundCriteria(1, (Criteria)atomicCrit2, (Criteria)crit3);
        atomicCrit2 = new NotCriteria((Criteria)atomicCrit2);
        int expected = 2;
        this.helpTestChooseSiblingAndMarkDependent(group1, atomicCrit1, group2, (Criteria)atomicCrit2, crits, expected);
        expected = 1;
        this.helpTestChooseSiblingAndMarkDependent(group2, (Criteria)atomicCrit2, group1, atomicCrit1, crits, expected);
    }

    @Test
    public void testCardinalityWithKeyComplexCrit3() throws Exception {
        this.metadata = RealMetadataFactory.example4();
        GroupSymbol group1 = this.getPhysicalGroup(1, 2);
        ElementSymbol g1e2 = this.getElementSymbol(1, 2, 2);
        GroupSymbol group2 = this.getPhysicalGroup(3, 3);
        ElementSymbol g2e1 = this.getElementSymbol(3, 3, 1);
        ElementSymbol g2e2 = this.getElementSymbol(3, 3, 2);
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>(1);
        crits.add(new CompareCriteria((Expression)g1e2, 1, (Expression)g2e2));
        Criteria atomicCrit1 = null;
        CompareCriteria crit1 = new CompareCriteria((Expression)g2e1, 6, (Expression)new Constant((Object)new Integer(5)));
        CompareCriteria crit2 = new CompareCriteria((Expression)g2e1, 2, (Expression)new Constant((Object)new Integer(7)));
        CompoundCriteria atomicCrit2 = new CompoundCriteria(1, (Criteria)crit1, (Criteria)crit2);
        atomicCrit2 = new NotCriteria((Criteria)atomicCrit2);
        CompareCriteria crit3 = new CompareCriteria((Expression)g2e1, 5, (Expression)new Constant((Object)new Integer(25)));
        atomicCrit2 = new CompoundCriteria(0, (Criteria)atomicCrit2, (Criteria)crit3);
        int expected = 1;
        this.helpTestChooseSiblingAndMarkDependent(group1, atomicCrit1, group2, (Criteria)atomicCrit2, crits, expected);
        expected = 2;
        this.helpTestChooseSiblingAndMarkDependent(group2, (Criteria)atomicCrit2, group1, atomicCrit1, crits, expected);
    }

    @Test
    public void testCardinalityWithNonKeyCrit() throws Exception {
        this.metadata = RealMetadataFactory.example4();
        GroupSymbol group1 = this.getPhysicalGroup(1, 2);
        ElementSymbol g1e1 = this.getElementSymbol(1, 2, 1);
        GroupSymbol group2 = this.getPhysicalGroup(3, 3);
        ElementSymbol g2e1 = this.getElementSymbol(3, 3, 1);
        ElementSymbol g2e2 = this.getElementSymbol(3, 3, 2);
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>(1);
        CompareCriteria crit2 = new CompareCriteria((Expression)g1e1, 1, (Expression)g2e1);
        crits.add(crit2);
        Criteria atomicCrit1 = null;
        CompareCriteria atomicCrit2 = new CompareCriteria((Expression)g2e2, 1, (Expression)new Constant((Object)new Integer(5)));
        int expected = 2;
        this.helpTestChooseSiblingAndMarkDependent(group1, atomicCrit1, group2, (Criteria)atomicCrit2, crits, expected);
        expected = 1;
        this.helpTestChooseSiblingAndMarkDependent(group2, (Criteria)atomicCrit2, group1, atomicCrit1, crits, expected);
    }

    @Test
    public void testCardinalityWithCriteriaAndJoin() throws Exception {
        this.metadata = RealMetadataFactory.example4();
        GroupSymbol group1 = this.getPhysicalGroup(2, 2);
        GroupSymbol group1a = null;
        GroupSymbol group2 = this.getPhysicalGroup(3, 3);
        GroupSymbol group2a = this.getPhysicalGroup(3, 1);
        ElementSymbol group1e1 = this.getElementSymbol(2, 2, 1);
        ElementSymbol group2e1 = this.getElementSymbol(3, 3, 1);
        ElementSymbol group2e2 = this.getElementSymbol(3, 3, 2);
        ElementSymbol group2ae1 = this.getElementSymbol(3, 1, 1);
        ElementSymbol group2ae2 = this.getElementSymbol(3, 1, 2);
        CompareCriteria crit = new CompareCriteria((Expression)group2e1, 1, (Expression)group1e1);
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>(1);
        crits.add(crit);
        Criteria atomicCrit1 = null;
        Criteria atomicCrit1a = null;
        CompareCriteria atomicCrit2 = new CompareCriteria((Expression)group2e1, 1, (Expression)new Constant((Object)new Integer(5)));
        CompareCriteria atomicCrit2a = new CompareCriteria((Expression)group2ae1, 1, (Expression)new Constant((Object)new Integer(5)));
        Collection atomicJoinCrits1 = null;
        CompareCriteria atomicJoinCrit2 = new CompareCriteria((Expression)group2ae2, 1, (Expression)group2e2);
        ArrayList<CompareCriteria> atomicJoinCrits2 = new ArrayList<CompareCriteria>(1);
        atomicJoinCrits2.add(atomicJoinCrit2);
        int expected = 1;
        this.helpTestChooseSiblingAndMarkDependent(group1, atomicCrit1, group1a, atomicCrit1a, atomicJoinCrits1, group2, (Criteria)atomicCrit2, group2a, (Criteria)atomicCrit2a, atomicJoinCrits2, crits, expected, 1000, 1);
    }

    @Test
    public void testCardinalityWithAtomicCrossJoin() throws Exception {
        this.metadata = RealMetadataFactory.example4();
        GroupSymbol group1 = this.getPhysicalGroup(2, 2);
        GroupSymbol group1a = null;
        GroupSymbol group2 = this.getPhysicalGroup(3, 3);
        GroupSymbol group2a = this.getPhysicalGroup(3, 1);
        ElementSymbol group1e1 = this.getElementSymbol(2, 2, 1);
        ElementSymbol group2e1 = this.getElementSymbol(3, 3, 1);
        CompareCriteria crit = new CompareCriteria((Expression)group2e1, 1, (Expression)group1e1);
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>(1);
        crits.add(crit);
        Criteria atomicCrit1 = null;
        Criteria atomicCrit1a = null;
        CompareCriteria atomicCrit2 = new CompareCriteria((Expression)group2e1, 1, (Expression)new Constant((Object)new Integer(5)));
        Criteria atomicCrit2a = null;
        Collection atomicJoinCrits1 = null;
        List atomicJoinCrits2 = Collections.EMPTY_LIST;
        int expected = 3;
        this.helpTestChooseSiblingAndMarkDependent(group1, atomicCrit1, group1a, atomicCrit1a, atomicJoinCrits1, group2, (Criteria)atomicCrit2, group2a, atomicCrit2a, atomicJoinCrits2, crits, expected, 1000, 100000.0);
    }

    @Test
    public void testCardinalityWithAtomicCrossJoin2() throws Exception {
        this.metadata = RealMetadataFactory.example4();
        GroupSymbol group1 = this.getPhysicalGroup(2, 2);
        GroupSymbol group1a = null;
        GroupSymbol group2 = this.getPhysicalGroup(3, 3);
        GroupSymbol group2a = this.getPhysicalGroup(3, 1);
        ElementSymbol group1e1 = this.getElementSymbol(2, 2, 1);
        ElementSymbol group2e1 = this.getElementSymbol(3, 3, 1);
        CompareCriteria crit = new CompareCriteria((Expression)group2e1, 1, (Expression)group1e1);
        ArrayList<CompareCriteria> crits = new ArrayList<CompareCriteria>(1);
        crits.add(crit);
        Criteria atomicCrit1 = null;
        Criteria atomicCrit1a = null;
        CompareCriteria atomicCrit2 = new CompareCriteria((Expression)group2e1, 2, (Expression)new Constant((Object)new Integer(5)));
        Criteria atomicCrit2a = null;
        Collection atomicJoinCrits1 = null;
        List atomicJoinCrits2 = Collections.EMPTY_LIST;
        int expected = 2;
        this.helpTestChooseSiblingAndMarkDependent(group1, atomicCrit1, group1a, atomicCrit1a, atomicJoinCrits1, group2, (Criteria)atomicCrit2, group2a, atomicCrit2a, atomicJoinCrits2, crits, expected, 1000, 10000000000L);
    }
}

