/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.framework.datasource;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.test.framework.ConfigPropertyLoader;
import org.teiid.test.framework.TestLogger;
import org.teiid.test.framework.datasource.DataSource;
import org.teiid.test.framework.datasource.DataSourceFactory;
import org.teiid.test.framework.exception.QueryTestFailedException;
import org.teiid.test.framework.exception.TransactionRuntimeException;

public class DataSourceMgr {
    private static DataSourceMgr _instance = null;
    public static final String DEFAULT_DATASOURCES_LOC = "./src/main/resources/datasources/";
    private static final String UNASSIGNEDDSLOC = "${";
    private Map<String, DataSource> allDatasourcesMap = new HashMap<String, DataSource>();
    private Map<String, DataSource> modelToDatasourceMap = new HashMap<String, DataSource>();
    private DataSourceFactory dsfactory = null;

    private DataSourceMgr() {
    }

    public static synchronized DataSourceMgr getInstance() {
        if (_instance == null) {
            _instance = new DataSourceMgr();
            try {
                _instance.loadDataSourceMappings();
            }
            catch (QueryTestFailedException e) {
                throw new TransactionRuntimeException(e);
            }
            catch (TransactionRuntimeException e) {
                throw e;
            }
        }
        return _instance;
    }

    private static synchronized void reset() {
        _instance = null;
    }

    public Map<String, DataSource> getDataSources() {
        HashMap<String, DataSource> ds = new HashMap<String, DataSource>(this.allDatasourcesMap.size());
        ds.putAll(this.allDatasourcesMap);
        return ds;
    }

    public int numberOfAvailDataSources() {
        return this.allDatasourcesMap.size();
    }

    public DataSource getDataSource(String modelname) {
        if (this.modelToDatasourceMap.containsKey(modelname)) {
            return this.modelToDatasourceMap.get(modelname);
        }
        try {
            DataSource ds = this.dsfactory.getDatasource(modelname);
            if (ds == null) {
                this.printAllDatasources();
                try {
                    Thread.sleep(100000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Thread.currentThread().getThreadGroup().stop();
            }
            this.modelToDatasourceMap.put(modelname, ds);
            return ds;
        }
        catch (QueryTestFailedException e) {
            throw new TransactionRuntimeException(e);
        }
    }

    private void printAllDatasources() {
        for (String key : this.allDatasourcesMap.keySet()) {
            DataSource ds = this.allDatasourcesMap.get(key);
            TestLogger.log("DataSource: " + ds.getName());
        }
    }

    public void shutdown() {
        DataSource ds;
        TestLogger.log("Shutting down data sources");
        if (this.allDatasourcesMap != null && this.allDatasourcesMap.size() > 0) {
            for (String key : this.allDatasourcesMap.keySet()) {
                ds = this.allDatasourcesMap.get(key);
                try {
                    ds.shutdown();
                }
                catch (Throwable throwable) {}
            }
            this.allDatasourcesMap.clear();
        }
        if (this.modelToDatasourceMap != null || this.modelToDatasourceMap.size() > 0) {
            for (String key : this.modelToDatasourceMap.keySet()) {
                ds = this.modelToDatasourceMap.get(key);
                try {
                    ds.shutdown();
                }
                catch (Throwable throwable) {}
            }
            this.modelToDatasourceMap.clear();
        }
        if (this.dsfactory != null) {
            this.dsfactory.cleanup();
        }
        DataSourceMgr.reset();
    }

    public void setDataSource(String modelName, DataSource ds) {
        this.modelToDatasourceMap.put(modelName, ds);
    }

    private void loadDataSourceMappings() throws QueryTestFailedException {
        if (ConfigPropertyLoader.getInstance().isDataStoreDisabled()) {
            TestLogger.logDebug("DataStore usage has been disabled");
            return;
        }
        String dsloc = ConfigPropertyLoader.getInstance().getProperty("datasourceloc");
        if (dsloc == null || dsloc.indexOf(UNASSIGNEDDSLOC) > -1) {
            dsloc = DEFAULT_DATASOURCES_LOC;
            TestLogger.logDebug("Using default datasource loc: " + dsloc);
        } else {
            TestLogger.logDebug("Using override for datasources loc: " + dsloc);
        }
        File[] dirs = DataSourceMgr.findAllChildDirectories(dsloc);
        if (dirs == null || dirs.length == 0) {
            throw new TransactionRuntimeException("No datasource directories found at location " + dsloc);
        }
        for (int i = 0; i < dirs.length; ++i) {
            File d = dirs[i];
            this.addDataSource(d, this.allDatasourcesMap);
        }
        if (this.allDatasourcesMap == null || this.allDatasourcesMap.isEmpty()) {
            throw new TransactionRuntimeException("Error: No Datasources were loaded.");
        }
        if (this.allDatasourcesMap.size() < 2) {
            throw new TransactionRuntimeException("Error: Must load 2 Datasources, only 1 was found.");
        }
        TestLogger.logDebug("Number of total datasource mappings loaded " + this.allDatasourcesMap.size());
        this.dsfactory = new DataSourceFactory(ConfigPropertyLoader.getInstance());
        this.dsfactory.config(this);
    }

    private static File[] findAllChildDirectories(String dir) {
        File mfile = new File(dir);
        File modelsDirFile = null;
        try {
            modelsDirFile = new File(mfile.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!modelsDirFile.exists()) {
            return null;
        }
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        File[] modelFiles = modelsDirFile.listFiles(fileFilter);
        return modelFiles;
    }

    private void addDataSource(File datasourcedir, Map<String, DataSource> datasources) {
        File dsfile = new File(datasourcedir, "connection.properties");
        if (!dsfile.exists()) {
            return;
        }
        Properties dsprops = DataSourceMgr.loadProperties(dsfile);
        if (dsprops != null) {
            DataSource ds = new DataSource(datasourcedir.getName(), "dsgroup", dsprops);
            datasources.put(ds.getName(), ds);
            TestLogger.logDebug("Loaded datasource " + ds.getName());
        }
    }

    private static Properties loadProperties(File dsfile) {
        Properties props = null;
        try {
            props = PropertiesUtils.load((String)dsfile.getAbsolutePath());
            return props;
        }
        catch (IOException e) {
            throw new TransactionRuntimeException("Error loading properties from file '" + dsfile.getAbsolutePath() + "'" + e.getMessage());
        }
    }
}

