/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.client.plan.Annotation;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.id.IDGenerator;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.QueryOptimizer;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.NewCalculateCostUtil;
import org.teiid.query.optimizer.relational.rules.RuleChooseDependent;
import org.teiid.query.optimizer.relational.rules.RuleChooseJoinStrategy;
import org.teiid.query.optimizer.relational.rules.RuleCollapseSource;
import org.teiid.query.optimizer.relational.rules.RuleConstants;
import org.teiid.query.optimizer.relational.rules.RuleImplementJoinStrategy;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.processor.relational.MergeJoinStrategy;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.navigator.DeepPostOrderNavigator;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.AggregateSymbolCollectorVisitor;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.sql.visitor.ReferenceCollectorVisitor;
import org.teiid.query.util.CommandContext;

public final class RuleMergeCriteria
implements OptimizerRule {
    private IDGenerator idGenerator;
    private CapabilitiesFinder capFinder;
    private AnalysisRecord analysisRecord;
    private CommandContext context;
    private QueryMetadataInterface metadata;
    private boolean dependent;

    public RuleMergeCriteria(IDGenerator idGenerator, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context, QueryMetadataInterface metadata) {
        this.idGenerator = idGenerator;
        this.capFinder = capFinder;
        this.analysisRecord = analysisRecord;
        this.context = context;
        this.metadata = metadata;
    }

    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, TeiidComponentException {
        this.dependent = false;
        ArrayList<PlanNode> criteriaChains = new ArrayList<PlanNode>();
        this.findCriteriaChains(plan, criteriaChains, analysisRecord);
        for (PlanNode critNode : criteriaChains) {
            RuleMergeCriteria.mergeChain(critNode, metadata);
        }
        if (this.dependent) {
            rules.push(RuleConstants.PUSH_SELECT_CRITERIA);
        }
        return plan;
    }

    void findCriteriaChains(PlanNode root, List<PlanNode> foundNodes, AnalysisRecord analysisRecord) throws QueryPlannerException, TeiidComponentException {
        PlanNode recurseRoot = root;
        if (root.getType() == 16) {
            while (recurseRoot.getType() == 16) {
                recurseRoot = this.planMergeJoin(recurseRoot, root);
                if (root.getChildCount() == 0 && (root = recurseRoot.getFirstChild()).getType() != 16) {
                    root = root.getParent();
                }
                recurseRoot = recurseRoot.getFirstChild();
            }
            if (recurseRoot.getParent() != root) {
                foundNodes.add(root);
            }
        }
        if (recurseRoot.getType() != 1) {
            for (PlanNode child : recurseRoot.getChildren()) {
                this.findCriteriaChains(child, foundNodes, analysisRecord);
            }
        }
    }

    static void mergeChain(PlanNode chainRoot, QueryMetadataInterface metadata) {
        CompoundCriteria critParts = new CompoundCriteria();
        LinkedList<Criteria> subqueryCriteria = new LinkedList<Criteria>();
        PlanNode current = chainRoot;
        boolean isDependentSet = false;
        while (current.getType() == 16) {
            if (!current.getCorrelatedReferenceElements().isEmpty()) {
                subqueryCriteria.add(0, (Criteria)current.getProperty(NodeConstants.Info.SELECT_CRITERIA));
            } else {
                critParts.getCriteria().add(0, (Criteria)current.getProperty(NodeConstants.Info.SELECT_CRITERIA));
            }
            isDependentSet |= current.hasBooleanProperty(NodeConstants.Info.IS_DEPENDENT_SET);
            PlanNode last = current;
            current = current.getLastChild();
            if (last == chainRoot) continue;
            NodeEditor.removeChildNode(last.getParent(), last);
        }
        critParts.getCriteria().addAll(subqueryCriteria);
        Criteria combinedCrit = QueryRewriter.optimizeCriteria(critParts, metadata);
        if (isDependentSet) {
            chainRoot.setProperty(NodeConstants.Info.IS_DEPENDENT_SET, Boolean.TRUE);
        }
        chainRoot.setProperty(NodeConstants.Info.SELECT_CRITERIA, combinedCrit);
        chainRoot.getGroups().clear();
        chainRoot.addGroups(GroupsUsedByElementsVisitor.getGroups(combinedCrit));
        chainRoot.addGroups(GroupsUsedByElementsVisitor.getGroups(chainRoot.getCorrelatedReferenceElements()));
    }

    private PlanNode planMergeJoin(PlanNode current, PlanNode root) throws QueryMetadataException, TeiidComponentException {
        float sourceCost = NewCalculateCostUtil.computeCostForTree(current.getFirstChild(), this.metadata);
        Criteria crit = (Criteria)current.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        PlannedResult plannedResult = this.findSubquery(crit, true);
        if (plannedResult.query == null) {
            return current;
        }
        if (sourceCost != -1.0f && sourceCost < (float)RuleChooseDependent.DEFAULT_INDEPENDENT_CARDINALITY && !plannedResult.mergeJoin) {
            return current;
        }
        RelationalPlan originalPlan = (RelationalPlan)plannedResult.query.getProcessorPlan();
        Number originalCardinality = originalPlan.getRootNode().getEstimateNodeCardinality();
        if (!plannedResult.mergeJoin && originalCardinality.floatValue() == -1.0f) {
            return current;
        }
        Set<GroupSymbol> leftGroups = FrameUtil.findJoinSourceNode(current).getGroups();
        if (!this.planQuery(leftGroups, false, plannedResult)) {
            if (plannedResult.mergeJoin && this.analysisRecord != null && this.analysisRecord.recordAnnotations()) {
                this.analysisRecord.addAnnotation(new Annotation("Hints", "Could not plan as a merge join: " + crit, "ignoring MJ hint", Annotation.Priority.HIGH));
            }
            return current;
        }
        PlanNode childSort = NodeEditor.findNodePreOrder(root, 32, 68);
        if (childSort != null) {
            if (plannedResult.mergeJoin && this.analysisRecord != null && this.analysisRecord.recordAnnotations()) {
                this.analysisRecord.addAnnotation(new Annotation("Hints", "Could not plan as a merge join since the parent join requires a sort: " + crit, "ignoring MJ hint", Annotation.Priority.HIGH));
            }
            return current;
        }
        plannedResult.query.setOrderBy(new OrderBy(plannedResult.rightExpressions).clone());
        for (OrderByItem item : plannedResult.query.getOrderBy().getOrderByItems()) {
            int index = plannedResult.query.getProjectedSymbols().indexOf(item.getSymbol());
            if (index >= 0 && !(item.getSymbol() instanceof ElementSymbol)) {
                item.setSymbol((Expression)plannedResult.query.getProjectedSymbols().get(index).clone());
            }
            item.setExpressionPosition(index);
        }
        try {
            ArrayList<Expression> projectedSymbols = LanguageObject.Util.deepClone(plannedResult.query.getProjectedSymbols(), Expression.class);
            RelationalPlan subPlan = (RelationalPlan)QueryOptimizer.optimizePlan(plannedResult.query, this.metadata, this.idGenerator, this.capFinder, this.analysisRecord, this.context);
            Number planCardinality = subPlan.getRootNode().getEstimateNodeCardinality();
            if (!plannedResult.mergeJoin && (planCardinality.floatValue() == -1.0f || planCardinality.floatValue() > 1.0E7f || sourceCost == -1.0f && planCardinality.floatValue() > 1000.0f || sourceCost != -1.0f && (double)(sourceCost * originalCardinality.floatValue()) < (double)planCardinality.floatValue() / (100.0 * Math.log(Math.max(4.0f, sourceCost))))) {
                if (this.analysisRecord != null && this.analysisRecord.recordDebug()) {
                    current.recordDebugAnnotation("cost of merge join plan was not favorable", null, "semi merge join will not be used", this.analysisRecord, this.metadata);
                }
                return current;
            }
            if (sourceCost != -1.0f && planCardinality.floatValue() != -1.0f && planCardinality.floatValue() < sourceCost / 8.0f || sourceCost == -1.0f && planCardinality.floatValue() <= 1000.0f) {
                plannedResult.makeInd = true;
            }
            current.recordDebugAnnotation("Conditions met (hint or cost)", null, "Converting to a semi merge join", this.analysisRecord, this.metadata);
            PlanNode semiJoin = NodeFactory.getNewNode(4);
            semiJoin.addGroups(current.getGroups());
            Set<GroupSymbol> groups = GroupsUsedByElementsVisitor.getGroups(plannedResult.rightExpressions);
            semiJoin.addGroups(groups);
            semiJoin.setProperty(NodeConstants.Info.JOIN_STRATEGY, (Object)JoinNode.JoinStrategyType.MERGE);
            semiJoin.setProperty(NodeConstants.Info.JOIN_TYPE, plannedResult.not ? JoinType.JOIN_ANTI_SEMI : JoinType.JOIN_SEMI);
            semiJoin.setProperty(NodeConstants.Info.NON_EQUI_JOIN_CRITERIA, plannedResult.nonEquiJoinCriteria);
            ArrayList<Criteria> joinCriteria = new ArrayList<Criteria>();
            joinCriteria.addAll(plannedResult.nonEquiJoinCriteria);
            for (int i = 0; i < plannedResult.leftExpressions.size(); ++i) {
                joinCriteria.add(new CompareCriteria((Expression)plannedResult.rightExpressions.get(i), 1, (Expression)plannedResult.leftExpressions.get(i)));
            }
            semiJoin.setProperty(NodeConstants.Info.JOIN_CRITERIA, joinCriteria);
            List<SymbolMap> refMaps = semiJoin.getAllReferences();
            SymbolMap parentRefs = plannedResult.query.getCorrelatedReferences();
            for (SymbolMap refs : refMaps) {
                for (Map.Entry<ElementSymbol, Expression> ref : refs.asUpdatableMap().entrySet()) {
                    Expression convertedExpr;
                    Expression expr = ref.getValue();
                    if (expr instanceof ElementSymbol && (convertedExpr = parentRefs.getMappedExpression((ElementSymbol)expr)) != null) {
                        ref.setValue(convertedExpr);
                    }
                    semiJoin.getGroups().addAll(GroupsUsedByElementsVisitor.getGroups(ref.getValue()));
                }
            }
            semiJoin.setProperty(NodeConstants.Info.LEFT_EXPRESSIONS, plannedResult.leftExpressions);
            semiJoin.getGroups().addAll(GroupsUsedByElementsVisitor.getGroups(plannedResult.leftExpressions));
            semiJoin.setProperty(NodeConstants.Info.RIGHT_EXPRESSIONS, plannedResult.rightExpressions);
            semiJoin.getGroups().addAll(GroupsUsedByElementsVisitor.getGroups(plannedResult.rightExpressions));
            semiJoin.setProperty(NodeConstants.Info.SORT_RIGHT, (Object)MergeJoinStrategy.SortOption.ALREADY_SORTED);
            semiJoin.setProperty(NodeConstants.Info.OUTPUT_COLS, root.getProperty(NodeConstants.Info.OUTPUT_COLS));
            List childOutput = (List)current.getFirstChild().getProperty(NodeConstants.Info.OUTPUT_COLS);
            for (PlanNode toCorrect = root; toCorrect != current; toCorrect = toCorrect.getFirstChild()) {
                toCorrect.setProperty(NodeConstants.Info.OUTPUT_COLS, childOutput);
            }
            PlanNode node = NodeFactory.getNewNode(1);
            node.setProperty(NodeConstants.Info.PROCESSOR_PLAN, subPlan);
            node.setProperty(NodeConstants.Info.OUTPUT_COLS, projectedSymbols);
            node.setProperty(NodeConstants.Info.EST_CARDINALITY, planCardinality);
            node.addGroups(groups);
            root.addAsParent(semiJoin);
            semiJoin.addLastChild(node);
            PlanNode result = current.getParent();
            NodeEditor.removeChildNode(result, current);
            RuleImplementJoinStrategy.insertSort(semiJoin.getFirstChild(), plannedResult.leftExpressions, semiJoin, this.metadata, this.capFinder, true, this.context);
            if (plannedResult.makeInd && !plannedResult.not) {
                String id = RuleChooseDependent.nextId();
                PlanNode dep = RuleChooseDependent.getDependentCriteriaNode(id, plannedResult.rightExpressions, plannedResult.leftExpressions, node, this.metadata, null, false, null);
                semiJoin.getFirstChild().addAsParent(dep);
                semiJoin.setProperty(NodeConstants.Info.DEPENDENT_VALUE_SOURCE, id);
                this.dependent = true;
            }
            return result;
        }
        catch (QueryPlannerException e) {
            return current;
        }
    }

    public PlannedResult findSubquery(Expression expr, boolean unnest, PlannedResult result) {
        if (expr instanceof ScalarSubquery) {
            ScalarSubquery scc = (ScalarSubquery)expr;
            if (scc.getSubqueryHint().isNoUnnest()) {
                return result;
            }
            Query query = (Query)scc.getCommand();
            if (!this.isSingleRow(query)) {
                return result;
            }
            result.type = scc.getClass();
            result.mergeJoin = scc.getSubqueryHint().isMergeJoin();
            if (!unnest && !result.mergeJoin) {
                return result;
            }
            result.makeInd = scc.getSubqueryHint().isDepJoin();
            result.query = query;
        }
        return result;
    }

    private boolean isSingleRow(Query query) {
        return query.hasAggregates() && query.getGroupBy() == null;
    }

    public PlannedResult findSubquery(Criteria crit, boolean unnest) throws TeiidComponentException, QueryMetadataException {
        CompareCriteria cc;
        PlannedResult result = new PlannedResult();
        if (crit instanceof SubquerySetCriteria) {
            SubquerySetCriteria ssc = (SubquerySetCriteria)crit;
            if (ssc.getSubqueryHint().isNoUnnest()) {
                return result;
            }
            result.not = ssc.isNegated();
            result.type = ssc.getClass();
            crit = new SubqueryCompareCriteria(ssc.getExpression(), ssc.getCommand(), 1, 2);
            ((SubqueryCompareCriteria)crit).setSubqueryHint(ssc.getSubqueryHint());
        } else if (crit instanceof CompareCriteria && (cc = (CompareCriteria)crit).getRightExpression() instanceof ScalarSubquery) {
            Query query;
            ScalarSubquery ss = (ScalarSubquery)cc.getRightExpression();
            if (ss.getSubqueryHint().isNoUnnest()) {
                return result;
            }
            result.type = ss.getClass();
            if (ss.getCommand() instanceof Query && (query = (Query)ss.getCommand()).getGroupBy() == null && query.hasAggregates()) {
                crit = new SubqueryCompareCriteria(cc.getLeftExpression(), ss.getCommand(), cc.getOperator(), 2);
                ((SubqueryCompareCriteria)crit).setSubqueryHint(ss.getSubqueryHint());
            }
        }
        if (crit instanceof SubqueryCompareCriteria) {
            SubqueryCompareCriteria scc = (SubqueryCompareCriteria)crit;
            if (scc.getSubqueryHint().isNoUnnest()) {
                return result;
            }
            if (scc.getPredicateQuantifier() != 2 || !(scc.getCommand() instanceof Query)) {
                return result;
            }
            Query query = (Query)scc.getCommand();
            Expression rightExpr = SymbolMap.getExpression(query.getProjectedSymbols().get(0));
            if (result.not && !this.isNonNull(query, rightExpr)) {
                return result;
            }
            if (result.type == null) {
                result.type = scc.getClass();
            }
            result.mergeJoin = scc.getSubqueryHint().isMergeJoin();
            if (!unnest && !result.mergeJoin) {
                return result;
            }
            result.makeInd = scc.getSubqueryHint().isDepJoin();
            result.query = query;
            result.additionalCritieria = (Criteria)new CompareCriteria(scc.getLeftExpression(), scc.getOperator(), rightExpr).clone();
        }
        if (crit instanceof ExistsCriteria) {
            ExistsCriteria exists = (ExistsCriteria)crit;
            if (exists.getSubqueryHint().isNoUnnest()) {
                return result;
            }
            if (!(exists.getCommand() instanceof Query)) {
                return result;
            }
            result.type = crit.getClass();
            result.not = exists.isNegated();
            result.mergeJoin = exists.getSubqueryHint().isMergeJoin();
            result.makeInd = exists.getSubqueryHint().isDepJoin();
            if (!unnest && !result.mergeJoin) {
                return result;
            }
            result.query = (Query)exists.getCommand();
        }
        return result;
    }

    private boolean isNonNull(Query query, Expression rightExpr) throws TeiidComponentException, QueryMetadataException {
        if (rightExpr instanceof ElementSymbol) {
            ElementSymbol es = (ElementSymbol)rightExpr;
            if (this.metadata.elementSupports(es.getMetadataID(), 4)) {
                return false;
            }
            if (!this.isSimpleJoin(query)) {
                return false;
            }
        } else if (rightExpr instanceof Constant) {
            if (((Constant)rightExpr).isNull()) {
                return false;
            }
        } else if (rightExpr instanceof AggregateSymbol) {
            AggregateSymbol as = (AggregateSymbol)rightExpr;
            if (as.getAggregateFunction() != AggregateSymbol.Type.COUNT) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean isSimpleJoin(Query query) {
        if (query.getFrom() != null) {
            for (FromClause clause : query.getFrom().getClauses()) {
                if (!RuleCollapseSource.hasOuterJoins(clause)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean planQuery(Collection<GroupSymbol> leftGroups, boolean requireDistinct, PlannedResult plannedResult) throws QueryMetadataException, TeiidComponentException {
        if (plannedResult.query.getLimit() != null && !plannedResult.query.getLimit().isImplicit() || plannedResult.query.getFrom() == null) {
            return false;
        }
        if ((plannedResult.type == ExistsCriteria.class || plannedResult.type == ScalarSubquery.class) && plannedResult.query.getCorrelatedReferences() == null) {
            return false;
        }
        plannedResult.query = (Query)plannedResult.query.clone();
        plannedResult.query.setLimit(null);
        List<GroupSymbol> rightGroups = plannedResult.query.getFrom().getGroups();
        LinkedHashSet<Expression> requiredExpressions = new LinkedHashSet<Expression>();
        SymbolMap refs = plannedResult.query.getCorrelatedReferences();
        boolean addGroupBy = false;
        if (refs != null) {
            boolean hasAggregates = plannedResult.query.hasAggregates();
            Criteria where = plannedResult.query.getCriteria();
            if (plannedResult.query.getGroupBy() == null) {
                plannedResult.query.setCriteria(null);
            }
            Criteria having = plannedResult.query.getHaving();
            plannedResult.query.setHaving(null);
            if (this.hasCorrelatedReferences(plannedResult.query, refs)) {
                return false;
            }
            if (plannedResult.query.getGroupBy() == null) {
                this.processCriteria(leftGroups, plannedResult, rightGroups, requiredExpressions, refs, where, null, true);
                if (hasAggregates) {
                    if (!plannedResult.nonEquiJoinCriteria.isEmpty()) {
                        return false;
                    }
                    addGroupBy = true;
                }
            }
            this.processCriteria(leftGroups, plannedResult, rightGroups, requiredExpressions, refs, having, plannedResult.query.getGroupBy(), false);
        }
        if (plannedResult.additionalCritieria != null) {
            RuleChooseJoinStrategy.separateCriteria(leftGroups, rightGroups, plannedResult.leftExpressions, plannedResult.rightExpressions, Criteria.separateCriteriaByAnd(plannedResult.additionalCritieria), plannedResult.nonEquiJoinCriteria);
        }
        if (plannedResult.leftExpressions.isEmpty()) {
            return false;
        }
        plannedResult.leftExpressions = RuleChooseJoinStrategy.createExpressionSymbols(plannedResult.leftExpressions);
        plannedResult.rightExpressions = RuleChooseJoinStrategy.createExpressionSymbols(plannedResult.rightExpressions);
        if (requireDistinct && !addGroupBy) {
            if (!(plannedResult.rightExpressions.size() <= 1 || plannedResult.type == SubquerySetCriteria.class && RuleMergeCriteria.isDistinct(plannedResult.query, plannedResult.rightExpressions.subList(plannedResult.rightExpressions.size() - 1, plannedResult.rightExpressions.size()), this.metadata))) {
                return false;
            }
            if (!RuleMergeCriteria.isDistinct(plannedResult.query, plannedResult.rightExpressions, this.metadata)) {
                if (plannedResult.type == ExistsCriteria.class ? requiredExpressions.size() > plannedResult.leftExpressions.size() : !requiredExpressions.isEmpty() && !RuleMergeCriteria.isDistinct(plannedResult.query, plannedResult.query.getProjectedSymbols(), this.metadata)) {
                    return false;
                }
                plannedResult.query.getSelect().setDistinct(true);
                plannedResult.madeDistinct = true;
            }
        }
        if (plannedResult.type == ExistsCriteria.class) {
            plannedResult.query.getSelect().clearSymbols();
        }
        if (addGroupBy) {
            LinkedHashSet groupingSymbols = new LinkedHashSet();
            for (Expression expr : plannedResult.rightExpressions) {
                AggregateSymbolCollectorVisitor.getAggregates(expr, null, groupingSymbols, null, null, null);
            }
            if (!groupingSymbols.isEmpty()) {
                plannedResult.query.setGroupBy((GroupBy)new GroupBy(new ArrayList(groupingSymbols)).clone());
            }
        }
        HashSet<Expression> projectedSymbols = new HashSet<Expression>();
        for (Expression ses : plannedResult.query.getProjectedSymbols()) {
            projectedSymbols.add(SymbolMap.getExpression(ses));
        }
        for (Expression ses : requiredExpressions) {
            if (!projectedSymbols.add(ses)) continue;
            plannedResult.query.getSelect().addSymbol((Expression)ses.clone());
        }
        for (Expression ses : plannedResult.rightExpressions) {
            if (!projectedSymbols.add(SymbolMap.getExpression(ses))) continue;
            plannedResult.query.getSelect().addSymbol((Expression)ses.clone());
        }
        return true;
    }

    private void processCriteria(Collection<GroupSymbol> leftGroups, PlannedResult plannedResult, List<GroupSymbol> rightGroups, Set<Expression> requiredExpressions, SymbolMap refs, Criteria joinCriteria, GroupBy groupBy, boolean where) {
        if (joinCriteria == null) {
            return;
        }
        List<Criteria> crits = Criteria.separateCriteriaByAnd((Criteria)joinCriteria.clone());
        Iterator<Criteria> critIter = crits.iterator();
        while (critIter.hasNext()) {
            Criteria conjunct = critIter.next();
            LinkedList additionalRequired = new LinkedList();
            AggregateSymbolCollectorVisitor.getAggregates(conjunct, additionalRequired, additionalRequired, additionalRequired, null, groupBy != null ? groupBy.getSymbols() : null);
            ReferenceReplacementVisitor emv = new ReferenceReplacementVisitor(refs);
            DeepPostOrderNavigator.doVisit(conjunct, emv);
            if (!emv.replacedAny) {
                critIter.remove();
                if (where) {
                    plannedResult.query.setCriteria(Criteria.combineCriteria(plannedResult.query.getCriteria(), conjunct));
                    continue;
                }
                plannedResult.query.setHaving(Criteria.combineCriteria(plannedResult.query.getHaving(), conjunct));
                continue;
            }
            requiredExpressions.addAll(additionalRequired);
        }
        RuleChooseJoinStrategy.separateCriteria(leftGroups, rightGroups, plannedResult.leftExpressions, plannedResult.rightExpressions, crits, plannedResult.nonEquiJoinCriteria);
    }

    public static boolean isDistinct(Query query, List<Expression> expressions, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        boolean distinct = false;
        if (query.getGroupBy() != null) {
            distinct = true;
            for (Expression groupByExpr : query.getGroupBy().getSymbols()) {
                if (expressions.contains(groupByExpr)) continue;
                distinct = false;
                break;
            }
        }
        if (distinct) {
            return true;
        }
        HashSet<GroupSymbol> keyPreservingGroups = new HashSet<GroupSymbol>();
        ResolverUtil.findKeyPreserved(query, keyPreservingGroups, metadata);
        return NewCalculateCostUtil.usesKey(expressions, keyPreservingGroups, metadata, true);
    }

    private boolean hasCorrelatedReferences(LanguageObject object, SymbolMap correlatedReferences) {
        List<Reference> references = ReferenceCollectorVisitor.getReferences(object);
        for (Reference reference : references) {
            if (!correlatedReferences.asMap().containsKey(reference.getExpression())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "MergeCriteria";
    }

    public static class PlannedResult {
        public List leftExpressions = new LinkedList();
        public List rightExpressions = new LinkedList();
        public Query query;
        public boolean not;
        public List<Criteria> nonEquiJoinCriteria = new LinkedList<Criteria>();
        public Criteria additionalCritieria;
        public Class<?> type;
        public boolean mergeJoin;
        public boolean madeDistinct;
        public boolean makeInd;

        public void reset() {
            this.leftExpressions.clear();
            this.rightExpressions.clear();
            this.query = null;
            this.not = false;
            this.nonEquiJoinCriteria.clear();
            this.additionalCritieria = null;
            this.type = null;
            this.mergeJoin = false;
            this.madeDistinct = false;
            this.makeInd = false;
        }
    }

    public static final class ReferenceReplacementVisitor
    extends ExpressionMappingVisitor {
        private final SymbolMap refs;
        private boolean replacedAny;

        public ReferenceReplacementVisitor(SymbolMap refs) {
            super(null);
            this.refs = refs;
        }

        @Override
        public Expression replaceExpression(Expression element) {
            Reference r;
            Expression ex;
            if (element instanceof Reference && (ex = this.refs.getMappedExpression((r = (Reference)element).getExpression())) != null) {
                if (ex instanceof ElementSymbol) {
                    ElementSymbol es = (ElementSymbol)ex.clone();
                    es.setIsExternalReference(false);
                    ex = es;
                }
                this.replacedAny = true;
                return ex;
            }
            return element;
        }
    }
}

