/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestColumnMasking {
    CommandContext context;

    @Before
    public void setup() {
        this.context = TestColumnMasking.createContext();
    }

    private static CommandContext createContext() {
        CommandContext context = TestProcessor.createCommandContext();
        DQPWorkContext workContext = new DQPWorkContext();
        HashMap<String, DataPolicyMetadata> policies = new HashMap<String, DataPolicyMetadata>();
        DataPolicyMetadata policy = new DataPolicyMetadata();
        DataPolicyMetadata.PermissionMetaData pmd = new DataPolicyMetadata.PermissionMetaData();
        pmd.setResourceName("pm1.sp1.e1");
        pmd.setMask("case when e2 > 1 then null else e1 end");
        DataPolicyMetadata.PermissionMetaData pmd1 = new DataPolicyMetadata.PermissionMetaData();
        pmd1.setResourceName("pm1.g1.e2");
        pmd1.setMask("case when e1 = 'a' then null else e2 end");
        policy.addPermission(new DataPolicyMetadata.PermissionMetaData[]{pmd, pmd1});
        policy.setName("some-role");
        policies.put("some-role", policy);
        workContext.setPolicies(policies);
        context.setDQPWorkContext(workContext);
        return context;
    }

    @Test
    public void testProcedureMask() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("EXEC pm1.sp1()", Arrays.asList("a", 1), Arrays.asList("b", 2));
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("exec pm1.sp1()"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new DefaultCapabilitiesFinder(), this.context);
        List[] expectedResults = new List[]{Arrays.asList("a", 1), Arrays.asList(null, 2)};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test
    public void testProcedureMask1() throws Exception {
        DataPolicyMetadata policy1 = new DataPolicyMetadata();
        DataPolicyMetadata.PermissionMetaData pmd11 = new DataPolicyMetadata.PermissionMetaData();
        pmd11.setResourceName("pm1.sp1.e1");
        pmd11.setOrder(Integer.valueOf(1));
        pmd11.setMask("null");
        policy1.addPermission(new DataPolicyMetadata.PermissionMetaData[]{pmd11});
        policy1.setName("other-role");
        this.context.getAllowedDataPolicies().put("other-role", policy1);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("EXEC pm1.sp1()", Arrays.asList("a", 1), Arrays.asList("b", 2));
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("exec pm1.sp1()"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new DefaultCapabilitiesFinder(), this.context);
        List[] expectedResults = new List[]{Arrays.asList(null, 1), Arrays.asList(null, 2)};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test
    public void testTableMask() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1", Arrays.asList("a", 1), Arrays.asList("b", 2));
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("select e2 from pm1.g1"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new DefaultCapabilitiesFinder(), this.context);
        List[] expectedResults = new List[]{Collections.singletonList(null), Arrays.asList(2)};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test(expected=QueryMetadataException.class)
    public void testInvalidTableMask() throws Exception {
        DataPolicyMetadata policy1 = new DataPolicyMetadata();
        DataPolicyMetadata.PermissionMetaData pmd11 = new DataPolicyMetadata.PermissionMetaData();
        pmd11.setResourceName("pm1.g1.e2");
        pmd11.setOrder(Integer.valueOf(1));
        pmd11.setMask("'a'");
        policy1.addPermission(new DataPolicyMetadata.PermissionMetaData[]{pmd11});
        policy1.setName("other-role");
        this.context.getAllowedDataPolicies().put("other-role", policy1);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1", Arrays.asList("a", 1), Arrays.asList("b", 2));
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("select e2 from pm1.g1"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new DefaultCapabilitiesFinder(), this.context);
        List[] expectedResults = new List[]{Collections.singletonList(null), Arrays.asList(2)};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test
    public void testTableAliasMask() throws Exception {
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1", Arrays.asList("a", 1), Arrays.asList("b", 2));
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("select g2.e2 from pm1.g1 as g2"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new DefaultCapabilitiesFinder(), this.context);
        List[] expectedResults = new List[]{Collections.singletonList(null), Arrays.asList(2)};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test(expected=QueryPlannerException.class)
    public void testSubqueryTableMaskRecursive() throws Exception {
        DataPolicyMetadata policy1 = new DataPolicyMetadata();
        DataPolicyMetadata.PermissionMetaData pmd11 = new DataPolicyMetadata.PermissionMetaData();
        pmd11.setResourceName("pm1.g1.e2");
        pmd11.setOrder(Integer.valueOf(1));
        pmd11.setMask("(select min(e2) from pm1.g1)");
        policy1.addPermission(new DataPolicyMetadata.PermissionMetaData[]{pmd11});
        policy1.setName("other-role");
        this.context.getAllowedDataPolicies().put("other-role", policy1);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("select g2.e2 from pm1.g1 as g2"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new DefaultCapabilitiesFinder(), this.context);
        TestProcessor.helpProcess(plan, this.context, dataManager, null);
    }

    @Test
    public void testSubqueryTableMask() throws Exception {
        DataPolicyMetadata policy1 = new DataPolicyMetadata();
        DataPolicyMetadata.PermissionMetaData pmd11 = new DataPolicyMetadata.PermissionMetaData();
        pmd11.setResourceName("pm1.g1.e2");
        pmd11.setOrder(Integer.valueOf(1));
        pmd11.setMask("(select min(e2) from pm1.g3)");
        policy1.addPermission(new DataPolicyMetadata.PermissionMetaData[]{pmd11});
        policy1.setName("other-role");
        this.context.getAllowedDataPolicies().put("other-role", policy1);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g1.e1 FROM pm1.g1", Arrays.asList("a"), Arrays.asList("b"));
        dataManager.addData("SELECT pm1.g3.e2 FROM pm1.g3", Arrays.asList(1), Arrays.asList(2));
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("select e1, g2.e2 from pm1.g1 as g2"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new DefaultCapabilitiesFinder(), this.context);
        List[] expectedResults = new List[]{Arrays.asList("a", 1), Arrays.asList("b", 1)};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test
    public void testColumnSubstitution() throws Exception {
        DataPolicyMetadata policy1 = new DataPolicyMetadata();
        DataPolicyMetadata.PermissionMetaData pmd11 = new DataPolicyMetadata.PermissionMetaData();
        pmd11.setResourceName("vm1.g15.x");
        pmd11.setMask("e1");
        policy1.addPermission(new DataPolicyMetadata.PermissionMetaData[]{pmd11});
        policy1.setName("other-role");
        this.context.getAllowedDataPolicies().put("other-role", policy1);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm3.g1.e1 FROM pm3.g1", Arrays.asList("a"), Arrays.asList("b"));
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("select * from vm1.g15"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new DefaultCapabilitiesFinder(), this.context);
        List[] expectedResults = new List[]{Arrays.asList("a", "a"), Arrays.asList("b", "b")};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test
    public void testSubqueryProcedureMask() throws Exception {
        DataPolicyMetadata policy1 = new DataPolicyMetadata();
        DataPolicyMetadata.PermissionMetaData pmd11 = new DataPolicyMetadata.PermissionMetaData();
        pmd11.setResourceName("pm1.sp1.e2");
        pmd11.setOrder(Integer.valueOf(1));
        pmd11.setMask("(select min(e2) from pm1.g3 where e1 = pm1.sp1.e2)");
        policy1.addPermission(new DataPolicyMetadata.PermissionMetaData[]{pmd11});
        policy1.setName("other-role");
        this.context.getAllowedDataPolicies().put("other-role", policy1);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("EXEC pm1.sp1()", Arrays.asList("a", 1), Arrays.asList("b", 2));
        dataManager.addData("SELECT pm1.g3.e1, pm1.g3.e2 FROM pm1.g3", Arrays.asList("1", 0), Arrays.asList("2", -1));
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("exec pm1.sp1()"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new DefaultCapabilitiesFinder(), this.context);
        List[] expectedResults = new List[]{Arrays.asList("a", 0), Arrays.asList(null, -1)};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test
    public void testViewMask() throws Exception {
        DataPolicyMetadata policy1 = new DataPolicyMetadata();
        DataPolicyMetadata.PermissionMetaData pmd11 = new DataPolicyMetadata.PermissionMetaData();
        pmd11.setResourceName("vm1.g1.e2");
        pmd11.setMask("null");
        policy1.addPermission(new DataPolicyMetadata.PermissionMetaData[]{pmd11});
        policy1.setName("other-role");
        this.context.getAllowedDataPolicies().put("other-role", policy1);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g1.e1 FROM pm1.g1", Arrays.asList("a", 1), Arrays.asList("b", 2));
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("select g2.e2 from vm1.g1 as g2"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new DefaultCapabilitiesFinder(), this.context);
        List[] expectedResults = new List[]{Collections.singletonList(null), Collections.singletonList(null)};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test(expected=QueryMetadataException.class)
    public void testWindowFunctionViewMask() throws Exception {
        DataPolicyMetadata policy1 = new DataPolicyMetadata();
        DataPolicyMetadata.PermissionMetaData pmd11 = new DataPolicyMetadata.PermissionMetaData();
        pmd11.setResourceName("vm1.g1.e2");
        pmd11.setMask("min(e2) over ()");
        policy1.addPermission(new DataPolicyMetadata.PermissionMetaData[]{pmd11});
        policy1.setName("other-role");
        this.context.getAllowedDataPolicies().put("other-role", policy1);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("select g2.e2 from vm1.g1 as g2"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new DefaultCapabilitiesFinder(), this.context);
        TestProcessor.helpProcess(plan, this.context, dataManager, null);
    }

    @Test
    public void testViewMaskWithRowFilter() throws Exception {
        DataPolicyMetadata policy1 = new DataPolicyMetadata();
        DataPolicyMetadata.PermissionMetaData pmd11 = new DataPolicyMetadata.PermissionMetaData();
        pmd11.setResourceName("vm1.g1.e2");
        pmd11.setMask("null");
        DataPolicyMetadata.PermissionMetaData pmd12 = new DataPolicyMetadata.PermissionMetaData();
        pmd12.setResourceName("vm1.g1");
        pmd12.setCondition("e2 = 1");
        policy1.addPermission(new DataPolicyMetadata.PermissionMetaData[]{pmd11, pmd12});
        policy1.setName("other-role");
        this.context.getAllowedDataPolicies().put("other-role", policy1);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1", Arrays.asList("a", 1), Arrays.asList("b", 1));
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("select g2.e2 from vm1.g1 as g2"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new DefaultCapabilitiesFinder(), this.context);
        List[] expectedResults = new List[]{Collections.singletonList(null)};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }

    @Test
    public void testConditionalMask() throws Exception {
        DataPolicyMetadata policy1 = new DataPolicyMetadata();
        DataPolicyMetadata.PermissionMetaData pmd11 = new DataPolicyMetadata.PermissionMetaData();
        pmd11.setResourceName("pm1.g1.e2");
        pmd11.setOrder(Integer.valueOf(1));
        pmd11.setCondition("e1 = 'c'");
        pmd11.setMask("0");
        policy1.addPermission(new DataPolicyMetadata.PermissionMetaData[]{pmd11});
        policy1.setName("other-role");
        this.context.getAllowedDataPolicies().put("other-role", policy1);
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("SELECT pm1.g1.e1, pm1.g1.e2 FROM pm1.g1", Arrays.asList("a", 1), Arrays.asList("b", 2), Arrays.asList("c", 0));
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse("select g2.e2 from pm1.g1 as g2"), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), new DefaultCapabilitiesFinder(), this.context);
        List[] expectedResults = new List[]{Collections.singletonList(null), Arrays.asList(2), Arrays.asList(0)};
        TestProcessor.helpProcess(plan, this.context, dataManager, expectedResults);
    }
}

