/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import org.teiid.core.types.DataTypeManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public abstract class Symbol
implements LanguageObject {
    private String shortName;
    protected String outputName;
    public static final String SEPARATOR = ".";

    public Symbol(String name) {
        this.setName(name);
    }

    public Symbol() {
    }

    protected void setName(String name) {
        this.setShortName(name);
    }

    public void setShortName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0017"));
        }
        this.shortName = DataTypeManager.getCanonicalString((String)name);
        this.outputName = null;
    }

    public String getName() {
        return this.getShortName();
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public int hashCode() {
        return this.shortName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Symbol)) {
            return false;
        }
        String otherFqn = ((Symbol)obj).getName();
        String thisFqn = this.getName();
        return thisFqn.equals(otherFqn);
    }

    @Override
    public abstract Object clone();

    public String getOutputName() {
        return this.outputName == null ? this.getName() : this.outputName;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName;
    }

    public final String getShortName() {
        return this.shortName;
    }

    public static String getShortName(Expression ex) {
        if (ex instanceof Symbol) {
            return ((Symbol)((Object)ex)).getShortName();
        }
        return "expr";
    }

    public static String getName(Expression ex) {
        if (ex instanceof Symbol) {
            return ((Symbol)((Object)ex)).getName();
        }
        return "expr";
    }

    public static String getOutputName(Expression ex) {
        if (ex instanceof Symbol) {
            return ((Symbol)((Object)ex)).getOutputName();
        }
        return "expr";
    }

    public static String getShortName(String name) {
        int index = name.lastIndexOf(SEPARATOR);
        if (index >= 0) {
            return name.substring(index + 1);
        }
        return name;
    }
}

