/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.framework.connection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.teiid.test.framework.TestLogger;
import org.teiid.test.framework.connection.ConnectionStrategy;
import org.teiid.test.framework.exception.QueryTestFailedException;
import org.teiid.test.framework.exception.TransactionRuntimeException;

public class DriverConnection
extends ConnectionStrategy {
    public static final String DS_USER = "user";
    public static final String DS_USERNAME = "User";
    public static final String DS_PASSWORD = "Password";
    public static final String DS_DRIVER = "driver";
    public static final String DS_URL = "URL";
    public static final String DS_APPLICATION_NAME = "application-name";
    private String url = null;
    private String driver = null;
    private String username = null;
    private String pwd = null;
    private Connection connection;

    public DriverConnection(Properties props) throws QueryTestFailedException {
        super(props);
        this.validate();
    }

    public void validate() {
        String urlProp = this.getEnvironment().getProperty(DS_URL);
        if (urlProp == null || urlProp.length() == 0) {
            throw new TransactionRuntimeException("Property URL was not specified");
        }
        StringBuffer urlSB = new StringBuffer(urlProp);
        String appl = this.getEnvironment().getProperty(DS_APPLICATION_NAME);
        if (appl != null) {
            urlSB.append(";");
            urlSB.append("ApplicationName").append("=").append(appl);
        }
        this.url = urlSB.toString();
        this.driver = this.getEnvironment().getProperty(DS_DRIVER);
        if (this.driver == null || this.driver.length() == 0) {
            throw new TransactionRuntimeException("Property driver was not specified");
        }
        this.username = this.getEnvironment().getProperty(DS_USER);
        if (this.username == null) {
            this.username = this.getEnvironment().getProperty(DS_USERNAME);
        }
        this.pwd = this.getEnvironment().getProperty(DS_PASSWORD);
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            throw new TransactionRuntimeException(e);
        }
    }

    @Override
    public synchronized Connection getConnection() throws QueryTestFailedException {
        if (this.connection != null) {
            try {
                if (!this.connection.isClosed()) {
                    return this.connection;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.connection = this.getJDBCConnection(this.driver, this.url, this.username, this.pwd);
        return this.connection;
    }

    private Connection getJDBCConnection(String driver, String url, String user, String passwd) throws QueryTestFailedException {
        TestLogger.log("Creating Driver Connection: \"" + url + "\" user:password - " + (user != null ? user : "NA") + ":" + (passwd != null ? passwd : "NA"));
        Connection conn = null;
        try {
            conn = user != null && user.length() > 0 ? DriverManager.getConnection(url, user, passwd) : DriverManager.getConnection(url);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new QueryTestFailedException(t.getMessage());
        }
        return conn;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.connection = null;
    }
}

