/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational;

import junit.framework.TestCase;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.rules.RuleConstants;
import org.teiid.query.optimizer.relational.rules.RulePushSelectCriteria;

public class TestRuleStack
extends TestCase {
    public TestRuleStack(String arg0) {
        super(arg0);
    }

    public void testInitialization() {
        RuleStack stack = new RuleStack();
        TestRuleStack.assertEquals((String)"Initial stack is not empty", (boolean)true, (boolean)stack.isEmpty());
        TestRuleStack.assertEquals((String)"Initial size is not 0", (int)0, (int)stack.size());
        TestRuleStack.assertNull((String)"Top is not null", (Object)stack.pop());
    }

    public void helpTestPop(RuleStack stack, OptimizerRule expectedPop, int expectedSize) {
        OptimizerRule out = stack.pop();
        int outSize = stack.size();
        TestRuleStack.assertSame((String)"Did not get same object", (Object)expectedPop, (Object)out);
        TestRuleStack.assertEquals((String)"Stack changed size", (int)expectedSize, (int)outSize);
    }

    public void testPopOneRule() {
        RuleStack stack = new RuleStack();
        int expectedSize = stack.size();
        RulePushSelectCriteria rule = new RulePushSelectCriteria();
        stack.push((OptimizerRule)rule);
        this.helpTestPop(stack, (OptimizerRule)rule, expectedSize);
    }

    public void testPopNothing() {
        RuleStack stack = new RuleStack();
        this.helpTestPop(stack, null, 0);
    }

    public void testRemove() {
        RuleStack stack = new RuleStack();
        stack.push(RuleConstants.ACCESS_PATTERN_VALIDATION);
        stack.push(RuleConstants.COLLAPSE_SOURCE);
        stack.push(RuleConstants.ACCESS_PATTERN_VALIDATION);
        stack.remove(RuleConstants.ACCESS_PATTERN_VALIDATION);
        TestRuleStack.assertEquals((int)1, (int)stack.size());
        TestRuleStack.assertEquals((Object)RuleConstants.COLLAPSE_SOURCE, (Object)stack.pop());
        TestRuleStack.assertEquals(null, (Object)stack.pop());
    }

    public void testContains() {
        RuleStack stack = new RuleStack();
        stack.push(RuleConstants.ACCESS_PATTERN_VALIDATION);
        stack.push(RuleConstants.COLLAPSE_SOURCE);
        TestRuleStack.assertEquals((boolean)true, (boolean)stack.contains(RuleConstants.ACCESS_PATTERN_VALIDATION));
        TestRuleStack.assertEquals((boolean)false, (boolean)stack.contains(RuleConstants.PLACE_ACCESS));
    }
}

